/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.core.resource;

import org.eclipse.core.internal.resources.ResourceException;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.xmi.ClassNotFoundException;
import org.eclipse.emf.ecore.xmi.IllegalValueException;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.core.utils.ServiceUtilsForActionHandlers;

public class ModelUtils {
    public static ModelSet getModelSet() {
        try {
            return ServiceUtilsForActionHandlers.getInstance().getModelSet();
        }
        catch (ServiceException e) {
            return null;
        }
    }

    public static ModelSet getModelSetChecked() throws ServiceException {
        return ServiceUtilsForActionHandlers.getInstance().getModelSet();
    }

    public static ModelSet getModelSet(ServicesRegistry servicesRegistry) {
        try {
            return servicesRegistry.getService(ModelSet.class);
        }
        catch (ServiceException e) {
            return null;
        }
    }

    public static ModelSet getModelSetChecked(ServicesRegistry servicesRegistry) throws ServiceException {
        return servicesRegistry.getService(ModelSet.class);
    }

    public static boolean isDegradedModeAllowed(Throwable t) {
        return t instanceof ClassNotFoundException || t instanceof IllegalValueException;
    }

    public static boolean resourceFailedOnLoad(Resource r) {
        if (r.getErrors() != null) {
            for (Resource.Diagnostic d : r.getErrors()) {
                WrappedException wrapped;
                if (!(d instanceof WrappedException) || !((wrapped = (WrappedException)d).getCause() instanceof ResourceException) || !r.getContents().isEmpty()) continue;
                return true;
            }
        }
        return false;
    }
}

