/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.discovery.ui.wizards;

import java.io.IOException;
import java.util.Collections;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceImpl;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.papyrus.infra.discovery.DiscoveryDefinition;
import org.eclipse.papyrus.infra.discovery.ui.viewer.DiscoveryContentProvider;
import org.eclipse.papyrus.infra.discovery.ui.wizards.DiscoveryWizard;
import org.eclipse.papyrus.infra.discovery.ui.wizards.Messages;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class DiscoveryComponent {
    public static final String DISCOVERY_PAPYRUS_URI = "http://www.eclipse.org/modeling/mdt/papyrus/downloads/discovery/juno/papyrus-extra.xmi";

    public static final Object execute() {
        final IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        DiscoveryContentProvider provider = new DiscoveryContentProvider(){

            protected DiscoveryDefinition load() {
                XMIResourceImpl res = new XMIResourceImpl(URI.createURI((String)DiscoveryComponent.DISCOVERY_PAPYRUS_URI));
                try {
                    res.load(Collections.EMPTY_MAP);
                }
                catch (IOException e) {
                    MessageDialog.openError((Shell)window.getShell(), (String)Messages.DiscoveryComponent_CannotConnectToSource_title, (String)Messages.DiscoveryComponent_CannotConnectToSource_label);
                    throw new RuntimeException(e);
                }
                return (DiscoveryDefinition)res.getContents().get(0);
            }

            public String getDescription() {
                return Messages.DiscoveryComponent_description;
            }

            public String getTitle() {
                return Messages.DiscoveryComponent_title;
            }
        };
        DiscoveryWizard wizard = new DiscoveryWizard(provider);
        WizardDialog dialog = new WizardDialog(window.getShell(), (IWizard)wizard);
        return dialog.open();
    }
}

