/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.emf;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.facet.infra.browser.custom.MetamodelView;
import org.eclipse.emf.facet.infra.browser.custom.TypeView;
import org.eclipse.emf.facet.infra.browser.custom.core.CustomizationsCatalog;
import org.eclipse.emf.facet.infra.browser.uicore.CustomizationManager;
import org.eclipse.emf.facet.infra.facet.Facet;
import org.eclipse.emf.facet.infra.facet.FacetSet;
import org.eclipse.emf.facet.infra.facet.core.FacetSetCatalog;
import org.eclipse.papyrus.infra.core.log.LogHelper;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Activator
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.eclipse.papyrus.infra.emf";
    private static Activator plugin;
    public static LogHelper log;
    private CustomizationManager fCustomizationManager;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        log = new LogHelper((Plugin)this);
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public static Activator getDefault() {
        return plugin;
    }

    public CustomizationManager getCustomizationManager() {
        if (this.fCustomizationManager == null) {
            this.fCustomizationManager = new CustomizationManager();
            this.init(this.fCustomizationManager);
        }
        return this.fCustomizationManager;
    }

    private void init(CustomizationManager customizationManager) {
        customizationManager.setShowDerivedLinks(true);
        customizationManager.setDecorateExternalResources(false);
        try {
            List registryDefaultCustomizations = CustomizationsCatalog.getInstance().getRegistryDefaultCustomizations();
            for (MetamodelView metamodelView : registryDefaultCustomizations) {
                customizationManager.registerCustomization(metamodelView);
            }
            customizationManager.loadCustomizations();
            this.loadFacetsForCustomizations(registryDefaultCustomizations, customizationManager);
        }
        catch (Throwable e) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, PLUGIN_ID, "Error initializing customizations", e));
        }
    }

    protected void loadFacetsForCustomizations(List<MetamodelView> customizations, CustomizationManager customizationManager) {
        HashSet<Facet> referencedFacets = new HashSet<Facet>();
        Collection facetSets = FacetSetCatalog.getSingleton().getAllFacetSets();
        for (MetamodelView customization : customizations) {
            String metamodelURI = customization.getMetamodelURI();
            FacetSet customizedFacetSet = null;
            if (metamodelURI != null) {
                for (FacetSet facetSet : facetSets) {
                    if (!metamodelURI.equals(facetSet.getNsURI())) continue;
                    customizedFacetSet = facetSet;
                    break;
                }
            }
            if (customizedFacetSet == null) continue;
            EList types = customization.getTypes();
            for (TypeView typeView : types) {
                String metaclassName = typeView.getMetaclassName();
                Facet facet = this.findFacetWithFullyQualifiedName(metaclassName, customizedFacetSet);
                if (facet != null) {
                    referencedFacets.add(facet);
                    continue;
                }
                log.warn(String.format("Missing required facet \"%s\" in FacetSet \"%s\" for customization \"%s\"", metaclassName, customizedFacetSet.getName(), customization.getName()));
            }
            for (Facet referencedFacet : referencedFacets) {
                customizationManager.loadFacet(referencedFacet);
            }
        }
    }

    private Facet findFacetWithFullyQualifiedName(String metaclassName, FacetSet customizedFacetSet) {
        EList facets = customizedFacetSet.getFacets();
        for (Facet facet : facets) {
            String facetName = Activator.getMetaclassQualifiedName((EClassifier)facet);
            if (!metaclassName.equals(facetName)) continue;
            return facet;
        }
        return null;
    }

    public static String getMetaclassQualifiedName(EClassifier eClass) {
        ArrayList<String> qualifiedNameParts = new ArrayList<String>();
        StringBuilder builder = new StringBuilder();
        EPackage ePackage = eClass.getEPackage();
        while (ePackage != null) {
            qualifiedNameParts.add(ePackage.getName());
            ePackage = ePackage.getESuperPackage();
        }
        int i = qualifiedNameParts.size() - 1;
        while (i >= 0) {
            builder.append(String.valueOf((String)qualifiedNameParts.get(i)) + ".");
            --i;
        }
        builder.append(eClass.getName());
        return builder.toString();
    }
}

