/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.emf.databinding;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.papyrus.commands.wrappers.GMFtoEMFCommandWrapper;
import org.eclipse.papyrus.infra.emf.databinding.EMFObservableList;
import org.eclipse.papyrus.infra.services.edit.service.ElementEditServiceUtils;
import org.eclipse.papyrus.infra.services.edit.service.IElementEditService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PapyrusObservableList
extends EMFObservableList {
    public PapyrusObservableList(List<?> wrappedList, EditingDomain domain, EObject source, EStructuralFeature feature) {
        super(wrappedList, domain, source, feature);
    }

    protected IElementEditService getProvider() {
        return ElementEditServiceUtils.getCommandProvider((Object)this.source);
    }

    protected Command getCommandFromRequests(IElementEditService provider, Collection<? extends IEditCommandRequest> requests) {
        if (requests.size() == 1) {
            return new GMFtoEMFCommandWrapper(provider.getEditCommand(requests.iterator().next()));
        }
        CompositeCommand cc = new CompositeCommand("Edit list");
        for (IEditCommandRequest iEditCommandRequest : requests) {
            ICommand cmd = provider.getEditCommand(iEditCommandRequest);
            cc.add((IUndoableOperation)cmd);
        }
        return new GMFtoEMFCommandWrapper((ICommand)cc);
    }

    @Override
    public Command getAddCommand(int index, Object value) {
        IElementEditService provider = this.getProvider();
        if (provider != null) {
            LinkedList<Object> values = new LinkedList<Object>((Collection<Object>)((Object)this));
            values.add(index, value);
            return this.getCommandFromRequests(provider, this.getRequests(values, null));
        }
        return super.getAddCommand(index, value);
    }

    @Override
    public Command getAddCommand(Object value) {
        IElementEditService provider = this.getProvider();
        if (provider != null) {
            LinkedList<Object> values = new LinkedList<Object>((Collection<Object>)((Object)this));
            values.add(value);
            return this.getCommandFromRequests(provider, this.getRequests(values, null));
        }
        return super.getAddCommand(value);
    }

    @Override
    public Command getAddAllCommand(Collection<?> values) {
        IElementEditService provider = this.getProvider();
        if (provider != null) {
            LinkedList<Object> result = new LinkedList<Object>((Collection<Object>)((Object)this));
            result.addAll(values);
            return this.getCommandFromRequests(provider, this.getRequests(result, null));
        }
        return super.getAddAllCommand(values);
    }

    @Override
    public Command getAddAllCommand(int index, Collection<?> values) {
        IElementEditService provider = this.getProvider();
        if (provider != null) {
            LinkedList<Object> result = new LinkedList<Object>((Collection<Object>)((Object)this));
            result.addAll(index, values);
            return this.getCommandFromRequests(provider, this.getRequests(result, null));
        }
        return super.getAddAllCommand(index, values);
    }

    @Override
    public Command getClearCommand() {
        IElementEditService provider = this.getProvider();
        if (provider != null) {
            return this.getCommandFromRequests(provider, this.getRequests(Collections.EMPTY_LIST, new LinkedList(this)));
        }
        return super.getClearCommand();
    }

    @Override
    public Command getRemoveCommand(int index) {
        IElementEditService provider = this.getProvider();
        if (provider != null) {
            LinkedList<Object> values = new LinkedList<Object>((Collection<Object>)((Object)this));
            Object o = values.remove(index);
            return this.getCommandFromRequests(provider, this.getRequests(values, Collections.singletonList(o)));
        }
        return null;
    }

    @Override
    public Command getRemoveCommand(Object value) {
        IElementEditService provider = this.getProvider();
        if (provider != null) {
            LinkedList<Object> values = new LinkedList<Object>((Collection<Object>)((Object)this));
            values.remove(value);
            return this.getCommandFromRequests(provider, this.getRequests(values, Collections.singletonList(value)));
        }
        return super.getRemoveCommand(value);
    }

    @Override
    public Command getRemoveAllCommand(Collection<?> values) {
        IElementEditService provider = this.getProvider();
        if (provider != null) {
            LinkedList<Object> result = new LinkedList<Object>((Collection<Object>)((Object)this));
            result.removeAll(values);
            return this.getCommandFromRequests(provider, this.getRequests(result, values));
        }
        return super.getRemoveAllCommand(values);
    }

    @Override
    public List<Command> getMoveCommands(int oldIndex, int newIndex) {
        IElementEditService provider = this.getProvider();
        if (provider != null) {
            LinkedList<Object> values = new LinkedList<Object>((Collection<Object>)((Object)this));
            Object result = values.remove(oldIndex);
            values.add(newIndex, result);
            return Collections.singletonList(this.getCommandFromRequests(provider, this.getRequests(values, null)));
        }
        return super.getMoveCommands(oldIndex, newIndex);
    }

    @Override
    public Command getSetCommand(int index, Object value) {
        IElementEditService provider = this.getProvider();
        if (provider != null) {
            LinkedList<Object> values = new LinkedList<Object>((Collection<Object>)((Object)this));
            Object oldElem = values.set(index, value);
            return this.getCommandFromRequests(provider, this.getRequests(values, Collections.singletonList(oldElem)));
        }
        return super.getSetCommand(index, value);
    }

    protected Collection<? extends IEditCommandRequest> getRequests(List<Object> newValues, Collection<?> removedValues) {
        LinkedList<Object> requests = new LinkedList<Object>();
        if (this.feature instanceof EReference && ((EReference)this.feature).isContainment() && removedValues != null) {
            for (Object o : removedValues) {
                if (!(o instanceof EObject)) continue;
                requests.add(new DestroyElementRequest((TransactionalEditingDomain)this.editingDomain, (EObject)o, false));
            }
        }
        requests.add(new SetRequest((TransactionalEditingDomain)this.editingDomain, this.source, this.feature, newValues));
        return requests;
    }
}

