/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.emf.providers.strategy;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.facet.infra.facet.FacetReference;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.widgets.providers.IAdaptableContentProvider;
import org.eclipse.papyrus.infra.widgets.strategy.ProviderBasedBrowseStrategy;
import org.eclipse.swt.widgets.TreeItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContainmentBrowseStrategy
extends ProviderBasedBrowseStrategy {
    protected IAdaptableContentProvider adaptableProvider;
    protected TreeViewer viewer;

    public ContainmentBrowseStrategy(ITreeContentProvider provider) {
        if (!(provider instanceof IAdaptableContentProvider)) {
            throw new IllegalArgumentException("The provider must be an IAdaptableContentProvider");
        }
        this.setProvider(provider);
        this.adaptableProvider = (IAdaptableContentProvider)this.provider;
    }

    protected boolean browseElement(Object containerElement) {
        Object semanticElement = this.adaptableProvider.getAdaptedValue(containerElement);
        if (semanticElement instanceof EReference && !(semanticElement instanceof FacetReference)) {
            return ((EReference)semanticElement).isContainment();
        }
        return true;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        if (viewer instanceof TreeViewer) {
            this.viewer = (TreeViewer)viewer;
        }
        super.inputChanged(viewer, oldInput, newInput);
    }

    public void revealSemanticElement(List<?> elementList) {
        Iterator<?> elementListIterator = elementList.iterator();
        ArrayList<Object> treeElementToSelect = new ArrayList<Object>();
        while (elementListIterator.hasNext()) {
            Object currentElement = elementListIterator.next();
            if (currentElement instanceof EObject) {
                Object root;
                List<Object> path;
                EObject currentEObject = (EObject)currentElement;
                if (this.provider != null && (path = this.searchPath(currentEObject, Arrays.asList(this.provider.getElements(root = this.provider.getElements(null)[0])))).size() > 0) {
                    this.expandItems(path, this.viewer.getTree().getItems());
                    treeElementToSelect.add(path.get(path.size() - 1));
                }
            }
            this.selectReveal((ISelection)new StructuredSelection(treeElementToSelect));
        }
    }

    public void expandItems(List<Object> treeElementList, TreeItem[] list) {
        if (treeElementList.size() > 0) {
            int i = 0;
            while (i < list.length) {
                if (list[i].getData() != null && list[i].getData().equals(treeElementList.get(0))) {
                    if (treeElementList.size() > 1) {
                        Object[] toexpand = new Object[]{treeElementList.get(0)};
                        this.viewer.setExpandedElements(toexpand);
                    }
                    ArrayList<Object> tmpList = new ArrayList<Object>();
                    tmpList.addAll(treeElementList);
                    tmpList.remove(tmpList.get(0));
                    this.expandItems(tmpList, list[i].getItems());
                }
                ++i;
            }
        }
    }

    public void selectReveal(ISelection selection) {
        if (this.viewer != null) {
            this.viewer.setSelection(selection, true);
        }
    }

    protected List<Object> searchPath(EObject eobject, List<Object> objects) {
        ArrayList<Object> path = new ArrayList<Object>();
        for (Object o : objects) {
            if (!(o instanceof Diagram) && o instanceof IAdaptable && eobject.equals(((IAdaptable)o).getAdapter(EObject.class))) {
                path.add(o);
                return path;
            }
            int i = 0;
            while (i < this.provider.getChildren(o).length) {
                Object treeItem = this.provider.getChildren(o)[i];
                List<Object> tmppath = new ArrayList();
                EObject element = EMFHelper.getEObject(treeItem);
                if (element != null) {
                    ArrayList<Object> childs;
                    if (element instanceof EReference) {
                        if (((EReference)element).isContainment() && !((EReference)element).isDerived()) {
                            childs = new ArrayList();
                            childs.add(treeItem);
                            tmppath = this.searchPath(eobject, childs);
                        }
                    } else if (element instanceof EObject) {
                        childs = new ArrayList<Object>();
                        childs.add(treeItem);
                        tmppath = this.searchPath(eobject, childs);
                    }
                }
                if (tmppath.size() > 0 && tmppath.get(tmppath.size() - 1) instanceof IAdaptable && eobject.equals(((IAdaptable)tmppath.get(tmppath.size() - 1)).getAdapter(EObject.class))) {
                    path.add(o);
                    path.addAll(tmppath);
                    return path;
                }
                ++i;
            }
        }
        return new ArrayList<Object>();
    }
}

