/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.common;

import java.util.Iterator;
import java.util.List;
import org.eclipse.gef.DefaultEditDomain;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IPrimaryEditPart;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramEditDomain;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.parts.DiagramDocumentEditor;
import org.eclipse.papyrus.commands.CheckedDiagramCommandStack;
import org.eclipse.papyrus.infra.core.ui.IRevealSemanticElement;
import org.eclipse.papyrus.infra.gmfdiag.common.SemanticFromGMFElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SynchronizableGmfDiagramEditor
extends DiagramDocumentEditor
implements IRevealSemanticElement {
    public SynchronizableGmfDiagramEditor(boolean hasFlyoutPalette) {
        super(hasFlyoutPalette);
    }

    public void revealSemanticElement(List<?> elementList) {
        SemanticFromGMFElement semanticFromGMFElement = new SemanticFromGMFElement();
        GraphicalViewer graphicalViewer = this.getGraphicalViewer();
        if (graphicalViewer != null) {
            Iterator iter = graphicalViewer.getEditPartRegistry().values().iterator();
            IGraphicalEditPart researchedEditPart = null;
            while (iter.hasNext() && researchedEditPart == null) {
                Object currentEditPart = iter.next();
                if (!(currentEditPart instanceof IPrimaryEditPart) || !elementList.contains(semanticFromGMFElement.getSemanticElement(currentEditPart))) continue;
                researchedEditPart = (IGraphicalEditPart)currentEditPart;
            }
            if (researchedEditPart != null) {
                graphicalViewer.select(researchedEditPart);
            }
        }
    }

    protected void configureDiagramEditDomain() {
        DefaultEditDomain editDomain = this.getEditDomain();
        if (editDomain != null) {
            CommandStack stack = editDomain.getCommandStack();
            if (stack != null) {
                stack.dispose();
            }
            CheckedDiagramCommandStack diagramStack = new CheckedDiagramCommandStack(this.getDiagramEditDomain());
            editDomain.setCommandStack((CommandStack)diagramStack);
        }
        DiagramEditDomain diagEditDomain = (DiagramEditDomain)this.getDiagramEditDomain();
        diagEditDomain.setActionManager(this.createActionManager());
    }
}

