/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.common.advice;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.ECrossReferenceAdapter;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.commands.core.commands.DuplicateEObjectsCommand;
import org.eclipse.gmf.runtime.emf.type.core.edithelper.AbstractEditHelperAdvice;
import org.eclipse.gmf.runtime.emf.type.core.requests.DuplicateElementsRequest;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.sasheditor.contentprovider.IPageMngr;
import org.eclipse.papyrus.infra.core.utils.BusinessModelResolver;
import org.eclipse.papyrus.infra.core.utils.EditorUtils;
import org.eclipse.papyrus.infra.gmfdiag.common.Activator;

public class GMFDiagramDuplicateEditHelperAdvice
extends AbstractEditHelperAdvice {
    protected ICommand getBeforeDuplicateCommand(DuplicateElementsRequest request) {
        Object additional = request.getParameter("Additional_Duplicated_Elements");
        if (!(additional instanceof Set)) {
            return super.getBeforeDuplicateCommand(request);
        }
        Set duplicatedObjects = (Set)additional;
        EObject object = this.getDuplicatedEObject(request);
        if (object == null) {
            return super.getBeforeDuplicateCommand(request);
        }
        ArrayList<Diagram> diagramsToDuplicate = new ArrayList<Diagram>();
        ResourceSet resourceSet = object.eResource().getResourceSet();
        ECrossReferenceAdapter adapter = ECrossReferenceAdapter.getCrossReferenceAdapter((Notifier)resourceSet);
        if (adapter == null) {
            adapter = new ECrossReferenceAdapter();
            resourceSet.eAdapters().add((Object)adapter);
        }
        if (object instanceof View) {
            return super.getBeforeDuplicateCommand(request);
        }
        Collection settings = adapter.getInverseReferences(object, false);
        for (EStructuralFeature.Setting setting : settings) {
            EObject value = setting.getEObject();
            if (!(value instanceof Diagram)) continue;
            diagramsToDuplicate.add((Diagram)value);
        }
        TreeIterator it = object.eAllContents();
        while (it.hasNext()) {
            EObject child = (EObject)it.next();
            settings = adapter.getInverseReferences(child, false);
            for (EStructuralFeature.Setting setting : settings) {
                EObject value = setting.getEObject();
                if (!(value instanceof Diagram)) continue;
                diagramsToDuplicate.add((Diagram)value);
            }
        }
        if (!diagramsToDuplicate.isEmpty()) {
            CompositeCommand command = null;
            for (Diagram diagramToDuplicate : diagramsToDuplicate) {
                if (duplicatedObjects.contains(diagramToDuplicate)) continue;
                if (command == null) {
                    command = new CompositeCommand("", Arrays.asList(new DuplicateDiagramCommand(request.getEditingDomain(), "Duplicate Diagram", diagramToDuplicate, request.getAllDuplicatedElementsMap())));
                } else {
                    command.add((IUndoableOperation)new DuplicateDiagramCommand(request.getEditingDomain(), "Duplicate Diagram", diagramToDuplicate, request.getAllDuplicatedElementsMap()));
                }
                duplicatedObjects.add(diagramToDuplicate);
            }
            if (command != null) {
                if (super.getBeforeDuplicateCommand(request) != null) {
                    command.add((IUndoableOperation)super.getBeforeDuplicateCommand(request));
                    return command.reduce();
                }
                return command.reduce();
            }
        }
        return super.getBeforeDuplicateCommand(request);
    }

    protected EObject getDuplicatedEObject(DuplicateElementsRequest request) {
        List elementsToBeDuplicated = request.getElementsToBeDuplicated();
        if (elementsToBeDuplicated == null || elementsToBeDuplicated.isEmpty()) {
            return null;
        }
        Object elementToBeDuplicated = elementsToBeDuplicated.get(0);
        if (elementToBeDuplicated instanceof EObject) {
            return (EObject)elementToBeDuplicated;
        }
        return null;
    }

    public Resource getNotationResourceForDiagram(EObject eObject, TransactionalEditingDomain domain) {
        Object object = BusinessModelResolver.getInstance().getBusinessModel((Object)eObject);
        EObject semanticObject = !(object instanceof EObject) ? eObject : (EObject)object;
        Resource containerResource = semanticObject.eResource();
        if (containerResource == null) {
            return null;
        }
        ResourceSet resourceSet = containerResource.getResourceSet();
        if (resourceSet instanceof ModelSet) {
            ModelSet modelSet = (ModelSet)resourceSet;
            Resource destinationResource = modelSet.getAssociatedResource(semanticObject, "notation");
            return destinationResource;
        }
        throw new RuntimeException("Resource Set is not a ModelSet or is null");
    }

    public Resource getDiResourceForDiagram(EObject eObject, TransactionalEditingDomain domain) {
        Object object = BusinessModelResolver.getInstance().getBusinessModel((Object)eObject);
        EObject semanticObject = !(object instanceof EObject) ? eObject : (EObject)object;
        Resource containerResource = semanticObject.eResource();
        if (containerResource == null) {
            return null;
        }
        ResourceSet resourceSet = containerResource.getResourceSet();
        if (resourceSet instanceof ModelSet) {
            ModelSet modelSet = (ModelSet)resourceSet;
            Resource destinationResource = modelSet.getAssociatedResource(semanticObject, "di");
            return destinationResource;
        }
        throw new RuntimeException("Resource Set is not a ModelSet or is null");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class DiagramCopier
    extends EcoreUtil.Copier {
        private static final long serialVersionUID = 8544123249170461708L;
        private Map<EObject, EObject> semanticObjects;

        public DiagramCopier(Map<EObject, EObject> semanticObjects) {
            this.semanticObjects = semanticObjects;
        }

        public EObject get(Object arg0) {
            EObject object = (EObject)super.get(arg0);
            if (object == null) {
                object = this.semanticObjects.get(arg0);
            }
            return object;
        }
    }

    public class DuplicateDiagramCommand
    extends DuplicateEObjectsCommand {
        private final Diagram diagramToDuplicate;

        public DuplicateDiagramCommand(TransactionalEditingDomain editingDomain, String label, Diagram diagram) {
            super(editingDomain, label, Collections.singletonList(diagram));
            this.diagramToDuplicate = diagram;
        }

        public DuplicateDiagramCommand(TransactionalEditingDomain editingDomain, String label, Diagram diagram, Map allDuplicatedObjectsMap) {
            super(editingDomain, label, Collections.singletonList(diagram), allDuplicatedObjectsMap);
            this.diagramToDuplicate = diagram;
        }

        public DuplicateDiagramCommand(TransactionalEditingDomain editingDomain, String label, Diagram diagram, Map allDuplicatedObjectsMap, EObject targetContainer) {
            super(editingDomain, label, Collections.singletonList(diagram), allDuplicatedObjectsMap, targetContainer);
            this.diagramToDuplicate = diagram;
        }

        protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
            DiagramCopier copier = new DiagramCopier(this.getAllDuplicatedObjectsMap());
            copier.copy((EObject)this.diagramToDuplicate);
            copier.copyReferences();
            EObject duplicateDiagram = (EObject)copier.get(this.diagramToDuplicate);
            Resource targetResource = GMFDiagramDuplicateEditHelperAdvice.this.getNotationResourceForDiagram(((Diagram)duplicateDiagram).getElement(), this.getEditingDomain());
            Resource diTargetResource = GMFDiagramDuplicateEditHelperAdvice.this.getDiResourceForDiagram(((Diagram)duplicateDiagram).getElement(), this.getEditingDomain());
            if (targetResource != null) {
                targetResource.getContents().add((Object)duplicateDiagram);
                if (diTargetResource != null) {
                    IPageMngr pageMngr = EditorUtils.getIPageMngr((Resource)diTargetResource);
                    pageMngr.addPage((Object)duplicateDiagram);
                } else {
                    Activator.log.error("It was not possible to find the di resource where to add the diagram page", null);
                }
            } else {
                Activator.log.warn("It was not possible to find the Resource with the target EObject");
                targetResource = this.diagramToDuplicate.eResource();
                if (targetResource != null) {
                    Activator.log.error("It was not possible to find the Resource with the source diagram", null);
                    targetResource.getContents().add((Object)duplicateDiagram);
                    if (diTargetResource != null) {
                        IPageMngr pageMngr = EditorUtils.getIPageMngr((Resource)diTargetResource);
                        pageMngr.addPage((Object)duplicateDiagram);
                    } else {
                        Activator.log.error("It was not possible to find the di resource where to add the diagram page", null);
                    }
                }
            }
            return CommandResult.newOKCommandResult((Object)this.getAllDuplicatedObjectsMap());
        }

        public boolean canExecute() {
            return true;
        }
    }
}

