/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.properties.databinding.custom;

import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.gmf.runtime.notation.NamedStyle;
import org.eclipse.gmf.runtime.notation.NotationFactory;
import org.eclipse.gmf.runtime.notation.View;

public abstract class AbstractCustomStyleListValueCommand
extends AbstractCommand {
    protected View view;
    protected EClass styleClass;
    protected String styleName;
    protected boolean needsCreate;
    protected EStructuralFeature styleFeature;
    protected EditingDomain domain;
    protected Command command;
    protected NamedStyle style;

    public AbstractCustomStyleListValueCommand(EditingDomain domain, View view, String styleName, EClass styleClass, EStructuralFeature styleFeature) {
        this.view = view;
        this.styleName = styleName;
        this.styleClass = styleClass;
        this.styleFeature = styleFeature;
        this.domain = domain;
    }

    public void execute() {
        if (!this.isPrepared) {
            this.prepare();
            this.isPrepared = true;
        }
        if (this.needsCreate) {
            this.view.getStyles().add((Object)this.style);
        }
        this.command.execute();
    }

    public void redo() {
        this.execute();
    }

    public boolean prepare() {
        this.style = this.view.getNamedStyle(this.styleClass, this.styleName);
        this.needsCreate = this.style == null;
        if (this.needsCreate) {
            this.style = (NamedStyle)NotationFactory.eINSTANCE.create(this.styleClass);
            this.style.setName(this.styleName);
        }
        this.command = this.createCommand();
        return this.command.canExecute();
    }

    protected abstract Command createCommand();

    public void undo() {
        EList currentList = (EList)this.style.eGet(this.styleFeature);
        this.command.undo();
        if (this.needsCreate) {
            this.view.getStyles().remove((Object)this.style);
        }
    }
}

