/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.properties.databinding.custom;

import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gmf.runtime.notation.NamedStyle;
import org.eclipse.gmf.runtime.notation.NotationFactory;
import org.eclipse.gmf.runtime.notation.View;

public class CustomStyleValueCommand
extends AbstractCommand {
    private boolean createStyle;
    private Object value;
    private Object oldValue;
    private EClass styleClass;
    private View view;
    private String styleName;
    private EStructuralFeature styleFeature;

    public CustomStyleValueCommand(View view, Object value, EClass styleClass, EStructuralFeature styleFeature, String styleName) {
        this.value = value;
        this.styleClass = styleClass;
        this.view = view;
        this.styleName = styleName;
        this.styleFeature = styleFeature;
    }

    public void execute() {
        NamedStyle valueStyle = this.view.getNamedStyle(this.styleClass, this.styleName);
        boolean bl = this.createStyle = valueStyle == null;
        if (this.createStyle) {
            valueStyle = this.createStyle();
        } else {
            this.oldValue = valueStyle.eGet(this.styleFeature);
        }
        valueStyle.eSet(this.styleFeature, this.value);
        if (this.createStyle) {
            this.view.getStyles().add((Object)valueStyle);
        }
    }

    protected NamedStyle createStyle() {
        NamedStyle result = (NamedStyle)NotationFactory.eINSTANCE.create(this.styleClass);
        result.setName(this.styleName);
        return result;
    }

    public void redo() {
        this.execute();
    }

    public void undo() {
        NamedStyle valueStyle = this.view.getNamedStyle(this.styleClass, this.styleName);
        if (this.createStyle) {
            this.view.getStyles().remove((Object)valueStyle);
        } else {
            valueStyle.eSet(this.styleFeature, this.oldValue);
        }
    }

    public boolean prepare() {
        return true;
    }
}

