/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.hyperlink.object;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.infra.hyperlink.Activator;
import org.eclipse.papyrus.infra.hyperlink.messages.Messages;
import org.eclipse.papyrus.infra.hyperlink.object.HyperLinkObject;
import org.eclipse.papyrus.infra.hyperlink.ui.EditorHyperlinkDocumentShell;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HyperLinkDocument
extends HyperLinkObject {
    public String getHyperlinkDocument() {
        return (String)super.getObject();
    }

    public void setHyperlinkDocument(String object) {
        super.setObject(object);
    }

    @Override
    public void executeSelectPressed() {
        try {
            Path location;
            IFile file;
            IEditorDescriptor eDesc = PlatformUI.getWorkbench().getEditorRegistry().findEditor("org.eclipse.ui.systemExternalEditor");
            IWorkspace ws = ResourcesPlugin.getWorkspace();
            IProject project = ws.getRoot().getProject(Messages.HyperLinkDocument_ExternalFiles);
            if (!project.exists()) {
                project.create(null);
            }
            if (!project.isOpen()) {
                project.open(null);
            }
            if (!(file = project.getFile((location = new Path(this.getHyperlinkDocument())).lastSegment())).exists()) {
                file.createLink((IPath)location, 0, null);
            }
            FileEditorInput editorInput = new FileEditorInput(file);
            IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            IWorkbenchPage page = window.getActivePage();
            page.openEditor((IEditorInput)editorInput, eDesc.getId());
        }
        catch (Exception e) {
            Activator.log.error((Throwable)e);
        }
    }

    @Override
    public void executeEditMousePressed(List<HyperLinkObject> list, EObject amodel) {
        EditorHyperlinkDocumentShell editor = new EditorHyperlinkDocumentShell();
        editor.setHyperlinkDocument(this);
        editor.open();
        int index = list.indexOf(this);
        list.remove(this);
        list.add(index, editor.getHyperlinkDocument());
    }
}

