/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.hyperlink.ui;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.papyrus.infra.core.editor.IMultiDiagramEditor;
import org.eclipse.papyrus.infra.core.editorsfactory.IPageIconsRegistry;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.utils.EditorUtils;
import org.eclipse.papyrus.infra.hyperlink.messages.Messages;
import org.eclipse.papyrus.infra.hyperlink.object.HyperLinkObject;
import org.eclipse.papyrus.infra.hyperlink.util.HyperLinkContentProvider;
import org.eclipse.papyrus.infra.hyperlink.util.HyperLinkLabelProvider;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EditorNavigationDialog
extends Dialog {
    protected int width = 350;
    protected int height = 150;
    protected List<HyperLinkObject> hyperlinkObjects;
    protected HyperLinkContentProvider contentProvider;
    private TableViewer tableViewer;
    protected Table availableHyperLink;
    protected List<HyperLinkObject> hyperlinkResult = new ArrayList<HyperLinkObject>();

    public EditorNavigationDialog(Shell parentShell, ArrayList<HyperLinkObject> hyperlinkObjects) {
        super(parentShell);
        this.hyperlinkObjects = hyperlinkObjects;
    }

    protected boolean isResizable() {
        return true;
    }

    protected Control createContents(Composite parent) {
        super.createContents(parent);
        Composite defaultHyperlinkComposite = (Composite)this.getDialogArea();
        Label lblHyperlinks = new Label(defaultHyperlinkComposite, 0);
        lblHyperlinks.setForeground(Display.getCurrent().getSystemColor(2));
        lblHyperlinks.setText(Messages.DiagramNavigationDialog_WhichHyperLinksWouldYouToNavigateTo);
        this.availableHyperLink = new Table(defaultHyperlinkComposite, 67616);
        this.availableHyperLink.setLayoutData((Object)new GridData(1808));
        this.contentProvider = new HyperLinkContentProvider();
        this.tableViewer = new TableViewer(this.availableHyperLink);
        this.tableViewer.setContentProvider((IContentProvider)this.contentProvider);
        IPageIconsRegistry editorRegistry = null;
        IMultiDiagramEditor papyrusEditor = EditorUtils.getMultiDiagramEditor();
        try {
            editorRegistry = (IPageIconsRegistry)papyrusEditor.getServicesRegistry().getService(IPageIconsRegistry.class);
        }
        catch (ServiceException e) {
            e.printStackTrace();
        }
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new HyperLinkLabelProvider(editorRegistry));
        this.tableViewer.setInput(this.hyperlinkObjects);
        if (this.availableHyperLink.getItemCount() > 0) {
            this.availableHyperLink.getItem(0).setChecked(true);
        }
        this.getShell().setText(Messages.DiagramNavigationDialog_ChooseHyperLinks);
        this.getShell().pack();
        return defaultHyperlinkComposite;
    }

    public List<HyperLinkObject> getSelectedHyperlinks() {
        return this.hyperlinkResult;
    }

    protected void okPressed() {
        this.hyperlinkResult = new ArrayList<HyperLinkObject>();
        TableItem[] tableItems = this.availableHyperLink.getItems();
        int i = 0;
        while (i < tableItems.length) {
            if (tableItems[i].getChecked()) {
                this.hyperlinkResult.add((HyperLinkObject)tableItems[i].getData());
            }
            ++i;
        }
        super.okPressed();
    }
}

