/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.queries.core.modisco;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.facet.infra.query.ModelQuery;
import org.eclipse.emf.facet.infra.query.ModelQueryParameter;
import org.eclipse.emf.facet.infra.query.ModelQuerySet;
import org.eclipse.emf.facet.infra.query.core.AbstractModelQuery;
import org.eclipse.emf.facet.infra.query.core.ModelQuerySetCatalog;
import org.eclipse.emf.facet.infra.query.core.java.ParameterValueList;
import org.eclipse.emf.facet.infra.query.runtime.ModelQueryParameterValue;
import org.eclipse.emf.facet.infra.query.runtime.ModelQueryResult;
import org.eclipse.papyrus.infra.queries.core.Activator;
import org.eclipse.papyrus.infra.queries.core.configuration.ConstantParameterValue;
import org.eclipse.papyrus.infra.queries.core.configuration.ListParameterValue;
import org.eclipse.papyrus.infra.queries.core.configuration.ModiscoQueryConfiguration;
import org.eclipse.papyrus.infra.queries.core.configuration.ParameterValue;
import org.eclipse.papyrus.infra.queries.core.configuration.QueryConfiguration;
import org.eclipse.papyrus.infra.queries.core.configuration.QueryExecutionValue;
import org.eclipse.papyrus.infra.queries.core.configuration.util.ConfigurationSwitch;
import org.eclipse.papyrus.infra.queries.core.converter.ConverterNotfoundException;
import org.eclipse.papyrus.infra.queries.core.converter.ConverterRegistry;
import org.eclipse.papyrus.infra.queries.core.modisco.ModelQueryNotFoundException;
import org.eclipse.papyrus.infra.queries.core.modisco.ModelQuerySetNotFoundException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryUtil {
    protected static final boolean defaultReturnValue = false;

    protected QueryUtil() {
    }

    public static final boolean evaluateBooleanQuery(ModelQuery query, EObject context, Map<String, Object> parameters) throws Exception {
        IStatus queryStatus = QueryUtil.isValidQuery(query);
        if (!queryStatus.isOK()) {
            throw new Exception(queryStatus.getMessage());
        }
        EList queryParameters = query.getParameters();
        ArrayList<ModelQueryParameterValue> parameterValues = new ArrayList<ModelQueryParameterValue>();
        if (queryParameters == null || queryParameters.isEmpty()) {
            return QueryUtil.evaluateBooleanQuery(query, context, parameterValues);
        }
        IStatus parameterCheck = QueryUtil.isValidParameterSet(query, parameters);
        if (8 == parameterCheck.getSeverity() || 4 == parameterCheck.getSeverity()) {
            Activator.log.error(parameterCheck.getMessage(), null);
            throw new Exception(parameterCheck.getMessage());
        }
        if (2 == parameterCheck.getSeverity()) {
            Activator.log.warn(parameterCheck.getMessage());
        } else if (1 == parameterCheck.getSeverity()) {
            Activator.log.info(parameterCheck.getMessage());
        }
        for (ModelQueryParameter parameter : queryParameters) {
            String parametername = parameter.getName();
            Object value = parameters.get(parametername);
            ModelQueryParameterValue parameterValue = ParameterValueList.createParameterValue((Object)value, (ModelQueryParameter)parameter);
            parameterValues.add(parameterValue);
        }
        return QueryUtil.evaluateBooleanQuery(query, context, parameterValues);
    }

    public static final Object evaluateQuery(EObject context, QueryConfiguration queryConfiguration) throws Exception {
        if (queryConfiguration instanceof ModiscoQueryConfiguration) {
            return QueryUtil.evaluateQuery(context, (ModiscoQueryConfiguration)queryConfiguration);
        }
        throw new Exception("Unhandled kind of query");
    }

    public static final boolean evaluateBooleanQuery(EObject context, QueryConfiguration queryConfiguration) throws Exception {
        if (queryConfiguration instanceof ModiscoQueryConfiguration) {
            return QueryUtil.evaluateBooleanQuery(context, (ModiscoQueryConfiguration)queryConfiguration);
        }
        throw new Exception("Unhandled kind of query");
    }

    public static final boolean evaluateBooleanQuery(EObject context, ModiscoQueryConfiguration queryConfiguration) throws Exception {
        Object result = QueryUtil.evaluateQuery(context, queryConfiguration);
        if (result instanceof Boolean) {
            return (Boolean)result;
        }
        Activator.log.error("Not a boolean result:  " + result, null);
        return false;
    }

    public static final Object evaluateQuery(EObject context, ModiscoQueryConfiguration queryConfiguration) throws Exception {
        ModelQuery query = queryConfiguration.getQuery();
        String modelQuerySetName = query.getModelQuerySet().getName();
        String modelQueryName = query.getName();
        ModelQuery finalModelQuery = QueryUtil.retrieveModelQuery(modelQueryName, modelQuerySetName);
        IStatus queryValidation = QueryUtil.isValidQuery(finalModelQuery);
        if (!queryValidation.isOK()) {
            throw new Exception(queryValidation.getMessage(), queryValidation.getException());
        }
        List<ModelQueryParameterValue> parameterValues = QueryUtil.createParameterValuesListFromConfiguration(context, queryConfiguration);
        return QueryUtil.evaluateQuery(finalModelQuery, context, parameterValues);
    }

    private static List<ModelQueryParameterValue> createParameterValuesListFromConfiguration(EObject context, ModiscoQueryConfiguration queryConfiguration) {
        ArrayList<ModelQueryParameterValue> parameterValues = new ArrayList<ModelQueryParameterValue>();
        EList parameters = queryConfiguration.getQuery().getParameters();
        for (ModelQueryParameter parameter : parameters) {
            Object value = QueryUtil.retrieveParameterValue(context, parameter, queryConfiguration);
            ModelQueryParameterValue parameterValue = ParameterValueList.createParameterValue((Object)value, (ModelQueryParameter)parameter);
            parameterValues.add(parameterValue);
        }
        return parameterValues;
    }

    private static Object retrieveParameterValue(final EObject context, final ModelQueryParameter parameter, ModiscoQueryConfiguration configuration) {
        for (ParameterValue parameterValue : configuration.getParameterValues()) {
            if (!parameter.equals(parameterValue.getParameter())) continue;
            return new ConfigurationSwitch<Object>(){

                public Object caseListParameterValue(ListParameterValue listParameterValue) {
                    ArrayList values = new ArrayList();
                    Class parameterType = parameter.getType().getInstanceClass();
                    for (ParameterValue parameterValue : listParameterValue.getValues()) {
                        values.addAll(ConverterRegistry.getSingleton().convertToList(context, parameterType, parameterValue));
                    }
                    return values;
                }

                public Object caseConstantParameterValue(ConstantParameterValue constantParameterValue) {
                    Class parameterType = parameter.getType().getInstanceClass();
                    try {
                        Object convertedValue = ConverterRegistry.getSingleton().convert(parameterType, constantParameterValue.getValueInstance());
                        return convertedValue;
                    }
                    catch (ConverterNotfoundException e) {
                        Activator.log.error((Throwable)e);
                        return null;
                    }
                }

                public Object caseQueryExecutionValue(QueryExecutionValue queryExecutionValue) {
                    QueryConfiguration configuration = queryExecutionValue.getConfiguration();
                    try {
                        return QueryUtil.evaluateQuery(context, configuration);
                    }
                    catch (Exception e) {
                        Activator.log.error((Throwable)e);
                        return null;
                    }
                }
            }.doSwitch((EObject)parameterValue);
        }
        return null;
    }

    public static final Object evaluateQuery(ModelQuery query, EObject context, List<ModelQueryParameterValue> parameterValues) throws Exception {
        if (QueryUtil.isValidQuery(query).isOK()) {
            AbstractModelQuery myModelQuery = ModelQuerySetCatalog.getSingleton().getModelQueryImpl(query);
            ModelQueryResult result = myModelQuery.evaluate(context, parameterValues);
            if (result.getException() != null) {
                throw new Exception();
            }
            return result.getValue();
        }
        throw new Exception("Query was not a valid query: " + query, null);
    }

    public static final boolean evaluateBooleanQuery(ModelQuery query, EObject context, List<ModelQueryParameterValue> parameterValues) throws Exception {
        Object result = QueryUtil.evaluateQuery(query, context, parameterValues);
        if (result instanceof Boolean) {
            return (Boolean)result;
        }
        Activator.log.error("Query did not return a boolean: " + result, null);
        return false;
    }

    public static final ModelQuery retrieveModelQuery(String queryName, String querySetName) throws ModelQueryNotFoundException, ModelQuerySetNotFoundException {
        ModelQuerySet querySet = ModelQuerySetCatalog.getSingleton().getModelQuerySet(querySetName);
        if (querySet == null) {
            throw new ModelQuerySetNotFoundException(querySetName);
        }
        ModelQuery query = querySet.getQuery(queryName);
        if (query == null) {
            throw new ModelQueryNotFoundException(queryName);
        }
        return query;
    }

    public static final IStatus isValidQuery(ModelQuery query) {
        if (query == null) {
            return new Status(4, "org.eclipse.papyrus.infra.queries.core", "Query should not be null.");
        }
        return Status.OK_STATUS;
    }

    public static final IStatus isValidBooleanQuery(ModelQuery query) {
        IStatus status = QueryUtil.isValidQuery(query);
        if (status.isOK()) {
            EClassifier returnType = query.getReturnType();
            if (returnType == null) {
                return new Status(4, "org.eclipse.papyrus.infra.queries.core", "Query " + query.getName() + " does not have a return value, whereas it should have a boolean return status");
            }
            Class instanceClass = returnType.getInstanceClass();
            if (!Boolean.TYPE.isAssignableFrom(instanceClass)) {
                return new Status(4, "org.eclipse.papyrus.infra.queries.core", "Query " + query.getName() + " should return a value that can be cast into Boolean value. Currently: " + returnType.getInstanceClass());
            }
            if (query.getUpperBound() > 1 || query.getUpperBound() < 0) {
                return new Status(4, "org.eclipse.papyrus.infra.queries.core", "Query " + query.getName() + " should return only one value. Currently: " + query.getUpperBound());
            }
        }
        return status;
    }

    public static final IStatus isValidParameterSet(ModelQuery query, Map<String, Object> parameters) {
        int parameterSize;
        int querySize = query.getParameters().size();
        if (querySize != (parameterSize = parameters.keySet().size())) {
            return new Status(4, "org.eclipse.papyrus.infra.queries.core", "The given parameters set do not have the same size (" + parameterSize + ") than the query parameter set (" + querySize + ")");
        }
        ArrayList<Status> status = new ArrayList<Status>();
        for (String parameterName : parameters.keySet()) {
            ModelQueryParameter queryParameter = QueryUtil.retrieveParameterByName(query, parameterName);
            if (queryParameter != null) continue;
            status.add(new Status(4, "org.eclipse.papyrus.infra.queries.core", "Impossible to find the parameter " + parameterName + " in the query parameters list for query: " + query.getName()));
        }
        if (status.size() > 0) {
            return new MultiStatus("org.eclipse.papyrus.infra.queries.core", 0, status.toArray(new IStatus[status.size()]), "", null);
        }
        return Status.OK_STATUS;
    }

    private static final ModelQueryParameter retrieveParameterByName(ModelQuery query, String parameterName) {
        for (ModelQueryParameter queryParameter : query.getParameters()) {
            if (!parameterName.equals(queryParameter.getName())) continue;
            return queryParameter;
        }
        return null;
    }
}

