/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.services.controlmode.action;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.ui.EMFEditUIPlugin;
import org.eclipse.emf.edit.ui.action.CommandActionHandler;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.papyrus.commands.CheckedOperationHistory;
import org.eclipse.papyrus.infra.core.resource.AbstractBaseModel;
import org.eclipse.papyrus.infra.core.resource.IModel;
import org.eclipse.papyrus.infra.core.resource.ModelUtils;
import org.eclipse.papyrus.infra.core.utils.EditorUtils;
import org.eclipse.papyrus.infra.services.controlmode.commands.UncontrolCommand;
import org.eclipse.papyrus.infra.services.controlmode.util.ControlModeUtil;
import org.eclipse.papyrus.infra.widgets.toolbox.notification.Type;
import org.eclipse.papyrus.infra.widgets.toolbox.notification.builders.NotificationBuilder;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class PapyrusUncontrolAction
extends CommandActionHandler {
    private EObject eObject;
    private IStructuredSelection selection;

    public PapyrusUncontrolAction(EditingDomain domain) {
        super(domain, EMFEditUIPlugin.INSTANCE.getString("_UI_Uncontrol_menu_item"));
        this.setDescription("_UI_Uncontrol_menu_item_description");
        this.setToolTipText("Merge the external model with the current model");
    }

    public boolean isEnabled() {
        return ControlModeUtil.canUncontrol(this.eObject);
    }

    public boolean updateSelection(IStructuredSelection theSelection) {
        boolean result = false;
        this.selection = theSelection;
        if (this.selection.size() == 1) {
            Object object = AdapterFactoryEditingDomain.unwrap((Object)this.selection.getFirstElement());
            if (object instanceof IAdaptable) {
                object = ((IAdaptable)object).getAdapter(EObject.class);
            }
            if (this.domain != null) {
                result = this.domain.isControllable(object);
                if (result) {
                    this.eObject = (EObject)object;
                    result = AdapterFactoryEditingDomain.isControlled((Object)this.eObject);
                } else {
                    this.eObject = null;
                }
            }
        }
        return result;
    }

    public void run() {
        IModel umlModel = ModelUtils.getModelSet().getModel("org.eclipse.papyrus.infra.core.resource.uml.UmlModel");
        Resource parentOfControlledResource = this.getParentOfControlledResource(this.eObject);
        boolean enableAction = false;
        if (this.eObject != null && umlModel instanceof AbstractBaseModel) {
            enableAction = ((AbstractBaseModel)umlModel).getResource().equals(parentOfControlledResource);
        }
        if (!enableAction) {
            NotificationBuilder.createAsyncPopup((String)("You must perform uncontrol action from the resource:\n" + parentOfControlledResource.getURI().trimFileExtension().toString() + " for this element")).setType(Type.INFO).run();
            return;
        }
        try {
            boolean confirmDelete = MessageDialog.openQuestion((Shell)Display.getDefault().getActiveShell(), (String)"Delete controlled resources?", (String)"Delete the original controlled files ?");
            UncontrolCommand transactionalCommand = new UncontrolCommand(EditorUtils.getTransactionalEditingDomain(), this.eObject, "Uncontrol", null, confirmDelete);
            IStatus status = CheckedOperationHistory.getInstance().execute((IUndoableOperation)transactionalCommand, (IProgressMonitor)new NullProgressMonitor(), null);
            if (!status.isOK()) {
                NotificationBuilder.createErrorPopup((String)status.getMessage()).setTitle("Unable to uncontrol").run();
            }
        }
        catch (ExecutionException e) {
            MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)EMFEditUIPlugin.INSTANCE.getString("_UI_InvalidURI_label"), (String)EMFEditUIPlugin.INSTANCE.getString("_WARN_CannotCreateResource"));
            EMFEditUIPlugin.INSTANCE.log((Object)e);
        }
    }

    private Resource getParentOfControlledResource(EObject eObject) {
        Resource currentResource = eObject.eResource();
        if (eObject.eContainer() != null) {
            if (!currentResource.equals(eObject.eContainer().eResource())) {
                return eObject.eContainer().eResource();
            }
            this.getParentOfControlledResource(eObject.eContainer());
        }
        return null;
    }
}

