/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.services.controlmode.commands;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.ui.EMFEditUIPlugin;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.emf.commands.core.command.EditingDomainUndoContext;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.papyrus.commands.wrappers.GMFtoEMFCommandWrapper;
import org.eclipse.papyrus.infra.core.modelsetquery.ModelSetQuery;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.resource.notation.NotationUtils;
import org.eclipse.papyrus.infra.core.resource.sasheditor.SashModelUtils;
import org.eclipse.papyrus.infra.core.resource.uml.UmlUtils;
import org.eclipse.papyrus.infra.core.sashwindows.di.PageRef;
import org.eclipse.papyrus.infra.core.sashwindows.di.SashWindowsMngr;
import org.eclipse.papyrus.infra.core.sashwindows.di.exception.SashEditorException;
import org.eclipse.papyrus.infra.core.sashwindows.di.util.DiUtils;
import org.eclipse.papyrus.infra.core.utils.EditorUtils;
import org.eclipse.papyrus.infra.services.controlmode.commands.IControlCommand;
import org.eclipse.papyrus.infra.services.controlmode.commands.UncontrolCommand;
import org.eclipse.papyrus.infra.services.controlmode.history.utils.HistoryUtils;
import org.eclipse.papyrus.infra.services.controlmode.mm.history.ControledResource;
import org.eclipse.papyrus.infra.services.controlmode.mm.history.historyFactory;
import org.eclipse.papyrus.infra.services.controlmode.mm.history.historyPackage;
import org.eclipse.papyrus.infra.widgets.toolbox.notification.NotificationRunnable;
import org.eclipse.papyrus.infra.widgets.toolbox.notification.Type;
import org.eclipse.papyrus.infra.widgets.toolbox.notification.builders.IContext;
import org.eclipse.papyrus.infra.widgets.toolbox.notification.builders.NotificationBuilder;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ControlCommand
extends AbstractTransactionalCommand {
    private static final String CONTROL_EXTENSION_POINT_ID = "org.eclipse.papyrus.infra.services.controlmode.customControlCommand";
    private static final String CONTROL_CMD_ATTRIBUTE_EXTENSION_POINT = "controlCommand";
    private static final String CONTROL_CMD_ELEMENT_EXTENSION_POINT = "customControlCommand";
    protected EObject eObject;
    protected ModelSet modelSet;
    protected Resource controlledModel;
    protected Resource controlledNotation;
    protected Resource controlledDI;
    protected List<IControlCommand> commands;

    public ControlCommand(TransactionalEditingDomain domain, Resource model, EObject selectedObject, String label, List<?> affectedFiles) {
        super(domain, label, affectedFiles);
        this.eObject = selectedObject;
        this.controlledModel = model;
        this.addContext((IUndoContext)new EditingDomainUndoContext((EditingDomain)domain));
        ResourceSet set = domain.getResourceSet();
        if (set instanceof ModelSet) {
            this.modelSet = (ModelSet)set;
        }
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        this.commands = this.getCommandExtensions();
        IStatus status = this.doRedo(monitor, info);
        CommandResult result = status.equals(Status.OK_STATUS) ? CommandResult.newOKCommandResult() : (status.equals(Status.CANCEL_STATUS) ? CommandResult.newErrorCommandResult((String)"Unable to execute control command") : CommandResult.newCancelledCommandResult());
        return result;
    }

    protected IStatus doUndo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        UncontrolCommand transactionalCommand = new UncontrolCommand(this.getEditingDomain(), this.eObject, "Uncontrol", null, true);
        this.getEditingDomain().getCommandStack().execute((Command)new GMFtoEMFCommandWrapper((ICommand)transactionalCommand));
        return Status.OK_STATUS;
    }

    protected IStatus doRedo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        if (this.modelSet == null) {
            this.modelSet = EditorUtils.getDiResourceSet();
        }
        URI newNotationURI = URI.createURI((String)this.controlledModel.getURI().trimFileExtension().appendFileExtension("notation").toString());
        this.controlledNotation = this.getResource(newNotationURI);
        URI newDiURI = URI.createURI((String)this.controlledModel.getURI().trimFileExtension().appendFileExtension("di").toString());
        this.controlledDI = this.getResource(newDiURI);
        List<Diagram> diagrams = this.getDiagrams(this.eObject);
        CompoundCommand compoundCommand = new CompoundCommand();
        this.controlModel(compoundCommand);
        this.controlNotation(compoundCommand, diagrams);
        try {
            this.controlDi(compoundCommand, diagrams);
        }
        catch (SashEditorException exception) {
            EMFEditUIPlugin.INSTANCE.log((Object)exception);
            return Status.CANCEL_STATUS;
        }
        EcoreUtil.resolveAll((ResourceSet)this.getEditingDomain().getResourceSet());
        if (compoundCommand.canExecute()) {
            compoundCommand.execute();
            return Status.OK_STATUS;
        }
        return Status.CANCEL_STATUS;
    }

    protected List<Diagram> getDiagrams(EObject eObject) {
        LinkedList<Diagram> diagrams = new LinkedList<Diagram>();
        Resource resource = eObject.eResource();
        Resource notationResource = this.modelSet.getResource(resource.getURI().trimFileExtension().appendFileExtension("notation"), false);
        diagrams.addAll(NotationUtils.getDiagrams((Resource)notationResource, (EObject)eObject));
        return diagrams;
    }

    protected void controlModel(CompoundCommand compoundCommand) {
        this.control((EditingDomain)this.getEditingDomain(), this.eObject, UmlUtils.getUmlModel((ModelSet)this.modelSet).getResource(), this.controlledModel, compoundCommand, IControlCommand.STATE_CONTROL.PRE_MODEL);
        compoundCommand.append((Command)new AddCommand((EditingDomain)this.getEditingDomain(), this.controlledModel.getContents(), (Object)this.eObject));
        this.assignControlledResourceOfCurrentElement((EditingDomain)this.getEditingDomain(), compoundCommand, this.getHistoryResource(this.eObject), this.eObject.eResource().getURI().toString(), this.controlledModel.getURI().toString());
        this.control((EditingDomain)this.getEditingDomain(), this.eObject, UmlUtils.getUmlModel((ModelSet)this.modelSet).getResource(), this.controlledModel, compoundCommand, IControlCommand.STATE_CONTROL.POST_MODEL);
    }

    protected void controlNotation(CompoundCommand compoundCommand, List<Diagram> diagrams) {
        for (Diagram diag : diagrams) {
            this.control((EditingDomain)this.getEditingDomain(), (EObject)diag, this.getNotationResourceForCurrent(this.eObject), this.controlledNotation, compoundCommand, IControlCommand.STATE_CONTROL.PRE_NOTATION);
        }
        if (!diagrams.isEmpty()) {
            compoundCommand.append((Command)new AddCommand((EditingDomain)this.getEditingDomain(), this.controlledNotation.getContents(), diagrams));
        }
        HashSet<Resource> resources = new HashSet<Resource>(diagrams.size());
        for (Diagram d : diagrams) {
            resources.add(d.eResource());
        }
        for (Resource r : resources) {
            this.assignControlledResourceOfCurrentElement((EditingDomain)this.getEditingDomain(), compoundCommand, this.getHistoryResource(this.eObject), r.getURI().toString(), this.controlledNotation.getURI().toString());
        }
        for (Diagram diag : diagrams) {
            this.control((EditingDomain)this.getEditingDomain(), (EObject)diag, this.getNotationResourceForCurrent(this.eObject), this.controlledNotation, compoundCommand, IControlCommand.STATE_CONTROL.POST_NOTATION);
        }
        this.control((EditingDomain)this.getEditingDomain(), this.eObject, this.getNotationResourceForCurrent(this.eObject), this.controlledNotation, compoundCommand, IControlCommand.STATE_CONTROL.POST_NOTATION);
    }

    protected void controlDi(CompoundCommand compoundCommand, List<Diagram> diagrams) throws SashEditorException {
        final SashWindowsMngr windowsMngr = DiUtils.createDefaultSashWindowsMngr();
        Resource diResource = SashModelUtils.getSashModel((ModelSet)this.modelSet).getResource();
        for (Diagram diagram : diagrams) {
            PageRef pageRef = DiUtils.getPageRef((Resource)diResource, (EObject)diagram);
            if (pageRef == null) continue;
            windowsMngr.getPageList().addPage(pageRef.getPageIdentifier());
            DiUtils.addPageToTabFolder((SashWindowsMngr)windowsMngr, (PageRef)pageRef);
        }
        this.control((EditingDomain)this.getEditingDomain(), this.eObject, diResource, this.controlledDI, compoundCommand, IControlCommand.STATE_CONTROL.PRE_DI);
        compoundCommand.append((Command)new AddCommand((EditingDomain)this.getEditingDomain(), this.controlledDI.getContents(), (Object)windowsMngr, 0));
        Adapter adapter = new Adapter(){

            public void notifyChanged(Notification notification) {
            }

            public Notifier getTarget() {
                return windowsMngr;
            }

            public void setTarget(Notifier newTarget) {
            }

            public boolean isAdapterForType(Object type) {
                return type == SashWindowsMngr.class;
            }
        };
        this.eObject.eAdapters().add((Object)adapter);
        this.control((EditingDomain)this.getEditingDomain(), this.eObject, diResource, this.controlledDI, compoundCommand, IControlCommand.STATE_CONTROL.POST_DI);
        this.eObject.eAdapters().remove((Object)adapter);
    }

    protected void notifySave() {
        new NotificationBuilder().setMessage("Your element has been controlled.\nYou need to save your model to see modifications in your workspace.\nDo you want to save ?").addAction(new NotificationRunnable(){

            public void run(IContext context) {
                try {
                    Display.getDefault().syncExec(new Runnable(){

                        public void run() {
                            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor().doSave((IProgressMonitor)new NullProgressMonitor());
                        }
                    });
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }

            public String getLabel() {
                return "Save";
            }
        }).setTemporary(true).setAsynchronous(true).setType(Type.INFO).setDelay(2000L).run();
    }

    protected void assignControlledResourceOfCurrentElement(EditingDomain domain, CompoundCommand compoundCommand, Resource model, String currentURL, String newURL) {
        if (model == null) {
            return;
        }
        URI uriPath = HistoryUtils.getURIFullPath((String)currentURL);
        String currentURLResolved = HistoryUtils.resolve((URI)uriPath, (String)currentURL);
        String newURLResolved = HistoryUtils.resolve((URI)uriPath, (String)newURL);
        ControledResource child = historyFactory.eINSTANCE.createControledResource();
        child.setResourceURL(newURLResolved);
        ControledResource resource = this.getControledResource(model);
        Resource parentResource = null;
        ControledResource parent = null;
        if (resource == null) {
            parent = historyFactory.eINSTANCE.createControledResource();
            parent.setResourceURL(currentURLResolved);
            parent.getChildren().add((Object)child);
            parentResource = model;
            compoundCommand.append((Command)new AddCommand(domain, parentResource.getContents(), Collections.singleton(parent)));
        } else {
            if (this.isCurrentURL(currentURLResolved, resource)) {
                parent = resource;
            }
            if (parent == null) {
                ControledResource modelRoot = this.getControledResource(model);
                Collection controled = ModelSetQuery.getObjectsOfType((EObject)modelRoot, (EClassifier)historyPackage.Literals.CONTROLED_RESOURCE);
                for (EObject next : controled) {
                    ControledResource tmp;
                    if (!(next instanceof ControledResource) || !this.isCurrentURL(currentURLResolved, tmp = (ControledResource)next)) continue;
                    parent = tmp;
                    break;
                }
            }
            if (parent == null) {
                parent = historyFactory.eINSTANCE.createControledResource();
                parent.setResourceURL(currentURLResolved);
                parentResource = resource.eResource();
                if (!currentURLResolved.endsWith("notation")) {
                    compoundCommand.append((Command)new AddCommand(domain, parentResource.getContents(), Collections.singleton(parent)));
                }
            }
            if (parent != null) {
                compoundCommand.append(AddCommand.create((EditingDomain)domain, (Object)parent, (Object)historyPackage.Literals.CONTROLED_RESOURCE__CHILDREN, Collections.singleton(child)));
            }
        }
        LinkedList<ControledResource> controledFromParent = new LinkedList<ControledResource>();
        if (parentResource == null) {
            parentResource = model;
        }
        if (parentResource != null) {
            for (EObject e : parentResource.getContents()) {
                if (!(e instanceof ControledResource)) continue;
                ControledResource aControled = (ControledResource)e;
                controledFromParent.add(aControled);
                TreeIterator i = aControled.eAllContents();
                while (i.hasNext()) {
                    EObject tmp = (EObject)i.next();
                    if (!(tmp instanceof ControledResource)) continue;
                    controledFromParent.add((ControledResource)tmp);
                }
            }
        }
        if (!newURL.endsWith("notation")) {
            this.assignToChildExistingControledResources(domain, compoundCommand, child, newURL, controledFromParent, currentURL, URI.createURI((String)newURL), uriPath);
        }
    }

    protected void assignToChildExistingControledResources(EditingDomain domain, CompoundCommand compoundCommand, ControledResource child, String controledResourceURL, List<ControledResource> controledFromParent, String parentURL, URI controledURIFullPath, URI parentURIFullPath) {
        for (ControledResource r : controledFromParent) {
            EObject top;
            URI fullPathParent;
            Resource resourceLoaded;
            if (r.getResourceURL() == null || (resourceLoaded = this.modelSet.getResource(fullPathParent = URI.createURI((String)r.getResourceURL()).resolve(parentURIFullPath), false)) == null || resourceLoaded.getContents().isEmpty() || !this.isInRootHierarchy(top = (EObject)resourceLoaded.getContents().get(0), this.eObject)) continue;
            URI newResolvedURIFromChild = fullPathParent.deresolve(controledURIFullPath, false, true, true);
            ControledResource aNewOne = historyFactory.eINSTANCE.createControledResource();
            aNewOne.setResourceURL(newResolvedURIFromChild.toString());
            compoundCommand.append((Command)new AddCommand(domain, (EObject)this.getControledResource(this.controlledDI, URI.createURI((String)controledResourceURL).lastSegment(), compoundCommand, (EditingDomain)this.getEditingDomain()), (EStructuralFeature)historyPackage.Literals.CONTROLED_RESOURCE__CHILDREN, (Object)aNewOne));
            compoundCommand.append(RemoveCommand.create((EditingDomain)domain, (Object)r.eContainer(), (Object)historyPackage.Literals.CONTROLED_RESOURCE__CHILDREN, (Object)r));
            URI newNotation = newResolvedURIFromChild.trimFileExtension().appendFileExtension("notation");
            ControledResource aNewOneNotation = historyFactory.eINSTANCE.createControledResource();
            aNewOneNotation.setResourceURL(newNotation.toString());
            compoundCommand.append((Command)new AddCommand(domain, (EObject)this.getControledResource(this.controlledDI, URI.createURI((String)URI.createURI((String)controledResourceURL).trimFileExtension().appendFileExtension("notation").toString()).lastSegment(), compoundCommand, (EditingDomain)this.getEditingDomain()), (EStructuralFeature)historyPackage.Literals.CONTROLED_RESOURCE__CHILDREN, (Object)aNewOneNotation));
            URI notationParentURL = URI.createURI((String)r.getParent().getResourceURL()).trimFileExtension().appendFileExtension("notation");
            ControledResource notationParent = this.getControledResource(r.eResource(), notationParentURL.toString(), compoundCommand, domain);
            for (ControledResource notationChild : notationParent.getChildren()) {
                URI notationURI = URI.createURI((String)r.getResourceURL()).trimFileExtension().appendFileExtension("notation");
                if (!notationChild.getResourceURL().equals(notationURI.toString())) continue;
                compoundCommand.append(RemoveCommand.create((EditingDomain)domain, (Object)notationParent, (Object)historyPackage.Literals.CONTROLED_RESOURCE__CHILDREN, (Object)notationChild));
            }
        }
    }

    protected ControledResource getControledResource(Resource resource) {
        for (EObject e : resource.getContents()) {
            if (!(e instanceof ControledResource)) continue;
            return (ControledResource)e;
        }
        return null;
    }

    protected ControledResource getControledResource(Resource resource, String controledResourceURL, CompoundCommand command, EditingDomain domain) {
        ControledResource result = null;
        for (EObject e : resource.getContents()) {
            if (!(e instanceof ControledResource)) continue;
            ControledResource controled = (ControledResource)e;
            if (controledResourceURL == null || !controledResourceURL.equals(controled.getResourceURL())) continue;
            result = controled;
        }
        if (result == null) {
            result = historyFactory.eINSTANCE.createControledResource();
            result.setResourceURL(controledResourceURL);
            command.append((Command)new AddCommand(domain, resource.getContents(), (Object)result, 0));
        }
        return result;
    }

    protected boolean isInRootHierarchy(EObject start, EObject search) {
        while (start != null && start != search) {
            start = start.eContainer();
        }
        return start != null;
    }

    protected boolean isCurrentURL(String currentURL, ControledResource resource) {
        return resource.getResourceURL() != null && resource.getResourceURL().equals(currentURL);
    }

    protected Resource getNotationResourceForCurrent(EObject eObject) {
        return this.modelSet.getResource(eObject.eResource().getURI().trimFileExtension().appendFileExtension("notation"), true);
    }

    protected Resource getHistoryResource(EObject eObject) {
        if (eObject.eResource() != null) {
            return this.modelSet.getResource(eObject.eResource().getURI().trimFileExtension().appendFileExtension("di"), true);
        }
        return null;
    }

    public void control(EditingDomain domain, EObject selection, Resource source, Resource target, CompoundCommand command, IControlCommand.STATE_CONTROL state) {
        for (IControlCommand cmd : this.commands) {
            if (!cmd.provides(selection, state, source, target)) continue;
            cmd.control(domain, selection, state, source, target, command);
        }
    }

    private List<IControlCommand> getCommandExtensions() {
        IConfigurationElement[] extensions;
        LinkedList<IControlCommand> commands = new LinkedList<IControlCommand>();
        IConfigurationElement[] iConfigurationElementArray = extensions = Platform.getExtensionRegistry().getConfigurationElementsFor(CONTROL_EXTENSION_POINT_ID);
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement e = iConfigurationElementArray[n2];
            if (CONTROL_CMD_ELEMENT_EXTENSION_POINT.equals(e.getName())) {
                try {
                    IControlCommand controlCmd = (IControlCommand)e.createExecutableExtension(CONTROL_CMD_ATTRIBUTE_EXTENSION_POINT);
                    commands.add(controlCmd);
                }
                catch (CoreException exception) {
                    exception.printStackTrace();
                }
            }
            ++n2;
        }
        return commands;
    }

    protected Resource getResource(URI uri) {
        Resource res = this.getEditingDomain().getResourceSet().getResource(uri, false);
        if (res == null) {
            res = this.getEditingDomain().getResourceSet().createResource(uri);
        }
        return res;
    }
}

