/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.table.controlmode.handlers;

import java.util.Iterator;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.papyrus.infra.core.sashwindows.di.SashWindowsMngr;
import org.eclipse.papyrus.infra.services.controlmode.commands.IControlCommand;
import org.eclipse.papyrus.infra.table.controlmode.helpers.TableMoveHelper;

public class PapyrusTableControlCommand
implements IControlCommand {
    public void control(EditingDomain domain, EObject selection, IControlCommand.STATE_CONTROL state, Resource source, Resource target, CompoundCommand commandToModify) {
        switch (state) {
            case POST_DI: {
                TableMoveHelper.addAllTableMoveCommands(domain, selection, source, target, commandToModify);
                SashWindowsMngr windowsMngr = null;
                Iterator iter = selection.eAdapters().iterator();
                while (iter.hasNext() && windowsMngr == null) {
                    Adapter current = (Adapter)iter.next();
                    if (!current.isAdapterForType(SashWindowsMngr.class)) continue;
                    windowsMngr = (SashWindowsMngr)current.getTarget();
                }
                if (windowsMngr == null) break;
                TableMoveHelper.addAllPageRefTableMoveCommands((TransactionalEditingDomain)domain, selection, source, target, windowsMngr, commandToModify);
            }
        }
    }

    public boolean provides(EObject selection, IControlCommand.STATE_CONTROL state, Resource source, Resource target) {
        return "di".equals(target.getURI().fileExtension());
    }
}

