/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.table.controlmode.helpers;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.TableInstance;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.TableinstancePackage;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance2.TableInstance2;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.papyrus.commands.wrappers.GMFtoEMFCommandWrapper;
import org.eclipse.papyrus.infra.core.sashwindows.di.PageRef;
import org.eclipse.papyrus.infra.core.sashwindows.di.SashWindowsMngr;
import org.eclipse.papyrus.infra.core.sashwindows.di.exception.SashEditorException;
import org.eclipse.papyrus.infra.core.sashwindows.di.util.DiUtils;
import org.eclipse.papyrus.infra.core.utils.PapyrusEcoreUtils;
import org.eclipse.papyrus.infra.table.instance.papyrustableinstance.PapyrusTableInstance;
import org.eclipse.papyrus.infra.table.instance.papyrustableinstance.PapyrustableinstancePackage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TableMoveHelper {
    private TableMoveHelper() {
    }

    public static void addAllPageRefTableMoveCommands(TransactionalEditingDomain domain, EObject selection, Resource source, Resource target, final SashWindowsMngr windowsMngr, CompoundCommand commandToModify) {
        Collection<PapyrusTableInstance> tables = TableMoveHelper.getPapyrusTableInstances(selection);
        for (PapyrusTableInstance pTable : tables) {
            final PageRef pageRef = DiUtils.getPageRef((Resource)source, (EObject)pTable);
            AbstractTransactionalCommand addPageCommand = new AbstractTransactionalCommand(domain, "Add Page Command", null){

                protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                    windowsMngr.getPageList().addPage(pageRef.getPageIdentifier());
                    try {
                        DiUtils.addPageToTabFolder((SashWindowsMngr)windowsMngr, (PageRef)pageRef);
                    }
                    catch (SashEditorException e) {
                        return CommandResult.newErrorCommandResult((Throwable)e);
                    }
                    return CommandResult.newOKCommandResult();
                }
            };
            commandToModify.append((Command)new GMFtoEMFCommandWrapper((ICommand)addPageCommand));
        }
    }

    public static void addAllTableMoveCommands(EditingDomain domain, EObject selection, Resource source, final Resource target, CompoundCommand commandToModify) {
        if (!(domain instanceof TransactionalEditingDomain)) {
            throw new RuntimeException("Unable to retrieve the transactional editing domain");
        }
        TransactionalEditingDomain editingDomain = (TransactionalEditingDomain)domain;
        final Collection<PapyrusTableInstance> pTables = TableMoveHelper.getPapyrusTableInstances(selection);
        final ArrayList<TableInstance2> tablesInstances = new ArrayList<TableInstance2>();
        for (PapyrusTableInstance papyrusTableInstance : pTables) {
            tablesInstances.add(papyrusTableInstance.getTable());
        }
        AbstractTransactionalCommand changeResourceCommand = new AbstractTransactionalCommand(editingDomain, "", Collections.emptyList()){

            protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                target.getContents().addAll(pTables);
                target.getContents().addAll(tablesInstances);
                return CommandResult.newOKCommandResult();
            }
        };
        commandToModify.append((Command)new GMFtoEMFCommandWrapper((ICommand)changeResourceCommand));
    }

    public static Collection<PapyrusTableInstance> getPapyrusTableInstances(EObject selection) {
        ArrayList<PapyrusTableInstance> pTables = new ArrayList<PapyrusTableInstance>();
        Iterable<EObject> allDescendingPapyrusTables = TableMoveHelper.createDescendantTablesIterable(selection);
        for (EObject eObject : allDescendingPapyrusTables) {
            if (!(eObject instanceof PapyrusTableInstance)) continue;
            pTables.add((PapyrusTableInstance)eObject);
        }
        return pTables;
    }

    public static Iterable<EObject> createDescendantTablesIterable(EObject context) {
        HashSet result = Sets.newHashSet();
        TreeIterator eAllContents = EcoreUtil.getAllProperContents((EObject)context, (boolean)true);
        Iterator contextAndDescendants = Iterators.concat((Iterator)eAllContents, (Iterator)Iterators.singletonIterator((Object)context));
        Predicate<EStructuralFeature.Setting> keepPapyrusTableInstances = new Predicate<EStructuralFeature.Setting>(){

            public boolean apply(EStructuralFeature.Setting setting) {
                boolean result = true;
                if (setting != null) {
                    EObject settingEObject = setting.getEObject();
                    result &= settingEObject instanceof PapyrusTableInstance;
                    result &= PapyrustableinstancePackage.Literals.PAPYRUS_TABLE_INSTANCE__TABLE == setting.getEStructuralFeature();
                } else {
                    result = false;
                }
                return result;
            }
        };
        Predicate<EStructuralFeature.Setting> keepTableInstances = new Predicate<EStructuralFeature.Setting>((Predicate)keepPapyrusTableInstances){
            private final /* synthetic */ Predicate val$keepPapyrusTableInstances;
            {
                this.val$keepPapyrusTableInstances = predicate;
            }

            public boolean apply(EStructuralFeature.Setting setting) {
                boolean result = true;
                if (setting != null) {
                    EObject settingEObject = setting.getEObject();
                    result &= settingEObject instanceof TableInstance;
                    boolean bl = setting.getEStructuralFeature() == TableinstancePackage.Literals.TABLE_INSTANCE__CONTEXT;
                    Collection references = PapyrusEcoreUtils.getUsages((EObject)settingEObject);
                    Iterable papyrusTableInstances = Iterables.filter((Iterable)references, (Predicate)this.val$keepPapyrusTableInstances);
                    result = (result &= bl) && !Iterables.isEmpty((Iterable)papyrusTableInstances);
                } else {
                    result = false;
                }
                return result;
            }
        };
        Function<EStructuralFeature.Setting, EObject> getEObject = new Function<EStructuralFeature.Setting, EObject>((Predicate)keepPapyrusTableInstances){
            private final /* synthetic */ Predicate val$keepPapyrusTableInstances;
            {
                this.val$keepPapyrusTableInstances = predicate;
            }

            public EObject apply(EStructuralFeature.Setting input) {
                EObject settingEObject = input.getEObject();
                Collection references = PapyrusEcoreUtils.getUsages((EObject)settingEObject);
                Iterable papyrusTableInstances = Iterables.filter((Iterable)references, (Predicate)this.val$keepPapyrusTableInstances);
                return ((EStructuralFeature.Setting)Iterables.get((Iterable)papyrusTableInstances, (int)0)).getEObject();
            }
        };
        while (contextAndDescendants.hasNext()) {
            EObject current = (EObject)contextAndDescendants.next();
            Collection usages = PapyrusEcoreUtils.getUsages((EObject)current);
            Iterable tableInstanceSettings = Iterables.filter((Iterable)usages, (Predicate)keepTableInstances);
            Iterable papyrusTableInstances = Iterables.transform((Iterable)tableInstanceSettings, (Function)getEObject);
            Iterables.addAll((Collection)result, (Iterable)papyrusTableInstances);
        }
        return result;
    }
}

