/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.widgets.toolbox.notification.builders;

import org.eclipse.papyrus.infra.widgets.toolbox.notification.IBuilder;
import org.eclipse.papyrus.infra.widgets.toolbox.notification.INotification;
import org.eclipse.papyrus.infra.widgets.toolbox.notification.builders.NotificationBuilder;
import org.eclipse.papyrus.infra.widgets.toolbox.notification.builders.PropertyWrapper;
import org.eclipse.papyrus.infra.widgets.toolbox.notification.popups.IconAndMessagePapyrusPopup;
import org.eclipse.papyrus.infra.widgets.toolbox.notification.popups.MessagePapyrusPopup;
import org.eclipse.papyrus.infra.widgets.toolbox.notification.popups.PopupNotification;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class PopupBuilder
implements IBuilder {
    public INotification build(PropertyWrapper wrapper, FormToolkit toolkit) {
        MessagePapyrusPopup popup = null;
        String title = "Papyrus";
        if (wrapper.getTitle() != null) {
            title = wrapper.getTitle();
        }
        String message = null;
        if (wrapper.getMessage() != null) {
            message = wrapper.getMessage();
        }
        Shell activeShell = new Shell(Display.getDefault());
        if (wrapper.getType() != null) {
            popup = new IconAndMessagePapyrusPopup(activeShell, toolkit, message, wrapper.getType());
        } else if (wrapper.getImage() != null) {
            popup = new IconAndMessagePapyrusPopup(activeShell, toolkit, message);
            ((IconAndMessagePapyrusPopup)popup).setImage(wrapper.getImage());
        } else {
            popup = new MessagePapyrusPopup(activeShell, toolkit, message);
        }
        popup.setTitle(title);
        popup.setUseHtml(wrapper.isHtml());
        if (wrapper.getComposite() != null) {
            popup.setCompositeCreator(wrapper.getComposite());
            popup.setTitle(title);
        }
        if (wrapper.getActions() != null) {
            popup.addRunnables(wrapper.getActions());
        }
        PopupNotification result = new PopupNotification(popup);
        popup.setINotification(result);
        result.setResult(popup.open());
        return result;
    }

    public boolean accept(String parameterName, Object value) {
        if (NotificationBuilder.ASYNCHRONOUS.equals(parameterName)) {
            return value instanceof Boolean && (Boolean)value == false;
        }
        if (NotificationBuilder.DELAY.equals(parameterName)) {
            return false;
        }
        if (NotificationBuilder.TITLE.equals(parameterName)) {
            return true;
        }
        if (NotificationBuilder.TYPE.equals(parameterName)) {
            return true;
        }
        if (NotificationBuilder.IMAGE.equals(parameterName)) {
            return true;
        }
        if (NotificationBuilder.MESSAGE.equals(parameterName)) {
            return true;
        }
        if (NotificationBuilder.COMPOSITE.equals(parameterName)) {
            return true;
        }
        if (NotificationBuilder.HTML.equals(parameterName)) {
            return true;
        }
        if (NotificationBuilder.ACTION.equals(parameterName)) {
            return true;
        }
        if (NotificationBuilder.TEMPORARY.equals(parameterName)) {
            return value instanceof Boolean && (Boolean)value == false;
        }
        return false;
    }
}

