/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sysml.diagram.blockdefinition.helper.advice;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.emf.type.core.edithelper.AbstractEditHelperAdvice;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyDependentsRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.MoveRequest;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.uml.diagram.common.util.CrossReferencerUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeleteViewDuringMoveHelperAdvice
extends AbstractEditHelperAdvice {
    protected ICommand getBeforeMoveCommand(MoveRequest request) {
        ICommand moveCommand = super.getBeforeMoveCommand(request);
        HashSet<View> viewsToDestroy = new HashSet<View>();
        for (EObject eObject : request.getElementsToMove().keySet()) {
            viewsToDestroy.addAll(this.getViewsToDestroy(eObject));
        }
        if (!viewsToDestroy.isEmpty()) {
            DestroyDependentsRequest ddr = new DestroyDependentsRequest(request.getEditingDomain(), request.getTargetContainer(), false);
            ICommand destroyViewsCommand = ddr.getDestroyDependentsCommand(viewsToDestroy);
            moveCommand = CompositeCommand.compose((ICommand)moveCommand, (ICommand)destroyViewsCommand);
        }
        return moveCommand;
    }

    protected Set<View> getViewsToDestroy(EObject movedObject) {
        HashSet<View> viewsToDestroy = new HashSet<View>();
        for (View view : CrossReferencerUtil.getCrossReferencingViews((EObject)movedObject, (String)"BlockDefinition")) {
            String containerType;
            String string = containerType = ViewUtil.getViewContainer((EObject)view) != null ? ViewUtil.getViewContainer((EObject)view).getType() : null;
            if (containerType == null || "BlockDefinition".equals(containerType)) continue;
            viewsToDestroy.add(view);
        }
        return viewsToDestroy;
    }
}

