/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.edit.policy;

import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.commands.SetBoundsCommand;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.CreationEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.l10n.DiagramUIMessages;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewRequest;
import org.eclipse.gmf.runtime.emf.commands.core.command.CompositeTransactionalCommand;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.gmf.diagram.common.commands.CreateViewCommand;
import org.eclipse.papyrus.uml.diagram.common.locator.PortPositionLocator;

public class StructuredClassifierCreationEditPolicy
extends CreationEditPolicy {
    protected Command getReparentCommand(ChangeBoundsRequest request) {
        return UnexecutableCommand.INSTANCE;
    }

    protected Command getCreateCommand(CreateViewRequest request) {
        TransactionalEditingDomain editingDomain = ((IGraphicalEditPart)this.getHost()).getEditingDomain();
        CompositeTransactionalCommand cc = new CompositeTransactionalCommand(editingDomain, DiagramUIMessages.AddCommand_Label);
        for (CreateViewRequest.ViewDescriptor descriptor : request.getViewDescriptors()) {
            CreateViewCommand createCommand = new CreateViewCommand(editingDomain, descriptor, (View)this.getHost().getModel());
            createCommand = CompositeCommand.compose((ICommand)createCommand, (ICommand)this.getSetBoundsCommand(request, descriptor));
            cc.compose((IUndoableOperation)createCommand);
        }
        return new ICommandProxy(cc.reduce());
    }

    private ICommand getSetBoundsCommand(CreateViewRequest request, CreateViewRequest.ViewDescriptor descriptor) {
        SetBoundsCommand setBoundsCommand = null;
        TransactionalEditingDomain editingDomain = ((IGraphicalEditPart)this.getHost()).getEditingDomain();
        Point parentLoc = this.getHostFigure().getBounds().getLocation().getCopy();
        Point requestedLocation = request.getLocation().getCopy();
        this.getHostFigure().translateToRelative((Translatable)requestedLocation);
        PortPositionLocator locator = new PortPositionLocator(this.getHostFigure(), 0);
        Rectangle proposedBounds = new Rectangle(requestedLocation, new Dimension(20, 20));
        Rectangle preferredBounds = locator.getPreferredLocation(proposedBounds);
        Rectangle creationBounds = preferredBounds.getTranslated(parentLoc.getNegated());
        setBoundsCommand = new SetBoundsCommand(editingDomain, DiagramUIMessages.SetLocationCommand_Label_Resize, (IAdaptable)descriptor, creationBounds);
        return setBoundsCommand;
    }

    private IFigure getHostFigure() {
        return ((GraphicalEditPart)this.getHost()).getFigure();
    }
}

