/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.parser;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.papyrus.gmf.diagram.common.parser.IMaskManagedSemanticParser;
import org.eclipse.papyrus.uml.diagram.common.commands.SemanticAdapter;
import org.eclipse.papyrus.uml.diagram.common.parser.NamedElementLabelParser;
import org.eclipse.papyrus.uml.diagram.common.parser.ParameterLabelParser;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Parameter;
import org.eclipse.uml2.uml.UMLPackage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OperationLabelParser
extends NamedElementLabelParser {
    protected IMaskManagedSemanticParser parameterParser = new ParameterLabelParser();
    protected static final String VISIBILITY_FORMAT = "%s ";
    protected static final String NAME_FORMAT = "%s%s(%s)";
    protected static final String TYPE_FORMAT = "%s: %s";
    protected static final String MODIFIER_FORMAT = "%s{%s}";

    @Override
    public String getPrintString(IAdaptable element, int flags) {
        if (flags == 0) {
            return "<empty label>";
        }
        String result = "";
        EObject eObject = (EObject)element.getAdapter(EObject.class);
        if (eObject != null && eObject instanceof Operation) {
            Operation operation = (Operation)eObject;
            if ((flags & 2) == 2) {
                String visibility;
                switch (operation.getVisibility().getValue()) {
                    case 3: {
                        visibility = "~";
                        break;
                    }
                    case 0: {
                        visibility = "+";
                        break;
                    }
                    case 2: {
                        visibility = "#";
                        break;
                    }
                    case 1: {
                        visibility = "-";
                        break;
                    }
                    default: {
                        visibility = "+";
                    }
                }
                result = String.format(VISIBILITY_FORMAT, visibility);
            }
            if ((flags & 8) == 8 && operation.isSetName()) {
                String name = operation.getName();
                StringBuffer params = new StringBuffer();
                for (Parameter parameter : operation.getOwnedParameters()) {
                    String currentParamLabel = this.parameterParser.getPrintString((IAdaptable)new SemanticAdapter((EObject)parameter, null), flags);
                    params.append(params.length() == 0 ? currentParamLabel : ", " + currentParamLabel);
                }
                result = String.format(NAME_FORMAT, result, name, params);
            }
            if ((flags & 0x10) == 16) {
                String type = "<Undefined>";
                if (operation.getType() != null) {
                    type = operation.getType().getName();
                }
                if ((flags & 0x200000) == 0x200000 || !"<Undefined>".equals(type)) {
                    result = String.format(TYPE_FORMAT, result, type);
                }
            }
            if ((flags & 0x80) == 128) {
                StringBuffer sb = new StringBuffer();
                if (operation.isAbstract()) {
                    sb.append(sb.length() == 0 ? "abstract" : ", abstract");
                }
                if (operation.isStatic()) {
                    sb.append(sb.length() == 0 ? "static" : ", static");
                }
                if (operation.isUnique()) {
                    sb.append(sb.length() == 0 ? "unique" : ", unique");
                }
                if (operation.isQuery()) {
                    sb.append(sb.length() == 0 ? "query" : ", query");
                }
                if (operation.isLeaf()) {
                    sb.append(sb.length() == 0 ? "leaf" : ", leaf");
                }
                if (sb.length() != 0) {
                    result = String.format(MODIFIER_FORMAT, result, sb.toString());
                }
            }
        }
        return result;
    }

    @Override
    public boolean isAffectingEvent(Object event, int flags) {
        Object feature;
        if (event instanceof Notification && (feature = ((Notification)event).getFeature()) instanceof EStructuralFeature) {
            return UMLPackage.eINSTANCE.getNamedElement_Visibility().equals(feature) || UMLPackage.eINSTANCE.getTypedElement_Type().equals(feature) || UMLPackage.eINSTANCE.getBehavioralFeature_IsAbstract().equals(feature) || UMLPackage.eINSTANCE.getFeature_IsStatic().equals(feature) || UMLPackage.eINSTANCE.getOperation_IsUnique().equals(feature) || UMLPackage.eINSTANCE.getOperation_IsQuery().equals(feature) || UMLPackage.eINSTANCE.getRedefinableElement_IsLeaf().equals(feature) || this.parameterParser.isAffectingEvent(event, flags) || super.isAffectingEvent(event, flags);
        }
        return false;
    }

    @Override
    public List<EObject> getSemanticElementsBeingParsed(EObject element) {
        ArrayList<EObject> semanticElementsBeingParsed = new ArrayList<EObject>();
        if (element != null && element instanceof Operation) {
            Operation semElement = (Operation)element;
            semanticElementsBeingParsed.add((EObject)semElement);
            if (semElement.getType() != null) {
                semanticElementsBeingParsed.add((EObject)semElement.getType());
            }
            for (Parameter parameter : semElement.getOwnedParameters()) {
                semanticElementsBeingParsed.addAll(this.parameterParser.getSemanticElementsBeingParsed((EObject)parameter));
            }
        }
        return semanticElementsBeingParsed;
    }

    @Override
    public Map<Integer, String> getMasks() {
        HashMap<Integer, String> masks = new HashMap<Integer, String>(5);
        masks.put(2, "Visibility");
        masks.put(8, "Name");
        masks.put(16, "Type");
        masks.put(0x200000, "Show <Undefined> type");
        masks.put(128, "Modifiers");
        masks.putAll(this.parameterParser.getMasks());
        return masks;
    }
}

