/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sysml.service.types.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.sysml.blocks.Block;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.StructuredClassifier;
import org.eclipse.uml2.uml.util.UMLUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnectorUtils
extends org.eclipse.papyrus.uml.service.types.utils.ConnectorUtils {
    public View getEncapsulatedContainer(View view) {
        View encapsulatedContainer = null;
        for (View containerView : this.getStructureContainers(view)) {
            StructuredClassifier structuredClassifier;
            Block block;
            if (view == containerView || view.getElement() instanceof Port && containerView.getChildren().contains((Object)view) || !(block = (Block)UMLUtil.getStereotypeApplication((Element)(structuredClassifier = this.getStructuredClassifier(containerView)), Block.class)).isEncapsulated()) continue;
            encapsulatedContainer = containerView;
            break;
        }
        return encapsulatedContainer;
    }

    public boolean isCrossingEncapsulation(View checkedEnd, View oppositeEnd) {
        boolean isCrossingEncapsulation = false;
        View encapsulatedContainer = new ConnectorUtils().getEncapsulatedContainer(checkedEnd);
        if (encapsulatedContainer != null) {
            View containerView = new ConnectorUtils().deduceViewContainer(checkedEnd, oppositeEnd);
            List containers = new ConnectorUtils().getStructureContainers(checkedEnd);
            if (containers.indexOf(encapsulatedContainer) < containers.indexOf(containerView)) {
                isCrossingEncapsulation = true;
            }
        }
        return isCrossingEncapsulation;
    }

    public List<View> getNestedPath(View checkedEnd, View oppositeEnd) {
        List<Object> isNestedConnectableElement = new ArrayList<View>();
        View nearestContainer = new ConnectorUtils().getNearestStructureContainer(checkedEnd);
        if (nearestContainer != null) {
            View containerView = new ConnectorUtils().deduceViewContainer(checkedEnd, oppositeEnd);
            List containers = new ConnectorUtils().getStructureContainers(checkedEnd);
            if (containers.indexOf(nearestContainer) < containers.indexOf(containerView)) {
                isNestedConnectableElement = containers.subList(containers.indexOf(nearestContainer), containers.indexOf(containerView));
            }
        }
        Collections.reverse(isNestedConnectableElement);
        return isNestedConnectableElement;
    }

    public List<Property> getNestedPropertyPath(View checkedEnd, View oppositeEnd) {
        ArrayList<Property> nestedPropertyPath = new ArrayList<Property>();
        List<View> nestedPath = this.getNestedPath(checkedEnd, oppositeEnd);
        for (View view : nestedPath) {
            if (view.getElement() == null || !(view.getElement() instanceof Property)) continue;
            nestedPropertyPath.add((Property)view.getElement());
        }
        return nestedPropertyPath;
    }

    public boolean isNestedConnectableElement(View checkedEnd, View oppositeEnd) {
        return !this.getNestedPath(checkedEnd, oppositeEnd).isEmpty();
    }

    public View getNearestStructureContainer(View view) {
        View nearestStructureContainer = null;
        for (View containerView : this.getStructureContainers(view)) {
            if (view == containerView || view.getElement() instanceof Port && containerView.getChildren().contains((Object)view)) continue;
            nearestStructureContainer = containerView;
            break;
        }
        return nearestStructureContainer;
    }
}

