/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.commands.handler;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.command.AbstractOverrideableCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.papyrus.uml.commands.handler.AbstractEMFCommandHandler;

public class CopyHandler
extends AbstractEMFCommandHandler {
    protected Command getCommand() {
        TransactionalEditingDomain editingDomain = this.getEditingDomain();
        List<EObject> selection = this.getSelectedElements();
        if (editingDomain != null && !selection.isEmpty()) {
            ArrayList<Object> stereotypedSelection = new ArrayList<Object>();
            stereotypedSelection.addAll(this.getSelectedElements());
            return new PutInClipboardCommand((EditingDomain)editingDomain, stereotypedSelection);
        }
        return UnexecutableCommand.INSTANCE;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class PutInClipboardCommand
    extends AbstractOverrideableCommand
    implements AbstractCommand.NonDirtying {
        private final Collection<Object> objectsToPutInClipboard;
        private Collection<Object> oldClipboardContent;

        protected PutInClipboardCommand(EditingDomain domain, Collection<Object> objectsToPutInClipboard) {
            super(domain);
            this.objectsToPutInClipboard = objectsToPutInClipboard;
        }

        public void doExecute() {
            this.oldClipboardContent = this.domain.getClipboard();
            this.domain.setClipboard(this.objectsToPutInClipboard);
        }

        public void doUndo() {
            this.domain.setClipboard(this.oldClipboardContent);
        }

        public void doRedo() {
            this.domain.setClipboard(this.objectsToPutInClipboard);
        }

        protected boolean prepare() {
            return this.domain != null;
        }
    }
}

