/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.controlmode.profile.validation;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.validation.AbstractModelConstraint;
import org.eclipse.emf.validation.EMFEventType;
import org.eclipse.emf.validation.IValidationContext;
import org.eclipse.gmf.runtime.emf.core.util.EMFCoreUtil;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.infra.core.utils.EditorUtils;
import org.eclipse.papyrus.infra.services.resourceloading.preferences.StrategyChooser;
import org.eclipse.papyrus.infra.widgets.toolbox.notification.builders.NotificationBuilder;
import org.eclipse.papyrus.uml.controlmode.profile.Activator;
import org.eclipse.papyrus.uml.controlmode.profile.Messages;
import org.eclipse.papyrus.uml.controlmode.profile.helpers.ProfileApplicationHelper;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.ProfileApplication;
import org.eclipse.uml2.uml.UMLPackage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProfileApplicationDuplicationChecker
extends AbstractModelConstraint {
    private static final String ENTRY_FORMAT = "<li>%s</li>";
    protected static final int LOAD_ALL_STRATEGY = 0;
    private IValidationContext lastValidatedContext = null;

    public IStatus validate(IValidationContext ctx) {
        try {
            if (ctx.equals(this.lastValidatedContext)) {
                return ctx.createSuccessStatus();
            }
            this.lastValidatedContext = ctx;
            EObject eObject = ctx.getTarget();
            if ((EMFEventType.ADD.equals(ctx.getEventType()) || EMFEventType.ADD_MANY.equals(ctx.getEventType())) && ctx.getFeatureNewValue() instanceof ProfileApplication) {
                Package pack = (Package)eObject;
                ProfileApplication profileAppl = (ProfileApplication)ctx.getFeatureNewValue();
                boolean res = this.stereotypeApplicationAdded(pack, profileAppl);
                if (!res) {
                    return ctx.createFailureStatus(new Object[0]);
                }
            } else if (EMFEventType.REMOVE.equals(ctx.getEventType()) && ctx.getFeatureNewValue() instanceof ProfileApplication || EMFEventType.REMOVE_MANY.equals(ctx.getEventType())) {
                HashMap<ProfileApplication, Profile> oldAssignement = new HashMap<ProfileApplication, Profile>(ctx.getAllEvents().size());
                for (Notification n : ctx.getAllEvents()) {
                    boolean res;
                    if (1 == n.getEventType() && UMLPackage.eINSTANCE.getProfileApplication_AppliedProfile().equals(n.getFeature()) && n.getNotifier() instanceof ProfileApplication) {
                        Profile profile = (Profile)n.getOldValue();
                        ProfileApplication profileAppl = (ProfileApplication)n.getNotifier();
                        oldAssignement.put(profileAppl, profile);
                    }
                    if (4 != n.getEventType() || !(n.getOldValue() instanceof ProfileApplication) || !(n.getNotifier() instanceof Package)) continue;
                    ProfileApplication profileAppl = (ProfileApplication)n.getOldValue();
                    Package pack = (Package)n.getNotifier();
                    Profile profile = profileAppl.getAppliedProfile();
                    if (profile == null) {
                        profile = (Profile)oldAssignement.get(profileAppl);
                    }
                    if (profile == null || (res = this.stereotypeApplicationRemoved(pack, profileAppl, profile))) continue;
                    return ctx.createFailureStatus(new Object[0]);
                }
            }
            return ctx.createSuccessStatus();
        }
        catch (RuntimeException rte) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.papyrus.uml.controlmode.profile", Messages.error_during_validation, (Throwable)rte));
            return ctx.createSuccessStatus();
        }
    }

    private boolean stereotypeApplicationAdded(Package packageElement, ProfileApplication profileAppl) {
        Set<Package> controlledPack = this.getControlledSubPackages(packageElement);
        boolean update = this.checkControlledPackagesUpdateable(controlledPack);
        if (update) {
            for (Package pack : controlledPack) {
                ProfileApplicationHelper.duplicateProfileApplication(pack, profileAppl.getAppliedProfile());
            }
            return true;
        }
        return false;
    }

    private boolean stereotypeApplicationRemoved(Package packageElement, ProfileApplication profileAppl, Profile profile) {
        if (ProfileApplicationHelper.isDuplicatedProfileApplication(profileAppl)) {
            Package parentPack = ProfileApplicationHelper.getParentPackageWithProfile(packageElement, profile, true);
            ProfileApplicationHelper.duplicateProfileApplication(packageElement, profile);
            String msg = parentPack != null ? NLS.bind((String)Messages.warning_cannot_delete_duplicated, (Object)EMFCoreUtil.getQualifiedName((EObject)packageElement, (boolean)true), (Object)EMFCoreUtil.getQualifiedName((EObject)parentPack, (boolean)true)) : NLS.bind((String)Messages.warning_cannot_delete_duplicated_alt, (Object)EMFCoreUtil.getQualifiedName((EObject)packageElement, (boolean)true));
            NotificationBuilder notifBuild = NotificationBuilder.createAsyncPopup((String)msg);
            notifBuild.run();
            return true;
        }
        Set<Package> controlledPack = this.getControlledSubPackages(packageElement);
        boolean update = this.checkControlledPackagesUpdateable(controlledPack);
        if (update) {
            for (Package pack : controlledPack) {
                ProfileApplicationHelper.removeProfileApplicationDuplication(pack, profile, false);
            }
            return true;
        }
        return false;
    }

    private boolean checkControlledPackagesUpdateable(Set<Package> controlledPackages) {
        String msg;
        boolean notLoadedPackages = false;
        StringBuffer notLoadedPackagesList = new StringBuffer();
        boolean readOnlyPackages = false;
        StringBuffer readOnlyPackagesList = new StringBuffer();
        for (Package pack : controlledPackages) {
            EObject loadedObject;
            TransactionalEditingDomain domain = EditorUtils.getTransactionalEditingDomain();
            if (pack.eIsProxy() && (loadedObject = domain.getResourceSet().getEObject(((InternalEObject)pack).eProxyURI(), true)) != null) {
                controlledPackages.remove(pack);
                pack = (Package)loadedObject;
                controlledPackages.add(pack);
            }
            if (pack.eIsProxy()) {
                notLoadedPackages = true;
                URI uri = ((InternalEObject)pack).eProxyURI();
                String uriLastSeg = uri.lastSegment();
                String name = uriLastSeg.substring(0, uriLastSeg.length() - uri.fileExtension().length() - 1);
                String qualifName = EMFCoreUtil.getQualifiedName((EObject)pack.getOwner(), (boolean)true).concat("::").concat(name);
                notLoadedPackagesList.append(String.format(ENTRY_FORMAT, qualifName));
                continue;
            }
            if (domain instanceof AdapterFactoryEditingDomain) {
                ((AdapterFactoryEditingDomain)domain).getResourceToReadOnlyMap().clear();
            }
            if (!domain.isReadOnly(pack.eResource())) continue;
            readOnlyPackages = true;
            String name = EMFCoreUtil.getQualifiedName((EObject)pack, (boolean)true);
            readOnlyPackagesList.append(String.format(ENTRY_FORMAT, name));
        }
        if (readOnlyPackages) {
            msg = NLS.bind((String)Messages.error_readonly, (Object)readOnlyPackagesList.toString());
            NotificationBuilder notifBuild = NotificationBuilder.createErrorPopup((String)msg);
            notifBuild.setHTML(true);
            notifBuild.run();
            return false;
        }
        if (notLoadedPackages) {
            msg = NLS.bind((String)Messages.switch_loading_strategy, (Object)notLoadedPackagesList.toString());
            final BooleanResult stategyChanged = new BooleanResult();
            Runnable runStrategySwitch = new Runnable(){

                public void run() {
                    StrategyChooser.setCurrentStrategy((int)0);
                    stategyChanged.setValue(true);
                }
            };
            Runnable cancel = new Runnable(){

                public void run() {
                    stategyChanged.setValue(false);
                }
            };
            NotificationBuilder notifBuild = NotificationBuilder.createYesNo((String)msg, (Runnable)runStrategySwitch, (Runnable)cancel);
            notifBuild.setHTML(true);
            notifBuild.setAsynchronous(false);
            notifBuild.run();
            if (stategyChanged.getValue()) {
                return this.checkControlledPackagesUpdateable(controlledPackages);
            }
            return false;
        }
        return true;
    }

    private Set<Package> getControlledSubPackages(Package packageElement) {
        HashSet<Package> controlledPackages = new HashSet<Package>();
        TreeIterator iterator = packageElement.eAllContents();
        while (iterator.hasNext()) {
            EObject child = (EObject)iterator.next();
            if (child instanceof Package) {
                if (!AdapterFactoryEditingDomain.isControlled((Object)child) && !child.eIsProxy()) continue;
                controlledPackages.add((Package)child);
                continue;
            }
            iterator.prune();
        }
        return controlledPackages;
    }

    public class BooleanResult {
        boolean value = false;

        public boolean getValue() {
            return this.value;
        }

        public void setValue(boolean pValue) {
            this.value = pValue;
        }
    }
}

