/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.clazz.custom.helper;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.requests.ReconnectRequest;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.core.commands.SetConnectionAnchorsCommand;
import org.eclipse.gmf.runtime.diagram.core.commands.SetConnectionEndsCommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.INodeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.l10n.DiagramUIMessages;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.uml.diagram.clazz.edit.parts.GeneralizationSetEditPart;
import org.eclipse.papyrus.uml.diagram.common.helper.ElementHelper;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.uml2.uml.Generalization;
import org.eclipse.uml2.uml.GeneralizationSet;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.UMLFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeneralizationSetHelper
extends ElementHelper {
    protected static final String CHOOSE_A_FOLLOWING_GENERALIZATION_SET_TO_CONNECT = "Choose a following generalizationSet to connect:";
    protected static final String WOULD_YOU_LIKE_TO_CREATE_A_NEW_GENERALIZATION = "Would you like to create a new Generalization?";
    private GeneralizationSet generalizationSettoCreate;

    public GeneralizationSetHelper(TransactionalEditingDomain editDomain) {
        this.editDomain = editDomain;
    }

    public GeneralizationSet createGeneralizationSet(Generalization source, Generalization target, Package container) {
        ArrayList<GeneralizationSet> generalizationSetList = new ArrayList<GeneralizationSet>((Collection<GeneralizationSet>)source.getGeneralizationSets());
        for (GeneralizationSet currentGeneralizationSet : target.getGeneralizationSets()) {
            if (generalizationSetList.contains(currentGeneralizationSet)) continue;
            generalizationSetList.add(currentGeneralizationSet);
        }
        if (generalizationSetList.size() > 0) {
            this.launchDialog(generalizationSetList, this.getEditingDomain());
        }
        if (this.generalizationSettoCreate == null) {
            this.generalizationSettoCreate = UMLFactory.eINSTANCE.createGeneralizationSet();
            this.generalizationSettoCreate.setName("GeneralizationSet_" + source.getSpecific().getName() + "_" + target.getSpecific().getName());
            container.getPackagedElements().add((Object)this.generalizationSettoCreate);
        }
        if (!this.generalizationSettoCreate.getGeneralizations().contains((Object)source)) {
            this.generalizationSettoCreate.getGeneralizations().add((Object)source);
        }
        if (!this.generalizationSettoCreate.getGeneralizations().contains((Object)target)) {
            this.generalizationSettoCreate.getGeneralizations().add((Object)target);
        }
        return this.generalizationSettoCreate;
    }

    public Command getMoveTarget(ReconnectRequest request, Command command, INodeEditPart node, ConnectionAnchor targetAnchor) {
        CompoundCommand cc = new CompoundCommand();
        ArrayList linkList = new ArrayList();
        linkList.addAll(node.getSourceConnections());
        linkList.addAll(node.getTargetConnections());
        linkList.remove(request.getConnectionEditPart());
        GeneralizationSetEditPart edgeToMove = null;
        for (Object currentObject : linkList) {
            if (!(currentObject instanceof GeneralizationSetEditPart) || !((GeneralizationSetEditPart)request.getConnectionEditPart()).resolveSemanticElement().equals(((GeneralizationSetEditPart)((Object)currentObject)).resolveSemanticElement())) continue;
            edgeToMove = (GeneralizationSetEditPart)((Object)currentObject);
        }
        cc.add(command);
        if (edgeToMove != null) {
            SetConnectionAnchorsCommand scaCommandbis = new SetConnectionAnchorsCommand(this.getEditingDomain(), "");
            scaCommandbis.setEdgeAdaptor((IAdaptable)new EObjectAdapter((EObject)((View)edgeToMove.getModel())));
            if (node.getSourceConnections().contains((Object)edgeToMove)) {
                scaCommandbis.setNewSourceTerminal(node.mapConnectionAnchorToTerminal(targetAnchor));
            } else {
                scaCommandbis.setNewTargetTerminal(node.mapConnectionAnchorToTerminal(targetAnchor));
            }
            cc.add((Command)new ICommandProxy((ICommand)scaCommandbis));
        }
        return cc;
    }

    public Command getReconnectSourceCommand(ReconnectRequest request, INodeEditPart node) {
        if (node == null) {
            return null;
        }
        TransactionalEditingDomain editingDomain = this.getEditingDomain();
        ConnectionAnchor sourceAnchor = node.getSourceConnectionAnchor((Request)request);
        SetConnectionEndsCommand sceCommand = new SetConnectionEndsCommand(editingDomain, "");
        sceCommand.setEdgeAdaptor((IAdaptable)new EObjectAdapter((EObject)((View)request.getConnectionEditPart().getModel())));
        sceCommand.setNewSourceAdaptor((IAdaptable)new EObjectAdapter((EObject)((View)node.getModel())));
        SetConnectionAnchorsCommand scaCommand = new SetConnectionAnchorsCommand(editingDomain, "");
        scaCommand.setEdgeAdaptor((IAdaptable)new EObjectAdapter((EObject)((View)request.getConnectionEditPart().getModel())));
        scaCommand.setNewSourceTerminal(node.mapConnectionAnchorToTerminal(sourceAnchor));
        CompositeCommand cc = new CompositeCommand(DiagramUIMessages.Commands_SetConnectionEndsCommand_Source);
        cc.compose((IUndoableOperation)sceCommand);
        cc.compose((IUndoableOperation)scaCommand);
        ArrayList linkList = new ArrayList();
        linkList.addAll(node.getSourceConnections());
        linkList.addAll(node.getTargetConnections());
        linkList.remove(request.getConnectionEditPart());
        GeneralizationSetEditPart edgeToMove = null;
        for (Object currentObject : linkList) {
            if (!(currentObject instanceof GeneralizationSetEditPart) || !((GeneralizationSetEditPart)request.getConnectionEditPart()).resolveSemanticElement().equals(((GeneralizationSetEditPart)((Object)currentObject)).resolveSemanticElement())) continue;
            edgeToMove = (GeneralizationSetEditPart)((Object)currentObject);
        }
        if (edgeToMove != null) {
            SetConnectionAnchorsCommand scaCommandbis = new SetConnectionAnchorsCommand(editingDomain, "");
            scaCommandbis.setEdgeAdaptor((IAdaptable)new EObjectAdapter((EObject)((View)edgeToMove.getModel())));
            if (node.getSourceConnections().contains((Object)edgeToMove)) {
                scaCommandbis.setNewSourceTerminal(node.mapConnectionAnchorToTerminal(sourceAnchor));
            } else {
                scaCommandbis.setNewTargetTerminal(node.mapConnectionAnchorToTerminal(sourceAnchor));
            }
            cc.compose((IUndoableOperation)scaCommandbis);
        }
        return new ICommandProxy((ICommand)cc);
    }

    private void launchDialog(final ArrayList<GeneralizationSet> generalizationSetList, TransactionalEditingDomain editingDomain) {
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                Display display = Display.getCurrent();
                final Button[] radios = new Button[2];
                Shell dialog = new Shell(display, 67680);
                dialog.setBackground(ColorConstants.white);
                GridLayout gridLayout = new GridLayout(2, false);
                gridLayout.verticalSpacing = 8;
                dialog.setLayout((Layout)gridLayout);
                dialog.setText("GeneralizationSet Selection");
                Label text = new Label((Composite)dialog, 0x1000000);
                text.setText(GeneralizationSetHelper.WOULD_YOU_LIKE_TO_CREATE_A_NEW_GENERALIZATION);
                text.setBackground(ColorConstants.white);
                GridData gridData = new GridData(32);
                gridData.horizontalSpan = 1;
                text.setLayoutData((Object)gridData);
                radios[0] = new Button((Composite)dialog, 16);
                radios[0].setBackground(ColorConstants.white);
                gridData = new GridData(256);
                gridData.horizontalSpan = 1;
                radios[0].setLayoutData((Object)gridData);
                text = new Label((Composite)dialog, 0x1000000);
                text.setBackground(ColorConstants.white);
                text.setText(GeneralizationSetHelper.CHOOSE_A_FOLLOWING_GENERALIZATION_SET_TO_CONNECT);
                gridData = new GridData(32);
                gridData.horizontalSpan = 1;
                text.setLayoutData((Object)gridData);
                radios[1] = new Button((Composite)dialog, 16);
                radios[1].setBackground(ColorConstants.white);
                gridData = new GridData(256);
                gridData.horizontalSpan = 1;
                radios[1].setLayoutData((Object)gridData);
                final List list = new List((Composite)dialog, 2050);
                gridData = new GridData(256);
                gridData.horizontalSpan = 2;
                list.setLayoutData((Object)gridData);
                int i = 0;
                while (i < generalizationSetList.size()) {
                    if (((GeneralizationSet)generalizationSetList.get(i)).getLabel() != null) {
                        list.add(((GeneralizationSet)generalizationSetList.get(i)).getLabel());
                    } else {
                        list.add("GeneralizationSet" + i);
                    }
                    ++i;
                }
                radios[0].addSelectionListener(new SelectionListener(){

                    public void widgetDefaultSelected(SelectionEvent e) {
                    }

                    public void widgetSelected(SelectionEvent e) {
                        list.setEnabled(!radios[0].getSelection());
                    }
                });
                radios[1].setSelection(true);
                Button buttonok = new Button((Composite)dialog, 8);
                gridData = new GridData(64);
                gridData.horizontalSpan = 1;
                gridData.horizontalAlignment = 3;
                buttonok.setLayoutData((Object)gridData);
                buttonok.setText("  OK  ");
                Button cancel = new Button((Composite)dialog, 8);
                gridData = new GridData(256);
                gridData.horizontalSpan = 1;
                gridData.horizontalAlignment = 3;
                cancel.setLayoutData((Object)gridData);
                cancel.setText("Cancel");
                DialogListener listener = new DialogListener(generalizationSetList, list, buttonok);
                buttonok.addListener(13, (Listener)listener);
                cancel.addListener(13, (Listener)listener);
                dialog.pack();
                dialog.open();
                while (!dialog.isDisposed()) {
                    if (display.readAndDispatch()) continue;
                    display.sleep();
                }
                GeneralizationSetHelper.this.generalizationSettoCreate = listener.getResult();
            }
        });
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DialogListener
    implements Listener {
        private Button abuttonOk;
        private List acombo;
        private GeneralizationSet ageneralizationSet = null;
        private ArrayList<GeneralizationSet> ageneralizationSetList;

        public DialogListener(ArrayList<GeneralizationSet> generalizationSetList, List combo, Button buttonOK) {
            this.ageneralizationSetList = generalizationSetList;
            this.acombo = combo;
            this.abuttonOk = buttonOK;
        }

        public GeneralizationSet getResult() {
            return this.ageneralizationSet;
        }

        public void handleEvent(Event event) {
            if (event.widget.equals(this.abuttonOk)) {
                int selectedButtonIndex = 0;
                selectedButtonIndex = this.acombo.getSelectionIndex();
                if (selectedButtonIndex >= 0) {
                    this.ageneralizationSet = this.ageneralizationSetList.get(selectedButtonIndex);
                }
                ((Shell)this.abuttonOk.getParent()).close();
            }
        }
    }
}

