/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.figure.node;

import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gmf.runtime.draw2d.ui.figures.FigureUtilities;
import org.eclipse.gmf.runtime.gef.ui.figures.NodeFigure;
import org.eclipse.papyrus.infra.gmfdiag.common.figure.node.IPapyrusNodeFigure;
import org.eclipse.papyrus.uml.diagram.common.figure.node.RectangularShadowBorder;
import org.eclipse.swt.graphics.Color;

public class PapyrusNodeFigure
extends NodeFigure
implements IPapyrusNodeFigure {
    private Color borderColor = ColorConstants.black;
    private boolean shadow = true;
    public static final int[] DEFAULT_CUSTOM_DASH = new int[]{5, 5};
    protected int[] customDash = null;
    protected LineBorder shadowborder;

    public int[] getCustomDash() {
        if (this.customDash == null) {
            this.customDash = DEFAULT_CUSTOM_DASH;
        }
        return this.customDash;
    }

    public void setCustomDash(int[] dash) {
        this.customDash = dash;
    }

    public PapyrusNodeFigure() {
        this.createCompositeFigureStructure();
        this.shadowborder = new RectangularShadowBorder(3, this.getForegroundColor());
        this.setBorder(this.getBorderedFigure(), (Border)this.shadowborder);
    }

    protected void createCompositeFigureStructure() {
    }

    protected IFigure getBorderedFigure() {
        return this;
    }

    protected void setBorder(IFigure borderedFigure, Border border) {
        if (borderedFigure == null) {
            super.setBorder(border);
        } else {
            borderedFigure.setBorder(border);
        }
    }

    public boolean isShadow() {
        return this.shadow;
    }

    public void setShadow(boolean shadow) {
        this.shadow = shadow;
        if (shadow) {
            this.setBorder(this.getBorderedFigure(), (Border)this.shadowborder);
        } else {
            this.setBorder(this.getBorderedFigure(), this.getDefaultBorder(null));
        }
    }

    public void setBorderColor(Color borderColor) {
        this.borderColor = borderColor;
        this.setBorder(this.getBorderedFigure(), this.getDefaultBorder(borderColor));
    }

    protected Border getDefaultBorder(Color borderColor) {
        LineBorder lineBorder = null;
        lineBorder = borderColor != null ? new LineBorder(borderColor) : new LineBorder();
        lineBorder.setStyle(this.getLineStyle());
        lineBorder.setWidth(this.getLineWidth());
        return lineBorder;
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public void paintFigure(Graphics graphics) {
        super.paintFigure(graphics);
        this.paintBackground(graphics, this.getBounds());
        this.shadowborder.setColor(this.getForegroundColor());
    }

    protected void paintBackground(Graphics graphics, Rectangle rectangle) {
        if (this.isUsingGradient()) {
            this.applyTransparency(graphics);
            boolean isVertical = this.getGradientStyle() == 0;
            graphics.setBackgroundColor(FigureUtilities.integerToColor((Integer)this.getGradientColor1()));
            graphics.setForegroundColor(FigureUtilities.integerToColor((Integer)this.getGradientColor2()));
            graphics.fillGradient(rectangle, isVertical);
        } else {
            this.applyTransparency(graphics);
            graphics.setBackgroundColor(this.getBackgroundColor());
            graphics.setForegroundColor(this.getForegroundColor());
            graphics.fillRectangle(rectangle);
        }
    }

    protected void paintBorder(Graphics graphics) {
        if (this.getLineStyle() == 6) {
            graphics.setLineDash(this.getCustomDash());
        }
        super.paintBorder(graphics);
    }

    public void setLineStyle(int s) {
        if (this.getBorder() != null && this.getBorder() instanceof LineBorder) {
            ((LineBorder)this.getBorder()).setStyle(s);
        }
        super.setLineStyle(s);
    }

    public void setLineWidth(int w) {
        if (this.getBorder() != null && this.getBorder() instanceof LineBorder) {
            ((LineBorder)this.getBorder()).setWidth(w);
        }
        super.setLineWidth(w);
    }
}

