/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.helper;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.gmfdiag.common.editpolicies.IMaskManagedLabelEditPolicy;
import org.eclipse.papyrus.uml.diagram.common.helper.StereotypedElementLabelHelper;
import org.eclipse.papyrus.uml.tools.utils.OperationUtil;
import org.eclipse.uml2.uml.Operation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OperationLabelHelper
extends StereotypedElementLabelHelper {
    private static OperationLabelHelper labelHelper;
    protected final Map<Integer, String> masks = new HashMap<Integer, String>(7);

    public static OperationLabelHelper getInstance() {
        if (labelHelper == null) {
            labelHelper = new OperationLabelHelper();
        }
        return labelHelper;
    }

    protected OperationLabelHelper() {
        this.masks.put(2, "Visibility");
        this.masks.put(8, "Name");
        this.masks.put(4096, "Parameters Name");
        this.masks.put(2048, "Parameters Direction");
        this.masks.put(256, "Parameters Type");
        this.masks.put(512, "Return Type");
        this.masks.put(16384, "Parameters Multiplicity");
        this.masks.put(32768, "Parameters Default Value");
        this.masks.put(65536, "Parameters Modifiers");
        this.masks.put(128, "Modifiers");
    }

    @Override
    protected String elementLabel(GraphicalEditPart editPart) {
        int displayValue = 2954;
        IMaskManagedLabelEditPolicy policy = (IMaskManagedLabelEditPolicy)editPart.getEditPolicy((Object)"MaskManagedLabelPolicy");
        if (policy != null) {
            displayValue = policy.getCurrentDisplayValue();
        }
        return OperationUtil.getCustomLabel((Operation)this.getUMLElement(editPart), (int)displayValue);
    }

    public String getMaskLabel(int value) {
        return this.masks.get(value);
    }

    public Collection<String> getMaskLabels() {
        return this.masks.values();
    }

    public Map<Integer, String> getMasks() {
        return this.masks;
    }

    public Set<Integer> getMaskValues() {
        return this.masks.keySet();
    }

    public Operation getUMLElement(GraphicalEditPart editPart) {
        return (Operation)((View)editPart.getModel()).getElement();
    }
}

