/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.menu.actions;

import java.util.Iterator;
import java.util.List;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SizeAction {
    public static final String PARAMETER_AUTOSIZE = "parameter_autosize";
    public static final String PARAMETER_BOTH = "parameter_both";
    public static final String PARAMETER_HEIGHT = "parameter_height";
    public static final String PARAMETER_WIDTH = "parameter_width";
    protected int sizeActionType = 0;
    public static final int AUTOSIZE = 0;
    public static final int BOTH = 1;
    public static final int HEIGHT = 2;
    public static final int WIDTH = 3;
    public List<IGraphicalEditPart> selectedElements;

    public SizeAction(String parameter, List<IGraphicalEditPart> selectedElements) {
        this.selectedElements = selectedElements;
        if (PARAMETER_AUTOSIZE.equals(parameter)) {
            this.sizeActionType = 0;
        } else if (PARAMETER_BOTH.equals(parameter)) {
            this.sizeActionType = 1;
        } else if (PARAMETER_HEIGHT.equals(parameter)) {
            this.sizeActionType = 2;
        } else if (PARAMETER_WIDTH.equals(parameter)) {
            this.sizeActionType = 3;
        }
    }

    public Command getCommand() {
        switch (this.sizeActionType) {
            case 0: {
                return this.getAutoSizeCommand();
            }
            case 1: {
                return this.getBothCommand();
            }
            case 2: {
                return this.getHeightCommand();
            }
            case 3: {
                return this.getWidthCommand();
            }
        }
        return UnexecutableCommand.INSTANCE;
    }

    protected Command getAutoSizeCommand() {
        if (this.selectedElements.isEmpty()) {
            return UnexecutableCommand.INSTANCE;
        }
        boolean foundNonAutosizedPart = false;
        List<IGraphicalEditPart> operationSet = this.selectedElements;
        Iterator<IGraphicalEditPart> editParts = operationSet.iterator();
        CompoundCommand command = new CompoundCommand("AutoSize Command");
        while (editParts.hasNext()) {
            Request request;
            Command curCommand;
            EditPart editPart = (EditPart)editParts.next();
            if (editPart instanceof GraphicalEditPart) {
                GraphicalEditPart graphicalEditPart = (GraphicalEditPart)editPart;
                Integer containerWidth = (Integer)graphicalEditPart.getStructuralFeatureValue((EStructuralFeature)NotationPackage.eINSTANCE.getSize_Width());
                Integer containerHeight = (Integer)graphicalEditPart.getStructuralFeatureValue((EStructuralFeature)NotationPackage.eINSTANCE.getSize_Height());
                if (containerWidth != -1 || containerHeight != -1) {
                    foundNonAutosizedPart = true;
                }
            }
            if ((curCommand = editPart.getCommand(request = new Request((Object)"autosize"))) == null) continue;
            command.add(curCommand);
        }
        return command.isEmpty() || command.size() != operationSet.size() || !foundNonAutosizedPart ? UnexecutableCommand.INSTANCE : command;
    }

    protected Command getBothCommand() {
        if (this.selectedElements.size() <= 1) {
            return UnexecutableCommand.INSTANCE;
        }
        CompoundCommand doResizeCmd = new CompoundCommand();
        Iterator<IGraphicalEditPart> iter = this.selectedElements.iterator();
        int last = this.selectedElements.size() - 1;
        IGraphicalEditPart primary = this.selectedElements.get(last);
        View primaryView = (View)primary.getModel();
        Integer width = (Integer)ViewUtil.getStructuralFeatureValue((View)primaryView, (EStructuralFeature)NotationPackage.eINSTANCE.getSize_Width());
        Integer height = (Integer)ViewUtil.getStructuralFeatureValue((View)primaryView, (EStructuralFeature)NotationPackage.eINSTANCE.getSize_Height());
        Dimension primarySize = width == -1 || height == -1 ? primary.getFigure().getSize().getCopy() : new Dimension(width.intValue(), height.intValue());
        while (iter.hasNext()) {
            IGraphicalEditPart toResize = iter.next();
            View resizeView = (View)toResize.getModel();
            Integer previousWidth = (Integer)ViewUtil.getStructuralFeatureValue((View)resizeView, (EStructuralFeature)NotationPackage.eINSTANCE.getSize_Width());
            Integer previousHeight = (Integer)ViewUtil.getStructuralFeatureValue((View)resizeView, (EStructuralFeature)NotationPackage.eINSTANCE.getSize_Height());
            Dimension previousSize = previousWidth == -1 || previousHeight == -1 ? toResize.getFigure().getSize().getCopy() : new Dimension(previousWidth.intValue(), previousHeight.intValue());
            Dimension delta = new Dimension(primarySize.width - previousSize.width, primarySize.height - previousSize.height);
            ChangeBoundsRequest bRequest = new ChangeBoundsRequest();
            bRequest.setResizeDirection(20);
            bRequest.setSizeDelta(delta);
            bRequest.setType((Object)"resize");
            Command resizeCommand = toResize.getCommand((Request)bRequest);
            doResizeCmd.add(resizeCommand);
        }
        return doResizeCmd.unwrap();
    }

    protected Command getHeightCommand() {
        if (this.selectedElements.size() <= 1) {
            return UnexecutableCommand.INSTANCE;
        }
        CompoundCommand doResizeCmd = new CompoundCommand();
        Iterator<IGraphicalEditPart> iter = this.selectedElements.iterator();
        int last = this.selectedElements.size() - 1;
        IGraphicalEditPart primary = this.selectedElements.get(last);
        View primaryView = (View)primary.getModel();
        Integer width = (Integer)ViewUtil.getStructuralFeatureValue((View)primaryView, (EStructuralFeature)NotationPackage.eINSTANCE.getSize_Width());
        Integer height = (Integer)ViewUtil.getStructuralFeatureValue((View)primaryView, (EStructuralFeature)NotationPackage.eINSTANCE.getSize_Height());
        Dimension primarySize = width == -1 || height == -1 ? primary.getFigure().getSize().getCopy() : new Dimension(width.intValue(), height.intValue());
        while (iter.hasNext()) {
            IGraphicalEditPart toResize = iter.next();
            View resizeView = (View)toResize.getModel();
            Integer previousWidth = (Integer)ViewUtil.getStructuralFeatureValue((View)resizeView, (EStructuralFeature)NotationPackage.eINSTANCE.getSize_Width());
            Integer previousHeight = (Integer)ViewUtil.getStructuralFeatureValue((View)resizeView, (EStructuralFeature)NotationPackage.eINSTANCE.getSize_Height());
            Dimension previousSize = previousWidth == -1 || previousHeight == -1 ? toResize.getFigure().getSize().getCopy() : new Dimension(previousWidth.intValue(), previousHeight.intValue());
            Dimension delta = new Dimension(0, primarySize.height - previousSize.height);
            ChangeBoundsRequest bRequest = new ChangeBoundsRequest();
            bRequest.setResizeDirection(4);
            bRequest.setSizeDelta(delta);
            bRequest.setType((Object)"resize");
            Command resizeCommand = toResize.getCommand((Request)bRequest);
            doResizeCmd.add(resizeCommand);
        }
        return doResizeCmd.unwrap();
    }

    protected Command getWidthCommand() {
        if (this.selectedElements.size() <= 1) {
            return UnexecutableCommand.INSTANCE;
        }
        CompoundCommand doResizeCmd = new CompoundCommand();
        Iterator<IGraphicalEditPart> iter = this.selectedElements.iterator();
        int last = this.selectedElements.size() - 1;
        IGraphicalEditPart primary = this.selectedElements.get(last);
        View primaryView = (View)primary.getModel();
        Integer width = (Integer)ViewUtil.getStructuralFeatureValue((View)primaryView, (EStructuralFeature)NotationPackage.eINSTANCE.getSize_Width());
        Integer height = (Integer)ViewUtil.getStructuralFeatureValue((View)primaryView, (EStructuralFeature)NotationPackage.eINSTANCE.getSize_Height());
        Dimension primarySize = width == -1 || height == -1 ? primary.getFigure().getSize().getCopy() : new Dimension(width.intValue(), height.intValue());
        while (iter.hasNext()) {
            IGraphicalEditPart toResize = iter.next();
            View resizeView = (View)toResize.getModel();
            Integer previousWidth = (Integer)ViewUtil.getStructuralFeatureValue((View)resizeView, (EStructuralFeature)NotationPackage.eINSTANCE.getSize_Width());
            Integer previousHeight = (Integer)ViewUtil.getStructuralFeatureValue((View)resizeView, (EStructuralFeature)NotationPackage.eINSTANCE.getSize_Height());
            Dimension previousSize = previousWidth == -1 || previousHeight == -1 ? toResize.getFigure().getSize().getCopy() : new Dimension(previousWidth.intValue(), previousHeight.intValue());
            Dimension delta = new Dimension(primarySize.width - previousSize.width, 0);
            ChangeBoundsRequest bRequest = new ChangeBoundsRequest();
            bRequest.setResizeDirection(16);
            bRequest.setSizeDelta(delta);
            bRequest.setType((Object)"resize");
            Command resizeCommand = toResize.getCommand((Request)bRequest);
            doResizeCmd.add(resizeCommand);
        }
        return doResizeCmd.unwrap();
    }
}

