/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.profile.custom.policies;

import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.AbstractEditPolicy;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.core.listener.DiagramEventBroker;
import org.eclipse.gmf.runtime.diagram.core.listener.NotificationListener;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.core.listenerservice.IPapyrusListener;
import org.eclipse.papyrus.infra.core.utils.EditorUtils;
import org.eclipse.papyrus.infra.services.edit.service.ElementEditServiceUtils;
import org.eclipse.papyrus.infra.services.edit.service.IElementEditService;
import org.eclipse.papyrus.uml.diagram.common.Activator;
import org.eclipse.papyrus.uml.diagram.profile.custom.helper.ExtensionHelper;
import org.eclipse.swt.widgets.Display;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Extension;
import org.eclipse.uml2.uml.ExtensionEnd;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.UMLPackage;

public class ExtensionCustomNameEditPolicy
extends AbstractEditPolicy
implements NotificationListener,
IPapyrusListener {
    public static final String SPECIFIC_EXTENSION_NAME_POLICY = "SpecificExtensionNameEditPolicy";
    public static final int CHANGE_NAME_OF_A_STEREOTYPE = 1;
    protected EObject hostSemanticElement;
    protected String systemExtensionName;

    public void activate() {
        View view = (View)this.getHost().getModel();
        this.hostSemanticElement = view.getElement();
        if (this.hostSemanticElement instanceof Extension) {
            Stereotype stereotype = ((Extension)this.hostSemanticElement).getStereotype();
            this.getDiagramEventBroker().addNotificationListener((EObject)stereotype, (NotificationListener)this);
            this.systemExtensionName = ((Extension)this.hostSemanticElement).getName();
        }
    }

    public void deactivate() {
        if (this.hostSemanticElement instanceof Extension) {
            Stereotype stereotype = ((Extension)this.hostSemanticElement).getStereotype();
            this.getDiagramEventBroker().removeNotificationListener((EObject)stereotype, (NotificationListener)this);
            this.hostSemanticElement = null;
        }
    }

    private DiagramEventBroker getDiagramEventBroker() {
        TransactionalEditingDomain theEditingDomain = ((IGraphicalEditPart)this.getHost()).getEditingDomain();
        if (theEditingDomain != null) {
            return DiagramEventBroker.getInstance((TransactionalEditingDomain)theEditingDomain);
        }
        return null;
    }

    public void notifyChanged(Notification notification) {
        int eventType = notification.getEventType();
        if (eventType == 1 && this.hostSemanticElement instanceof Extension && ((Extension)this.hostSemanticElement).getStereotype() instanceof Stereotype) {
            final TransactionalEditingDomain domain = EditorUtils.getTransactionalEditingDomain();
            try {
                ((IGraphicalEditPart)this.getHost()).getEditingDomain().runExclusive(new Runnable(){

                    public void run() {
                        Display.getCurrent().asyncExec(new Runnable(){

                            public void run() {
                                CompositeCommand cc = new CompositeCommand("Change Extension Name");
                                Extension ext = (Extension)(this).ExtensionCustomNameEditPolicy.this.hostSemanticElement;
                                Stereotype ste = ((Extension)(this).ExtensionCustomNameEditPolicy.this.hostSemanticElement).getStereotype();
                                String newExtEndName = "Extension_" + ste.getName();
                                String newExtensionName = ExtensionHelper.getExtensionName((Element)(this).ExtensionCustomNameEditPolicy.this.hostSemanticElement, ((Extension)(this).ExtensionCustomNameEditPolicy.this.hostSemanticElement).getStereotype(), ((Extension)(this).ExtensionCustomNameEditPolicy.this.hostSemanticElement).getMetaclass());
                                if ((this).ExtensionCustomNameEditPolicy.this.systemExtensionName.equals(((Extension)(this).ExtensionCustomNameEditPolicy.this.hostSemanticElement).getName())) {
                                    SetRequest setRequestExt = new SetRequest(domain, (EObject)ext, (EStructuralFeature)UMLPackage.eINSTANCE.getNamedElement_Name(), (Object)newExtensionName);
                                    IElementEditService provider = ElementEditServiceUtils.getCommandProvider((Object)ext);
                                    if (provider != null) {
                                        ICommand editCommand = null;
                                        editCommand = provider.getEditCommand((IEditCommandRequest)setRequestExt);
                                        if (editCommand != null && editCommand.canExecute()) {
                                            cc.add((IUndoableOperation)editCommand);
                                        }
                                    }
                                    (this).ExtensionCustomNameEditPolicy.this.systemExtensionName = newExtensionName;
                                    (this).ExtensionCustomNameEditPolicy.this.systemExtensionName = newExtensionName;
                                }
                                ExtensionEnd extEnd = (ExtensionEnd)((Extension)(this).ExtensionCustomNameEditPolicy.this.hostSemanticElement).getOwnedEnds().get(0);
                                SetRequest setRequestExtEnd = new SetRequest(domain, (EObject)extEnd, (EStructuralFeature)UMLPackage.eINSTANCE.getNamedElement_Name(), (Object)newExtEndName.replaceFirst("E", "e"));
                                IElementEditService provider = ElementEditServiceUtils.getCommandProvider((Object)extEnd);
                                if (provider != null) {
                                    ICommand editCommand = null;
                                    editCommand = provider.getEditCommand((IEditCommandRequest)setRequestExtEnd);
                                    if (editCommand != null && editCommand.canExecute()) {
                                        cc.add((IUndoableOperation)editCommand);
                                    }
                                }
                                ((IGraphicalEditPart)ExtensionCustomNameEditPolicy.this.getHost()).getDiagramEditDomain().getDiagramCommandStack().execute((Command)new ICommandProxy((ICommand)cc));
                            }
                        });
                    }
                });
            }
            catch (Exception e) {
                Activator.log.error((Throwable)e);
            }
        }
    }
}

