/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.edit.parts;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.Shape;
import org.eclipse.draw2d.StackLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.LayoutEditPolicy;
import org.eclipse.gef.editpolicies.NonResizableEditPolicy;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gef.requests.LocationRequest;
import org.eclipse.gef.requests.ReconnectRequest;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ShapeNodeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.CreationEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.DragDropEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateConnectionViewAndElementRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateUnspecifiedTypeConnectionRequest;
import org.eclipse.gmf.runtime.draw2d.ui.figures.ConstrainedToolbarLayout;
import org.eclipse.gmf.runtime.draw2d.ui.figures.FigureUtilities;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.gef.ui.figures.DefaultSizeNodeFigure;
import org.eclipse.gmf.runtime.gef.ui.figures.NodeFigure;
import org.eclipse.gmf.runtime.gef.ui.figures.SlidableAnchor;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.papyrus.infra.gmfdiag.preferences.utils.GradientPreferenceConverter;
import org.eclipse.papyrus.infra.gmfdiag.preferences.utils.PreferenceConstantHelper;
import org.eclipse.papyrus.uml.diagram.common.editpolicies.ShowHideCompartmentEditPolicy;
import org.eclipse.papyrus.uml.diagram.common.figure.node.InteractionRectangleFigure;
import org.eclipse.papyrus.uml.diagram.common.helper.PreferenceInitializerForElementHelper;
import org.eclipse.papyrus.uml.diagram.common.providers.UIAdapterImpl;
import org.eclipse.papyrus.uml.diagram.common.util.MessageDirection;
import org.eclipse.papyrus.uml.diagram.sequence.edit.helpers.AnchorHelper;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.ActionExecutionSpecificationEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.BehaviorExecutionSpecificationEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.CombinedFragment2EditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.CombinedFragmentEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.CommentEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.ConsiderIgnoreFragmentEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.ConstraintEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.ContinuationEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.DestructionOccurrenceSpecificationEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.DurationConstraintEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.DurationConstraintInMessageEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.DurationObservationEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.InteractionInteractionCompartmentEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.InteractionNameEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.InteractionOperandEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.InteractionUseEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.LifelineEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.Message6EditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.Message7EditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.StateInvariantEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.TimeConstraintEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.TimeObservationEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.policies.InteractionItemSemanticEditPolicy;
import org.eclipse.papyrus.uml.diagram.sequence.edit.policies.SequenceGraphicalNodeEditPolicy;
import org.eclipse.papyrus.uml.diagram.sequence.part.UMLDiagramEditorPlugin;
import org.eclipse.papyrus.uml.diagram.sequence.part.UMLVisualIDRegistry;
import org.eclipse.papyrus.uml.diagram.sequence.providers.UMLElementTypes;
import org.eclipse.papyrus.uml.diagram.sequence.util.NotificationHelper;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.uml2.uml.Gate;
import org.eclipse.uml2.uml.Interaction;
import org.eclipse.uml2.uml.UMLPackage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InteractionEditPart
extends ShapeNodeEditPart {
    public static final int VISUAL_ID = 2001;
    protected IFigure contentPane;
    protected IFigure primaryShape;
    private NotificationHelper notifier = new NotificationHelper(new UIAdapterImpl(){

        protected void safeNotifyChanged(Notification msg) {
            InteractionEditPart.this.handleNotificationEvent(msg);
        }
    });

    public InteractionEditPart(View view) {
        super(view);
    }

    protected void createDefaultEditPolicies() {
        this.installEditPolicy("CreationPolicy", (EditPolicy)new CreationEditPolicy());
        super.createDefaultEditPolicies();
        this.installEditPolicy("SemanticPolicy", (EditPolicy)new InteractionItemSemanticEditPolicy());
        this.installEditPolicy("DragDropPolicy", (EditPolicy)new DragDropEditPolicy());
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)this.createLayoutEditPolicy());
        this.installEditPolicy("GraphicalNodeEditPolicy", (EditPolicy)new SequenceGraphicalNodeEditPolicy());
        this.installEditPolicy("Show/Hide Compartment Policy", (EditPolicy)new ShowHideCompartmentEditPolicy());
    }

    protected LayoutEditPolicy createLayoutEditPolicy() {
        org.eclipse.gmf.runtime.diagram.ui.editpolicies.LayoutEditPolicy lep = new org.eclipse.gmf.runtime.diagram.ui.editpolicies.LayoutEditPolicy(){

            protected EditPolicy createChildEditPolicy(EditPart child) {
                EditPolicy result = child.getEditPolicy((Object)"PrimaryDrag Policy");
                if (result == null) {
                    result = new NonResizableEditPolicy();
                }
                return result;
            }

            protected Command getMoveChildrenCommand(Request request) {
                return null;
            }

            protected Command getCreateCommand(CreateRequest request) {
                return null;
            }
        };
        return lep;
    }

    protected IFigure createNodeShape() {
        this.primaryShape = new InteractionRectangleFigure(){

            public Dimension getMinimumSize(int wHint, int hHint) {
                Rectangle bounds = new Rectangle();
                for (Object child : InteractionEditPart.this.getChildren()) {
                    if (!(child instanceof InteractionInteractionCompartmentEditPart)) continue;
                    InteractionInteractionCompartmentEditPart childEditPart = (InteractionInteractionCompartmentEditPart)((Object)child);
                    for (Object grandChild : childEditPart.getChildren()) {
                        GraphicalEditPart editPart = (GraphicalEditPart)grandChild;
                        IFigure figure = editPart.getFigure();
                        bounds.union(figure.getBounds());
                    }
                    IFigure figure = childEditPart.getFigure();
                    Rectangle rectangle = figure.getBounds();
                    IFigure parentfigure = InteractionEditPart.this.getFigure();
                    Rectangle parentRectangle = parentfigure.getBounds();
                    bounds.width += parentRectangle.width - rectangle.width + 10;
                    bounds.height += parentRectangle.height - rectangle.height + 16;
                    break;
                }
                return bounds.getSize();
            }
        };
        return this.primaryShape;
    }

    public InteractionRectangleFigure getPrimaryShape() {
        return (InteractionRectangleFigure)this.primaryShape;
    }

    protected boolean addFixedChild(EditPart childEditPart) {
        if (childEditPart instanceof InteractionNameEditPart) {
            ((InteractionNameEditPart)childEditPart).setLabel(this.getPrimaryShape().getHeaderLabel());
            return true;
        }
        if (childEditPart instanceof InteractionInteractionCompartmentEditPart) {
            RectangleFigure pane = this.getPrimaryShape().getCompartmentFigure();
            this.setupContentPane((IFigure)pane);
            pane.add(((InteractionInteractionCompartmentEditPart)childEditPart).getFigure());
            return true;
        }
        return false;
    }

    protected boolean removeFixedChild(EditPart childEditPart) {
        if (childEditPart instanceof InteractionNameEditPart) {
            return true;
        }
        if (childEditPart instanceof InteractionInteractionCompartmentEditPart) {
            RectangleFigure pane = this.getPrimaryShape().getCompartmentFigure();
            this.setupContentPane((IFigure)pane);
            pane.remove(((InteractionInteractionCompartmentEditPart)childEditPart).getFigure());
            return true;
        }
        return false;
    }

    protected void addChildVisual(EditPart childEditPart, int index) {
        if (this.addFixedChild(childEditPart)) {
            return;
        }
        super.addChildVisual(childEditPart, -1);
    }

    protected void removeChildVisual(EditPart childEditPart) {
        if (this.removeFixedChild(childEditPart)) {
            return;
        }
        super.removeChildVisual(childEditPart);
    }

    protected IFigure getContentPaneFor(IGraphicalEditPart editPart) {
        if (editPart instanceof InteractionInteractionCompartmentEditPart) {
            return this.getPrimaryShape().getCompartmentFigure();
        }
        return this.getContentPane();
    }

    protected NodeFigure createNodePlate() {
        String prefElementId = "Interaction";
        IPreferenceStore store = UMLDiagramEditorPlugin.getInstance().getPreferenceStore();
        String preferenceConstantWitdh = PreferenceInitializerForElementHelper.getpreferenceKey((View)this.getNotationView(), (String)prefElementId, (int)17);
        String preferenceConstantHeight = PreferenceInitializerForElementHelper.getpreferenceKey((View)this.getNotationView(), (String)prefElementId, (int)16);
        DefaultSizeNodeFigure result = new DefaultSizeNodeFigure(store.getInt(preferenceConstantWitdh), store.getInt(preferenceConstantHeight)){

            protected ConnectionAnchor createAnchor(PrecisionPoint p) {
                if (p == null) {
                    return this.createDefaultAnchor();
                }
                return new AnchorHelper.IntersectionPointAnchor((IFigure)this, p);
            }
        };
        return result;
    }

    protected NodeFigure createNodeFigure() {
        NodeFigure figure = this.createNodePlate();
        figure.setLayoutManager((LayoutManager)new StackLayout());
        IFigure shape = this.createNodeShape();
        figure.add(shape);
        this.contentPane = this.setupContentPane(shape);
        return figure;
    }

    protected IFigure setupContentPane(IFigure nodeShape) {
        if (nodeShape.getLayoutManager() == null) {
            ConstrainedToolbarLayout layout = new ConstrainedToolbarLayout();
            layout.setSpacing(5);
            nodeShape.setLayoutManager((LayoutManager)layout);
        }
        return nodeShape;
    }

    public IFigure getContentPane() {
        if (this.contentPane != null) {
            return this.contentPane;
        }
        return super.getContentPane();
    }

    protected void setForegroundColor(Color color) {
        if (this.primaryShape != null) {
            this.primaryShape.setForegroundColor(color);
        }
    }

    protected void setBackgroundColor(Color color) {
        if (this.primaryShape != null) {
            InteractionRectangleFigure irf;
            this.primaryShape.setBackgroundColor(color);
            if (this.primaryShape instanceof InteractionRectangleFigure && (irf = (InteractionRectangleFigure)this.primaryShape).getCompartmentFigure() != null) {
                irf.getCompartmentFigure().setForegroundColor(color);
            }
        }
    }

    protected void setLineWidth(int width) {
        if (this.primaryShape instanceof Shape) {
            ((Shape)this.primaryShape).setLineWidth(width);
        }
    }

    protected void setLineType(int style) {
        if (this.primaryShape instanceof Shape) {
            ((Shape)this.primaryShape).setLineStyle(style);
        }
    }

    public EditPart getPrimaryChildEditPart() {
        return this.getChildBySemanticHint(UMLVisualIDRegistry.getType(5001));
    }

    public List<IElementType> getMARelTypesOnSource() {
        ArrayList<IElementType> types = new ArrayList<IElementType>(7);
        types.add(UMLElementTypes.Message_4003);
        types.add(UMLElementTypes.Message_4004);
        types.add(UMLElementTypes.Message_4005);
        types.add(UMLElementTypes.Message_4006);
        types.add(UMLElementTypes.Message_4007);
        types.add(UMLElementTypes.Message_4008);
        types.add(UMLElementTypes.Message_4009);
        return types;
    }

    public List<IElementType> getMARelTypesOnSourceAndTarget(IGraphicalEditPart targetEditPart) {
        LinkedList<IElementType> types = new LinkedList<IElementType>();
        if (targetEditPart instanceof InteractionEditPart) {
            types.add(UMLElementTypes.Message_4003);
        }
        if (targetEditPart instanceof ConsiderIgnoreFragmentEditPart) {
            types.add(UMLElementTypes.Message_4003);
        }
        if (targetEditPart instanceof CombinedFragmentEditPart) {
            types.add(UMLElementTypes.Message_4003);
        }
        if (targetEditPart instanceof InteractionOperandEditPart) {
            types.add(UMLElementTypes.Message_4003);
        }
        if (targetEditPart instanceof InteractionUseEditPart) {
            types.add(UMLElementTypes.Message_4003);
        }
        if (targetEditPart instanceof ContinuationEditPart) {
            types.add(UMLElementTypes.Message_4003);
        }
        if (targetEditPart instanceof LifelineEditPart) {
            types.add(UMLElementTypes.Message_4003);
        }
        if (targetEditPart instanceof ActionExecutionSpecificationEditPart) {
            types.add(UMLElementTypes.Message_4003);
        }
        if (targetEditPart instanceof BehaviorExecutionSpecificationEditPart) {
            types.add(UMLElementTypes.Message_4003);
        }
        if (targetEditPart instanceof StateInvariantEditPart) {
            types.add(UMLElementTypes.Message_4003);
        }
        if (targetEditPart instanceof CombinedFragment2EditPart) {
            types.add(UMLElementTypes.Message_4003);
        }
        if (targetEditPart instanceof TimeConstraintEditPart) {
            types.add(UMLElementTypes.Message_4003);
        }
        if (targetEditPart instanceof TimeObservationEditPart) {
            types.add(UMLElementTypes.Message_4003);
        }
        if (targetEditPart instanceof DurationConstraintEditPart) {
            types.add(UMLElementTypes.Message_4003);
        }
        if (targetEditPart instanceof DestructionOccurrenceSpecificationEditPart) {
            types.add(UMLElementTypes.Message_4003);
        }
        if (targetEditPart instanceof ConstraintEditPart) {
            types.add(UMLElementTypes.Message_4003);
        }
        if (targetEditPart instanceof CommentEditPart) {
            types.add(UMLElementTypes.Message_4003);
        }
        if (targetEditPart instanceof DurationConstraintInMessageEditPart) {
            types.add(UMLElementTypes.Message_4003);
        }
        if (targetEditPart instanceof DurationObservationEditPart) {
            types.add(UMLElementTypes.Message_4003);
        }
        if (targetEditPart instanceof InteractionEditPart) {
            types.add(UMLElementTypes.Message_4004);
        }
        if (targetEditPart instanceof ConsiderIgnoreFragmentEditPart) {
            types.add(UMLElementTypes.Message_4004);
        }
        if (targetEditPart instanceof CombinedFragmentEditPart) {
            types.add(UMLElementTypes.Message_4004);
        }
        if (targetEditPart instanceof InteractionOperandEditPart) {
            types.add(UMLElementTypes.Message_4004);
        }
        if (targetEditPart instanceof InteractionUseEditPart) {
            types.add(UMLElementTypes.Message_4004);
        }
        if (targetEditPart instanceof ContinuationEditPart) {
            types.add(UMLElementTypes.Message_4004);
        }
        if (targetEditPart instanceof LifelineEditPart) {
            types.add(UMLElementTypes.Message_4004);
        }
        if (targetEditPart instanceof ActionExecutionSpecificationEditPart) {
            types.add(UMLElementTypes.Message_4004);
        }
        if (targetEditPart instanceof BehaviorExecutionSpecificationEditPart) {
            types.add(UMLElementTypes.Message_4004);
        }
        if (targetEditPart instanceof StateInvariantEditPart) {
            types.add(UMLElementTypes.Message_4004);
        }
        if (targetEditPart instanceof CombinedFragment2EditPart) {
            types.add(UMLElementTypes.Message_4004);
        }
        if (targetEditPart instanceof TimeConstraintEditPart) {
            types.add(UMLElementTypes.Message_4004);
        }
        if (targetEditPart instanceof TimeObservationEditPart) {
            types.add(UMLElementTypes.Message_4004);
        }
        if (targetEditPart instanceof DurationConstraintEditPart) {
            types.add(UMLElementTypes.Message_4004);
        }
        if (targetEditPart instanceof DestructionOccurrenceSpecificationEditPart) {
            types.add(UMLElementTypes.Message_4004);
        }
        if (targetEditPart instanceof ConstraintEditPart) {
            types.add(UMLElementTypes.Message_4004);
        }
        if (targetEditPart instanceof CommentEditPart) {
            types.add(UMLElementTypes.Message_4004);
        }
        if (targetEditPart instanceof DurationConstraintInMessageEditPart) {
            types.add(UMLElementTypes.Message_4004);
        }
        if (targetEditPart instanceof DurationObservationEditPart) {
            types.add(UMLElementTypes.Message_4004);
        }
        if (targetEditPart instanceof InteractionEditPart) {
            types.add(UMLElementTypes.Message_4005);
        }
        if (targetEditPart instanceof ConsiderIgnoreFragmentEditPart) {
            types.add(UMLElementTypes.Message_4005);
        }
        if (targetEditPart instanceof CombinedFragmentEditPart) {
            types.add(UMLElementTypes.Message_4005);
        }
        if (targetEditPart instanceof InteractionOperandEditPart) {
            types.add(UMLElementTypes.Message_4005);
        }
        if (targetEditPart instanceof InteractionUseEditPart) {
            types.add(UMLElementTypes.Message_4005);
        }
        if (targetEditPart instanceof ContinuationEditPart) {
            types.add(UMLElementTypes.Message_4005);
        }
        if (targetEditPart instanceof LifelineEditPart) {
            types.add(UMLElementTypes.Message_4005);
        }
        if (targetEditPart instanceof ActionExecutionSpecificationEditPart) {
            types.add(UMLElementTypes.Message_4005);
        }
        if (targetEditPart instanceof BehaviorExecutionSpecificationEditPart) {
            types.add(UMLElementTypes.Message_4005);
        }
        if (targetEditPart instanceof StateInvariantEditPart) {
            types.add(UMLElementTypes.Message_4005);
        }
        if (targetEditPart instanceof CombinedFragment2EditPart) {
            types.add(UMLElementTypes.Message_4005);
        }
        if (targetEditPart instanceof TimeConstraintEditPart) {
            types.add(UMLElementTypes.Message_4005);
        }
        if (targetEditPart instanceof TimeObservationEditPart) {
            types.add(UMLElementTypes.Message_4005);
        }
        if (targetEditPart instanceof DurationConstraintEditPart) {
            types.add(UMLElementTypes.Message_4005);
        }
        if (targetEditPart instanceof DestructionOccurrenceSpecificationEditPart) {
            types.add(UMLElementTypes.Message_4005);
        }
        if (targetEditPart instanceof ConstraintEditPart) {
            types.add(UMLElementTypes.Message_4005);
        }
        if (targetEditPart instanceof CommentEditPart) {
            types.add(UMLElementTypes.Message_4005);
        }
        if (targetEditPart instanceof DurationConstraintInMessageEditPart) {
            types.add(UMLElementTypes.Message_4005);
        }
        if (targetEditPart instanceof DurationObservationEditPart) {
            types.add(UMLElementTypes.Message_4005);
        }
        if (targetEditPart instanceof InteractionEditPart) {
            types.add(UMLElementTypes.Message_4006);
        }
        if (targetEditPart instanceof ConsiderIgnoreFragmentEditPart) {
            types.add(UMLElementTypes.Message_4006);
        }
        if (targetEditPart instanceof CombinedFragmentEditPart) {
            types.add(UMLElementTypes.Message_4006);
        }
        if (targetEditPart instanceof InteractionOperandEditPart) {
            types.add(UMLElementTypes.Message_4006);
        }
        if (targetEditPart instanceof InteractionUseEditPart) {
            types.add(UMLElementTypes.Message_4006);
        }
        if (targetEditPart instanceof ContinuationEditPart) {
            types.add(UMLElementTypes.Message_4006);
        }
        if (targetEditPart instanceof LifelineEditPart) {
            types.add(UMLElementTypes.Message_4006);
        }
        if (targetEditPart instanceof ActionExecutionSpecificationEditPart) {
            types.add(UMLElementTypes.Message_4006);
        }
        if (targetEditPart instanceof BehaviorExecutionSpecificationEditPart) {
            types.add(UMLElementTypes.Message_4006);
        }
        if (targetEditPart instanceof StateInvariantEditPart) {
            types.add(UMLElementTypes.Message_4006);
        }
        if (targetEditPart instanceof CombinedFragment2EditPart) {
            types.add(UMLElementTypes.Message_4006);
        }
        if (targetEditPart instanceof TimeConstraintEditPart) {
            types.add(UMLElementTypes.Message_4006);
        }
        if (targetEditPart instanceof TimeObservationEditPart) {
            types.add(UMLElementTypes.Message_4006);
        }
        if (targetEditPart instanceof DurationConstraintEditPart) {
            types.add(UMLElementTypes.Message_4006);
        }
        if (targetEditPart instanceof DestructionOccurrenceSpecificationEditPart) {
            types.add(UMLElementTypes.Message_4006);
        }
        if (targetEditPart instanceof ConstraintEditPart) {
            types.add(UMLElementTypes.Message_4006);
        }
        if (targetEditPart instanceof CommentEditPart) {
            types.add(UMLElementTypes.Message_4006);
        }
        if (targetEditPart instanceof DurationConstraintInMessageEditPart) {
            types.add(UMLElementTypes.Message_4006);
        }
        if (targetEditPart instanceof DurationObservationEditPart) {
            types.add(UMLElementTypes.Message_4006);
        }
        if (targetEditPart instanceof InteractionEditPart) {
            types.add(UMLElementTypes.Message_4007);
        }
        if (targetEditPart instanceof ConsiderIgnoreFragmentEditPart) {
            types.add(UMLElementTypes.Message_4007);
        }
        if (targetEditPart instanceof CombinedFragmentEditPart) {
            types.add(UMLElementTypes.Message_4007);
        }
        if (targetEditPart instanceof InteractionOperandEditPart) {
            types.add(UMLElementTypes.Message_4007);
        }
        if (targetEditPart instanceof InteractionUseEditPart) {
            types.add(UMLElementTypes.Message_4007);
        }
        if (targetEditPart instanceof ContinuationEditPart) {
            types.add(UMLElementTypes.Message_4007);
        }
        if (targetEditPart instanceof LifelineEditPart) {
            types.add(UMLElementTypes.Message_4007);
        }
        if (targetEditPart instanceof ActionExecutionSpecificationEditPart) {
            types.add(UMLElementTypes.Message_4007);
        }
        if (targetEditPart instanceof BehaviorExecutionSpecificationEditPart) {
            types.add(UMLElementTypes.Message_4007);
        }
        if (targetEditPart instanceof StateInvariantEditPart) {
            types.add(UMLElementTypes.Message_4007);
        }
        if (targetEditPart instanceof CombinedFragment2EditPart) {
            types.add(UMLElementTypes.Message_4007);
        }
        if (targetEditPart instanceof TimeConstraintEditPart) {
            types.add(UMLElementTypes.Message_4007);
        }
        if (targetEditPart instanceof TimeObservationEditPart) {
            types.add(UMLElementTypes.Message_4007);
        }
        if (targetEditPart instanceof DurationConstraintEditPart) {
            types.add(UMLElementTypes.Message_4007);
        }
        if (targetEditPart instanceof DestructionOccurrenceSpecificationEditPart) {
            types.add(UMLElementTypes.Message_4007);
        }
        if (targetEditPart instanceof ConstraintEditPart) {
            types.add(UMLElementTypes.Message_4007);
        }
        if (targetEditPart instanceof CommentEditPart) {
            types.add(UMLElementTypes.Message_4007);
        }
        if (targetEditPart instanceof DurationConstraintInMessageEditPart) {
            types.add(UMLElementTypes.Message_4007);
        }
        if (targetEditPart instanceof DurationObservationEditPart) {
            types.add(UMLElementTypes.Message_4007);
        }
        if (targetEditPart instanceof InteractionEditPart) {
            types.add(UMLElementTypes.Message_4008);
        }
        if (targetEditPart instanceof ConsiderIgnoreFragmentEditPart) {
            types.add(UMLElementTypes.Message_4008);
        }
        if (targetEditPart instanceof CombinedFragmentEditPart) {
            types.add(UMLElementTypes.Message_4008);
        }
        if (targetEditPart instanceof InteractionOperandEditPart) {
            types.add(UMLElementTypes.Message_4008);
        }
        if (targetEditPart instanceof InteractionUseEditPart) {
            types.add(UMLElementTypes.Message_4008);
        }
        if (targetEditPart instanceof ContinuationEditPart) {
            types.add(UMLElementTypes.Message_4008);
        }
        if (targetEditPart instanceof LifelineEditPart) {
            types.add(UMLElementTypes.Message_4008);
        }
        if (targetEditPart instanceof ActionExecutionSpecificationEditPart) {
            types.add(UMLElementTypes.Message_4008);
        }
        if (targetEditPart instanceof BehaviorExecutionSpecificationEditPart) {
            types.add(UMLElementTypes.Message_4008);
        }
        if (targetEditPart instanceof StateInvariantEditPart) {
            types.add(UMLElementTypes.Message_4008);
        }
        if (targetEditPart instanceof CombinedFragment2EditPart) {
            types.add(UMLElementTypes.Message_4008);
        }
        if (targetEditPart instanceof TimeConstraintEditPart) {
            types.add(UMLElementTypes.Message_4008);
        }
        if (targetEditPart instanceof TimeObservationEditPart) {
            types.add(UMLElementTypes.Message_4008);
        }
        if (targetEditPart instanceof DurationConstraintEditPart) {
            types.add(UMLElementTypes.Message_4008);
        }
        if (targetEditPart instanceof DestructionOccurrenceSpecificationEditPart) {
            types.add(UMLElementTypes.Message_4008);
        }
        if (targetEditPart instanceof ConstraintEditPart) {
            types.add(UMLElementTypes.Message_4008);
        }
        if (targetEditPart instanceof CommentEditPart) {
            types.add(UMLElementTypes.Message_4008);
        }
        if (targetEditPart instanceof DurationConstraintInMessageEditPart) {
            types.add(UMLElementTypes.Message_4008);
        }
        if (targetEditPart instanceof DurationObservationEditPart) {
            types.add(UMLElementTypes.Message_4008);
        }
        if (targetEditPart instanceof InteractionEditPart) {
            types.add(UMLElementTypes.Message_4009);
        }
        if (targetEditPart instanceof ConsiderIgnoreFragmentEditPart) {
            types.add(UMLElementTypes.Message_4009);
        }
        if (targetEditPart instanceof CombinedFragmentEditPart) {
            types.add(UMLElementTypes.Message_4009);
        }
        if (targetEditPart instanceof InteractionOperandEditPart) {
            types.add(UMLElementTypes.Message_4009);
        }
        if (targetEditPart instanceof InteractionUseEditPart) {
            types.add(UMLElementTypes.Message_4009);
        }
        if (targetEditPart instanceof ContinuationEditPart) {
            types.add(UMLElementTypes.Message_4009);
        }
        if (targetEditPart instanceof LifelineEditPart) {
            types.add(UMLElementTypes.Message_4009);
        }
        if (targetEditPart instanceof ActionExecutionSpecificationEditPart) {
            types.add(UMLElementTypes.Message_4009);
        }
        if (targetEditPart instanceof BehaviorExecutionSpecificationEditPart) {
            types.add(UMLElementTypes.Message_4009);
        }
        if (targetEditPart instanceof StateInvariantEditPart) {
            types.add(UMLElementTypes.Message_4009);
        }
        if (targetEditPart instanceof CombinedFragment2EditPart) {
            types.add(UMLElementTypes.Message_4009);
        }
        if (targetEditPart instanceof TimeConstraintEditPart) {
            types.add(UMLElementTypes.Message_4009);
        }
        if (targetEditPart instanceof TimeObservationEditPart) {
            types.add(UMLElementTypes.Message_4009);
        }
        if (targetEditPart instanceof DurationConstraintEditPart) {
            types.add(UMLElementTypes.Message_4009);
        }
        if (targetEditPart instanceof DestructionOccurrenceSpecificationEditPart) {
            types.add(UMLElementTypes.Message_4009);
        }
        if (targetEditPart instanceof ConstraintEditPart) {
            types.add(UMLElementTypes.Message_4009);
        }
        if (targetEditPart instanceof CommentEditPart) {
            types.add(UMLElementTypes.Message_4009);
        }
        if (targetEditPart instanceof DurationConstraintInMessageEditPart) {
            types.add(UMLElementTypes.Message_4009);
        }
        if (targetEditPart instanceof DurationObservationEditPart) {
            types.add(UMLElementTypes.Message_4009);
        }
        return types;
    }

    public List<IElementType> getMATypesForTarget(IElementType relationshipType) {
        LinkedList<IElementType> types = new LinkedList<IElementType>();
        if (relationshipType == UMLElementTypes.Message_4003) {
            types.add(UMLElementTypes.Interaction_2001);
            types.add(UMLElementTypes.ConsiderIgnoreFragment_3007);
            types.add(UMLElementTypes.CombinedFragment_3004);
            types.add(UMLElementTypes.InteractionOperand_3005);
            types.add(UMLElementTypes.InteractionUse_3002);
            types.add(UMLElementTypes.Continuation_3016);
            types.add(UMLElementTypes.Lifeline_3001);
            types.add(UMLElementTypes.ActionExecutionSpecification_3006);
            types.add(UMLElementTypes.BehaviorExecutionSpecification_3003);
            types.add(UMLElementTypes.StateInvariant_3017);
            types.add(UMLElementTypes.CombinedFragment_3018);
            types.add(UMLElementTypes.TimeConstraint_3019);
            types.add(UMLElementTypes.TimeObservation_3020);
            types.add(UMLElementTypes.DurationConstraint_3021);
            types.add(UMLElementTypes.DestructionOccurrenceSpecification_3022);
            types.add(UMLElementTypes.Constraint_3008);
            types.add(UMLElementTypes.Comment_3009);
            types.add(UMLElementTypes.DurationConstraint_3023);
            types.add(UMLElementTypes.DurationObservation_3024);
        } else if (relationshipType == UMLElementTypes.Message_4004) {
            types.add(UMLElementTypes.Interaction_2001);
            types.add(UMLElementTypes.ConsiderIgnoreFragment_3007);
            types.add(UMLElementTypes.CombinedFragment_3004);
            types.add(UMLElementTypes.InteractionOperand_3005);
            types.add(UMLElementTypes.InteractionUse_3002);
            types.add(UMLElementTypes.Continuation_3016);
            types.add(UMLElementTypes.Lifeline_3001);
            types.add(UMLElementTypes.ActionExecutionSpecification_3006);
            types.add(UMLElementTypes.BehaviorExecutionSpecification_3003);
            types.add(UMLElementTypes.StateInvariant_3017);
            types.add(UMLElementTypes.CombinedFragment_3018);
            types.add(UMLElementTypes.TimeConstraint_3019);
            types.add(UMLElementTypes.TimeObservation_3020);
            types.add(UMLElementTypes.DurationConstraint_3021);
            types.add(UMLElementTypes.DestructionOccurrenceSpecification_3022);
            types.add(UMLElementTypes.Constraint_3008);
            types.add(UMLElementTypes.Comment_3009);
            types.add(UMLElementTypes.DurationConstraint_3023);
            types.add(UMLElementTypes.DurationObservation_3024);
        } else if (relationshipType == UMLElementTypes.Message_4005) {
            types.add(UMLElementTypes.Interaction_2001);
            types.add(UMLElementTypes.ConsiderIgnoreFragment_3007);
            types.add(UMLElementTypes.CombinedFragment_3004);
            types.add(UMLElementTypes.InteractionOperand_3005);
            types.add(UMLElementTypes.InteractionUse_3002);
            types.add(UMLElementTypes.Continuation_3016);
            types.add(UMLElementTypes.Lifeline_3001);
            types.add(UMLElementTypes.ActionExecutionSpecification_3006);
            types.add(UMLElementTypes.BehaviorExecutionSpecification_3003);
            types.add(UMLElementTypes.StateInvariant_3017);
            types.add(UMLElementTypes.CombinedFragment_3018);
            types.add(UMLElementTypes.TimeConstraint_3019);
            types.add(UMLElementTypes.TimeObservation_3020);
            types.add(UMLElementTypes.DurationConstraint_3021);
            types.add(UMLElementTypes.DestructionOccurrenceSpecification_3022);
            types.add(UMLElementTypes.Constraint_3008);
            types.add(UMLElementTypes.Comment_3009);
            types.add(UMLElementTypes.DurationConstraint_3023);
            types.add(UMLElementTypes.DurationObservation_3024);
        } else if (relationshipType == UMLElementTypes.Message_4006) {
            types.add(UMLElementTypes.Interaction_2001);
            types.add(UMLElementTypes.ConsiderIgnoreFragment_3007);
            types.add(UMLElementTypes.CombinedFragment_3004);
            types.add(UMLElementTypes.InteractionOperand_3005);
            types.add(UMLElementTypes.InteractionUse_3002);
            types.add(UMLElementTypes.Continuation_3016);
            types.add(UMLElementTypes.Lifeline_3001);
            types.add(UMLElementTypes.ActionExecutionSpecification_3006);
            types.add(UMLElementTypes.BehaviorExecutionSpecification_3003);
            types.add(UMLElementTypes.StateInvariant_3017);
            types.add(UMLElementTypes.CombinedFragment_3018);
            types.add(UMLElementTypes.TimeConstraint_3019);
            types.add(UMLElementTypes.TimeObservation_3020);
            types.add(UMLElementTypes.DurationConstraint_3021);
            types.add(UMLElementTypes.DestructionOccurrenceSpecification_3022);
            types.add(UMLElementTypes.Constraint_3008);
            types.add(UMLElementTypes.Comment_3009);
            types.add(UMLElementTypes.DurationConstraint_3023);
            types.add(UMLElementTypes.DurationObservation_3024);
        } else if (relationshipType == UMLElementTypes.Message_4007) {
            types.add(UMLElementTypes.Interaction_2001);
            types.add(UMLElementTypes.ConsiderIgnoreFragment_3007);
            types.add(UMLElementTypes.CombinedFragment_3004);
            types.add(UMLElementTypes.InteractionOperand_3005);
            types.add(UMLElementTypes.InteractionUse_3002);
            types.add(UMLElementTypes.Continuation_3016);
            types.add(UMLElementTypes.Lifeline_3001);
            types.add(UMLElementTypes.ActionExecutionSpecification_3006);
            types.add(UMLElementTypes.BehaviorExecutionSpecification_3003);
            types.add(UMLElementTypes.StateInvariant_3017);
            types.add(UMLElementTypes.CombinedFragment_3018);
            types.add(UMLElementTypes.TimeConstraint_3019);
            types.add(UMLElementTypes.TimeObservation_3020);
            types.add(UMLElementTypes.DurationConstraint_3021);
            types.add(UMLElementTypes.DestructionOccurrenceSpecification_3022);
            types.add(UMLElementTypes.Constraint_3008);
            types.add(UMLElementTypes.Comment_3009);
            types.add(UMLElementTypes.DurationConstraint_3023);
            types.add(UMLElementTypes.DurationObservation_3024);
        } else if (relationshipType == UMLElementTypes.Message_4008) {
            types.add(UMLElementTypes.Interaction_2001);
            types.add(UMLElementTypes.ConsiderIgnoreFragment_3007);
            types.add(UMLElementTypes.CombinedFragment_3004);
            types.add(UMLElementTypes.InteractionOperand_3005);
            types.add(UMLElementTypes.InteractionUse_3002);
            types.add(UMLElementTypes.Continuation_3016);
            types.add(UMLElementTypes.Lifeline_3001);
            types.add(UMLElementTypes.ActionExecutionSpecification_3006);
            types.add(UMLElementTypes.BehaviorExecutionSpecification_3003);
            types.add(UMLElementTypes.StateInvariant_3017);
            types.add(UMLElementTypes.CombinedFragment_3018);
            types.add(UMLElementTypes.TimeConstraint_3019);
            types.add(UMLElementTypes.TimeObservation_3020);
            types.add(UMLElementTypes.DurationConstraint_3021);
            types.add(UMLElementTypes.DestructionOccurrenceSpecification_3022);
            types.add(UMLElementTypes.Constraint_3008);
            types.add(UMLElementTypes.Comment_3009);
            types.add(UMLElementTypes.DurationConstraint_3023);
            types.add(UMLElementTypes.DurationObservation_3024);
        } else if (relationshipType == UMLElementTypes.Message_4009) {
            types.add(UMLElementTypes.Interaction_2001);
            types.add(UMLElementTypes.ConsiderIgnoreFragment_3007);
            types.add(UMLElementTypes.CombinedFragment_3004);
            types.add(UMLElementTypes.InteractionOperand_3005);
            types.add(UMLElementTypes.InteractionUse_3002);
            types.add(UMLElementTypes.Continuation_3016);
            types.add(UMLElementTypes.Lifeline_3001);
            types.add(UMLElementTypes.ActionExecutionSpecification_3006);
            types.add(UMLElementTypes.BehaviorExecutionSpecification_3003);
            types.add(UMLElementTypes.StateInvariant_3017);
            types.add(UMLElementTypes.CombinedFragment_3018);
            types.add(UMLElementTypes.TimeConstraint_3019);
            types.add(UMLElementTypes.TimeObservation_3020);
            types.add(UMLElementTypes.DurationConstraint_3021);
            types.add(UMLElementTypes.DestructionOccurrenceSpecification_3022);
            types.add(UMLElementTypes.Constraint_3008);
            types.add(UMLElementTypes.Comment_3009);
            types.add(UMLElementTypes.DurationConstraint_3023);
            types.add(UMLElementTypes.DurationObservation_3024);
        }
        return types;
    }

    public List<IElementType> getMARelTypesOnTarget() {
        ArrayList<IElementType> types = new ArrayList<IElementType>(9);
        types.add(UMLElementTypes.Message_4003);
        types.add(UMLElementTypes.Message_4004);
        types.add(UMLElementTypes.Message_4005);
        types.add(UMLElementTypes.Message_4006);
        types.add(UMLElementTypes.Message_4007);
        types.add(UMLElementTypes.Message_4008);
        types.add(UMLElementTypes.Message_4009);
        types.add(UMLElementTypes.CommentAnnotatedElement_4010);
        types.add(UMLElementTypes.ConstraintConstrainedElement_4011);
        return types;
    }

    public List<IElementType> getMATypesForSource(IElementType relationshipType) {
        LinkedList<IElementType> types = new LinkedList<IElementType>();
        if (relationshipType == UMLElementTypes.Message_4003) {
            types.add(UMLElementTypes.Interaction_2001);
            types.add(UMLElementTypes.ConsiderIgnoreFragment_3007);
            types.add(UMLElementTypes.CombinedFragment_3004);
            types.add(UMLElementTypes.InteractionOperand_3005);
            types.add(UMLElementTypes.InteractionUse_3002);
            types.add(UMLElementTypes.Continuation_3016);
            types.add(UMLElementTypes.Lifeline_3001);
            types.add(UMLElementTypes.ActionExecutionSpecification_3006);
            types.add(UMLElementTypes.BehaviorExecutionSpecification_3003);
            types.add(UMLElementTypes.StateInvariant_3017);
            types.add(UMLElementTypes.CombinedFragment_3018);
            types.add(UMLElementTypes.TimeConstraint_3019);
            types.add(UMLElementTypes.TimeObservation_3020);
            types.add(UMLElementTypes.DurationConstraint_3021);
            types.add(UMLElementTypes.DestructionOccurrenceSpecification_3022);
            types.add(UMLElementTypes.Constraint_3008);
            types.add(UMLElementTypes.Comment_3009);
            types.add(UMLElementTypes.DurationConstraint_3023);
            types.add(UMLElementTypes.DurationObservation_3024);
        } else if (relationshipType == UMLElementTypes.Message_4004) {
            types.add(UMLElementTypes.Interaction_2001);
            types.add(UMLElementTypes.ConsiderIgnoreFragment_3007);
            types.add(UMLElementTypes.CombinedFragment_3004);
            types.add(UMLElementTypes.InteractionOperand_3005);
            types.add(UMLElementTypes.InteractionUse_3002);
            types.add(UMLElementTypes.Continuation_3016);
            types.add(UMLElementTypes.Lifeline_3001);
            types.add(UMLElementTypes.ActionExecutionSpecification_3006);
            types.add(UMLElementTypes.BehaviorExecutionSpecification_3003);
            types.add(UMLElementTypes.StateInvariant_3017);
            types.add(UMLElementTypes.CombinedFragment_3018);
            types.add(UMLElementTypes.TimeConstraint_3019);
            types.add(UMLElementTypes.TimeObservation_3020);
            types.add(UMLElementTypes.DurationConstraint_3021);
            types.add(UMLElementTypes.DestructionOccurrenceSpecification_3022);
            types.add(UMLElementTypes.Constraint_3008);
            types.add(UMLElementTypes.Comment_3009);
            types.add(UMLElementTypes.DurationConstraint_3023);
            types.add(UMLElementTypes.DurationObservation_3024);
        } else if (relationshipType == UMLElementTypes.Message_4005) {
            types.add(UMLElementTypes.Interaction_2001);
            types.add(UMLElementTypes.ConsiderIgnoreFragment_3007);
            types.add(UMLElementTypes.CombinedFragment_3004);
            types.add(UMLElementTypes.InteractionOperand_3005);
            types.add(UMLElementTypes.InteractionUse_3002);
            types.add(UMLElementTypes.Continuation_3016);
            types.add(UMLElementTypes.Lifeline_3001);
            types.add(UMLElementTypes.ActionExecutionSpecification_3006);
            types.add(UMLElementTypes.BehaviorExecutionSpecification_3003);
            types.add(UMLElementTypes.StateInvariant_3017);
            types.add(UMLElementTypes.CombinedFragment_3018);
            types.add(UMLElementTypes.TimeConstraint_3019);
            types.add(UMLElementTypes.TimeObservation_3020);
            types.add(UMLElementTypes.DurationConstraint_3021);
            types.add(UMLElementTypes.DestructionOccurrenceSpecification_3022);
            types.add(UMLElementTypes.Constraint_3008);
            types.add(UMLElementTypes.Comment_3009);
            types.add(UMLElementTypes.DurationConstraint_3023);
            types.add(UMLElementTypes.DurationObservation_3024);
        } else if (relationshipType == UMLElementTypes.Message_4006) {
            types.add(UMLElementTypes.Interaction_2001);
            types.add(UMLElementTypes.ConsiderIgnoreFragment_3007);
            types.add(UMLElementTypes.CombinedFragment_3004);
            types.add(UMLElementTypes.InteractionOperand_3005);
            types.add(UMLElementTypes.InteractionUse_3002);
            types.add(UMLElementTypes.Continuation_3016);
            types.add(UMLElementTypes.Lifeline_3001);
            types.add(UMLElementTypes.ActionExecutionSpecification_3006);
            types.add(UMLElementTypes.BehaviorExecutionSpecification_3003);
            types.add(UMLElementTypes.StateInvariant_3017);
            types.add(UMLElementTypes.CombinedFragment_3018);
            types.add(UMLElementTypes.TimeConstraint_3019);
            types.add(UMLElementTypes.TimeObservation_3020);
            types.add(UMLElementTypes.DurationConstraint_3021);
            types.add(UMLElementTypes.DestructionOccurrenceSpecification_3022);
            types.add(UMLElementTypes.Constraint_3008);
            types.add(UMLElementTypes.Comment_3009);
            types.add(UMLElementTypes.DurationConstraint_3023);
            types.add(UMLElementTypes.DurationObservation_3024);
        } else if (relationshipType == UMLElementTypes.Message_4007) {
            types.add(UMLElementTypes.Interaction_2001);
            types.add(UMLElementTypes.ConsiderIgnoreFragment_3007);
            types.add(UMLElementTypes.CombinedFragment_3004);
            types.add(UMLElementTypes.InteractionOperand_3005);
            types.add(UMLElementTypes.InteractionUse_3002);
            types.add(UMLElementTypes.Continuation_3016);
            types.add(UMLElementTypes.Lifeline_3001);
            types.add(UMLElementTypes.ActionExecutionSpecification_3006);
            types.add(UMLElementTypes.BehaviorExecutionSpecification_3003);
            types.add(UMLElementTypes.StateInvariant_3017);
            types.add(UMLElementTypes.CombinedFragment_3018);
            types.add(UMLElementTypes.TimeConstraint_3019);
            types.add(UMLElementTypes.TimeObservation_3020);
            types.add(UMLElementTypes.DurationConstraint_3021);
            types.add(UMLElementTypes.DestructionOccurrenceSpecification_3022);
            types.add(UMLElementTypes.Constraint_3008);
            types.add(UMLElementTypes.Comment_3009);
            types.add(UMLElementTypes.DurationConstraint_3023);
            types.add(UMLElementTypes.DurationObservation_3024);
        } else if (relationshipType == UMLElementTypes.Message_4008) {
            types.add(UMLElementTypes.Interaction_2001);
            types.add(UMLElementTypes.ConsiderIgnoreFragment_3007);
            types.add(UMLElementTypes.CombinedFragment_3004);
            types.add(UMLElementTypes.InteractionOperand_3005);
            types.add(UMLElementTypes.InteractionUse_3002);
            types.add(UMLElementTypes.Continuation_3016);
            types.add(UMLElementTypes.Lifeline_3001);
            types.add(UMLElementTypes.ActionExecutionSpecification_3006);
            types.add(UMLElementTypes.BehaviorExecutionSpecification_3003);
            types.add(UMLElementTypes.StateInvariant_3017);
            types.add(UMLElementTypes.CombinedFragment_3018);
            types.add(UMLElementTypes.TimeConstraint_3019);
            types.add(UMLElementTypes.TimeObservation_3020);
            types.add(UMLElementTypes.DurationConstraint_3021);
            types.add(UMLElementTypes.DestructionOccurrenceSpecification_3022);
            types.add(UMLElementTypes.Constraint_3008);
            types.add(UMLElementTypes.Comment_3009);
            types.add(UMLElementTypes.DurationConstraint_3023);
            types.add(UMLElementTypes.DurationObservation_3024);
        } else if (relationshipType == UMLElementTypes.Message_4009) {
            types.add(UMLElementTypes.Interaction_2001);
            types.add(UMLElementTypes.ConsiderIgnoreFragment_3007);
            types.add(UMLElementTypes.CombinedFragment_3004);
            types.add(UMLElementTypes.InteractionOperand_3005);
            types.add(UMLElementTypes.InteractionUse_3002);
            types.add(UMLElementTypes.Continuation_3016);
            types.add(UMLElementTypes.Lifeline_3001);
            types.add(UMLElementTypes.ActionExecutionSpecification_3006);
            types.add(UMLElementTypes.BehaviorExecutionSpecification_3003);
            types.add(UMLElementTypes.StateInvariant_3017);
            types.add(UMLElementTypes.CombinedFragment_3018);
            types.add(UMLElementTypes.TimeConstraint_3019);
            types.add(UMLElementTypes.TimeObservation_3020);
            types.add(UMLElementTypes.DurationConstraint_3021);
            types.add(UMLElementTypes.DestructionOccurrenceSpecification_3022);
            types.add(UMLElementTypes.Constraint_3008);
            types.add(UMLElementTypes.Comment_3009);
            types.add(UMLElementTypes.DurationConstraint_3023);
            types.add(UMLElementTypes.DurationObservation_3024);
        } else if (relationshipType == UMLElementTypes.CommentAnnotatedElement_4010) {
            types.add(UMLElementTypes.Comment_3009);
        } else if (relationshipType == UMLElementTypes.ConstraintConstrainedElement_4011) {
            types.add(UMLElementTypes.TimeConstraint_3019);
            types.add(UMLElementTypes.DurationConstraint_3021);
            types.add(UMLElementTypes.Constraint_3008);
            types.add(UMLElementTypes.DurationConstraint_3023);
        }
        return types;
    }

    public Object getPreferredValue(EStructuralFeature feature) {
        IPreferenceStore preferenceStore = (IPreferenceStore)this.getDiagramPreferencesHint().getPreferenceStore();
        Object result = null;
        if (feature == NotationPackage.eINSTANCE.getLineStyle_LineColor() || feature == NotationPackage.eINSTANCE.getFontStyle_FontColor() || feature == NotationPackage.eINSTANCE.getFillStyle_FillColor()) {
            String prefColor = null;
            if (feature == NotationPackage.eINSTANCE.getLineStyle_LineColor()) {
                prefColor = PreferenceConstantHelper.getElementConstant((String)"Interaction", (int)3);
            } else if (feature == NotationPackage.eINSTANCE.getFontStyle_FontColor()) {
                prefColor = PreferenceConstantHelper.getElementConstant((String)"Interaction", (int)2);
            } else if (feature == NotationPackage.eINSTANCE.getFillStyle_FillColor()) {
                prefColor = PreferenceConstantHelper.getElementConstant((String)"Interaction", (int)0);
            }
            result = FigureUtilities.RGBToInteger((RGB)PreferenceConverter.getColor((IPreferenceStore)preferenceStore, (String)prefColor));
        } else if (feature == NotationPackage.eINSTANCE.getFillStyle_Transparency() || feature == NotationPackage.eINSTANCE.getFillStyle_Gradient()) {
            String prefGradient = PreferenceConstantHelper.getElementConstant((String)"Interaction", (int)4);
            GradientPreferenceConverter gradientPreferenceConverter = new GradientPreferenceConverter(preferenceStore.getString(prefGradient));
            if (feature == NotationPackage.eINSTANCE.getFillStyle_Transparency()) {
                result = new Integer(gradientPreferenceConverter.getTransparency());
            } else if (feature == NotationPackage.eINSTANCE.getFillStyle_Gradient()) {
                result = gradientPreferenceConverter.getGradientData();
            }
        }
        if (result == null) {
            result = this.getStructuralFeatureValue(feature);
        }
        return result;
    }

    protected void refreshFont() {
        super.refreshFont();
        this.refreshBounds();
    }

    protected void handleNotificationEvent(Notification notification) {
        Object feature = notification.getFeature();
        if (UMLPackage.eINSTANCE.getInteraction_FormalGate().equals(feature)) {
            this.notifier.unlistenObject((Notifier)notification.getOldValue());
            this.notifier.listenObject((Notifier)notification.getNewValue());
        } else if (UMLPackage.eINSTANCE.getNamedElement_Name().equals(feature) && notification.getNotifier() instanceof Gate) {
            String newPrefix;
            String oldPrefix;
            Gate gate = (Gate)notification.getNotifier();
            String oldStringValue = notification.getOldStringValue();
            String newStringValue = notification.getNewStringValue();
            if (oldStringValue != null && newStringValue != null && !(oldPrefix = oldStringValue.split("_")[0]).equals(newPrefix = newStringValue.split("_")[0]) && (oldPrefix.equals(MessageDirection.IN.getName()) || oldPrefix.equals(MessageDirection.OUT.getName()))) {
                this.notifier.unlistenObject((Notifier)gate);
                gate.setName(String.valueOf(oldPrefix) + "_" + gate.getName());
                this.notifier.listenObject((Notifier)gate);
            }
        }
        super.handleNotificationEvent(notification);
    }

    public void activate() {
        super.activate();
        Interaction interaction = (Interaction)this.resolveSemanticElement();
        if (interaction != null) {
            for (Gate formalGate : interaction.getFormalGates()) {
                this.notifier.listenObject((Notifier)formalGate);
            }
        }
    }

    public void deactivate() {
        super.deactivate();
        this.notifier.unlistenAll();
    }

    public void removeNotify() {
        this.notifier.unlistenAll();
        super.removeNotify();
    }

    public ConnectionAnchor getSourceConnectionAnchor(Request request) {
        ConnectionAnchor sourceAnchor = this.createAnchor(request, UMLElementTypes.Message_4009, 4009, Message7EditPart.class);
        if (sourceAnchor == null) {
            sourceAnchor = super.getSourceConnectionAnchor(request);
        }
        return sourceAnchor;
    }

    public ConnectionAnchor getSourceConnectionAnchor(ConnectionEditPart connEditPart) {
        String terminal;
        if (connEditPart instanceof Message7EditPart && (terminal = AnchorHelper.getAnchorId(this.getEditingDomain(), connEditPart, true)).length() > 0) {
            PrecisionPoint pt = SlidableAnchor.parseTerminalString((String)terminal);
            return new AnchorHelper.InnerPointAnchor(this.getFigure(), pt);
        }
        ConnectionAnchor sourceConnectionAnchor = super.getSourceConnectionAnchor(connEditPart);
        return sourceConnectionAnchor;
    }

    public ConnectionAnchor getTargetConnectionAnchor(Request request) {
        ConnectionAnchor targetAnchor = this.createAnchor(request, UMLElementTypes.Message_4008, 4008, Message6EditPart.class);
        if (targetAnchor == null) {
            targetAnchor = super.getTargetConnectionAnchor(request);
        }
        return targetAnchor;
    }

    public ConnectionAnchor getTargetConnectionAnchor(ConnectionEditPart connEditPart) {
        String terminal;
        if (connEditPart instanceof Message6EditPart && (terminal = AnchorHelper.getAnchorId(this.getEditingDomain(), connEditPart, false)).length() > 0) {
            PrecisionPoint pt = SlidableAnchor.parseTerminalString((String)terminal);
            return new AnchorHelper.InnerPointAnchor(this.getFigure(), pt);
        }
        ConnectionAnchor targetConnectionAnchor = super.getTargetConnectionAnchor(connEditPart);
        return targetConnectionAnchor;
    }

    private ConnectionAnchor createAnchor(Request request, IElementType elementType, int visualId, Class<?> messageType) {
        ReconnectRequest reconnectRequest;
        ConnectionEditPart connectionEditPart;
        if (request instanceof CreateUnspecifiedTypeConnectionRequest) {
            CreateUnspecifiedTypeConnectionRequest createRequest = (CreateUnspecifiedTypeConnectionRequest)request;
            List relationshipTypes = createRequest.getElementTypes();
            for (Object obj : relationshipTypes) {
                if (!elementType.equals(obj)) continue;
                return this.createAnchor(createRequest.getLocation().getCopy());
            }
        } else if (request instanceof CreateConnectionViewAndElementRequest) {
            CreateConnectionViewAndElementRequest createRequest = (CreateConnectionViewAndElementRequest)request;
            CreateConnectionViewAndElementRequest.ConnectionViewAndElementDescriptor connectionViewDescriptor = createRequest.getConnectionViewAndElementDescriptor();
            if (connectionViewDescriptor != null && String.valueOf(visualId).equals(connectionViewDescriptor.getSemanticHint())) {
                return this.createAnchor(createRequest.getLocation().getCopy());
            }
        } else if (request instanceof ReconnectRequest && messageType.equals((connectionEditPart = (reconnectRequest = (ReconnectRequest)request).getConnectionEditPart()).getClass()) && request instanceof LocationRequest) {
            return this.createAnchor(((LocationRequest)request).getLocation().getCopy());
        }
        return null;
    }

    private ConnectionAnchor createAnchor(Point location) {
        return AnchorHelper.InnerPointAnchor.createAnchorAtLocation(this.getFigure(), new PrecisionPoint(location));
    }
}

