/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.edit.policies;

import java.util.ArrayList;
import org.eclipse.draw2d.ConnectionRouter;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Polyline;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.CreateConnectionRequest;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gef.requests.ReconnectRequest;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateConnectionViewAndElementRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateConnectionViewRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateUnspecifiedTypeConnectionRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateUnspecifiedTypeRequest;
import org.eclipse.papyrus.uml.diagram.sequence.draw2d.routers.MessageRouter;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.LifelineEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.Message4EditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.policies.SequenceGraphicalNodeEditPolicy;
import org.eclipse.papyrus.uml.diagram.sequence.providers.UMLElementTypes;
import org.eclipse.papyrus.uml.diagram.sequence.util.LifelineMessageCreateHelper;
import org.eclipse.papyrus.uml.diagram.sequence.util.OccurrenceSpecificationMoveHelper;

public class LifelineChildGraphicalNodeEditPolicy
extends SequenceGraphicalNodeEditPolicy {
    private Polyline durationCreationFeedback = null;
    public static ConnectionRouter messageRouter = new MessageRouter();

    public Command getCommand(Request request) {
        if ("connection start".equals(request.getType())) {
            if (request instanceof CreateConnectionViewAndElementRequest) {
                return this.getConnectionAndRelationshipCreateCommand((CreateConnectionViewAndElementRequest)request);
            }
            if (request instanceof CreateUnspecifiedTypeConnectionRequest) {
                return this.getUnspecifiedConnectionCreateCommand((CreateUnspecifiedTypeConnectionRequest)request);
            }
        } else if ("connection end".equals(request.getType())) {
            if (request instanceof CreateConnectionViewAndElementRequest) {
                return this.getConnectionAndRelationshipCompleteCommand((CreateConnectionViewAndElementRequest)request);
            }
            if (request instanceof CreateUnspecifiedTypeConnectionRequest) {
                return this.getUnspecifiedConnectionCompleteCommand((CreateUnspecifiedTypeConnectionRequest)request);
            }
        }
        return super.getCommand(request);
    }

    private Command getUnspecifiedConnectionCreateCommand(CreateUnspecifiedTypeConnectionRequest request) {
        if (request.isDirectionReversed()) {
            return new Command(){

                public boolean canExecute() {
                    return true;
                }
            };
        }
        ArrayList<Command> commands = new ArrayList<Command>();
        for (Request individualRequest : request.getAllRequests()) {
            Command cmd = null;
            if (individualRequest instanceof CreateConnectionViewAndElementRequest) {
                cmd = this.getConnectionAndRelationshipCreateCommand((CreateConnectionViewAndElementRequest)individualRequest);
            } else if (individualRequest instanceof CreateConnectionViewRequest) {
                cmd = this.getConnectionCreateCommand((CreateConnectionRequest)((CreateConnectionViewRequest)individualRequest));
            }
            if (cmd == null || !cmd.canExecute()) continue;
            commands.add(cmd);
        }
        if (commands.isEmpty()) {
            return null;
        }
        return new Command(){};
    }

    protected Command getReconnectSourceCommand(ReconnectRequest request) {
        Command command = super.getReconnectSourceCommand(request);
        if (command != null) {
            command = OccurrenceSpecificationMoveHelper.completeReconnectConnectionCommand(command, request, this.getConnectableEditPart());
            if (request.getConnectionEditPart() instanceof Message4EditPart && request.getTarget() instanceof LifelineEditPart) {
                LifelineEditPart newSource = (LifelineEditPart)request.getTarget();
                LifelineEditPart target = (LifelineEditPart)request.getConnectionEditPart().getTarget();
                command = LifelineMessageCreateHelper.moveLifelineDown(command, target, newSource.getFigure().getBounds().getLocation().getCopy());
            }
        }
        return command;
    }

    protected Command getReconnectTargetCommand(ReconnectRequest request) {
        Command command = super.getReconnectTargetCommand(request);
        if (command != null) {
            command = OccurrenceSpecificationMoveHelper.completeReconnectConnectionCommand(command, request, this.getConnectableEditPart());
            if (request.getConnectionEditPart() instanceof Message4EditPart && request.getTarget() instanceof LifelineEditPart) {
                command = LifelineMessageCreateHelper.reconnectMessageCreateTarget(request, command);
            }
        }
        return command;
    }

    public void showSourceFeedback(Request request) {
        if (request instanceof CreateUnspecifiedTypeRequest) {
            Object initLocation;
            Object hintedType = ((CreateUnspecifiedTypeRequest)request).getElementTypes().get(0);
            CreateRequest req = null;
            if (UMLElementTypes.DurationConstraint_3021.equals(hintedType)) {
                req = ((CreateUnspecifiedTypeRequest)request).getRequestForType(UMLElementTypes.DurationConstraint_3021);
            } else if (UMLElementTypes.DurationObservation_3024.equals(hintedType)) {
                req = ((CreateUnspecifiedTypeRequest)request).getRequestForType(UMLElementTypes.DurationObservation_3024);
            }
            if (req != null && (initLocation = req.getExtendedData().get("Nearest occurrence specification location")) instanceof Point) {
                Point startPoint = ((Point)initLocation).getCopy();
                Point targetPoint = ((CreateUnspecifiedTypeRequest)request).getLocation().getCopy();
                this.getFeedbackLayer().translateToRelative((Translatable)startPoint);
                this.getFeedbackLayer().translateToRelative((Translatable)targetPoint);
                if (this.durationCreationFeedback == null) {
                    this.durationCreationFeedback = new Polyline();
                    this.durationCreationFeedback.setLineWidth(1);
                    this.durationCreationFeedback.setLineStyle(4);
                    this.durationCreationFeedback.setForegroundColor(((IGraphicalEditPart)this.getHost()).getFigure().getLocalForegroundColor());
                    this.addFeedback((IFigure)this.durationCreationFeedback);
                }
                this.durationCreationFeedback.setStart(startPoint);
                this.durationCreationFeedback.setEnd(targetPoint);
                return;
            }
        }
        super.showSourceFeedback(request);
    }

    public void eraseSourceFeedback(Request request) {
        super.eraseSourceFeedback(request);
        if (this.durationCreationFeedback != null) {
            this.removeFeedback((IFigure)this.durationCreationFeedback);
        }
        this.durationCreationFeedback = null;
    }

    protected ConnectionRouter getDummyConnectionRouter(CreateConnectionRequest req) {
        return messageRouter;
    }
}

