/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.util;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.EditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.LabelEditPart;
import org.eclipse.gmf.runtime.notation.LayoutConstraint;
import org.eclipse.gmf.runtime.notation.Location;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.AbstractMessageEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.LifelineEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.locator.SelfMessageLabelLocator;

public class SelfMessageHelper {
    private static Location getLocation(LabelEditPart label) {
        LayoutConstraint layoutConstraint;
        if (label == null) {
            return null;
        }
        Object model = label.getModel();
        if (model instanceof Node && (layoutConstraint = ((Node)model).getLayoutConstraint()) instanceof Location) {
            return (Location)layoutConstraint;
        }
        return null;
    }

    public static void updateLabelLocation(LabelEditPart label) {
        if (label == null || !(label.getParent() instanceof AbstractMessageEditPart)) {
            return;
        }
        AbstractMessageEditPart message = (AbstractMessageEditPart)label.getParent();
        if (!SelfMessageHelper.isSelfLink(message)) {
            return;
        }
        Location location = SelfMessageHelper.getLocation(label);
        if (location == null) {
            return;
        }
        Point pt = new Point(location.getX(), location.getY());
        if (pt.x == 1 && pt.y == -13) {
            message.setLayoutConstraint((EditPart)label, label.getFigure(), (Object)new SelfMessageLabelLocator((IFigure)message.getConnectionFigure(), label.getKeyPoint()));
        }
    }

    public static boolean isSelfLink(AbstractMessageEditPart message) {
        if (message == null) {
            return false;
        }
        LifelineEditPart sourceLifeline = SelfMessageHelper.getLifeline(message.getSource());
        LifelineEditPart targetLifeline = SelfMessageHelper.getLifeline(message.getTarget());
        return sourceLifeline == null ? targetLifeline == null : sourceLifeline == targetLifeline;
    }

    private static LifelineEditPart getLifeline(EditPart editPart) {
        if (editPart == null) {
            return null;
        }
        if (editPart instanceof LifelineEditPart) {
            return (LifelineEditPart)editPart;
        }
        return SelfMessageHelper.getLifeline(editPart.getParent());
    }
}

