/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.AbstractPointListShape;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ConnectionEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ConnectionNodeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IBorderItemEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ShapeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ShapeNodeEditPart;
import org.eclipse.gmf.runtime.draw2d.ui.figures.BaseSlidableAnchor;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.notation.Anchor;
import org.eclipse.gmf.runtime.notation.Bounds;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.IdentityAnchor;
import org.eclipse.gmf.runtime.notation.LayoutConstraint;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.papyrus.uml.diagram.common.helper.DurationConstraintHelper;
import org.eclipse.papyrus.uml.diagram.common.helper.InteractionFragmentHelper;
import org.eclipse.papyrus.uml.diagram.common.util.DiagramEditPartsUtil;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.ActionExecutionSpecificationEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.BehaviorExecutionSpecificationEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.CombinedFragment2EditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.CombinedFragmentEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.ContinuationEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.DestructionOccurrenceSpecificationEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.DurationObservationEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.InteractionEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.InteractionOperandEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.InteractionUseEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.LifelineEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.Message2EditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.Message3EditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.Message4EditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.Message5EditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.Message6EditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.Message7EditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.MessageAsyncAppliedStereotypeEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.MessageCreateAppliedStereotypeEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.MessageDeleteAppliedStereotypeEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.MessageEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.MessageFoundAppliedStereotypeEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.MessageLostAppliedStereotypeEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.MessageName2EditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.MessageName3EditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.MessageName4EditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.MessageName5EditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.MessageName6EditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.MessageName7EditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.MessageNameEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.MessageReplyAppliedStereotypeEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.MessageSyncAppliedStereotypeEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.ObservationLinkEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.StateInvariantEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.TimeObservationLabelEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.policies.ObservationLinkPolicy;
import org.eclipse.papyrus.uml.diagram.sequence.util.CommandHelper;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.uml2.common.util.CacheAdapter;
import org.eclipse.uml2.uml.CombinedFragment;
import org.eclipse.uml2.uml.Continuation;
import org.eclipse.uml2.uml.DestructionOccurrenceSpecification;
import org.eclipse.uml2.uml.DurationConstraint;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.ExecutionOccurrenceSpecification;
import org.eclipse.uml2.uml.ExecutionSpecification;
import org.eclipse.uml2.uml.Interaction;
import org.eclipse.uml2.uml.InteractionFragment;
import org.eclipse.uml2.uml.InteractionOperand;
import org.eclipse.uml2.uml.InteractionOperatorKind;
import org.eclipse.uml2.uml.InteractionUse;
import org.eclipse.uml2.uml.Lifeline;
import org.eclipse.uml2.uml.Message;
import org.eclipse.uml2.uml.MessageEnd;
import org.eclipse.uml2.uml.MessageOccurrenceSpecification;
import org.eclipse.uml2.uml.MessageSort;
import org.eclipse.uml2.uml.OccurrenceSpecification;
import org.eclipse.uml2.uml.StateInvariant;
import org.eclipse.uml2.uml.TimeConstraint;
import org.eclipse.uml2.uml.TimeObservation;
import org.eclipse.uml2.uml.UMLPackage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SequenceUtil {
    private static final double MAXIMAL_DISTANCE_FROM_EVENT = 10.0;
    public static final String OBSERVATION_LINK_TYPE = "observation link";
    public static final String OBSERVATION_LINK_REQUEST_START = "observation connection start";
    public static final String OBSERVATION_LINK_REQUEST_END = "observation connection end";
    public static final String OBSERVATION_LINK_REQUEST_RECONNECT_SOURCE = "observation reconnect source";
    public static final String OBSERVATION_LINK_REQUEST_RECONNECT_TARGET = "observation reconnect target";
    public static final int LIFELINE_VERTICAL_OFFSET = 10;
    private static final String BLOCK_SORT_MODIFICATION_TITLE = "Forbidden action";
    private static final String BLOCK_SORT_MODIFICATION_MSG = "It's impossible to change the message sort.";

    public static InteractionFragment findInteractionFragmentContainerAt(Point location, EditPart hostEditPart) {
        Rectangle bounds = new Rectangle();
        bounds.setLocation(location);
        return SequenceUtil.findInteractionFragmentContainerAt(bounds, hostEditPart);
    }

    public static InteractionFragment findInteractionFragmentContainerAt(Rectangle bounds, EditPart hostEditPart) {
        if (hostEditPart == null) {
            return null;
        }
        InteractionFragment container = null;
        HashSet<InteractionFragment> coveredInteractions = new HashSet<InteractionFragment>();
        HashSet<CombinedFragment> coveredCF = new HashSet<CombinedFragment>();
        Set allEditPartEntries = hostEditPart.getViewer().getEditPartRegistry().entrySet();
        for (Map.Entry epEntry : allEditPartEntries) {
            Rectangle figureBounds;
            EditPart ep = (EditPart)epEntry.getValue();
            if (!(ep instanceof ShapeEditPart)) continue;
            ShapeEditPart sep = (ShapeEditPart)ep;
            EObject eObject = sep.resolveSemanticElement();
            if (eObject instanceof Interaction || eObject instanceof InteractionOperand) {
                figureBounds = SequenceUtil.getAbsoluteBounds((IGraphicalEditPart)sep);
                if (!figureBounds.contains(bounds)) continue;
                coveredInteractions.add((InteractionFragment)eObject);
                continue;
            }
            if (!(eObject instanceof CombinedFragment) || !(figureBounds = SequenceUtil.getAbsoluteBounds((IGraphicalEditPart)sep)).contains(bounds)) continue;
            coveredCF.add((CombinedFragment)eObject);
        }
        for (CombinedFragment cf : coveredCF) {
            EList operands = cf.getOperands();
            if (operands.size() <= 0 || !Collections.disjoint(operands, coveredInteractions)) continue;
            coveredInteractions.add((InteractionFragment)operands.get(0));
        }
        for (InteractionFragment ift : coveredInteractions) {
            boolean subiftFounded = false;
            if (ift instanceof Interaction) {
                for (InteractionFragment subift : ((Interaction)ift).getFragments()) {
                    if (!(subift instanceof CombinedFragment)) continue;
                    for (InteractionOperand io : ((CombinedFragment)subift).getOperands()) {
                        if (!coveredInteractions.contains(io)) continue;
                        subiftFounded = true;
                    }
                }
            }
            if (!subiftFounded && ift instanceof InteractionOperand) {
                for (InteractionFragment subift : ((InteractionOperand)ift).getFragments()) {
                    if (!(subift instanceof CombinedFragment)) continue;
                    for (InteractionOperand io : ((CombinedFragment)subift).getOperands()) {
                        if (!coveredInteractions.contains(io)) continue;
                        subiftFounded = true;
                    }
                }
            }
            if (subiftFounded) continue;
            container = ift;
            break;
        }
        return container;
    }

    public static Point findLocationOfEvent(LifelineEditPart lifelineEditPart, InteractionFragment fragment) {
        return SequenceUtil.findLocationOfEvent(lifelineEditPart, fragment, false);
    }

    public static Point findLocationOfEvent(LifelineEditPart lifelineEditPart, InteractionFragment fragment, boolean relyOnMessageFigure) {
        if (lifelineEditPart == null) {
            return null;
        }
        if (fragment instanceof CombinedFragment || fragment instanceof Continuation || fragment instanceof InteractionOperand || fragment instanceof InteractionUse || fragment instanceof Interaction) {
            List views = DiagramEditPartsUtil.findViews((EObject)fragment, (EditPartViewer)lifelineEditPart.getViewer());
            for (View view : views) {
                EditPart part = DiagramEditPartsUtil.getEditPartFromView((View)view, (EditPart)lifelineEditPart);
                boolean isCombinedFragment = part instanceof CombinedFragmentEditPart || part instanceof CombinedFragment2EditPart;
                boolean isContinuation = part instanceof ContinuationEditPart;
                boolean isInteractionOperand = part instanceof InteractionOperandEditPart;
                boolean isInteractionUse = part instanceof InteractionUseEditPart;
                boolean isInteraction = part instanceof InteractionEditPart;
                if (!isCombinedFragment && !isContinuation && !isInteractionOperand && !isInteractionUse && !isInteraction) continue;
                Rectangle bounds = SequenceUtil.getAbsoluteBounds((IGraphicalEditPart)((GraphicalEditPart)part));
                return bounds.getTop();
            }
        } else {
            Point loc;
            List children = lifelineEditPart.getChildren();
            for (Object child : children) {
                Point loc2;
                Rectangle bounds;
                EObject element;
                if (child instanceof DestructionOccurrenceSpecificationEditPart) {
                    DestructionOccurrenceSpecification destEvent;
                    EObject destructionOccurence = ((GraphicalEditPart)child).resolveSemanticElement();
                    EObject lifeline = lifelineEditPart.resolveSemanticElement();
                    if (destructionOccurence instanceof DestructionOccurrenceSpecification && lifeline instanceof Lifeline && fragment instanceof DestructionOccurrenceSpecification && (destEvent = (DestructionOccurrenceSpecification)fragment) != null && destEvent.equals(destructionOccurence)) {
                        Rectangle bounds2 = SequenceUtil.getAbsoluteBounds((IGraphicalEditPart)((GraphicalEditPart)child));
                        return bounds2.getCenter();
                    }
                }
                if (child instanceof ActionExecutionSpecificationEditPart || child instanceof BehaviorExecutionSpecificationEditPart) {
                    if (fragment instanceof ExecutionSpecification) {
                        element = ((GraphicalEditPart)child).resolveSemanticElement();
                        if (element instanceof ExecutionSpecification && fragment.equals(element)) {
                            bounds = SequenceUtil.getAbsoluteBounds((IGraphicalEditPart)((GraphicalEditPart)child));
                            return bounds.getTop();
                        }
                    } else if (fragment instanceof ExecutionOccurrenceSpecification) {
                        element = ((GraphicalEditPart)child).resolveSemanticElement();
                        if (element instanceof ExecutionSpecification) {
                            if (fragment.equals(((ExecutionSpecification)element).getStart())) {
                                bounds = SequenceUtil.getAbsoluteBounds((IGraphicalEditPart)((GraphicalEditPart)child));
                                return bounds.getTop();
                            }
                            if (fragment.equals(((ExecutionSpecification)element).getFinish())) {
                                bounds = SequenceUtil.getAbsoluteBounds((IGraphicalEditPart)((GraphicalEditPart)child));
                                return bounds.getBottom();
                            }
                        }
                    } else if (fragment instanceof MessageOccurrenceSpecification && (loc2 = SequenceUtil.findLocationOfMessageOccurrence((GraphicalEditPart)child, (MessageOccurrenceSpecification)fragment, relyOnMessageFigure)) != null) {
                        return loc2;
                    }
                }
                if (!(child instanceof StateInvariantEditPart)) continue;
                if (fragment instanceof StateInvariant) {
                    element = ((GraphicalEditPart)child).resolveSemanticElement();
                    if (!(element instanceof StateInvariant) || !fragment.equals(element)) continue;
                    bounds = SequenceUtil.getAbsoluteBounds((IGraphicalEditPart)((GraphicalEditPart)child));
                    return bounds.getTop();
                }
                if (!(fragment instanceof MessageOccurrenceSpecification) || (loc2 = SequenceUtil.findLocationOfMessageOccurrence((GraphicalEditPart)child, (MessageOccurrenceSpecification)fragment, relyOnMessageFigure)) == null) continue;
                return loc2;
            }
            if (fragment instanceof MessageOccurrenceSpecification && (loc = SequenceUtil.findLocationOfMessageOccurrence((GraphicalEditPart)lifelineEditPart, (MessageOccurrenceSpecification)fragment, relyOnMessageFigure)) != null) {
                return loc;
            }
        }
        if (fragment instanceof MessageOccurrenceSpecification) {
            boolean isSync;
            boolean bl = isSync = ((MessageOccurrenceSpecification)fragment).getMessage() != null && MessageSort.SYNCH_CALL_LITERAL.equals((Object)((MessageOccurrenceSpecification)fragment).getMessage().getMessageSort());
            if (isSync) {
                EObject container = fragment.eContainer();
                EObject lifeline = lifelineEditPart.resolveSemanticElement();
                InteractionFragment nextFragment = InteractionFragmentHelper.findNextFragment((InteractionFragment)fragment, (EObject)container);
                while (nextFragment != null && nextFragment.getCovereds().contains((Object)lifeline)) {
                    if (nextFragment.getCovereds().contains((Object)lifeline)) {
                        ExecutionSpecification exe;
                        if (!(nextFragment instanceof ExecutionOccurrenceSpecification) || (exe = ((ExecutionOccurrenceSpecification)nextFragment).getExecution()) == null || !EcoreUtil.equals((EObject)exe.getStart(), (EObject)nextFragment)) break;
                        return SequenceUtil.findLocationOfEvent(lifelineEditPart, nextFragment);
                    }
                    nextFragment = InteractionFragmentHelper.findNextFragment((InteractionFragment)nextFragment, (EObject)container);
                }
            }
        }
        return null;
    }

    public static Rectangle getAbsoluteBounds(IGraphicalEditPart part) {
        Node node;
        LayoutConstraint cst;
        Rectangle bounds = part.getFigure().getBounds().getCopy();
        if (part.getNotationView() instanceof Node && (cst = (node = (Node)part.getNotationView()).getLayoutConstraint()) instanceof Bounds) {
            Bounds b = (Bounds)cst;
            Point parentLoc = part.getFigure().getParent().getBounds().getLocation();
            if (b.getX() > 0) {
                bounds.x = b.getX() + parentLoc.x;
            }
            if (b.getY() > 0) {
                bounds.y = b.getY() + parentLoc.y;
            }
            if (b.getHeight() != -1) {
                bounds.height = b.getHeight();
            }
            if (b.getWidth() != -1) {
                bounds.width = b.getWidth();
            }
        }
        part.getFigure().getParent().translateToAbsolute((Translatable)bounds);
        return bounds;
    }

    public static Point getAbsoluteEdgeExtremity(ConnectionNodeEditPart connection, boolean isStart) {
        return SequenceUtil.getAbsoluteEdgeExtremity(connection, isStart, false);
    }

    static Point getAbsoluteEdgeExtremity(ConnectionNodeEditPart connection, boolean isStart, boolean relyOnMessageFigure) {
        Connection msgFigure = connection.getConnectionFigure();
        if (connection.getNotationView() instanceof Edge && !relyOnMessageFigure) {
            View linkedFigure;
            Edge edge = (Edge)connection.getNotationView();
            Anchor idAnchor = null;
            ConnectionAnchor conAnchor = null;
            Object part = null;
            if (isStart && connection.getSource() instanceof IGraphicalEditPart) {
                linkedFigure = edge.getSource();
                part = connection.getSource().getViewer().getEditPartRegistry().get(linkedFigure);
                idAnchor = edge.getSourceAnchor();
                conAnchor = msgFigure.getSourceAnchor();
            } else if (!isStart && connection.getTarget() instanceof IGraphicalEditPart) {
                linkedFigure = edge.getTarget();
                part = connection.getTarget().getViewer().getEditPartRegistry().get(linkedFigure);
                idAnchor = edge.getTargetAnchor();
                conAnchor = msgFigure.getTargetAnchor();
            }
            if (part instanceof IGraphicalEditPart && idAnchor instanceof IdentityAnchor && conAnchor != null) {
                Rectangle linkedPartBounds = SequenceUtil.getAbsoluteBounds(part);
                IFigure anchorOwningFigure = conAnchor.getOwner();
                IFigure partFigure = ((IGraphicalEditPart)part).getFigure();
                Dimension delta = anchorOwningFigure.getBounds().getLocation().getDifference(partFigure.getBounds().getLocation());
                String oldTerminal = ((IdentityAnchor)idAnchor).getId();
                PrecisionPoint pp = BaseSlidableAnchor.parseTerminalString((String)oldTerminal);
                int xPos = linkedPartBounds.x + delta.width + (int)Math.round((double)anchorOwningFigure.getBounds().width * pp.preciseX);
                int yPos = linkedPartBounds.y + delta.height + (int)Math.round((double)anchorOwningFigure.getBounds().height * pp.preciseY);
                return new Point(xPos, yPos);
            }
        }
        if (msgFigure instanceof AbstractPointListShape) {
            Point extremity = isStart ? ((AbstractPointListShape)msgFigure).getStart().getCopy() : ((AbstractPointListShape)msgFigure).getEnd().getCopy();
            msgFigure.getParent().translateToAbsolute((Translatable)extremity);
            return extremity;
        }
        return null;
    }

    public static Point findLocationOfMessageOccurrence(GraphicalEditPart nodeEditPart, MessageOccurrenceSpecification event) {
        return SequenceUtil.findLocationOfMessageOccurrence(nodeEditPart, event, false);
    }

    static Point findLocationOfMessageOccurrence(GraphicalEditPart nodeEditPart, MessageOccurrenceSpecification event, boolean relyOnMessageFigure) {
        List targetConnections = nodeEditPart.getTargetConnections();
        for (Object conn : targetConnections) {
            IFigure figure;
            EObject element;
            if (!(conn instanceof ConnectionNodeEditPart) || !((element = ((ConnectionNodeEditPart)conn).resolveSemanticElement()) instanceof Message) || !event.equals(((Message)element).getReceiveEvent()) || !((figure = ((ConnectionNodeEditPart)conn).getFigure()) instanceof AbstractPointListShape)) continue;
            return SequenceUtil.getAbsoluteEdgeExtremity((ConnectionNodeEditPart)conn, false, relyOnMessageFigure);
        }
        List sourceConnections = nodeEditPart.getSourceConnections();
        for (Object conn : sourceConnections) {
            IFigure figure;
            EObject element;
            if (!(conn instanceof ConnectionNodeEditPart) || !((element = ((ConnectionNodeEditPart)conn).resolveSemanticElement()) instanceof Message) || !event.equals(((Message)element).getSendEvent()) || !((figure = ((ConnectionNodeEditPart)conn).getFigure()) instanceof AbstractPointListShape)) continue;
            return SequenceUtil.getAbsoluteEdgeExtremity((ConnectionNodeEditPart)conn, true, relyOnMessageFigure);
        }
        return null;
    }

    public static Point findLocationOfExecutionOccurrence(GraphicalEditPart nodeEditPart, ExecutionOccurrenceSpecification event) {
        List children = nodeEditPart.getChildren();
        for (Object child : children) {
            Rectangle copy;
            IFigure figure;
            EObject element;
            if (child instanceof ActionExecutionSpecificationEditPart) {
                element = ((ActionExecutionSpecificationEditPart)((Object)child)).resolveSemanticElement();
                if (element == null || !(element instanceof ExecutionSpecification)) continue;
                figure = ((ActionExecutionSpecificationEditPart)((Object)child)).getFigure();
                copy = figure.getBounds().getCopy();
                figure.translateToAbsolute((Translatable)copy);
                if (event.equals(((ExecutionSpecification)element).getStart())) {
                    return copy.getTop();
                }
                if (!event.equals(((ExecutionSpecification)element).getFinish())) continue;
                return copy.getBottom();
            }
            if (!(child instanceof BehaviorExecutionSpecificationEditPart) || (element = ((BehaviorExecutionSpecificationEditPart)((Object)child)).resolveSemanticElement()) == null || !(element instanceof ExecutionSpecification)) continue;
            figure = ((BehaviorExecutionSpecificationEditPart)((Object)child)).getFigure();
            copy = figure.getBounds().getCopy();
            figure.translateToAbsolute((Translatable)copy);
            if (event.equals(((ExecutionSpecification)element).getStart())) {
                return copy.getTop();
            }
            if (!event.equals(((ExecutionSpecification)element).getFinish())) continue;
            return copy.getBottom();
        }
        return null;
    }

    public static Map.Entry<Point, List<OccurrenceSpecification>> findNearestEvent(Point location, LifelineEditPart lifelineEditPart) {
        if (lifelineEditPart == null) {
            return null;
        }
        HashMap<Point, List<OccurrenceSpecification>> occurrences = new HashMap<Point, List<OccurrenceSpecification>>();
        List children = lifelineEditPart.getChildren();
        block0: for (Object child : children) {
            EObject element;
            if ((child instanceof ActionExecutionSpecificationEditPart || child instanceof BehaviorExecutionSpecificationEditPart) && (element = ((GraphicalEditPart)child).resolveSemanticElement()) instanceof ExecutionSpecification) {
                Rectangle bounds = SequenceUtil.getAbsoluteBounds((IGraphicalEditPart)((GraphicalEditPart)child));
                if (!occurrences.containsKey(bounds.getTop())) {
                    occurrences.put(bounds.getTop(), new ArrayList(2));
                }
                ((List)occurrences.get(bounds.getTop())).add(((ExecutionSpecification)element).getStart());
                if (!occurrences.containsKey(bounds.getBottom())) {
                    occurrences.put(bounds.getBottom(), new ArrayList(1));
                }
                ((List)occurrences.get(bounds.getBottom())).add(((ExecutionSpecification)element).getFinish());
                SequenceUtil.completeOccurrencesMapWithMessages((GraphicalEditPart)child, occurrences);
            }
            if (!(child instanceof DestructionOccurrenceSpecificationEditPart)) continue;
            EObject destructionOccurence = ((GraphicalEditPart)child).resolveSemanticElement();
            EObject lifeline = lifelineEditPart.resolveSemanticElement();
            if (!(destructionOccurence instanceof DestructionOccurrenceSpecification) || !(lifeline instanceof Lifeline)) continue;
            for (InteractionFragment occurence : ((Lifeline)lifeline).getCoveredBys()) {
                DestructionOccurrenceSpecification currentOccurence;
                if (!(occurence instanceof DestructionOccurrenceSpecification) || !destructionOccurence.equals(currentOccurence = (DestructionOccurrenceSpecification)occurence)) continue;
                Rectangle bounds = SequenceUtil.getAbsoluteBounds((IGraphicalEditPart)((GraphicalEditPart)child));
                if (!occurrences.containsKey(bounds.getCenter())) {
                    occurrences.put(bounds.getCenter(), new ArrayList(2));
                }
                ((List)occurrences.get(bounds.getCenter())).add((OccurrenceSpecification)occurence);
                continue block0;
            }
        }
        SequenceUtil.completeOccurrencesMapWithMessages((GraphicalEditPart)lifelineEditPart, occurrences);
        double smallerDistance = 10.0;
        Map.Entry nearestObject = null;
        for (Map.Entry entry : occurrences.entrySet()) {
            double distance = location.getDistance((Point)entry.getKey());
            if (distance < smallerDistance) {
                smallerDistance = distance;
                nearestObject = entry;
                continue;
            }
            if (distance != smallerDistance || nearestObject == null || !(entry.getValue() instanceof MessageOccurrenceSpecification)) continue;
            ((List)nearestObject.getValue()).addAll((Collection)entry.getValue());
        }
        return nearestObject;
    }

    private static void completeOccurrencesMapWithMessages(GraphicalEditPart nodeEditPart, Map<Point, List<OccurrenceSpecification>> occurrencesMap) {
        List targetConnections = nodeEditPart.getTargetConnections();
        for (Object conn : targetConnections) {
            IFigure figure;
            EObject element;
            if (!(conn instanceof ConnectionNodeEditPart) || !((element = ((ConnectionNodeEditPart)conn).resolveSemanticElement()) instanceof Message) || !(((Message)element).getReceiveEvent() instanceof MessageOccurrenceSpecification) || !((figure = ((ConnectionNodeEditPart)conn).getFigure()) instanceof AbstractPointListShape)) continue;
            Point end = SequenceUtil.getAbsoluteEdgeExtremity((ConnectionNodeEditPart)conn, false);
            if (!occurrencesMap.containsKey(end)) {
                occurrencesMap.put(end, new ArrayList(1));
            }
            occurrencesMap.get(end).add((OccurrenceSpecification)((MessageOccurrenceSpecification)((Message)element).getReceiveEvent()));
        }
        List sourceConnections = nodeEditPart.getSourceConnections();
        for (Object conn : sourceConnections) {
            IFigure figure;
            EObject element;
            if (!(conn instanceof ConnectionNodeEditPart) || !((element = ((ConnectionNodeEditPart)conn).resolveSemanticElement()) instanceof Message) || !(((Message)element).getSendEvent() instanceof MessageOccurrenceSpecification) || !((figure = ((ConnectionNodeEditPart)conn).getFigure()) instanceof AbstractPointListShape)) continue;
            Point start = SequenceUtil.getAbsoluteEdgeExtremity((ConnectionNodeEditPart)conn, true);
            if (!occurrencesMap.containsKey(start)) {
                occurrencesMap.put(start, new ArrayList(1));
            }
            occurrencesMap.get(start).add((OccurrenceSpecification)((MessageOccurrenceSpecification)((Message)element).getSendEvent()));
        }
    }

    public static int positionWhereEventIsLinkedToPart(OccurrenceSpecification occSpec, IBorderItemEditPart timeElementPart) {
        EObject timeElement = timeElementPart.resolveSemanticElement();
        if (timeElement instanceof TimeObservation) {
            if (occSpec.equals(((TimeObservation)timeElement).getEvent())) {
                return 2;
            }
            return 0;
        }
        if (timeElement instanceof TimeConstraint) {
            if (((TimeConstraint)timeElement).getConstrainedElements().contains((Object)occSpec)) {
                return 2;
            }
            return 0;
        }
        if (timeElement instanceof DurationConstraint) {
            if (((DurationConstraint)timeElement).getConstrainedElements().contains((Object)occSpec)) {
                EList events = ((DurationConstraint)timeElement).getConstrainedElements();
                LifelineEditPart lifelinePart = SequenceUtil.getParentLifelinePart((EditPart)timeElementPart);
                if (lifelinePart != null && events.size() >= 2) {
                    OccurrenceSpecification otherEvent = null;
                    if (!occSpec.equals(events.get(0)) && events.get(0) instanceof OccurrenceSpecification) {
                        otherEvent = (OccurrenceSpecification)events.get(0);
                    } else if (!occSpec.equals(events.get(1)) && events.get(1) instanceof OccurrenceSpecification) {
                        otherEvent = (OccurrenceSpecification)events.get(1);
                    }
                    if (otherEvent != null) {
                        Point otherLoc = SequenceUtil.findLocationOfEvent(lifelinePart, (InteractionFragment)otherEvent);
                        Point thisLoc = SequenceUtil.findLocationOfEvent(lifelinePart, (InteractionFragment)occSpec);
                        if (otherLoc != null && thisLoc != null) {
                            if (otherLoc.y > thisLoc.y) {
                                return 8;
                            }
                            return 32;
                        }
                    }
                }
            } else {
                return 0;
            }
        }
        return 0;
    }

    public static LifelineEditPart getParentLifelinePart(EditPart nodeEditPart) {
        EditPart parent = nodeEditPart;
        while (parent != null) {
            if (parent instanceof LifelineEditPart) {
                return (LifelineEditPart)parent;
            }
            parent = parent.getParent();
        }
        return null;
    }

    public static EditPart getLinkedEditPart(EditPart lifelinePart, OccurrenceSpecification event) {
        if (event instanceof MessageOccurrenceSpecification) {
            Message message = ((MessageOccurrenceSpecification)event).getMessage();
            if (message == null) {
                return null;
            }
            Collection settings = CacheAdapter.INSTANCE.getNonNavigableInverseReferences((EObject)message);
            for (EStructuralFeature.Setting ref : settings) {
                View view;
                EditPart part;
                if (!NotationPackage.eINSTANCE.getView_Element().equals(ref.getEStructuralFeature()) || !((part = DiagramEditPartsUtil.getEditPartFromView((View)(view = (View)ref.getEObject()), (EditPart)lifelinePart)) instanceof ConnectionEditPart)) continue;
                EditPart lifelineChild = null;
                if (event.equals(message.getSendEvent())) {
                    lifelineChild = ((ConnectionEditPart)part).getSource();
                } else if (event.equals(message.getReceiveEvent())) {
                    lifelineChild = ((ConnectionEditPart)part).getTarget();
                }
                LifelineEditPart parentLifeline = SequenceUtil.getParentLifelinePart(lifelineChild);
                if (!lifelinePart.equals((Object)parentLifeline)) continue;
                return part;
            }
        } else if (event instanceof ExecutionOccurrenceSpecification) {
            ExecutionSpecification execution = ((ExecutionOccurrenceSpecification)event).getExecution();
            if (execution == null) {
                return null;
            }
            Collection settings = CacheAdapter.INSTANCE.getNonNavigableInverseReferences((EObject)execution);
            for (EStructuralFeature.Setting ref : settings) {
                View view;
                EditPart part;
                EditPart lifelineChild;
                LifelineEditPart parentLifeline;
                if (!NotationPackage.eINSTANCE.getView_Element().equals(ref.getEStructuralFeature()) || !lifelinePart.equals((Object)(parentLifeline = SequenceUtil.getParentLifelinePart(lifelineChild = (part = DiagramEditPartsUtil.getEditPartFromView((View)(view = (View)ref.getEObject()), (EditPart)lifelinePart)))))) continue;
                return part;
            }
        } else {
            for (Object lifelineChild : lifelinePart.getChildren()) {
                EObject destr;
                if (!(lifelineChild instanceof DestructionOccurrenceSpecificationEditPart) || !((destr = ((DestructionOccurrenceSpecificationEditPart)((Object)lifelineChild)).resolveSemanticElement()) instanceof DestructionOccurrenceSpecification) || !destr.equals(event)) continue;
                return (EditPart)lifelineChild;
            }
        }
        return null;
    }

    public static List<OccurrenceSpecification> getAsOccSpecList(Object occurrenceSpecificationList) {
        List list;
        if (occurrenceSpecificationList instanceof List && !(list = (List)occurrenceSpecificationList).isEmpty()) {
            ArrayList<OccurrenceSpecification> newList = new ArrayList<OccurrenceSpecification>(list.size());
            for (Object elt : list) {
                if (!(elt instanceof OccurrenceSpecification)) continue;
                newList.add((OccurrenceSpecification)elt);
            }
            return newList;
        }
        return Collections.emptyList();
    }

    public static OccurrenceSpecification[] getPairOfCorrespondingOccSpec(List<OccurrenceSpecification> occ1List, List<OccurrenceSpecification> occ2List) {
        for (OccurrenceSpecification occ1 : occ1List) {
            for (OccurrenceSpecification occ2 : occ2List) {
                if (!DurationConstraintHelper.endsOfSameMessage((OccurrenceSpecification)occ1, (OccurrenceSpecification)occ2)) continue;
                return new OccurrenceSpecification[]{occ1, occ2};
            }
        }
        for (OccurrenceSpecification occ1 : occ1List) {
            Message mess;
            if (occ1 instanceof MessageOccurrenceSpecification && (mess = ((MessageOccurrenceSpecification)occ1).getMessage()).getReceiveEvent().equals(occ1) && MessageSort.SYNCH_CALL_LITERAL.equals((Object)mess.getMessageSort())) continue;
            for (OccurrenceSpecification occ2 : occ2List) {
                Message mess2;
                if (occ2 instanceof MessageOccurrenceSpecification && (mess2 = ((MessageOccurrenceSpecification)occ2).getMessage()).getReceiveEvent().equals(occ2) && MessageSort.SYNCH_CALL_LITERAL.equals((Object)mess2.getMessageSort()) || !DurationConstraintHelper.coversSameLifeline((OccurrenceSpecification)occ1, (OccurrenceSpecification)occ2)) continue;
                return new OccurrenceSpecification[]{occ1, occ2};
            }
        }
        return null;
    }

    public static List<Element> getCombinedFragmentAssociatedElement(CombinedFragment cf) {
        LinkedList<Element> elements = new LinkedList<Element>();
        for (InteractionOperand operand : cf.getOperands()) {
            elements.addAll(SequenceUtil.getInteractionOperandAssociatedElement(operand));
            elements.add((Element)operand);
        }
        return elements;
    }

    public static List<Element> getInteractionOperandAssociatedElement(InteractionOperand interactionOperand) {
        LinkedList<Element> elements = new LinkedList<Element>();
        for (InteractionFragment itf : interactionOperand.getFragments()) {
            MessageOccurrenceSpecification mos;
            if (itf instanceof CombinedFragment) {
                elements.addAll(SequenceUtil.getCombinedFragmentAssociatedElement((CombinedFragment)itf));
            }
            elements.add((Element)itf);
            if (!(itf instanceof MessageOccurrenceSpecification) || (mos = (MessageOccurrenceSpecification)itf).getMessage() == null) continue;
            elements.add((Element)mos.getMessage());
        }
        return elements;
    }

    public static void handleMessageSortChange(EditingDomain editingDomain, Notification notification, Message message, MessageSort expectedMessageSort) {
        Object feature = notification.getFeature();
        if (UMLPackage.eINSTANCE.getMessage_MessageSort().equals(feature) && !expectedMessageSort.equals(notification.getNewValue())) {
            Object oldValue = notification.getOldValue();
            Object newValue = notification.getNewValue();
            if (!(!(oldValue instanceof MessageSort) || oldValue == MessageSort.ASYNCH_CALL_LITERAL && newValue == MessageSort.ASYNCH_SIGNAL_LITERAL || oldValue == MessageSort.ASYNCH_SIGNAL_LITERAL && newValue == MessageSort.ASYNCH_CALL_LITERAL)) {
                MessageDialog.openWarning((Shell)Display.getCurrent().getActiveShell(), (String)BLOCK_SORT_MODIFICATION_TITLE, (String)BLOCK_SORT_MODIFICATION_MSG);
                CommandHelper.executeCommandWithoutHistory(editingDomain, SetCommand.create((EditingDomain)editingDomain, (Object)message, (Object)feature, (Object)notification.getOldValue()), true);
                return;
            }
        }
    }

    public static Set<Lifeline> getCoveredLifelines(Rectangle selectionRect, EditPart hostEditPart) {
        HashSet<Lifeline> coveredLifelines = new HashSet<Lifeline>();
        Set allEditPartEntries = hostEditPart.getViewer().getEditPartRegistry().entrySet();
        for (Map.Entry epEntry : allEditPartEntries) {
            Rectangle figureBounds;
            ShapeEditPart sep;
            EObject elem;
            EditPart ep = (EditPart)epEntry.getValue();
            if (!(ep instanceof ShapeEditPart) || !((elem = (sep = (ShapeEditPart)ep).getNotationView().getElement()) instanceof Lifeline) || !selectionRect.intersects(figureBounds = SequenceUtil.getAbsoluteBounds((IGraphicalEditPart)sep))) continue;
            coveredLifelines.add((Lifeline)elem);
        }
        return coveredLifelines;
    }

    public static Set<InteractionFragment> getCoveredInteractionFragments(Rectangle selectionRect, EditPart hostEditPart, Set<InteractionFragment> ignoreSet) {
        HashSet<InteractionFragment> coveredInteractionFragments = new HashSet<InteractionFragment>();
        if (ignoreSet == null) {
            ignoreSet = new HashSet<InteractionFragment>();
        }
        Set allEditPartEntries = hostEditPart.getViewer().getEditPartRegistry().entrySet();
        for (Map.Entry epEntry : allEditPartEntries) {
            MessageEnd msgReceiveEnd;
            MessageEnd msgSendEnd;
            ConnectionEditPart cep;
            EObject elem;
            EditPart ep = (EditPart)epEntry.getValue();
            if (ep instanceof ShapeEditPart) {
                ShapeEditPart sep = (ShapeEditPart)ep;
                elem = sep.getNotationView().getElement();
                if (!(elem instanceof InteractionFragment) || ignoreSet.contains(elem)) continue;
                Rectangle figureBounds = SequenceUtil.getAbsoluteBounds((IGraphicalEditPart)sep);
                if (selectionRect.contains(figureBounds)) {
                    coveredInteractionFragments.add((InteractionFragment)elem);
                    if (!(elem instanceof ExecutionSpecification)) continue;
                    ExecutionSpecification es = (ExecutionSpecification)elem;
                    coveredInteractionFragments.add((InteractionFragment)es.getStart());
                    coveredInteractionFragments.add((InteractionFragment)es.getFinish());
                    continue;
                }
                Rectangle intersection = selectionRect.getIntersection(figureBounds);
                if (intersection.equals((Object)new Rectangle()) || intersection.equals((Object)selectionRect)) continue;
                return null;
            }
            if (!(ep instanceof ConnectionEditPart) || !((elem = (cep = (ConnectionEditPart)ep).getNotationView().getElement()) instanceof Message)) continue;
            Message msg = (Message)elem;
            Connection msgFigure = cep.getConnectionFigure();
            Point sourcePoint = msgFigure.getSourceAnchor().getReferencePoint();
            Point targetPoint = msgFigure.getTargetAnchor().getReferencePoint();
            if (selectionRect.contains(sourcePoint) && (msgSendEnd = msg.getSendEvent()) instanceof InteractionFragment) {
                coveredInteractionFragments.add((InteractionFragment)msgSendEnd);
            }
            if (!selectionRect.contains(targetPoint) || !((msgReceiveEnd = msg.getReceiveEvent()) instanceof InteractionFragment)) continue;
            coveredInteractionFragments.add((InteractionFragment)msgReceiveEnd);
        }
        return coveredInteractionFragments;
    }

    public static ICommand getSetEnclosingInteractionCommand(TransactionalEditingDomain ed, final InteractionFragment ift, final EObject interaction) {
        return new AbstractTransactionalCommand(ed, "Set enclosing interaction command", null){

            protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                SequenceUtil.setEnclosingInteraction(ift, interaction, false);
                return CommandResult.newOKCommandResult();
            }
        };
    }

    public static void setEnclosingInteraction(InteractionFragment ift, EObject interaction, boolean forceIfCoregion) {
        if (ift != null) {
            if (interaction instanceof Interaction) {
                if (!interaction.equals(ift.getEnclosingInteraction())) {
                    Element cf;
                    InteractionOperand operand;
                    if (!forceIfCoregion && ift instanceof MessageOccurrenceSpecification && (operand = ift.getEnclosingOperand()) != null && (cf = operand.getOwner()) instanceof CombinedFragment && InteractionOperatorKind.PAR_LITERAL.equals((Object)((CombinedFragment)cf).getInteractionOperator())) {
                        Message mess = ((MessageOccurrenceSpecification)ift).getMessage();
                        MessageOccurrenceSpecification otherMos = null;
                        if (ift.equals(mess.getSendEvent()) && mess.getReceiveEvent() instanceof MessageOccurrenceSpecification) {
                            otherMos = (MessageOccurrenceSpecification)mess.getReceiveEvent();
                        } else if (ift.equals(mess.getReceiveEvent()) && mess.getSendEvent() instanceof MessageOccurrenceSpecification) {
                            otherMos = (MessageOccurrenceSpecification)mess.getSendEvent();
                        }
                        if (otherMos != null && operand.equals(otherMos.getEnclosingOperand())) {
                            return;
                        }
                    }
                    ift.setEnclosingOperand(null);
                    ift.setEnclosingInteraction((Interaction)interaction);
                }
            } else if (interaction instanceof InteractionOperand && !interaction.equals(ift.getEnclosingOperand())) {
                ift.setEnclosingInteraction(null);
                ift.setEnclosingOperand((InteractionOperand)interaction);
            }
        }
    }

    public static ICommand getAddCoveredLifelineCommand(TransactionalEditingDomain ed, final InteractionFragment ift, final Lifeline lifeline) {
        return new AbstractTransactionalCommand(ed, "Add covered lifeline command", null){

            protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                ift.getCovereds().add((Object)lifeline);
                return CommandResult.newOKCommandResult();
            }
        };
    }

    public static ICommand getRemoveCoveredLifelineCommand(TransactionalEditingDomain ed, final InteractionFragment ift, final Lifeline lifeline) {
        return new AbstractTransactionalCommand(ed, "Add covered lifeline command", null){

            protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                ift.getCovereds().remove((Object)lifeline);
                return CommandResult.newOKCommandResult();
            }
        };
    }

    public static Command createUpdateEnclosingInteractionCommand(MessageOccurrenceSpecification movedMos, Point newLocation, GraphicalEditPart editPart) {
        HashMap<MessageOccurrenceSpecification, Rectangle> iftToCheckForUpdate = new HashMap<MessageOccurrenceSpecification, Rectangle>();
        iftToCheckForUpdate.put(movedMos, new Rectangle(newLocation, new Dimension()));
        CompoundCommand cmd = new CompoundCommand();
        for (Map.Entry entry : iftToCheckForUpdate.entrySet()) {
            InteractionFragment newEnclosingInteraction = SequenceUtil.findInteractionFragmentContainerAt((Rectangle)entry.getValue(), (EditPart)editPart);
            if (newEnclosingInteraction == null) continue;
            cmd.add((Command)new ICommandProxy(SequenceUtil.getSetEnclosingInteractionCommand(editPart.getEditingDomain(), (InteractionFragment)entry.getKey(), (EObject)newEnclosingInteraction)));
        }
        if (!cmd.isEmpty()) {
            return cmd;
        }
        return null;
    }

    public static Command createUpdateEnclosingInteractionCommand(ShapeNodeEditPart executionSpecificationEP, Point moveDelta, Dimension sizeDelta) {
        Rectangle absoluteNewBounds = executionSpecificationEP.getFigure().getBounds().getCopy();
        executionSpecificationEP.getFigure().getParent().translateToAbsolute((Translatable)absoluteNewBounds);
        absoluteNewBounds.translate(moveDelta);
        absoluteNewBounds.resize(sizeDelta);
        int xCenter = absoluteNewBounds.getCenter().x;
        Rectangle top = new Rectangle(xCenter, absoluteNewBounds.y, 0, 0);
        Rectangle bottom = new Rectangle(xCenter, absoluteNewBounds.bottom(), 0, 0);
        HashMap<Object, Rectangle> iftToCheckForUpdate = new HashMap<Object, Rectangle>();
        ExecutionSpecification es = (ExecutionSpecification)executionSpecificationEP.resolveSemanticElement();
        iftToCheckForUpdate.put(es, absoluteNewBounds);
        iftToCheckForUpdate.put(es.getStart(), top);
        iftToCheckForUpdate.put(es.getFinish(), bottom);
        List sourceConnectionEPs = executionSpecificationEP.getSourceConnections();
        for (ConnectionEditPart sourceConnectionEP : sourceConnectionEPs) {
            Message msg;
            MessageEnd sendEvent;
            EObject elem = sourceConnectionEP.getNotationView().getElement();
            if (!(elem instanceof Message) || !((sendEvent = (msg = (Message)elem).getSendEvent()) instanceof InteractionFragment)) continue;
            Connection msgFigure = sourceConnectionEP.getConnectionFigure();
            Point sourcePoint = msgFigure.getSourceAnchor().getLocation(msgFigure.getTargetAnchor().getReferencePoint());
            iftToCheckForUpdate.put((InteractionFragment)sendEvent, new Rectangle(sourcePoint.x + moveDelta.x, sourcePoint.y + moveDelta.y, 0, 0));
        }
        List targetConnectionEPs = executionSpecificationEP.getTargetConnections();
        for (ConnectionEditPart targetConnectionEP : targetConnectionEPs) {
            Message msg;
            MessageEnd receiveEvent;
            EObject elem = targetConnectionEP.getNotationView().getElement();
            if (!(elem instanceof Message) || !((receiveEvent = (msg = (Message)elem).getReceiveEvent()) instanceof InteractionFragment)) continue;
            Connection msgFigure = targetConnectionEP.getConnectionFigure();
            Point targetPoint = msgFigure.getTargetAnchor().getLocation(msgFigure.getSourceAnchor().getReferencePoint());
            iftToCheckForUpdate.put((InteractionFragment)receiveEvent, new Rectangle(targetPoint.x + moveDelta.x, targetPoint.y + moveDelta.y, 0, 0));
        }
        CompoundCommand cmd = new CompoundCommand();
        for (Map.Entry entry : iftToCheckForUpdate.entrySet()) {
            InteractionFragment newEnclosingInteraction = SequenceUtil.findInteractionFragmentContainerAt((Rectangle)entry.getValue(), (EditPart)executionSpecificationEP);
            if (newEnclosingInteraction == null) continue;
            cmd.add((Command)new ICommandProxy(SequenceUtil.getSetEnclosingInteractionCommand(executionSpecificationEP.getEditingDomain(), (InteractionFragment)entry.getKey(), (EObject)newEnclosingInteraction)));
        }
        if (!cmd.isEmpty()) {
            return cmd;
        }
        return null;
    }

    public static GraphicalEditPart findPartToReconnectTo(LifelineEditPart lifelinePart, Point referencePoint) {
        Rectangle absoluteLifelineBounds = SequenceUtil.getAbsoluteBounds((IGraphicalEditPart)lifelinePart);
        List children = lifelinePart.getChildren();
        GraphicalEditPart adequateExecutionPart = null;
        int maxDeltaWithMiddle = 0;
        for (Object child : children) {
            int deltaWithMiddle;
            if (!(child instanceof ActionExecutionSpecificationEditPart) && !(child instanceof BehaviorExecutionSpecificationEditPart) && !(child instanceof CombinedFragment2EditPart)) continue;
            GraphicalEditPart childPart = (GraphicalEditPart)child;
            Rectangle absoluteBounds = SequenceUtil.getAbsoluteBounds((IGraphicalEditPart)childPart);
            absoluteBounds.expand(1, 1);
            if (!absoluteBounds.contains(referencePoint) || (deltaWithMiddle = Math.abs(absoluteBounds.getTop().x - absoluteLifelineBounds.getTop().x)) < maxDeltaWithMiddle) continue;
            maxDeltaWithMiddle = deltaWithMiddle;
            adequateExecutionPart = childPart;
        }
        if (adequateExecutionPart != null) {
            return adequateExecutionPart;
        }
        return lifelinePart;
    }

    public static Rectangle findPossibleLocationsForEvent(LifelineEditPart lifelineEditPart, OccurrenceSpecification occSpec) {
        Rectangle result = lifelineEditPart.getContentPane().getBounds().getCopy();
        lifelineEditPart.getFigure().translateToAbsolute((Translatable)result);
        IGraphicalEditPart containerPart = SequenceUtil.findDrawnContainerEditPart(lifelineEditPart, occSpec);
        IFigure drawnContentPane = SequenceUtil.getContentPaneThatCanContainFragments((EditPart)containerPart);
        if (drawnContentPane != null) {
            Rectangle bounds = drawnContentPane.getBounds().getCopy();
            drawnContentPane.getParent().translateToAbsolute((Translatable)bounds);
            result.intersect(bounds);
        }
        EObject uppestContainerToSearchInto = containerPart.resolveSemanticElement();
        InteractionFragment after = InteractionFragmentHelper.findNextFragment((InteractionFragment)occSpec, (EObject)uppestContainerToSearchInto);
        boolean foundNextFragment = false;
        while (!foundNextFragment && after != null) {
            Point bottom = SequenceUtil.findLocationOfEvent(lifelineEditPart, after);
            if (bottom != null && result.contains(bottom)) {
                int diff = bottom.y - result.bottom();
                result.resize(0, diff);
                foundNextFragment = true;
                continue;
            }
            after = InteractionFragmentHelper.findNextFragment((InteractionFragment)after, (EObject)uppestContainerToSearchInto);
        }
        InteractionFragment before = InteractionFragmentHelper.findPreviousFragment((InteractionFragment)occSpec, (EObject)uppestContainerToSearchInto);
        boolean foundPreviousFragment = false;
        while (!foundPreviousFragment && before != null) {
            Point top = SequenceUtil.findLocationOfEvent(lifelineEditPart, before);
            if (top != null && result.contains(top)) {
                int diff = top.y - result.y;
                result.translate(0, diff);
                result.resize(0, -diff);
                foundPreviousFragment = true;
                SequenceUtil.reduceByNodeContainingBefore(result, before, occSpec, lifelineEditPart);
                continue;
            }
            before = InteractionFragmentHelper.findPreviousFragment((InteractionFragment)before, (EObject)uppestContainerToSearchInto);
        }
        return result;
    }

    private static void reduceByNodeContainingBefore(Rectangle possibleBounds, InteractionFragment before, OccurrenceSpecification occSpec, LifelineEditPart lifelineEditPart) {
        InteractionFragment eventualNodeElement = before;
        while (!EcoreUtil.isAncestor((EObject)eventualNodeElement, (EObject)occSpec)) {
            List views = DiagramEditPartsUtil.findViews((EObject)eventualNodeElement, (EditPartViewer)lifelineEditPart.getViewer());
            for (View view : views) {
                Rectangle bounds;
                int newPossibleTop;
                EditPart part = DiagramEditPartsUtil.getEditPartFromView((View)view, (EditPart)lifelineEditPart);
                if (!(part instanceof IGraphicalEditPart) || SequenceUtil.getContentPaneThatCanContainFragments(part) == null || possibleBounds.y >= (newPossibleTop = (bounds = SequenceUtil.getAbsoluteBounds((IGraphicalEditPart)part)).bottom())) continue;
                int diff = newPossibleTop - possibleBounds.y;
                possibleBounds.translate(0, diff);
                possibleBounds.resize(0, -diff);
            }
            eventualNodeElement = eventualNodeElement.getOwner();
        }
    }

    private static IFigure getContentPaneThatCanContainFragments(EditPart containerPart) {
        if (containerPart instanceof InteractionOperandEditPart) {
            return ((InteractionOperandEditPart)containerPart).getContentPane();
        }
        if (containerPart instanceof CombinedFragmentEditPart) {
            return ((CombinedFragmentEditPart)containerPart).getContentPane();
        }
        if (containerPart instanceof CombinedFragment2EditPart) {
            return ((CombinedFragment2EditPart)containerPart).getContentPane();
        }
        if (containerPart instanceof ContinuationEditPart) {
            return ((ContinuationEditPart)containerPart).getContentPane();
        }
        if (containerPart instanceof InteractionUseEditPart) {
            return ((InteractionUseEditPart)containerPart).getContentPane();
        }
        if (containerPart instanceof InteractionEditPart) {
            return ((InteractionEditPart)containerPart).getContentPane();
        }
        return null;
    }

    private static IGraphicalEditPart findDrawnContainerEditPart(LifelineEditPart lifelineEditPart, OccurrenceSpecification occSpec) {
        Element owner = occSpec.getOwner();
        while (owner != null) {
            List views = DiagramEditPartsUtil.findViews((EObject)owner, (EditPartViewer)lifelineEditPart.getViewer());
            for (View view : views) {
                EditPart part = DiagramEditPartsUtil.getEditPartFromView((View)view, (EditPart)lifelineEditPart);
                if (!(part instanceof IGraphicalEditPart) || SequenceUtil.getContentPaneThatCanContainFragments(part) == null) continue;
                return (IGraphicalEditPart)part;
            }
            owner = owner.getOwner();
        }
        return null;
    }

    public static boolean isCreateMessageEndLifeline(LifelineEditPart lifelineEP) {
        List targetConnections = lifelineEP.getTargetConnections();
        if (targetConnections != null && targetConnections.size() > 0) {
            int i = 0;
            while (i < targetConnections.size()) {
                Object connection = targetConnections.get(i);
                if (connection instanceof Message4EditPart) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public static List<TimeObservationLabelEditPart> findOccurenceSpecificationRelatedTimeObservationPart(LifelineEditPart lifelinePart, List<OccurrenceSpecification> oss) {
        ArrayList<TimeObservationLabelEditPart> list = new ArrayList<TimeObservationLabelEditPart>();
        if (oss == null || oss.size() == 0) {
            return list;
        }
        if (lifelinePart != null && lifelinePart.getTargetConnections().size() > 0) {
            for (Object targetConnection : lifelinePart.getTargetConnections()) {
                TimeObservationLabelEditPart source;
                EObject timeElement;
                ObservationLinkEditPart observationLinkEditPart;
                if (!(targetConnection instanceof ObservationLinkEditPart) || !((observationLinkEditPart = (ObservationLinkEditPart)((Object)targetConnection)).getSource() instanceof TimeObservationLabelEditPart) || !((timeElement = (source = (TimeObservationLabelEditPart)observationLinkEditPart.getSource()).resolveSemanticElement()) instanceof TimeObservation) || !oss.contains(((TimeObservation)timeElement).getEvent())) continue;
                list.add(source);
            }
        }
        return list;
    }

    public static List<TimeObservationLabelEditPart> findOccurenceSpecificationRelatedTimeObservationPart(LifelineEditPart lifelinePart, OccurrenceSpecification os) {
        ArrayList<OccurrenceSpecification> oss = new ArrayList<OccurrenceSpecification>();
        oss.add(os);
        return SequenceUtil.findOccurenceSpecificationRelatedTimeObservationPart(lifelinePart, oss);
    }

    public static EditPart getEditPart(EditPart editPart, EObject targetElement, Class targetClass) {
        if (editPart == null || targetElement == null || targetClass == null) {
            return null;
        }
        Map map = editPart.getViewer().getEditPartRegistry();
        for (Map.Entry entry : map.entrySet()) {
            Object value;
            View view;
            EObject tempElement;
            Object key = entry.getKey();
            if (!(key instanceof View) || !targetElement.equals(tempElement = (view = (View)key).getElement()) || (value = entry.getValue()).getClass() != targetClass) continue;
            return (EditPart)value;
        }
        return null;
    }

    public static void installObservationLinkPolicy(EditPart editPart) {
        String editPolicy = "observationlink";
        if (editPart instanceof LifelineEditPart || editPart instanceof TimeObservationLabelEditPart) {
            editPart.installEditPolicy((Object)editPolicy, (EditPolicy)new ObservationLinkPolicy(editPart));
        }
        if (editPart instanceof DurationObservationEditPart) {
            editPart.installEditPolicy((Object)editPolicy, (EditPolicy)new ObservationLinkPolicy(editPart));
        }
        if (editPart instanceof MessageEditPart || editPart instanceof Message2EditPart || editPart instanceof Message3EditPart || editPart instanceof Message4EditPart || editPart instanceof Message5EditPart || editPart instanceof Message6EditPart || editPart instanceof Message7EditPart) {
            editPart.installEditPolicy((Object)editPolicy, (EditPolicy)new ObservationLinkPolicy(editPart));
        } else if (editPart instanceof MessageNameEditPart || editPart instanceof MessageName2EditPart || editPart instanceof MessageName3EditPart || editPart instanceof MessageName4EditPart || editPart instanceof MessageName5EditPart || editPart instanceof MessageName6EditPart || editPart instanceof MessageName7EditPart) {
            editPart.getParent().installEditPolicy((Object)editPolicy, (EditPolicy)new ObservationLinkPolicy(editPart));
        } else if (editPart instanceof MessageSyncAppliedStereotypeEditPart || editPart instanceof MessageAsyncAppliedStereotypeEditPart || editPart instanceof MessageReplyAppliedStereotypeEditPart || editPart instanceof MessageCreateAppliedStereotypeEditPart || editPart instanceof MessageDeleteAppliedStereotypeEditPart || editPart instanceof MessageLostAppliedStereotypeEditPart || editPart instanceof MessageFoundAppliedStereotypeEditPart) {
            editPart.getParent().installEditPolicy((Object)editPolicy, (EditPolicy)new ObservationLinkPolicy(editPart));
        }
    }
}

