/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.statemachine.custom.figures;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gmf.runtime.draw2d.ui.figures.FigureUtilities;
import org.eclipse.gmf.runtime.draw2d.ui.figures.WrappingLabel;
import org.eclipse.papyrus.uml.diagram.common.figure.node.AutomaticCompartmentLayoutManager;
import org.eclipse.papyrus.uml.diagram.common.figure.node.CompartmentFigure;
import org.eclipse.papyrus.uml.diagram.statemachine.custom.figures.RoundedBorder;
import org.eclipse.papyrus.uml.diagram.statemachine.custom.figures.RoundedShadowBorder;

public class StateFigure
extends CompartmentFigure {
    int arcwidth = 20;
    protected WrappingLabel informationLabel;
    protected boolean informationHasChanged = false;
    protected boolean isInformationShown = false;
    protected String submachineStateName = "";
    protected boolean isSubmachineState = false;
    private static final String STATE_COMPARTMENT = "stateCompartment";
    private static final List<String> COMPARTMENT = new ArrayList<String>(){
        private static final long serialVersionUID = 1L;
        {
            this.add(StateFigure.STATE_COMPARTMENT);
        }
    };

    public StateFigure() {
        this(null);
    }

    public StateFigure(String tagLabel) {
        super(COMPARTMENT, tagLabel);
        this.shadowborder = new RoundedShadowBorder(this.getForegroundColor());
        this.setBorder((Border)this.shadowborder);
        ((AutomaticCompartmentLayoutManager)this.getLayoutManager()).setAddExtraHeight(false);
    }

    protected void createInformationLabel() {
        this.informationLabel = new WrappingLabel();
        this.informationLabel.setOpaque(false);
        this.informationLabel.setAlignment(16);
        this.informationLabel.setVisible(false);
        this.informationLabel.setTextWrap(true);
        this.getInformationLabelContainer().add((IFigure)this.informationLabel, this.getInformationLabelConstraint(), -1);
    }

    public void setSubmachineStateName(String text) {
        this.submachineStateName = text;
    }

    public void setIsSubmachineState(boolean b) {
        this.isSubmachineState = b;
    }

    protected void refreshName() {
        if (this.isSubmachineState) {
            this.nameLabel.setText(this.submachineStateName);
        }
    }

    protected void createNameLabel() {
        super.createNameLabel();
        this.createInformationLabel();
    }

    public void fillInformation(String text) {
        if (!this.informationLabel.getText().equals(text)) {
            this.informationLabel.setText(text);
            this.informationHasChanged = true;
            this.refreshInformationToShow();
        } else {
            this.informationHasChanged = false;
        }
    }

    public WrappingLabel getInformationLabel() {
        return this.informationLabel;
    }

    protected Object getInformationLabelConstraint() {
        return this.getDefaultLabelsConstraint();
    }

    protected IFigure getInformationLabelContainer() {
        return this.getDefaultLabelsContainer();
    }

    public RectangleFigure getStateCompartmentFigure() {
        return this.getCompartment(STATE_COMPARTMENT);
    }

    public boolean hasInformationChanged() {
        return this.informationHasChanged;
    }

    protected void paintBackground(Graphics graphics, Rectangle rectangle) {
        if (this.isUsingGradient()) {
            boolean isVertical;
            this.applyTransparency(graphics);
            boolean bl = isVertical = this.getGradientStyle() == 0;
            if (isVertical && rectangle.height > 3 * this.arcwidth / 2) {
                Rectangle rect1 = new Rectangle(rectangle.getLocation(), new Dimension(rectangle.width, this.arcwidth));
                Rectangle rect2 = new Rectangle(rectangle.x, rectangle.y + rectangle.height - this.arcwidth, rectangle.width, this.arcwidth);
                graphics.setBackgroundColor(FigureUtilities.integerToColor((Integer)this.getGradientColor2()));
                graphics.fillRoundRectangle(rect1, this.arcwidth, this.arcwidth);
                graphics.setBackgroundColor(FigureUtilities.integerToColor((Integer)this.getGradientColor1()));
                graphics.fillRoundRectangle(rect2, this.arcwidth, this.arcwidth);
                graphics.setBackgroundColor(FigureUtilities.integerToColor((Integer)this.getGradientColor1()));
                graphics.setForegroundColor(FigureUtilities.integerToColor((Integer)this.getGradientColor2()));
                Rectangle rect = new Rectangle(rectangle.x, rectangle.y + this.arcwidth / 2, rectangle.width, rectangle.height - this.arcwidth);
                graphics.fillGradient(rect, true);
            } else if (!isVertical && rectangle.width > 3 * this.arcwidth / 2) {
                Rectangle rect1 = new Rectangle(rectangle.getLocation(), new Dimension(this.arcwidth, rectangle.height));
                Rectangle rect2 = new Rectangle(rectangle.x + rectangle.width - this.arcwidth, rectangle.y, this.arcwidth, rectangle.height);
                graphics.setBackgroundColor(FigureUtilities.integerToColor((Integer)this.getGradientColor2()));
                graphics.fillRoundRectangle(rect1, this.arcwidth, this.arcwidth);
                graphics.setBackgroundColor(FigureUtilities.integerToColor((Integer)this.getGradientColor1()));
                graphics.fillRoundRectangle(rect2, this.arcwidth, this.arcwidth);
                graphics.setBackgroundColor(FigureUtilities.integerToColor((Integer)this.getGradientColor1()));
                graphics.setForegroundColor(FigureUtilities.integerToColor((Integer)this.getGradientColor2()));
                Rectangle rect = new Rectangle(rectangle.x + this.arcwidth / 2, rectangle.y, rectangle.width - this.arcwidth, rectangle.height);
                graphics.fillGradient(rect, false);
            } else {
                graphics.setBackgroundColor(FigureUtilities.integerToColor((Integer)this.getGradientColor1()));
                graphics.setForegroundColor(FigureUtilities.integerToColor((Integer)this.getGradientColor2()));
                graphics.fillRoundRectangle(rectangle, this.arcwidth, this.arcwidth);
            }
        } else {
            graphics.setBackgroundColor(this.getBackgroundColor());
            graphics.setForegroundColor(this.getForegroundColor());
            graphics.fillRoundRectangle(rectangle, this.arcwidth, this.arcwidth);
        }
    }

    public void paintFigure(Graphics graphics) {
        this.paintBackground(graphics, this.getBounds());
        this.refreshInformationToShow();
        this.refreshName();
        if (this.isInformationShown) {
            Rectangle rect = this.informationLabel.getBounds();
            Rectangle rect2 = this.nameLabel.getBounds();
            graphics.setForegroundColor(this.getBorderColor());
            graphics.setLineStyle(1);
            graphics.setLineWidth(1);
            graphics.drawLine(rect.x - 2, rect.y, rect.x + rect.width - 1, rect.y);
        }
    }

    protected void refreshInformationToShow() {
        String text = this.informationLabel.getText();
        if (text == null || text.length() == 0 || text.equalsIgnoreCase("\n")) {
            this.informationLabel.setVisible(false);
            this.isInformationShown = false;
        } else {
            this.informationLabel.setVisible(true);
            this.isInformationShown = true;
        }
    }

    public void setShadow(boolean shadow) {
        super.setShadow(shadow);
        if (!shadow) {
            RoundedBorder bord = new RoundedBorder(this.arcwidth, this.arcwidth);
            this.setBorder((Border)bord);
        }
    }
}

