/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.statemachine.custom.parsers;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.ui.services.parser.IParser;
import org.eclipse.gmf.runtime.common.ui.services.parser.IParserEditStatus;
import org.eclipse.gmf.runtime.common.ui.services.parser.ParserEditStatus;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.emf.ui.services.parser.ISemanticParser;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.papyrus.infra.core.utils.EditorUtils;
import org.eclipse.papyrus.uml.tools.utils.ValueSpecificationUtil;
import org.eclipse.uml2.uml.Behavior;
import org.eclipse.uml2.uml.CallEvent;
import org.eclipse.uml2.uml.ChangeEvent;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Event;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.OpaqueBehavior;
import org.eclipse.uml2.uml.OpaqueExpression;
import org.eclipse.uml2.uml.SignalEvent;
import org.eclipse.uml2.uml.TimeEvent;
import org.eclipse.uml2.uml.Transition;
import org.eclipse.uml2.uml.Trigger;
import org.eclipse.uml2.uml.UMLFactory;
import org.eclipse.uml2.uml.ValueSpecification;

public class TransitionPropertiesParser
implements IParser,
ISemanticParser {
    private static final String ONE_SPACE_STRING = " ";
    protected Constraint guardConstraint = null;
    private static String EMPTY_STRING = "";

    public IContentAssistProcessor getCompletionProcessor(IAdaptable element) {
        return null;
    }

    public String getEditString(IAdaptable element, int flags) {
        return EMPTY_STRING;
    }

    public ICommand getParseCommand(IAdaptable element, String newString, int flags) {
        final Transition transition = (Transition)((EObjectAdapter)element).getRealObject();
        final String result = newString;
        AbstractTransactionalCommand tc = new AbstractTransactionalCommand(EditorUtils.getTransactionalEditingDomain(), "Edit Transition Properties", null){

            protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                SafeRunnable.run((ISafeRunnable)new SafeRunnable(){

                    public void run() {
                        RecordingCommand rc = new RecordingCommand(EditorUtils.getTransactionalEditingDomain()){

                            protected void doExecute() {
                                EList elements = transition.getModel().allOwnedElements();
                                for (Element pElement : elements) {
                                    if (!(pElement instanceof Constraint) || !result.equals(((NamedElement)pElement).getName())) continue;
                                    ((this).this).TransitionPropertiesParser.this.guardConstraint = (Constraint)pElement;
                                    transition.setGuard(((this).this).TransitionPropertiesParser.this.guardConstraint);
                                }
                                if (((this).this).TransitionPropertiesParser.this.guardConstraint == null) {
                                    ((this).this).TransitionPropertiesParser.this.guardConstraint = UMLFactory.eINSTANCE.createConstraint();
                                    ((this).this).TransitionPropertiesParser.this.guardConstraint.setName(result);
                                    ((this).this).TransitionPropertiesParser.this.guardConstraint.setContext(transition.getNamespace());
                                    transition.setGuard(((this).this).TransitionPropertiesParser.this.guardConstraint);
                                }
                            }
                        };
                        EditorUtils.getTransactionalEditingDomain().getCommandStack().execute((Command)rc);
                    }
                });
                return CommandResult.newOKCommandResult();
            }
        };
        return tc;
    }

    public String getPrintString(IAdaptable element, int flags) {
        String label = this.getValueString(element, flags);
        if (label == null || label.length() == 0) {
            label = ONE_SPACE_STRING;
        }
        return label;
    }

    public boolean isAffectingEvent(Object event, int flags) {
        int notificationType;
        if (event instanceof Notification && 1 == (notificationType = ((Notification)event).getEventType())) {
            if (((Notification)event).getNewValue() instanceof Constraint) {
                this.guardConstraint = (Constraint)((Notification)event).getNewValue();
            }
            return true;
        }
        return false;
    }

    protected String getValueString(IAdaptable element, int flags) {
        Object obj = element.getAdapter(EObject.class);
        if (obj instanceof Transition) {
            Transition trans = (Transition)obj;
            StringBuilder result = new StringBuilder();
            String textForTrigger = this.getTextForTrigger(trans);
            if (textForTrigger != null && !EMPTY_STRING.equals(textForTrigger)) {
                result.append(textForTrigger).append(ONE_SPACE_STRING);
            }
            result.append(this.getTextForGuard(trans));
            String textForEffect = this.getTextForEffect(trans);
            if (textForEffect != null && !EMPTY_STRING.equals(textForEffect)) {
                result.append("/\n").append(textForEffect);
            }
            return result.toString();
        }
        return EMPTY_STRING;
    }

    protected String getTextForGuard(Transition trans) {
        String value;
        Constraint valueSpec = trans.getGuard();
        if (valueSpec != null && (value = ValueSpecificationUtil.getConstraintnValue((Constraint)valueSpec)) != null) {
            return String.format("[%s]", value);
        }
        return EMPTY_STRING;
    }

    protected String getTextForEffect(Transition trans) {
        StringBuilder result = new StringBuilder();
        Behavior effect = trans.getEffect();
        if (effect != null) {
            OpaqueBehavior ob;
            EClass eClass = effect.eClass();
            if (effect instanceof OpaqueBehavior && (ob = (OpaqueBehavior)effect).getBodies().size() > 0) {
                result.append((String)ob.getBodies().get(0));
                return result.toString();
            }
            if (eClass != null) {
                result.append(eClass.getName()).append(": ").append(effect.getName());
            }
        }
        return result.toString();
    }

    protected String getTextForTrigger(Transition trans) {
        StringBuilder result = new StringBuilder();
        boolean isFirstTrigger = true;
        for (Trigger t : trans.getTriggers()) {
            if (t == null) continue;
            if (!isFirstTrigger) {
                result.append(", ");
            } else {
                isFirstTrigger = false;
            }
            Event e = t.getEvent();
            if (e instanceof CallEvent) {
                if (((CallEvent)e).getOperation() != null) {
                    result.append(((CallEvent)e).getOperation().getName());
                    continue;
                }
                result.append(((CallEvent)e).getName());
                continue;
            }
            if (e instanceof SignalEvent) {
                if (((SignalEvent)e).getSignal() != null) {
                    result.append(((SignalEvent)e).getSignal().getName());
                    continue;
                }
                result.append(((SignalEvent)e).getName());
                continue;
            }
            if (e instanceof ChangeEvent) {
                result.append("when ").append("\"").append(this.retrieveBody((OpaqueExpression)((ChangeEvent)e).getChangeExpression(), "Natural language")).append("\"");
                continue;
            }
            if (e instanceof TimeEvent) {
                result.append(((TimeEvent)e).isRelative() ? "after " : "at ");
                result.append("\"").append(this.retrieveBody((OpaqueExpression)((TimeEvent)e).getWhen().getExpr(), "Natural language")).append("\"");
                continue;
            }
            result.append("all");
        }
        return result.toString();
    }

    public IParserEditStatus isValidEditString(IAdaptable element, String editString) {
        return new ParserEditStatus("org.eclipse.papyrus.uml.diagram.statemachine", 0, "");
    }

    public List getSemanticElementsBeingParsed(EObject element) {
        Transition trans;
        Element umlElement = (Element)element;
        LinkedList<Object> result = new LinkedList<Object>();
        if (umlElement instanceof Transition && (trans = (Transition)umlElement) != null) {
            result.add(trans);
            Constraint constraint = trans.getGuard();
            if (constraint != null) {
                result.add(constraint);
                ValueSpecification specification = constraint.getSpecification();
                if (specification != null) {
                    result.add(specification);
                }
            }
            for (Trigger t : trans.getTriggers()) {
                if (t == null) continue;
                result.add(t);
            }
            Behavior effect = trans.getEffect();
            if (effect != null) {
                result.add(effect);
            }
        }
        return result;
    }

    public boolean areSemanticElementsAffected(EObject listener, Object notification) {
        return true;
    }

    private String retrieveBody(OpaqueExpression exp, String languageName) {
        String body = EMPTY_STRING;
        if (exp == null) {
            return body;
        }
        int index = 0;
        for (String _languageName : exp.getLanguages()) {
            if (_languageName.equals(languageName)) {
                if (index < exp.getBodies().size()) {
                    return (String)exp.getBodies().get(index);
                }
                return EMPTY_STRING;
            }
            ++index;
        }
        return body;
    }
}

