/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.profile.readonly;

import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.resource.uml.UmlModel;
import org.eclipse.papyrus.infra.emf.readonly.IReadOnlyHandler;
import org.eclipse.uml2.uml.Profile;

public class AppliedProfileReadOnlyHandler
implements IReadOnlyHandler {
    public boolean isReadOnly(URI[] uris, EditingDomain editingDomain) {
        if (editingDomain != null) {
            Resource mainUmlResource = null;
            if (editingDomain.getResourceSet() instanceof ModelSet) {
                UmlModel umlModel = (UmlModel)((ModelSet)editingDomain.getResourceSet()).getModel("org.eclipse.papyrus.infra.core.resource.uml.UmlModel");
                if (umlModel == null) {
                    return false;
                }
                mainUmlResource = umlModel.getResource();
            }
            URI[] uRIArray = uris;
            int n = uris.length;
            int n2 = 0;
            while (n2 < n) {
                URI uri = uRIArray[n2];
                Resource resource = editingDomain.getResourceSet().getResource(uri, false);
                if (this.isProfileResource(resource) && mainUmlResource != resource) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    private boolean isProfileResource(Resource resource) {
        if (resource == null) {
            return false;
        }
        for (EObject rootElement : resource.getContents()) {
            if (!(rootElement instanceof Profile)) continue;
            return true;
        }
        return false;
    }

    public boolean enableWrite(URI[] uris, EditingDomain editingDomain) {
        return false;
    }
}

