/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.profile.ui.dialogs;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.papyrus.uml.profile.ImageManager;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.DataType;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Enumeration;
import org.eclipse.uml2.uml.InstanceSpecification;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.PrimitiveType;
import org.eclipse.uml2.uml.Profile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ElementImportTreeSelectionDialog
extends Dialog {
    protected Package model;
    protected List<Package> models;
    protected boolean subSelection = false;
    protected ArrayList<Element> elementsToImport = new ArrayList();
    protected Tree elementTree;
    protected static final Image IMG_PACKAGE = ImageManager.IMG_PACKAGE;
    protected static final Image IMG_CLASS = ImageManager.IMG_CLASS;
    protected static final Image IMG_DATATYPE = ImageManager.IMG_DATATYPE;
    protected static final Image IMG_ENUM = ImageManager.IMG_ENUMERATION;
    protected static final Image IMG_PRIMITIVE = ImageManager.IMG_PRIMITIVETYPE;
    protected static final Image IMG_PROFILE = ImageManager.IMG_PROFILE;
    protected static final Image IMG_ASSOCIATION = ImageManager.IMG_ASSOCIATION;
    protected static final Image IMG_INSTANCESPEC = ImageManager.IMG_INSTANCESPEC;

    public ElementImportTreeSelectionDialog(Shell parent, Package model) {
        super(parent);
        this.model = model;
        this.models = null;
    }

    public ElementImportTreeSelectionDialog(Shell parent, List<Package> models) {
        super(parent);
        this.model = null;
        this.models = models;
    }

    protected Control createDialogArea(Composite parent) {
        Composite comp = (Composite)super.createDialogArea(parent);
        this.elementTree = new Tree(comp, 2592);
        GridData treeData = new GridData(4, 4, true, true);
        treeData.widthHint = 300;
        treeData.heightHint = 300;
        this.elementTree.setLayoutData((Object)treeData);
        if (this.model != null) {
            this.createTreeItem(this.model);
        } else if (this.models != null) {
            for (Package current : this.models) {
                this.createTreeItem(current);
            }
        }
        this.elementTree.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (event.detail == 32) {
                    if (ElementImportTreeSelectionDialog.this.elementsToImport.contains(event.item.getData())) {
                        ElementImportTreeSelectionDialog.this.elementsToImport.remove(event.item.getData());
                        if (ElementImportTreeSelectionDialog.this.subSelection) {
                            ElementImportTreeSelectionDialog.this.remChildSelection((TreeItem)event.item);
                        }
                    } else {
                        ElementImportTreeSelectionDialog.this.elementsToImport.add((Element)event.item.getData());
                        if (ElementImportTreeSelectionDialog.this.subSelection) {
                            ElementImportTreeSelectionDialog.this.addChildSelection((TreeItem)event.item);
                        }
                    }
                }
            }
        });
        this.getShell().setText("Select the elements to import");
        return comp;
    }

    protected void addChildSelection(TreeItem item) {
        TreeItem[] items = item.getItems();
        if (items != null && items.length > 0) {
            int i = 0;
            while (i < items.length) {
                items[i].setChecked(true);
                this.addChildSelection(items[i]);
                this.elementsToImport.add((Element)items[i].getData());
                ++i;
            }
        }
    }

    protected void remChildSelection(TreeItem item) {
        TreeItem[] items = item.getItems();
        if (items != null && items.length > 0) {
            int i = 0;
            while (i < items.length) {
                items[i].setChecked(false);
                this.remChildSelection(items[i]);
                while (this.elementsToImport.contains(items[i].getData())) {
                    this.elementsToImport.remove(items[i].getData());
                }
                ++i;
            }
        }
    }

    private void createTreeItem(Package _package) {
        TreeItem item = new TreeItem(this.elementTree, 0);
        item.setText(_package.getName());
        item.setData((Object)_package);
        if (_package instanceof Profile) {
            item.setImage(IMG_PROFILE);
        } else {
            item.setImage(IMG_PACKAGE);
        }
        this.buildImportTreeList(item, _package);
    }

    public ArrayList getResult() {
        return this.elementsToImport;
    }

    protected void buildImportTreeList(TreeItem elemTree, Package _package) {
        for (Element elem : _package.getPackagedElements()) {
            TreeItem item;
            if (elem instanceof Package) {
                item = new TreeItem(elemTree, 0);
                item.setText(((Package)elem).getName());
                item.setData((Object)elem);
                if (elem instanceof Profile) {
                    item.setImage(IMG_PROFILE);
                }
                item.setImage(IMG_PACKAGE);
                this.buildImportTreeList(item, (Package)elem);
                continue;
            }
            if (!(elem instanceof NamedElement)) continue;
            item = new TreeItem(elemTree, 0);
            item.setText(((NamedElement)elem).getName());
            item.setData((Object)elem);
            if (elem instanceof Association) {
                item.setImage(IMG_ASSOCIATION);
                continue;
            }
            if (elem instanceof Enumeration) {
                item.setImage(IMG_ENUM);
                continue;
            }
            if (elem instanceof PrimitiveType) {
                item.setImage(IMG_PRIMITIVE);
                continue;
            }
            if (elem instanceof DataType) {
                item.setImage(IMG_DATATYPE);
                continue;
            }
            if (elem instanceof Class) {
                item.setImage(IMG_CLASS);
                continue;
            }
            if (!(elem instanceof InstanceSpecification)) continue;
            item.setImage(IMG_INSTANCESPEC);
        }
    }
}

