/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.profilefacet.queries.getter;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.facet.infra.query.core.exception.ModelQueryExecutionException;
import org.eclipse.emf.facet.infra.query.core.java.ParameterValueList;
import org.eclipse.papyrus.uml.profilefacet.metamodel.profilefacet.StereotypeFacet;
import org.eclipse.papyrus.uml.profilefacet.metamodel.profilefacet.StereotypePropertyElement;
import org.eclipse.papyrus.uml.profilefacet.queries.getter.GetGenericMultiValue;
import org.eclipse.papyrus.uml.tools.utils.EnumerationUtil;
import org.eclipse.papyrus.uml.tools.utils.NamedElementUtil;
import org.eclipse.papyrus.uml.tools.utils.StereotypeUtil;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Enumeration;
import org.eclipse.uml2.uml.EnumerationLiteral;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.TypedElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GetUMLEnumerationMultiValue
extends GetGenericMultiValue<EnumerationLiteral> {
    @Override
    public List<EnumerationLiteral> evaluate(Element source, ParameterValueList parameterValues) throws ModelQueryExecutionException {
        StereotypePropertyElement element = (StereotypePropertyElement)parameterValues.getParameterValueByName("editedFeature").getValue();
        if (element != null) {
            EObject container = element.eContainer();
            assert (container instanceof StereotypeFacet);
            StereotypeFacet facet = (StereotypeFacet)container;
            String stereotypeQN = facet.getStereotypeQualifiedName();
            Stereotype appliedStereotype = source.getAppliedStereotype(stereotypeQN);
            String propertyQN = element.getPropertyQualifiedName();
            String propertyName = NamedElementUtil.getNameFromQualifiedName((String)propertyQN);
            if (appliedStereotype != null) {
                Enumeration type = (Enumeration)((TypedElement)appliedStereotype.getOwnedMember(propertyName)).getType();
                Object value = source.getValue(appliedStereotype, propertyName);
                assert (value instanceof Collection);
                return EnumerationUtil.adaptToEnumerationLiteralList((Enumeration)type, (Collection)((Collection)value));
            }
            if (appliedStereotype == null) {
                for (Stereotype appliedSte : source.getAppliedStereotypes()) {
                    List superClasses = StereotypeUtil.getAllSuperStereotypes((Stereotype)appliedSte);
                    for (Stereotype current : superClasses) {
                        if (!current.getQualifiedName().equals(stereotypeQN)) continue;
                        Enumeration type = (Enumeration)((TypedElement)current.getOwnedMember(propertyName)).getType();
                        Object value = source.getValue(appliedSte, propertyName);
                        assert (value instanceof Collection);
                        return EnumerationUtil.adaptToEnumerationLiteralList((Enumeration)type, (Collection)((Collection)value));
                    }
                }
            }
        }
        return Collections.emptyList();
    }
}

