/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.properties.profile.ui.actions;

import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.papyrus.uml.profile.ui.dialogs.PackageImportTreeSelectionDialog;
import org.eclipse.papyrus.uml.properties.profile.ui.actions.AbstractPackageImportAction;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ResourceSelectionDialog;
import org.eclipse.uml2.common.edit.command.ChangeCommand;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.PackageImport;
import org.eclipse.uml2.uml.UMLFactory;

public class ImportFromFile
extends AbstractPackageImportAction {
    public ChangeCommand getCommand(EditingDomain domain) {
        if (this.command == null) {
            this.command = new ImportFromFileCommand(domain);
        }
        return this.command;
    }

    public class ImportFromFileCommand
    extends ChangeCommand {
        public ImportFromFileCommand(EditingDomain editingDomain) {
            super(editingDomain, new Runnable(){

                public void run() {
                    Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                    ResourceSelectionDialog chooseLib = new ResourceSelectionDialog(shell, (IAdaptable)ResourcesPlugin.getWorkspace().getRoot(), "Select Registered ModelLibrary");
                    chooseLib.open();
                    Object[] selection = chooseLib.getResult();
                    if (selection == null) {
                        return;
                    }
                    ResourceSet resourceSet = ImportFromFile.this.selectedElement.eResource().getResourceSet();
                    int i = 0;
                    while (i < selection.length) {
                        if (selection[i] instanceof IFile) {
                            IFile currentFile = (IFile)selection[i];
                            URI modelUri = URI.createURI((String)("platform:/resource" + currentFile.getFullPath()));
                            Resource modelResource = resourceSet.getResource(modelUri, true);
                            PackageImportTreeSelectionDialog eisd = new PackageImportTreeSelectionDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (Package)modelResource.getContents().get(0));
                            int ret = eisd.open();
                            if (ret == 0) {
                                ArrayList result = eisd.getResult();
                                for (Element element : result) {
                                    PackageImport ei = UMLFactory.eINSTANCE.createPackageImport();
                                    ei.setImportedPackage((Package)element);
                                    ImportFromFile.this.selectedElement.getPackageImports().add((Object)ei);
                                }
                            }
                        }
                        ++i;
                    }
                }
            }, "Import Libraries", "Import Libraries from Workspace");
        }
    }
}

