/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.service.types.helper;

import java.util.Collection;
import java.util.Collections;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.CreateChildCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.commands.CreateElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.internal.EMFTypePlugin;
import org.eclipse.gmf.runtime.emf.type.core.internal.l10n.EMFTypeCoreMessages;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.papyrus.uml.service.types.helper.ElementEditHelper;

public class ActivityHelper
extends ElementEditHelper {
    protected ICommand getCreateCommand(CreateElementRequest req) {
        return new CreateActivityNode(req);
    }

    private class CreateActivityNode
    extends CreateElementCommand {
        protected Command emfcmd;

        public CreateActivityNode(CreateElementRequest request) {
            super(request);
            this.emfcmd = null;
        }

        protected EObject doDefaultElementCreation() {
            EObject element;
            EObject result = null;
            EReference containment = this.getContainmentFeature();
            EClass eClass = this.getElementType().getEClass();
            if (containment != null && (element = this.getElementToEdit()) != null) {
                result = eClass.getEPackage().getEFactoryInstance().create(eClass);
                this.emfcmd = new CreateChildCommand((EditingDomain)this.getRequest().getEditingDomain(), element, (EStructuralFeature)containment, (Object)result, (Collection)Collections.EMPTY_LIST);
                this.emfcmd.canExecute();
                this.emfcmd.execute();
                if (!this.emfcmd.getResult().isEmpty()) {
                    result = (EObject)this.emfcmd.getResult().toArray()[0];
                }
            }
            IStatus status = result != null ? Status.OK_STATUS : new Status(4, EMFTypePlugin.getPluginId(), EMFTypeCoreMessages.bind((String)EMFTypeCoreMessages.createElementCommand_noElementCreated, (Object)this.getElementType().getDisplayName()));
            this.setDefaultElementCreationStatus(status);
            return result;
        }

        protected IStatus doUndo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            this.emfcmd.undo();
            return super.doUndo(monitor, info);
        }

        protected IStatus doRedo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            IStatus status = super.doRedo(monitor, info);
            this.emfcmd.redo();
            return status;
        }
    }
}

