/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.service.types.helper;

import java.util.Map;
import java.util.Set;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.ElementTypeRegistry;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.commands.DestroyElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.edithelper.AbstractEditHelper;
import org.eclipse.gmf.runtime.emf.type.core.edithelper.IEditHelperAdvice;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyDependentsRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.papyrus.commands.DestroyElementPapyrusCommand;

public class DefaultEditHelper
extends AbstractEditHelper {
    public static final String Cache_Maps = "Cache_Maps";
    public static final String Element_Type = "Element_Type";
    public static final String Checked_Elements = "Checked_Elements";
    public static final String EditHelper_Advice = "EditHelper_Advice";

    protected ICommand getDestroyElementWithDependentsCommand(DestroyElementRequest req) {
        ICommand command;
        Map map;
        DestroyDependentsRequest ddr;
        ICommand result = this.getBasicDestroyElementCommand(req);
        EObject initial = (EObject)req.getParameter("DestroyElementRequest.initialElementToDestroy");
        if (initial == null) {
            req.setParameter("DestroyElementRequest.initialElementToDestroy", (Object)req.getElementToDestroy());
        }
        if ((ddr = (DestroyDependentsRequest)req.getParameter("DestroyElementRequest.destroyDependentsRequest")) == null) {
            ddr = new DestroyDependentsRequest(req.getEditingDomain(), req.getElementToDestroy(), req.isConfirmationRequired());
            ddr.addParameters(req.getParameters());
            ddr.setClientContext(req.getClientContext());
            req.setParameter("DestroyElementRequest.destroyDependentsRequest", (Object)ddr);
        } else {
            ddr.setElementToDestroy(req.getElementToDestroy());
        }
        IElementType typeToDestroy = null;
        Map cacheMaps = (Map)req.getParameter(Cache_Maps);
        if (cacheMaps != null && (map = (Map)cacheMaps.get(req.getElementToDestroy())) != null) {
            typeToDestroy = (IElementType)map.get(Element_Type);
        }
        if (typeToDestroy == null) {
            typeToDestroy = ElementTypeRegistry.getInstance().getElementType(req.getElementToDestroy(), req.getClientContext());
        }
        if (typeToDestroy != null && (command = typeToDestroy.getEditCommand((IEditCommandRequest)ddr)) != null) {
            result = result.compose((IUndoableOperation)command);
        }
        return result;
    }

    protected ICommand getDestroyElementCommand(DestroyElementRequest req) {
        ICommand result = null;
        EObject parent = req.getElementToDestroy();
        if (req.getParameter("DestroyElementRequest.initialElementToDestroy") == null) {
            req.setParameter("DestroyElementRequest.initialElementToDestroy", (Object)parent);
        }
        IElementType parentType = null;
        Map cacheMaps = (Map)req.getParameter(Cache_Maps);
        Set checkedElement = null;
        if (cacheMaps != null) {
            checkedElement = (Set)cacheMaps.get(Checked_Elements);
            checkedElement.add(parent);
            Map parentMap = (Map)cacheMaps.get(parent);
            parentType = parentMap != null ? (IElementType)parentMap.get(Element_Type) : ElementTypeRegistry.getInstance().getElementType(parent, req.getClientContext());
        } else {
            parentType = ElementTypeRegistry.getInstance().getElementType(parent, req.getClientContext());
        }
        if (parentType != null) {
            for (EObject next : parent.eContents()) {
                DestroyDependentsRequest ddr = (DestroyDependentsRequest)req.getParameter("DestroyElementRequest.destroyDependentsRequest");
                if (ddr != null && (checkedElement == null || !checkedElement.add(next)) && ddr.getDependentElementsToDestroy().contains(next)) continue;
                req.setElementToDestroy(next);
                ICommand command = parentType.getEditCommand((IEditCommandRequest)req);
                if (command == null) continue;
                result = result == null ? command : result.compose((IUndoableOperation)command);
            }
        }
        req.setElementToDestroy(parent);
        ICommand destroyParent = this.getDestroyElementWithDependentsCommand(req);
        result = result == null ? destroyParent : result.compose((IUndoableOperation)destroyParent);
        return result;
    }

    protected IEditHelperAdvice[] getEditHelperAdvice(IEditCommandRequest req) {
        Map contextMap;
        IEditHelperAdvice[] advices = null;
        Object editHelperContext = req.getEditHelperContext();
        Map cacheMaps = (Map)req.getParameter(Cache_Maps);
        if (cacheMaps != null && (contextMap = (Map)cacheMaps.get(editHelperContext)) != null) {
            advices = (IEditHelperAdvice[])contextMap.get(EditHelper_Advice);
        }
        if (advices == null) {
            advices = editHelperContext instanceof EObject ? ElementTypeRegistry.getInstance().getEditHelperAdvice((EObject)editHelperContext, req.getClientContext()) : (editHelperContext instanceof IElementType ? ElementTypeRegistry.getInstance().getEditHelperAdvice((IElementType)editHelperContext, req.getClientContext()) : ElementTypeRegistry.getInstance().getEditHelperAdvice(editHelperContext));
        }
        return advices;
    }

    protected ICommand getBasicDestroyElementCommand(DestroyElementRequest req) {
        DestroyElementCommand result = req.getBasicDestroyCommand();
        if (result == null) {
            result = new DestroyElementPapyrusCommand(req);
        } else {
            req.setBasicDestroyCommand(null);
        }
        return result;
    }
}

