/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.tools.utils;

import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.uml.tools.utils.PackageUtil;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.UMLPackage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProfileUtil {
    private static EPackage umlMetamodel = UMLPackage.eINSTANCE;

    public static boolean isDirty(Package _package, Profile _profile) {
        URI prof_URI;
        Resource modelResource;
        boolean isDirty = false;
        if (_profile == null || _profile.eResource() == null) {
            return false;
        }
        ResourceSet pkge_resourceSet = _package.eResource().getResourceSet();
        if (pkge_resourceSet != null && (modelResource = pkge_resourceSet.getResource(prof_URI = _profile.eResource().getURI(), true)) != null && modelResource.getContents().get(0) instanceof Profile) {
            Profile profileInFile = (Profile)modelResource.getContents().get(0);
            if (_package.getProfileApplication(_profile) != null) {
                String fileProfileName;
                EPackage appliedProfileDefinition = _package.getProfileApplication(_profile).getAppliedDefinition();
                EPackage fileProfileDefinition = null;
                String appliedProfileName = _profile.getQualifiedName();
                if (!appliedProfileName.equals(fileProfileName = profileInFile.getQualifiedName())) {
                    for (Profile current : PackageUtil.getSubProfiles((Package)profileInFile)) {
                        fileProfileName = current.getQualifiedName();
                        if (!fileProfileName.equals(appliedProfileName)) continue;
                        profileInFile = current;
                    }
                }
                if (appliedProfileDefinition != (fileProfileDefinition = profileInFile.getDefinition())) {
                    isDirty = true;
                }
            }
        }
        return isDirty;
    }

    public static List<Stereotype> findAllSubStereotypes(Stereotype parentStereotype, Package umlPackage, boolean concreteOnly) {
        LinkedHashSet<Stereotype> result = new LinkedHashSet<Stereotype>();
        for (Profile profile : umlPackage.getAllAppliedProfiles()) {
            LinkedList<Stereotype> allStereotypes = new LinkedList<Stereotype>();
            ProfileUtil.findAllStereotypes(profile, allStereotypes);
            for (Stereotype stereotype : allStereotypes) {
                if (concreteOnly && stereotype.isAbstract() || !ProfileUtil.isSubStereotype(parentStereotype, stereotype)) continue;
                result.add(stereotype);
            }
        }
        return new LinkedList<Stereotype>(result);
    }

    public static boolean isSubStereotype(Stereotype parentStereotype, Stereotype childStereotype) {
        if (parentStereotype == childStereotype) {
            return true;
        }
        return childStereotype.getGenerals().contains((Object)parentStereotype);
    }

    public static void findAllStereotypes(Profile profile, List<Stereotype> result) {
        for (Stereotype stereotype : profile.getOwnedStereotypes()) {
            result.add(stereotype);
        }
        for (Package subPackage : profile.getNestedPackages()) {
            if (!(subPackage instanceof Profile)) continue;
            Profile subProfile = (Profile)subPackage;
            ProfileUtil.findAllStereotypes(subProfile, result);
        }
    }

    public static List<EClass> getAllExtendedMetaclasses(Stereotype stereotype, boolean concreteClassesOnly) {
        EList extendedMetaclasses = stereotype.getAllExtendedMetaclasses();
        LinkedHashSet allMetaclasses = new LinkedHashSet();
        for (Class extendedMetaclass : extendedMetaclasses) {
            EClass UMLEClass = ProfileUtil.findEClass(extendedMetaclass);
            allMetaclasses.addAll(EMFHelper.getSubclassesOf((EClass)UMLEClass, (boolean)concreteClassesOnly));
        }
        return new LinkedList<EClass>(allMetaclasses);
    }

    private static EClass findEClass(Class metaclass) {
        for (EClassifier classifier : umlMetamodel.getEClassifiers()) {
            if (!(classifier instanceof EClass) || !classifier.getName().equals(metaclass.getName())) continue;
            return (EClass)classifier;
        }
        return null;
    }

    public static Property findStereotypedProperty(Stereotype stereotype, String associationName) {
        block0: for (Association association : stereotype.getAssociations()) {
            for (Property memberEnd : association.getMemberEnds()) {
                if (memberEnd.getType() != stereotype) continue;
                for (Property oppositeEnd : association.getMemberEnds()) {
                    if (oppositeEnd == memberEnd || !oppositeEnd.getName().equals(associationName) || association.getOwnedEnds().contains((Object)oppositeEnd)) continue;
                    if (!(oppositeEnd.getType() instanceof Stereotype)) break block0;
                    return oppositeEnd;
                }
            }
        }
        for (Property property : stereotype.getAllAttributes()) {
            if (!property.getName().equals(associationName) || !(property.getType() instanceof Stereotype)) continue;
            return property;
        }
        return null;
    }
}

