/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.tools.utils;

import org.eclipse.papyrus.uml.tools.utils.NamedElementUtil;
import org.eclipse.papyrus.uml.tools.utils.PropertyUtil;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Signal;

public class SignalUtil {
    public static String getCustomLabel(Signal signal, int style) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(" ");
        if ((style & 2) != 0) {
            buffer.append(NamedElementUtil.getVisibilityAsSign((NamedElement)signal));
        }
        if ((style & 8) != 0) {
            buffer.append(" ");
            buffer.append(signal.getName());
        }
        buffer.append("(");
        buffer.append(SignalUtil.getPropertiesAsString(signal, style));
        buffer.append(")");
        return buffer.toString();
    }

    private static String getPropertiesAsString(Signal signal, int style) {
        StringBuffer propertiesString = new StringBuffer();
        boolean firstProperty = true;
        for (Property property : signal.getOwnedAttributes()) {
            String propertyString = PropertyUtil.getCustomLabel(property, style);
            if (propertyString.trim().equals("")) continue;
            if (!firstProperty) {
                propertiesString.append(", ");
            }
            propertiesString.append(propertyString);
            firstProperty = false;
        }
        return propertiesString.toString();
    }
}

