/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.views.properties.runtime;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.views.properties.Activator;
import org.eclipse.papyrus.views.properties.contexts.Context;
import org.eclipse.papyrus.views.properties.contexts.DataContextElement;
import org.eclipse.papyrus.views.properties.contexts.Property;
import org.eclipse.papyrus.views.properties.contexts.Section;
import org.eclipse.papyrus.views.properties.contexts.Tab;
import org.eclipse.papyrus.views.properties.environment.CompositeWidgetType;
import org.eclipse.papyrus.views.properties.environment.Environment;
import org.eclipse.papyrus.views.properties.environment.EnvironmentPackage;
import org.eclipse.papyrus.views.properties.environment.LayoutType;
import org.eclipse.papyrus.views.properties.environment.Namespace;
import org.eclipse.papyrus.views.properties.environment.PropertyEditorType;
import org.eclipse.papyrus.views.properties.environment.StandardWidgetType;
import org.eclipse.papyrus.views.properties.environment.Type;
import org.eclipse.papyrus.views.properties.environment.WidgetType;
import org.eclipse.papyrus.views.properties.extensions.ContextExtensionPoint;
import org.eclipse.papyrus.views.properties.extensions.EnvironmentExtensionPoint;
import org.eclipse.papyrus.views.properties.root.PropertiesRoot;
import org.eclipse.papyrus.views.properties.root.RootFactory;
import org.eclipse.papyrus.views.properties.runtime.ConfigurationConflict;
import org.eclipse.papyrus.views.properties.runtime.ViewConstraintEngine;
import org.eclipse.papyrus.views.properties.runtime.ViewConstraintEngineImpl;
import org.eclipse.papyrus.views.properties.runtime.preferences.ContextDescriptor;
import org.eclipse.papyrus.views.properties.runtime.preferences.Preferences;
import org.eclipse.papyrus.views.properties.runtime.preferences.PreferencesFactory;
import org.eclipse.papyrus.views.properties.util.PropertiesUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurationManager {
    private final Preferences preferences;
    private final PropertiesRoot root;
    private final ResourceSet resourceSet = new ResourceSetImpl();
    private boolean started = false;
    private final Map<URI, Context> contexts;
    private final Set<Context> enabledContexts;
    private final Map<Context, Boolean> customizableContexts;
    public ViewConstraintEngine constraintEngine = new ViewConstraintEngineImpl();
    public static final ConfigurationManager instance = new ConfigurationManager();

    private ConfigurationManager() {
        this.enabledContexts = new LinkedHashSet<Context>();
        this.customizableContexts = new HashMap<Context, Boolean>();
        this.contexts = new LinkedHashMap<URI, Context>();
        this.root = RootFactory.eINSTANCE.createPropertiesRoot();
        this.preferences = this.loadPreferences();
    }

    private void start() {
        if (this.started) {
            return;
        }
        this.started = true;
        new ContextExtensionPoint();
        new EnvironmentExtensionPoint();
        this.loadCustomContexts();
    }

    private EObject loadEMFModel(URI sourceURI) throws IOException {
        return EMFHelper.loadEMFModel((ResourceSet)this.resourceSet, (URI)sourceURI);
    }

    private Preferences loadPreferences() {
        IPath path = Activator.getDefault().getPreferencesPath();
        String preferencesPath = String.valueOf(path.toString()) + "/preferences.xmi";
        URI preferencesURI = URI.createFileURI((String)preferencesPath);
        try {
            EObject model = this.loadEMFModel(preferencesURI);
            if (model != null && model instanceof Preferences) {
                return (Preferences)model;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.createPreferences(preferencesURI);
    }

    private Preferences createPreferences(URI preferencesURI) {
        Preferences preferencesStore = PreferencesFactory.eINSTANCE.createPreferences();
        Resource resource = this.resourceSet.createResource(preferencesURI);
        resource.getContents().add((Object)preferencesStore);
        this.saveModel(preferencesStore);
        return preferencesStore;
    }

    private void loadCustomContexts() {
        IPath path = Activator.getDefault().getPreferencesPath();
        File preferencesDirectory = path.toFile();
        File[] fileArray = preferencesDirectory.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File contextDirectory = fileArray[n2];
            try {
                if (contextDirectory.isDirectory()) {
                    this.loadCustomContext(contextDirectory);
                }
            }
            catch (Exception ex) {
                Activator.log.error((Throwable)ex);
            }
            ++n2;
        }
    }

    public void refresh(File contextFile) {
        URI contextURI = URI.createFileURI((String)contextFile.getAbsolutePath());
        ResourceSetImpl tmpResourceSet = new ResourceSetImpl();
        try {
            EObject root = EMFHelper.loadEMFModel((ResourceSet)tmpResourceSet, (URI)contextURI);
            if (root != null) {
                for (Object rootObject : root.eResource().getContents()) {
                    if (!(rootObject instanceof Context)) continue;
                    this.refresh((Context)rootObject);
                }
            }
        }
        catch (IOException ex) {
            Activator.log.error((Throwable)ex);
        }
    }

    private void refresh(Context context) {
        URI contextURI = EcoreUtil.getURI((EObject)context);
        if (this.contexts.containsKey(contextURI)) {
            Context previousContext = this.contexts.get(contextURI);
            this.enabledContexts.remove(previousContext);
            previousContext.eResource().unload();
            try {
                this.addContext(contextURI);
                this.constraintEngine.refresh();
            }
            catch (IOException ex) {
                Activator.log.error((Throwable)ex);
            }
        }
    }

    private void loadCustomContext(File contextDirectory) throws IOException {
        String contextPath = String.valueOf(contextDirectory.getPath()) + "/" + contextDirectory.getName() + ".ctx";
        URI contextURI = URI.createFileURI((String)contextPath);
        try {
            EObject model = this.loadEMFModel(contextURI);
            if (model instanceof Context) {
                Context context = (Context)model;
                this.addContext(context, this.findDescriptor(context).isApplied(), true);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public boolean isApplied(Context context) {
        return !this.isCustomizable(context) || this.findDescriptor(context).isApplied();
    }

    private ContextDescriptor findDescriptor(Context context) {
        ContextDescriptor descriptor2;
        if (context.getName() == null || context.getName().equals("")) {
            return null;
        }
        for (ContextDescriptor descriptor2 : this.preferences.getContexts()) {
            if (!descriptor2.getName().equals(context.getName())) continue;
            return descriptor2;
        }
        descriptor2 = PreferencesFactory.eINSTANCE.createContextDescriptor();
        descriptor2.setName(context.getName());
        this.preferences.getContexts().add((Object)descriptor2);
        this.savePreferences();
        return descriptor2;
    }

    public void addContext(URI uri, boolean customizable) throws IOException {
        EObject firstRootObject = this.loadEMFModel(uri);
        if (firstRootObject != null) {
            for (EObject rootObject : firstRootObject.eResource().getContents()) {
                if (!(rootObject instanceof Context)) continue;
                Context context = (Context)rootObject;
                this.addContext(context, this.findDescriptor(context).isApplied(), customizable);
            }
        }
    }

    public void addContext(URI uri) throws IOException {
        this.addContext(uri, true);
    }

    public void addContext(Context context, boolean apply) {
        this.addContext(context, apply, true);
    }

    public void addContext(Context context, boolean apply, boolean isCustomizable) {
        this.customizableContexts.put(context, isCustomizable);
        this.contexts.put(EcoreUtil.getURI((EObject)context), context);
        if (apply || !isCustomizable) {
            this.enableContext(context, true);
        } else {
            this.disableContext(context, true);
        }
    }

    public Collection<Context> getEnabledContexts() {
        return this.enabledContexts;
    }

    public void disableContext(Context context, boolean update) {
        if (!this.isCustomizable(context)) {
            throw new IllegalStateException("Non-customizable contexts cannot be disabled. Trying to disable " + context.getName());
        }
        update = this.enabledContexts.remove(context) && update;
        ContextDescriptor descriptor = this.findDescriptor(context);
        if (descriptor.isApplied()) {
            descriptor.setApplied(false);
            this.savePreferences();
        }
        if (update) {
            this.update();
        }
    }

    public void enableContext(Context context, boolean update) {
        this.enabledContexts.add(context);
        ContextDescriptor descriptor = this.findDescriptor(context);
        if (!descriptor.isApplied()) {
            descriptor.setApplied(true);
            this.savePreferences();
        }
        if (update) {
            this.constraintEngine.addContext(context);
        }
    }

    public boolean isPlugin(Context context) {
        URI uri = EcoreUtil.getURI((EObject)context);
        boolean result = !uri.isFile() && !uri.isPlatformResource();
        return result;
    }

    public Context getContext(URI uri) throws IOException {
        return (Context)this.loadEMFModel(uri);
    }

    private void addEnvironment(Environment environment) {
        this.root.getEnvironments().add((Object)environment);
    }

    public void addEnvironment(URI uri) throws IOException {
        Environment environment = (Environment)this.loadEMFModel(uri);
        this.addEnvironment(environment);
    }

    public PropertiesRoot getPropertiesRoot() {
        return this.root;
    }

    public Context getContext(String contextName) {
        for (Context context : this.getContexts()) {
            if (!context.getName().equals(contextName)) continue;
            return context;
        }
        return null;
    }

    private void savePreferences() {
        this.saveModel(this.preferences);
    }

    private void saveModel(EObject eObject) {
        try {
            eObject.eResource().save(Collections.EMPTY_MAP);
        }
        catch (IOException ex) {
            Activator.log.error((Throwable)ex);
        }
    }

    public Collection<Context> getContexts() {
        return this.contexts.values();
    }

    public Collection<Context> getCustomizableContexts() {
        LinkedList<Context> result = new LinkedList<Context>();
        for (Context context : this.contexts.values()) {
            if (!this.isCustomizable(context)) continue;
            result.add(context);
        }
        return result;
    }

    private <T extends WidgetType> T getDefaultWidget(int featureID, Class<T> theClass, String widgetName, String namespacePrefix) {
        EStructuralFeature feature = EnvironmentPackage.Literals.ENVIRONMENT.getEStructuralFeature(featureID);
        for (Environment environment : this.root.getEnvironments()) {
            T widget = this.findWidgetTypeByClassName((Collection<T>)((EList)environment.eGet(feature)), widgetName, namespacePrefix);
            if (widget == null) continue;
            return widget;
        }
        return null;
    }

    private <T extends WidgetType> T findWidgetTypeByClassName(Collection<T> types, String className, String namespacePrefix) {
        for (WidgetType widgetType : types) {
            if (!widgetType.getWidgetClass().equals(className) || !PropertiesUtil.namespaceEqualsByName(widgetType.getNamespace(), namespacePrefix)) continue;
            return (T)widgetType;
        }
        return null;
    }

    public CompositeWidgetType getDefaultCompositeType() {
        return this.getDefaultWidget(4, CompositeWidgetType.class, "Composite", "");
    }

    public LayoutType getDefaultLayoutType() {
        return this.getDefaultWidget(5, LayoutType.class, "PropertiesLayout", "ppel");
    }

    public StandardWidgetType getDefaultWidgetType() {
        return this.getDefaultWidget(2, StandardWidgetType.class, "Label", "");
    }

    public PropertyEditorType getDefaultEditorType(Type propertyType, boolean multiple) {
        String propertyEditorName = null;
        switch (propertyType) {
            case BOOLEAN: {
                propertyEditorName = multiple ? "MultiBoolean" : "BooleanRadio";
                break;
            }
            case ENUMERATION: {
                propertyEditorName = multiple ? "MultiEnum" : "EnumCombo";
                break;
            }
            case INTEGER: {
                propertyEditorName = multiple ? "MultiInteger" : "IntegerEditor";
                break;
            }
            case REFERENCE: {
                propertyEditorName = multiple ? "MultiReference" : "ReferenceDialog";
                break;
            }
            case STRING: {
                String string = propertyEditorName = multiple ? "MultiString" : "StringEditor";
            }
        }
        if (propertyEditorName == null) {
            return null;
        }
        return this.getDefaultWidget(3, PropertyEditorType.class, propertyEditorName, "ppe");
    }

    public Set<Namespace> getBaseNamespaces() {
        HashSet<Namespace> result = new HashSet<Namespace>();
        result.add(this.getNamespaceByName(""));
        result.add(this.getNamespaceByName("x"));
        result.add(this.getNamespaceByName("j"));
        return result;
    }

    public Namespace getNamespaceByName(String name) {
        for (Environment environment : this.root.getEnvironments()) {
            for (Namespace namespace : environment.getNamespaces()) {
                if (!PropertiesUtil.namespaceEqualsByName(namespace, name)) continue;
                return namespace;
            }
        }
        Activator.log.warn("Cannot find a registered namespace for '" + name + "'");
        return null;
    }

    public PropertyEditorType getDefaultEditorType(Property property) {
        return this.getDefaultEditorType(property.getType(), property.getMultiplicity() != 1);
    }

    public void deleteContext(Context context) {
        if (!this.isCustomizable(context)) {
            throw new IllegalStateException("Non-customizable contexts cannot be deleted. Trying to delete " + context.getName());
        }
        Resource resource = context.eResource();
        this.contexts.remove(EcoreUtil.getURI((EObject)context));
        this.disableContext(context, true);
        this.root.getContexts().remove((Object)context);
        resource.unload();
        this.resourceSet.getResources().remove((Object)resource);
    }

    public static void init() {
        instance.start();
    }

    public Property getProperty(String propertyPath, Context context) {
        String elementName = propertyPath.substring(0, propertyPath.lastIndexOf(":"));
        String propertyName = propertyPath.substring(propertyPath.lastIndexOf(":") + 1, propertyPath.length());
        HashSet elements = new HashSet();
        Collection<Context> allContexts = context == null ? this.getContexts() : PropertiesUtil.getDependencies(context);
        for (Context ctx : allContexts) {
            elements.addAll(ctx.getDataContexts());
        }
        DataContextElement element = PropertiesUtil.getContextElementByQualifiedName(elementName, elements);
        if (element != null) {
            for (Property property : element.getProperties()) {
                if (!property.getName().equals(propertyName)) continue;
                return property;
            }
        }
        return null;
    }

    public void update() {
        this.constraintEngine.refresh();
    }

    public Collection<ConfigurationConflict> checkConflicts() {
        HashMap sections = new HashMap();
        HashMap<String, ConfigurationConflict> conflicts = new HashMap<String, ConfigurationConflict>();
        for (Context context : this.getEnabledContexts()) {
            for (Tab tab : context.getTabs()) {
                for (Section section : tab.getSections()) {
                    String sectionID = section.getName();
                    LinkedList<Context> contexts = (LinkedList<Context>)sections.get(sectionID);
                    if (contexts == null) {
                        contexts = new LinkedList<Context>();
                        sections.put(sectionID, contexts);
                    } else {
                        ConfigurationConflict conflict = (ConfigurationConflict)conflicts.get(sectionID);
                        if (conflict == null) {
                            conflict = new ConfigurationConflict(sectionID);
                            conflicts.put(sectionID, conflict);
                            conflict.addContext((Context)contexts.get(0));
                        }
                        conflict.addContext(context);
                    }
                    contexts.add(context);
                }
            }
        }
        return conflicts.values();
    }

    public ResourceSet getResourceSet() {
        return this.resourceSet;
    }

    public boolean isCustomizable(Context propertyViewConfiguration) {
        if (this.customizableContexts.containsKey(propertyViewConfiguration)) {
            return this.customizableContexts.get(propertyViewConfiguration);
        }
        return false;
    }
}

