/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor;

import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.internal.core.WorkspaceModelManager;
import org.eclipse.pde.internal.core.project.PDEProject;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.model.IWorkbenchAdapter;

public class OpenManifestHandler
extends AbstractHandler {
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection ssel = (IStructuredSelection)selection;
            Iterator it = ssel.iterator();
            final HashSet<IProject> projects = new HashSet<IProject>();
            while (it.hasNext()) {
                Object element = it.next();
                IProject proj = null;
                if (element instanceof IFile) {
                    proj = ((IFile)element).getProject();
                }
                if (proj == null && element instanceof IProject) {
                    proj = (IProject)element;
                }
                if (proj == null && element instanceof IAdaptable) {
                    IResource resource;
                    IAdaptable iAdaptable = (IAdaptable)element;
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = Class.forName("org.eclipse.core.resources.IResource");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if ((resource = (IResource)iAdaptable.getAdapter((Class)clazz)) != null) {
                        proj = resource.getProject();
                    }
                    if (proj == null) {
                        Object o;
                        IWorkbenchAdapter workbenchAdapter;
                        IAdaptable iAdaptable2 = (IAdaptable)element;
                        Class<?> clazz2 = class$1;
                        if (clazz2 == null) {
                            try {
                                clazz2 = Class.forName("org.eclipse.ui.model.IWorkbenchAdapter");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        if ((workbenchAdapter = (IWorkbenchAdapter)iAdaptable2.getAdapter((Class)clazz2)) != null && (o = workbenchAdapter.getParent(element)) instanceof IAdaptable) {
                            IAdaptable iAdaptable3 = (IAdaptable)o;
                            Class<?> clazz3 = class$0;
                            if (clazz3 == null) {
                                try {
                                    clazz3 = Class.forName("org.eclipse.core.resources.IResource");
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                }
                            }
                            if ((resource = (IResource)iAdaptable3.getAdapter((Class)clazz3)) != null) {
                                proj = resource.getProject();
                            }
                        }
                    }
                }
                if (proj == null || !WorkspaceModelManager.isPluginProject((IProject)proj)) continue;
                projects.add(proj);
            }
            if (projects.size() > 0) {
                BusyIndicator.showWhile((Display)PDEPlugin.getActiveWorkbenchShell().getDisplay(), (Runnable)new Runnable(){

                    public void run() {
                        Iterator it = projects.iterator();
                        while (it.hasNext()) {
                            IProject project = (IProject)it.next();
                            IFile file = PDEProject.getManifest((IProject)project);
                            if (file == null || !file.exists()) {
                                file = PDEProject.getPluginXml((IProject)project);
                            }
                            if (file == null || !file.exists()) {
                                file = PDEProject.getFragmentXml((IProject)project);
                            }
                            if (file == null || !file.exists()) {
                                MessageDialog.openError((Shell)PDEPlugin.getActiveWorkbenchShell(), (String)PDEUIMessages.OpenManifestsAction_title, (String)NLS.bind((String)PDEUIMessages.OpenManifestsAction_cannotFind, (Object)project.getName()));
                                continue;
                            }
                            try {
                                IDE.openEditor((IWorkbenchPage)PDEPlugin.getActivePage(), (IFile)file, (String)"org.eclipse.pde.ui.manifestEditor");
                            }
                            catch (PartInitException partInitException) {
                                MessageDialog.openError((Shell)PDEPlugin.getActiveWorkbenchShell(), (String)PDEUIMessages.OpenManifestsAction_title, (String)NLS.bind((String)PDEUIMessages.OpenManifestsAction_cannotOpen, (Object)project.getName()));
                            }
                        }
                    }
                });
            } else {
                MessageDialog.openInformation((Shell)PDEPlugin.getActiveWorkbenchShell(), (String)PDEUIMessages.OpenManifestsAction_title, (String)PDEUIMessages.OpenManifestAction_noManifest);
            }
        }
        return null;
    }
}

