/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.oxm;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import javax.xml.namespace.QName;
import javax.xml.transform.Result;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import org.eclipse.persistence.exceptions.XMLMarshalException;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.oxm.FragmentContentHandler;
import org.eclipse.persistence.internal.oxm.TreeObjectBuilder;
import org.eclipse.persistence.internal.oxm.XMLConversionManager;
import org.eclipse.persistence.internal.oxm.XMLObjectBuilder;
import org.eclipse.persistence.internal.oxm.XPathEngine;
import org.eclipse.persistence.internal.oxm.XPathFragment;
import org.eclipse.persistence.internal.oxm.record.DOMReader;
import org.eclipse.persistence.internal.oxm.record.namespaces.PrefixMapperNamespaceResolver;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.oxm.CharacterEscapeHandler;
import org.eclipse.persistence.oxm.JSONWithPadding;
import org.eclipse.persistence.oxm.MediaType;
import org.eclipse.persistence.oxm.NamespacePrefixMapper;
import org.eclipse.persistence.oxm.NamespaceResolver;
import org.eclipse.persistence.oxm.XMLContext;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.XMLField;
import org.eclipse.persistence.oxm.XMLMarshalListener;
import org.eclipse.persistence.oxm.XMLRoot;
import org.eclipse.persistence.oxm.attachment.XMLAttachmentMarshaller;
import org.eclipse.persistence.oxm.documentpreservation.DocumentPreservationPolicy;
import org.eclipse.persistence.oxm.record.ContentHandlerRecord;
import org.eclipse.persistence.oxm.record.FormattedOutputStreamRecord;
import org.eclipse.persistence.oxm.record.FormattedWriterRecord;
import org.eclipse.persistence.oxm.record.JSONFormattedWriterRecord;
import org.eclipse.persistence.oxm.record.JSONWriterRecord;
import org.eclipse.persistence.oxm.record.MarshalRecord;
import org.eclipse.persistence.oxm.record.NodeRecord;
import org.eclipse.persistence.oxm.record.OutputStreamRecord;
import org.eclipse.persistence.oxm.record.ValidatingMarshalRecord;
import org.eclipse.persistence.oxm.record.WriterRecord;
import org.eclipse.persistence.oxm.record.XMLRecord;
import org.eclipse.persistence.platform.xml.XMLPlatform;
import org.eclipse.persistence.platform.xml.XMLPlatformException;
import org.eclipse.persistence.platform.xml.XMLPlatformFactory;
import org.eclipse.persistence.platform.xml.XMLTransformer;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.ext.LexicalHandler;

public class XMLMarshaller
implements Cloneable {
    private static final String DEFAULT_XML_VERSION = "1.0";
    private String schemaLocation;
    private String noNamespaceSchemaLocation;
    private XMLTransformer transformer;
    private XMLContext xmlContext;
    private XMLMarshalListener marshalListener;
    private XMLAttachmentMarshaller attachmentMarshaller;
    private ErrorHandler errorHandler;
    private Properties marshalProperties;
    private Schema schema;
    private MediaType mediaType = MediaType.APPLICATION_XML;
    private char namespaceSeparator = (char)46;
    private String attributePrefix;
    private boolean includeRoot;
    private boolean marshalEmptyCollections;
    private String valueWrapper = "value";
    private NamespacePrefixMapper mapper;
    private String indentString;
    private CharacterEscapeHandler charEscapeHandler;
    private String xmlHeader;
    private boolean equalUsingIdenity = true;
    private static final String STAX_RESULT_CLASS_NAME = "javax.xml.transform.stax.StAXResult";
    private static final String GET_XML_STREAM_WRITER_METHOD_NAME = "getXMLStreamWriter";
    private static final String GET_XML_EVENT_WRITER_METHOD_NAME = "getXMLEventWriter";
    private static final String XML_STREAM_WRITER_RECORD_CLASS_NAME = "org.eclipse.persistence.oxm.record.XMLStreamWriterRecord";
    private static final String XML_EVENT_WRITER_RECORD_CLASS_NAME = "org.eclipse.persistence.oxm.record.XMLEventWriterRecord";
    private static final String XML_STREAM_WRITER_CLASS_NAME = "javax.xml.stream.XMLStreamWriter";
    private static final String XML_EVENT_WRITER_CLASS_NAME = "javax.xml.stream.XMLEventWriter";
    private static final String DOM_TO_STREAM_WRITER_CLASS_NAME = "org.eclipse.persistence.internal.oxm.record.DomToXMLStreamWriter";
    private static final String DOM_TO_EVENT_WRITER_CLASS_NAME = "org.eclipse.persistence.internal.oxm.record.DomToXMLEventWriter";
    private static final String WRITE_TO_STREAM_METHOD_NAME = "writeToStream";
    private static final String WRITE_TO_EVENT_WRITER_METHOD_NAME = "writeToEventWriter";
    private static Class staxResultClass;
    private static Method staxResultGetStreamWriterMethod;
    private static Method staxResultGetEventWriterMethod;
    private static Constructor xmlStreamWriterRecordConstructor;
    private static Constructor xmlEventWriterRecordConstructor;
    private static Method writeToStreamMethod;
    private static Method writeToEventWriterMethod;
    private static Class domToStreamWriterClass;
    private static Class domToEventWriterClass;

    static {
        try {
            staxResultClass = PrivilegedAccessHelper.getClassForName(STAX_RESULT_CLASS_NAME);
            if (staxResultClass != null) {
                staxResultGetStreamWriterMethod = PrivilegedAccessHelper.getDeclaredMethod(staxResultClass, GET_XML_STREAM_WRITER_METHOD_NAME, new Class[0]);
                staxResultGetEventWriterMethod = PrivilegedAccessHelper.getDeclaredMethod(staxResultClass, GET_XML_EVENT_WRITER_METHOD_NAME, new Class[0]);
            }
            Class streamWriterRecordClass = PrivilegedAccessHelper.getClassForName(XML_STREAM_WRITER_RECORD_CLASS_NAME);
            Class streamWriterClass = PrivilegedAccessHelper.getClassForName(XML_STREAM_WRITER_CLASS_NAME);
            xmlStreamWriterRecordConstructor = PrivilegedAccessHelper.getConstructorFor(streamWriterRecordClass, new Class[]{streamWriterClass}, true);
            Class eventWriterRecordClass = PrivilegedAccessHelper.getClassForName(XML_EVENT_WRITER_RECORD_CLASS_NAME);
            Class eventWriterClass = PrivilegedAccessHelper.getClassForName(XML_EVENT_WRITER_CLASS_NAME);
            xmlEventWriterRecordConstructor = PrivilegedAccessHelper.getConstructorFor(eventWriterRecordClass, new Class[]{eventWriterClass}, true);
            domToStreamWriterClass = PrivilegedAccessHelper.getClassForName(DOM_TO_STREAM_WRITER_CLASS_NAME);
            writeToStreamMethod = PrivilegedAccessHelper.getMethod(domToStreamWriterClass, WRITE_TO_STREAM_METHOD_NAME, new Class[]{ClassConstants.NODE, ClassConstants.STRING, ClassConstants.STRING, streamWriterClass}, true);
            domToEventWriterClass = PrivilegedAccessHelper.getClassForName(DOM_TO_EVENT_WRITER_CLASS_NAME);
            writeToEventWriterMethod = PrivilegedAccessHelper.getMethod(domToEventWriterClass, WRITE_TO_EVENT_WRITER_METHOD_NAME, new Class[]{ClassConstants.NODE, ClassConstants.STRING, ClassConstants.STRING, eventWriterClass}, true);
        }
        catch (Exception exception) {}
    }

    public XMLMarshaller(XMLContext xmlContext) {
        this.setXMLContext(xmlContext);
        this.initialize();
    }

    private void initialize() {
        XMLPlatform xmlPlatform = XMLPlatformFactory.getInstance().getXMLPlatform();
        this.transformer = xmlPlatform.newXMLTransformer();
        this.setEncoding("UTF-8");
        this.setFormattedOutput(true);
        this.marshalProperties = new Properties();
        this.includeRoot = true;
        this.marshalEmptyCollections = true;
        this.indentString = "   ";
    }

    public XMLContext getXMLContext() {
        return this.xmlContext;
    }

    public void setXMLContext(XMLContext value) {
        this.xmlContext = value;
    }

    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public boolean isFormattedOutput() {
        return this.transformer.isFormattedOutput();
    }

    public void setFormattedOutput(boolean shouldFormat) {
        this.transformer.setFormattedOutput(shouldFormat);
    }

    public String getEncoding() {
        return this.transformer.getEncoding();
    }

    public void setEncoding(String newEncoding) {
        this.transformer.setEncoding(newEncoding);
    }

    public void setMediaType(MediaType mediaType) {
        this.mediaType = mediaType;
    }

    public MediaType getMediaType() {
        return this.mediaType;
    }

    public String getSchemaLocation() {
        return this.schemaLocation;
    }

    public void setSchemaLocation(String newSchemaLocation) {
        this.schemaLocation = newSchemaLocation;
    }

    public String getNoNamespaceSchemaLocation() {
        return this.noNamespaceSchemaLocation;
    }

    public Properties getProperties() {
        return this.marshalProperties;
    }

    public Object getProperty(Object key) {
        return this.marshalProperties.get(key);
    }

    public void setNoNamespaceSchemaLocation(String newNoNamespaceSchemaLocation) {
        this.noNamespaceSchemaLocation = newNoNamespaceSchemaLocation;
    }

    public void setXMLMarshalHandler(XMLMarshalListener marshalListener) {
        this.marshalListener = marshalListener;
    }

    public XMLMarshalListener getMarshalListener() {
        return this.marshalListener;
    }

    public void setMarshalListener(XMLMarshalListener listener) {
        this.marshalListener = listener;
    }

    /*
     * Unable to fully structure code
     */
    public void marshal(Object object, Result result) throws XMLMarshalException {
        block47: {
            block48: {
                block46: {
                    if (object == null || result == null) {
                        throw XMLMarshalException.nullArgumentException();
                    }
                    xmlDescriptor = null;
                    session = null;
                    isXMLRoot = object instanceof XMLRoot;
                    if (isXMLRoot) {
                        try {
                            session = this.xmlContext.getSession(((XMLRoot)object).getObject());
                            if (session == null) ** GOTO lbl18
                            xmlDescriptor = this.getDescriptor(((XMLRoot)object).getObject(), session);
                        }
                        catch (XMLMarshalException marshalException) {
                            if (this.isSimpleXMLRoot((XMLRoot)object)) ** GOTO lbl18
                            throw marshalException;
                        }
                    } else {
                        objectClass = object.getClass();
                        session = this.xmlContext.getSession(objectClass);
                        xmlDescriptor = this.getDescriptor(objectClass, session);
                    }
lbl18:
                    // 4 sources

                    if (isXMLRoot && ((XMLRoot)object).getObject() instanceof Node || session != null && this.xmlContext.getDocumentPreservationPolicy(session).shouldPreserveDocument()) break block48;
                    if (!(result instanceof StreamResult)) ** GOTO lbl47
                    streamResult = (StreamResult)result;
                    writer = streamResult.getWriter();
                    if (writer != null) {
                        this.marshal(object, writer, session, xmlDescriptor);
                    } else if (streamResult.getOutputStream() != null) {
                        this.marshal(object, streamResult.getOutputStream(), session, xmlDescriptor);
                    } else {
                        try {
                            try {
                                f = new File(new URL(streamResult.getSystemId()).toURI());
                            }
                            catch (MalformedURLException malformedURLException) {
                                try {
                                    f = new File(streamResult.getSystemId());
                                }
                                catch (Exception v0) {
                                    throw malformedURLException;
                                }
                            }
                            writer = new FileWriter(f);
                            try {
                                this.marshal(object, writer, session, xmlDescriptor);
                                break block46;
                            }
                            finally {
                                writer.close();
                            }
                        }
                        catch (Exception e) {
                            throw XMLMarshalException.marshalException(e);
                        }
lbl47:
                        // 1 sources

                        if (result instanceof DOMResult) {
                            domResult = (DOMResult)result;
                            if (domResult.getNode() == null) {
                                domResult.setNode(this.objectToXML(object));
                            } else {
                                this.marshal(object, domResult.getNode());
                            }
                        } else if (result instanceof SAXResult) {
                            saxResult = (SAXResult)result;
                            this.marshal(object, saxResult.getHandler());
                        } else {
                            if (result.getClass().equals(XMLMarshaller.staxResultClass)) {
                                try {
                                    xmlStreamWriter = PrivilegedAccessHelper.invokeMethod(XMLMarshaller.staxResultGetStreamWriterMethod, result);
                                    if (xmlStreamWriter != null) {
                                        record = (MarshalRecord)PrivilegedAccessHelper.invokeConstructor(XMLMarshaller.xmlStreamWriterRecordConstructor, new Object[]{xmlStreamWriter});
                                        record.setMarshaller(this);
                                        this.marshal(object, record, session, xmlDescriptor, isXMLRoot);
                                        return;
                                    }
                                    xmlEventWriter = PrivilegedAccessHelper.invokeMethod(XMLMarshaller.staxResultGetEventWriterMethod, result);
                                    if (xmlEventWriter != null) {
                                        record = (MarshalRecord)PrivilegedAccessHelper.invokeConstructor(XMLMarshaller.xmlEventWriterRecordConstructor, new Object[]{xmlEventWriter});
                                        record.setMarshaller(this);
                                        this.marshal(object, record, session, xmlDescriptor, isXMLRoot);
                                        return;
                                    }
                                }
                                catch (Exception e) {
                                    throw XMLMarshalException.marshalException(e);
                                }
                            }
                            writer = new StringWriter();
                            this.marshal(object, writer);
                            source = new StreamSource(new StringReader(writer.toString()));
                            this.transformer.transform(source, result);
                        }
                    }
                }
                return;
            }
            try {
                document = null;
                document = isXMLRoot != false && session == null ? ((Node)((XMLRoot)object).getObject()).getOwnerDocument() : this.objectToXML(object, xmlDescriptor, isXMLRoot);
                if (result instanceof SAXResult && this.isFragment()) {
                    fragmentHandler = new FragmentContentHandler(((SAXResult)result).getHandler());
                    if (isXMLRoot) {
                        oldEncoding = this.transformer.getEncoding();
                        oldVersion = this.transformer.getVersion();
                        if (((XMLRoot)object).getEncoding() != null) {
                            this.transformer.setEncoding(((XMLRoot)object).getEncoding());
                        }
                        if (((XMLRoot)object).getXMLVersion() != null) {
                            this.transformer.setVersion(((XMLRoot)object).getXMLVersion());
                        }
                        this.transformer.transform((Node)document, fragmentHandler);
                        this.transformer.setEncoding(oldEncoding);
                        this.transformer.setVersion(oldVersion);
                    } else {
                        this.transformer.transform((Node)document, fragmentHandler);
                    }
                    break block47;
                }
                if (result.getClass().equals(XMLMarshaller.staxResultClass)) {
                    try {
                        namespace = null;
                        localName = null;
                        if (isXMLRoot && (xmlRootObject = (XMLRoot)object).getObject() != null && xmlRootObject.getObject() instanceof Node) {
                            namespace = ((XMLRoot)object).getNamespaceURI();
                            localName = ((XMLRoot)object).getLocalName();
                        }
                        if ((xmlStreamWriter = PrivilegedAccessHelper.invokeMethod(XMLMarshaller.staxResultGetStreamWriterMethod, result)) != null) {
                            domtostax = PrivilegedAccessHelper.newInstanceFromClass(XMLMarshaller.domToStreamWriterClass);
                            PrivilegedAccessHelper.invokeMethod(XMLMarshaller.writeToStreamMethod, domtostax, new Object[]{document, namespace, localName, xmlStreamWriter});
                            return;
                        }
                        xmlEventWriter = PrivilegedAccessHelper.invokeMethod(XMLMarshaller.staxResultGetEventWriterMethod, result);
                        if (xmlEventWriter != null) {
                            domToEventWriter = PrivilegedAccessHelper.newInstanceFromClass(XMLMarshaller.domToEventWriterClass);
                            PrivilegedAccessHelper.invokeMethod(XMLMarshaller.writeToEventWriterMethod, domToEventWriter, new Object[]{document, namespace, localName, xmlEventWriter});
                            return;
                        }
                    }
                    catch (Exception e) {
                        throw XMLMarshalException.marshalException(e);
                    }
                }
                if (isXMLRoot) {
                    oldEncoding = this.transformer.getEncoding();
                    oldVersion = this.transformer.getVersion();
                    if (((XMLRoot)object).getEncoding() != null) {
                        this.transformer.setEncoding(((XMLRoot)object).getEncoding());
                    }
                    if (((XMLRoot)object).getXMLVersion() != null) {
                        this.transformer.setVersion(((XMLRoot)object).getXMLVersion());
                    }
                    this.transformer.transform((Node)document, result);
                    this.transformer.setEncoding(oldEncoding);
                    this.transformer.setVersion(oldVersion);
                } else {
                    this.transformer.transform((Node)document, result);
                }
            }
            catch (XMLPlatformException e) {
                throw XMLMarshalException.marshalException(e);
            }
        }
    }

    public void marshal(Object object, OutputStream outputStream) throws XMLMarshalException {
        this.marshal(object, outputStream, null, null);
    }

    /*
     * Unable to fully structure code
     */
    private void marshal(Object object, OutputStream outputStream, AbstractSession session, XMLDescriptor xmlDescriptor) throws XMLMarshalException {
        block23: {
            if (object instanceof JSONWithPadding && MediaType.APPLICATION_XML == this.mediaType) {
                object = ((JSONWithPadding)object).getObject();
            }
            if (object == null || outputStream == null) {
                throw XMLMarshalException.nullArgumentException();
            }
            try {
                encoding = this.getEncoding();
                isXMLRoot = false;
                version = "1.0";
                if (object instanceof XMLRoot) {
                    isXMLRoot = true;
                    xroot = (XMLRoot)object;
                    version = xroot.getXMLVersion() != null ? xroot.getXMLVersion() : version;
                    v0 = encoding = xroot.getEncoding() != null ? xroot.getEncoding() : encoding;
                }
                if (MediaType.APPLICATION_JSON == this.mediaType) {
                    this.marshal(object, new OutputStreamWriter(outputStream, encoding), session, xmlDescriptor);
                    return;
                }
                if (encoding.equals("UTF-8")) {
                    if (session == null || xmlDescriptor == null) {
                        if (isXMLRoot) {
                            try {
                                session = this.xmlContext.getSession(((XMLRoot)object).getObject());
                                if (session == null) ** GOTO lbl31
                                xmlDescriptor = this.getDescriptor(((XMLRoot)object).getObject(), session);
                            }
                            catch (XMLMarshalException marshalException) {
                                if (this.isSimpleXMLRoot((XMLRoot)object)) ** GOTO lbl31
                                throw marshalException;
                            }
                        } else {
                            objectClass = object.getClass();
                            session = this.xmlContext.getSession(objectClass);
                            xmlDescriptor = this.getDescriptor(objectClass, session);
                        }
                    }
lbl31:
                    // 6 sources

                    record = this.isFormattedOutput() != false ? new FormattedOutputStreamRecord() : new OutputStreamRecord();
                    record.setMarshaller(this);
                    record.setOutputStream(outputStream);
                    if (!(isXMLRoot && ((XMLRoot)object).getObject() instanceof Node || session != null && this.xmlContext.getDocumentPreservationPolicy(session).shouldPreserveDocument())) {
                        this.marshal(object, record, session, xmlDescriptor, isXMLRoot);
                    } else {
                        try {
                            xmlDocument = null;
                            rootUri = null;
                            rootLocalName = null;
                            if (isXMLRoot && session == null) {
                                xmlDocument = (Node)((XMLRoot)object).getObject();
                                rootUri = ((XMLRoot)object).getNamespaceURI();
                                rootLocalName = ((XMLRoot)object).getLocalName();
                            } else {
                                xmlDocument = this.objectToXMLNode(object, session, xmlDescriptor, isXMLRoot);
                            }
                            record.setSession(session);
                            if (this.isFragment()) {
                                if (xmlDescriptor == null) {
                                    record.node(xmlDocument, null, rootUri, rootLocalName);
                                } else {
                                    record.node(xmlDocument, xmlDescriptor.getNamespaceResolver(), rootUri, rootLocalName);
                                }
                            } else {
                                record.startDocument(encoding, version);
                                record.node(xmlDocument, record.getNamespaceResolver(), rootUri, rootLocalName);
                                record.endDocument();
                            }
                        }
                        catch (XMLPlatformException e) {
                            throw XMLMarshalException.marshalException(e);
                        }
                    }
                    record.flush();
                    break block23;
                }
                writer = new OutputStreamWriter(outputStream, encoding);
                this.marshal(object, writer);
                writer.flush();
            }
            catch (UnsupportedEncodingException exception) {
                throw XMLMarshalException.marshalException(exception);
            }
            catch (Exception ex) {
                throw XMLMarshalException.marshalException(ex);
            }
        }
    }

    public void marshal(Object object, Writer writer) throws XMLMarshalException {
        this.marshal(object, writer, null, null);
    }

    /*
     * Unable to fully structure code
     */
    private void marshal(Object object, Writer writer, AbstractSession session, XMLDescriptor xmlDescriptor) throws XMLMarshalException {
        if (object == null || writer == null) {
            throw XMLMarshalException.nullArgumentException();
        }
        isXMLRoot = false;
        version = "1.0";
        encoding = this.getEncoding();
        callbackName = null;
        if (object instanceof JSONWithPadding) {
            callbackName = ((JSONWithPadding)object).getCallbackName();
            if ((object = ((JSONWithPadding)object).getObject()) == null) {
                throw XMLMarshalException.nullArgumentException();
            }
        }
        if (object instanceof XMLRoot) {
            isXMLRoot = true;
            xroot = (XMLRoot)object;
            version = xroot.getXMLVersion() != null ? xroot.getXMLVersion() : version;
            encoding = xroot.getEncoding() != null ? xroot.getEncoding() : encoding;
        }
        writer = new BufferedWriter(writer);
        if (this.isFormattedOutput()) {
            if (MediaType.APPLICATION_JSON == this.mediaType) {
                writerRecord = new JSONFormattedWriterRecord(writer, callbackName);
            } else {
                writerRecord = new FormattedWriterRecord();
                writerRecord.setWriter(writer);
            }
        } else if (MediaType.APPLICATION_JSON == this.mediaType) {
            writerRecord = new JSONWriterRecord(writer, callbackName);
        } else {
            writerRecord = new WriterRecord();
            ((WriterRecord)writerRecord).setWriter(writer);
        }
        writerRecord.setMarshaller(this);
        rootName = null;
        rootNamespace = null;
        if (isXMLRoot) {
            rootName = ((XMLRoot)object).getLocalName();
            rootNamespace = ((XMLRoot)object).getNamespaceURI();
            if (session == null || xmlDescriptor == null) {
                try {
                    session = this.xmlContext.getSession(((XMLRoot)object).getObject());
                    if (session == null) ** GOTO lbl76
                    xmlDescriptor = this.getDescriptor(((XMLRoot)object).getObject(), session);
                }
                catch (XMLMarshalException marshalException) {
                    if (this.isSimpleXMLRoot((XMLRoot)object)) ** GOTO lbl76
                    throw marshalException;
                }
            }
        } else {
            objectClass = object.getClass();
            if (object instanceof Collection) {
                try {
                    writerRecord.startCollection();
                    for (E o : (Collection)object) {
                        this.marshal(o, writerRecord);
                    }
                    writerRecord.endCollection();
                    writer.flush();
                }
                catch (IOException e) {
                    throw XMLMarshalException.marshalException(e);
                }
                return;
            }
            if (objectClass.isArray()) {
                try {
                    writerRecord.startCollection();
                    arrayLength = Array.getLength(object);
                    x = 0;
                    while (x < arrayLength) {
                        this.marshal(Array.get(object, x), writerRecord);
                        ++x;
                    }
                    writerRecord.endCollection();
                    writer.flush();
                }
                catch (IOException e) {
                    throw XMLMarshalException.marshalException(e);
                }
                return;
            }
            if (session == null || xmlDescriptor == null) {
                session = this.xmlContext.getSession(objectClass);
                xmlDescriptor = this.getDescriptor(objectClass, session);
            }
        }
lbl76:
        // 7 sources

        if (!(isXMLRoot && ((XMLRoot)object).getObject() instanceof Node || session != null && this.xmlContext.getDocumentPreservationPolicy(session).shouldPreserveDocument())) {
            this.marshal(object, writerRecord, session, xmlDescriptor, isXMLRoot);
        } else {
            try {
                xmlDocument = null;
                xmlDocument = isXMLRoot != false && session == null ? (Node)((XMLRoot)object).getObject() : this.objectToXMLNode(object, session, xmlDescriptor, isXMLRoot);
                writerRecord.setSession(session);
                if (this.isFragment()) {
                    if (xmlDescriptor == null) {
                        writerRecord.node(xmlDocument, null, rootNamespace, rootName);
                    } else {
                        writerRecord.node(xmlDocument, xmlDescriptor.getNamespaceResolver(), rootNamespace, rootName);
                    }
                } else {
                    writerRecord.startDocument(encoding, version);
                    writerRecord.node(xmlDocument, writerRecord.getNamespaceResolver(), rootNamespace, rootName);
                    writerRecord.endDocument();
                }
            }
            catch (XMLPlatformException e) {
                throw XMLMarshalException.marshalException(e);
            }
        }
        try {
            writer.flush();
        }
        catch (IOException e) {
            throw XMLMarshalException.marshalException(e);
        }
    }

    public void marshal(Object object, ContentHandler contentHandler) throws XMLMarshalException {
        this.marshal(object, contentHandler, null);
    }

    /*
     * Unable to fully structure code
     */
    public void marshal(Object object, ContentHandler contentHandler, LexicalHandler lexicalHandler) throws XMLMarshalException {
        if (object instanceof JSONWithPadding && MediaType.APPLICATION_XML == this.mediaType) {
            object = ((JSONWithPadding)object).getObject();
        }
        if (object == null || contentHandler == null) {
            throw XMLMarshalException.nullArgumentException();
        }
        isXMLRoot = object instanceof XMLRoot;
        session = null;
        xmlDescriptor = null;
        if (isXMLRoot) {
            try {
                session = this.xmlContext.getSession(((XMLRoot)object).getObject());
                if (session == null) ** GOTO lbl20
                xmlDescriptor = this.getDescriptor(((XMLRoot)object).getObject(), session);
            }
            catch (XMLMarshalException marshalException) {
                if (this.isSimpleXMLRoot((XMLRoot)object)) ** GOTO lbl20
                throw marshalException;
            }
        } else {
            objectClass = object.getClass();
            session = this.xmlContext.getSession(objectClass);
            xmlDescriptor = this.getDescriptor(objectClass, session);
        }
lbl20:
        // 4 sources

        if (!(isXMLRoot && ((XMLRoot)object).getObject() instanceof Node || session != null && this.xmlContext.getDocumentPreservationPolicy(session).shouldPreserveDocument())) {
            contentHandlerRecord = new ContentHandlerRecord();
            contentHandlerRecord.setMarshaller(this);
            contentHandlerRecord.setContentHandler(contentHandler);
            contentHandlerRecord.setLexicalHandler(lexicalHandler);
            this.marshal(object, contentHandlerRecord, session, xmlDescriptor, isXMLRoot);
            return;
        }
        try {
            xmlDocument = null;
            name = null;
            namespace = null;
            if (session == null) {
                xmlDocument = (Node)((XMLRoot)object).getObject();
                namespace = ((XMLRoot)object).getNamespaceURI();
                name = ((XMLRoot)object).getLocalName();
            } else {
                xmlDocument = this.objectToXML(object, xmlDescriptor, isXMLRoot);
            }
            reader = new DOMReader();
            reader.setProperty("http://xml.org/sax/properties/lexical-handler", lexicalHandler);
            if (this.isFragment()) {
                fragmentHandler = new FragmentContentHandler(contentHandler);
                reader.setContentHandler(fragmentHandler);
            } else {
                reader.setContentHandler(contentHandler);
            }
            reader.parse(xmlDocument, namespace, name);
        }
        catch (XMLPlatformException e) {
            throw XMLMarshalException.marshalException(e);
        }
        catch (SAXNotRecognizedException v0) {
        }
        catch (SAXNotSupportedException v1) {
        }
        catch (SAXException e) {
            throw XMLMarshalException.marshalException(e);
        }
    }

    /*
     * Unable to fully structure code
     */
    public void marshal(Object object, Node node) throws XMLMarshalException {
        if (object instanceof JSONWithPadding && MediaType.APPLICATION_XML == this.mediaType) {
            object = ((JSONWithPadding)object).getObject();
        }
        if (object == null || node == null) {
            throw XMLMarshalException.nullArgumentException();
        }
        try {
            isXMLRoot = object instanceof XMLRoot;
            session = null;
            xmlDescriptor = null;
            if (isXMLRoot) {
                try {
                    session = this.xmlContext.getSession(((XMLRoot)object).getObject());
                    if (session == null) ** GOTO lbl21
                    xmlDescriptor = this.getDescriptor(((XMLRoot)object).getObject(), session);
                }
                catch (XMLMarshalException marshalException) {
                    if (this.isSimpleXMLRoot((XMLRoot)object)) ** GOTO lbl21
                    throw marshalException;
                }
            } else {
                objectClass = object.getClass();
                session = this.xmlContext.getSession(objectClass);
                xmlDescriptor = this.getDescriptor(objectClass, session);
            }
lbl21:
            // 4 sources

            if (!(isXMLRoot && ((XMLRoot)object).getObject() instanceof Node || session != null && this.xmlContext.getDocumentPreservationPolicy(session).shouldPreserveDocument())) {
                nodeRecord = new NodeRecord(node);
                nodeRecord.setMarshaller(this);
                if (!isXMLRoot && xmlDescriptor.getDefaultRootElement() == null && node.getNodeType() == 1 && xmlDescriptor.getSchemaReference() != null && xmlDescriptor.getSchemaReference().getType() == 1) {
                    typeAttr = ((Element)node).getAttributeNodeNS("http://www.w3.org/2001/XMLSchema-instance", "type");
                    if (typeAttr == null) {
                        namespaceResolver = xmlDescriptor.getNamespaceResolver();
                        xsiPrefix = null;
                        if (namespaceResolver == null) {
                            namespaceResolver = new NamespaceResolver();
                            xmlDescriptor.setNamespaceResolver(namespaceResolver);
                        } else {
                            xsiPrefix = namespaceResolver.resolveNamespaceURI("http://www.w3.org/2001/XMLSchema-instance");
                        }
                        if (xsiPrefix == null) {
                            xsiPrefix = namespaceResolver.generatePrefix("xsi");
                        }
                        value = xmlDescriptor.getSchemaReference().getSchemaContext();
                        ((Element)node).setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + xsiPrefix, "http://www.w3.org/2001/XMLSchema-instance");
                        ((Element)node).setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", String.valueOf(xsiPrefix) + ':' + "type", value);
                    } else {
                        value = xmlDescriptor.getSchemaReference().getSchemaContext();
                        typeAttr.setValue(value);
                    }
                }
                this.marshal(object, nodeRecord, session, xmlDescriptor, isXMLRoot);
                return;
            }
            doc = null;
            doc = isXMLRoot != false && session == null ? (Node)((XMLRoot)object).getObject() : this.objectToXMLNode(object, node, session, xmlDescriptor, isXMLRoot);
            if (isXMLRoot) {
                xmlRootObject = (XMLRoot)object;
                if (node.getNodeType() == 9) {
                    this.transformChildren(doc, (Document)node, (Document)node, xmlRootObject.getNamespaceURI(), xmlRootObject.getLocalName());
                } else {
                    this.transformChildren(doc, node.getOwnerDocument(), node, xmlRootObject.getNamespaceURI(), xmlRootObject.getLocalName());
                }
            } else {
                if (doc.getNodeType() == 9) {
                    doc = ((Document)doc).getDocumentElement();
                }
                if (node.getNodeType() == 9) {
                    imported = ((Document)node).importNode(doc, true);
                    node.appendChild(imported);
                } else {
                    imported = node.getOwnerDocument().importNode(doc, true);
                    node.appendChild(imported);
                }
            }
        }
        catch (Exception exception) {
            if (exception instanceof XMLMarshalException) {
                throw (XMLMarshalException)exception;
            }
            throw XMLMarshalException.marshalException(exception);
        }
    }

    private void transformChildren(Node sourceNode, Document targetDoc, Node targetNode, String namespace, String name) {
        Element sourceElement = null;
        String xmlRootQualifiedName = name;
        if (sourceNode.getNodeType() == 9) {
            sourceElement = ((Document)sourceNode).getDocumentElement();
        } else if (sourceNode.getNodeType() == 1) {
            sourceElement = (Element)sourceNode;
        }
        NamespaceResolver sourceNR = new NamespaceResolver();
        sourceNR.setDOM(sourceElement);
        NamespaceResolver targetNR = new NamespaceResolver();
        targetNR.setDOM(targetDoc.getDocumentElement());
        String prefix = this.getPrefix(namespace, sourceNR, sourceElement);
        if (prefix != null && prefix.length() > 0) {
            xmlRootQualifiedName = String.valueOf(prefix) + ':' + name;
        }
        Element newElement = targetDoc.createElementNS(namespace, xmlRootQualifiedName);
        if (prefix != null && prefix.length() > 0 && targetNR.resolveNamespaceURI(namespace) == null) {
            newElement.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + prefix, namespace);
        }
        targetNode.appendChild(newElement);
        this.copyAttributes(sourceElement.getAttributes(), sourceElement, newElement, sourceNR, targetNR);
        NodeList children = sourceElement.getChildNodes();
        if (children != null) {
            int childrenSize = children.getLength();
            int i = 0;
            while (i < childrenSize) {
                Node nextChild = children.item(i);
                Node imported = targetDoc.importNode(nextChild, true);
                newElement.appendChild(imported);
                ++i;
            }
        }
    }

    private String getPrefix(String namespace, NamespaceResolver sourceNR, Element sourceElement) {
        if (namespace == null) {
            return null;
        }
        String prefix = sourceNR.resolveNamespaceURI(namespace);
        if (prefix == null) {
            String defaultNamespace = sourceElement.getAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns");
            prefix = defaultNamespace == null ? sourceNR.generatePrefix() : (defaultNamespace != namespace ? sourceNR.generatePrefix() : "");
        }
        return prefix;
    }

    private void copyAttributes(NamedNodeMap attrs, Element sourceElement, Element newElement, NamespaceResolver sourceNR, NamespaceResolver targetNR) {
        int i = 0;
        while (i < attrs.getLength()) {
            String prefix;
            Attr nextAttr = (Attr)attrs.item(i);
            String name = nextAttr.getLocalName();
            String uri = nextAttr.getNamespaceURI();
            if (!"xmlns".equals(name) && (prefix = this.getPrefix(uri, sourceNR, sourceElement)) != null && prefix.length() > 0) {
                name = String.valueOf(prefix) + ':' + name;
                if (targetNR.resolveNamespaceURI(uri) == null) {
                    newElement.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + prefix, uri);
                }
            }
            newElement.setAttributeNS(uri, name, nextAttr.getValue());
            ++i;
        }
    }

    /*
     * Unable to fully structure code
     */
    public void marshal(Object object, MarshalRecord marshalRecord) {
        if (object instanceof JSONWithPadding && MediaType.APPLICATION_XML == this.mediaType) {
            object = ((JSONWithPadding)object).getObject();
        }
        if (object == null || marshalRecord == null) {
            throw XMLMarshalException.nullArgumentException();
        }
        isXMLRoot = object instanceof XMLRoot;
        session = null;
        xmlDescriptor = null;
        if (isXMLRoot) {
            try {
                session = this.xmlContext.getSession(((XMLRoot)object).getObject());
                if (session == null) ** GOTO lbl20
                xmlDescriptor = this.getDescriptor(((XMLRoot)object).getObject(), session);
            }
            catch (XMLMarshalException marshalException) {
                if (this.isSimpleXMLRoot((XMLRoot)object)) ** GOTO lbl20
                throw marshalException;
            }
        } else {
            objectClass = object.getClass();
            session = this.xmlContext.getSession(objectClass);
            xmlDescriptor = this.getDescriptor(objectClass, session);
        }
lbl20:
        // 4 sources

        this.marshal(object, marshalRecord, session, xmlDescriptor, isXMLRoot);
    }

    protected void marshal(Object object, AbstractSession session, MarshalRecord marshalRecord) {
        boolean isXMLRoot = object instanceof XMLRoot;
        this.marshal(object, marshalRecord, session, this.getDescriptor(object, isXMLRoot), isXMLRoot);
    }

    private void marshal(Object object, MarshalRecord marshalRecord, AbstractSession session, XMLDescriptor descriptor, boolean isXMLRoot) {
        if (this.schema != null) {
            marshalRecord = new ValidatingMarshalRecord(marshalRecord, this);
        }
        if (this.attachmentMarshaller != null) {
            marshalRecord.setXOPPackage(this.attachmentMarshaller.isXOPPackage());
        }
        marshalRecord.setMarshaller(this);
        if (this.mapper == null) {
            this.addDescriptorNamespacesToXMLRecord(descriptor, marshalRecord);
        } else if (this.mapper != null) {
            if (descriptor == null) {
                marshalRecord.setNamespaceResolver(new PrefixMapperNamespaceResolver(this.mapper, null));
            } else {
                marshalRecord.setNamespaceResolver(new PrefixMapperNamespaceResolver(this.mapper, descriptor.getNamespaceResolver()));
            }
            marshalRecord.setCustomNamespaceMapper(true);
        }
        NamespaceResolver nr = marshalRecord.getNamespaceResolver();
        XMLRoot root = null;
        if (isXMLRoot) {
            root = (XMLRoot)object;
        }
        marshalRecord.beforeContainmentMarshal(object);
        if (!this.isFragment()) {
            String encoding = this.getEncoding();
            String version = DEFAULT_XML_VERSION;
            if (!isXMLRoot && descriptor != null) {
                marshalRecord.setLeafElementType(descriptor.getDefaultRootElementType());
            } else {
                if (root.getEncoding() != null) {
                    encoding = root.getEncoding();
                }
                if (root.getXMLVersion() != null) {
                    version = root.getXMLVersion();
                }
            }
            marshalRecord.startDocument(encoding, version);
        }
        if (this.getXmlHeader() != null) {
            marshalRecord.writeHeader();
        }
        if (isXMLRoot && root.getObject() instanceof Node) {
            marshalRecord.node((Node)root.getObject(), new NamespaceResolver(), root.getNamespaceURI(), root.getLocalName());
            marshalRecord.endDocument();
            return;
        }
        XPathFragment rootFragment = this.buildRootFragment(object, descriptor, isXMLRoot, marshalRecord);
        String schemaLocation = this.getSchemaLocation();
        String noNsSchemaLocation = this.getNoNamespaceSchemaLocation();
        boolean isNil = false;
        if (isXMLRoot) {
            object = root.getObject();
            if (root.getSchemaLocation() != null) {
                schemaLocation = root.getSchemaLocation();
            }
            if (root.getNoNamespaceSchemaLocation() != null) {
                noNsSchemaLocation = root.getNoNamespaceSchemaLocation();
            }
            marshalRecord.setLeafElementType(root.getSchemaType());
            isNil = root.isNil();
        }
        String xsiPrefix = null;
        if ((this.getSchemaLocation() != null || this.getNoNamespaceSchemaLocation() != null || isNil) && (xsiPrefix = nr.resolveNamespaceURI("http://www.w3.org/2001/XMLSchema-instance")) == null) {
            xsiPrefix = "xsi";
            nr.put("xsi", "http://www.w3.org/2001/XMLSchema-instance");
        }
        TreeObjectBuilder treeObjectBuilder = null;
        if (descriptor != null) {
            treeObjectBuilder = (TreeObjectBuilder)descriptor.getObjectBuilder();
        }
        if (session == null) {
            session = (AbstractSession)((Object)this.xmlContext.getSession(0));
        }
        marshalRecord.setSession(session);
        if (rootFragment != null && !rootFragment.getLocalName().equals("")) {
            marshalRecord.startPrefixMappings(nr);
            if (!isXMLRoot && descriptor != null && descriptor.getNamespaceResolver() == null && rootFragment.hasNamespace()) {
                throw XMLMarshalException.namespaceResolverNotSpecified(rootFragment.getShortName());
            }
            if (this.isIncludeRoot()) {
                marshalRecord.openStartElement(rootFragment, nr);
            }
            if (schemaLocation != null) {
                marshalRecord.attributeWithoutQName("http://www.w3.org/2001/XMLSchema-instance", "schemaLocation", xsiPrefix, schemaLocation);
            }
            if (noNsSchemaLocation != null) {
                marshalRecord.attributeWithoutQName("http://www.w3.org/2001/XMLSchema-instance", "noNamespaceSchemaLocation", xsiPrefix, noNsSchemaLocation);
            }
            if (isNil) {
                marshalRecord.nilSimple(nr);
            }
            marshalRecord.namespaceDeclarations(nr);
            if (descriptor != null && !isNil) {
                treeObjectBuilder.addXsiTypeAndClassIndicatorIfRequired(marshalRecord, descriptor, null, descriptor.getDefaultRootElementField(), root, object, isXMLRoot, true);
                treeObjectBuilder.marshalAttributes(marshalRecord, object, session);
            }
            if (this.isIncludeRoot()) {
                marshalRecord.closeStartElement();
            }
        } else {
            marshalRecord.marshalWithoutRootElement(treeObjectBuilder, object, descriptor, root, isXMLRoot);
        }
        if (treeObjectBuilder != null && !isNil) {
            treeObjectBuilder.buildRow(marshalRecord, object, session, this, rootFragment, DatabaseMapping.WriteType.UNDEFINED);
        } else if (isXMLRoot && object != null && !isNil) {
            QName type;
            if (root.getDeclaredType() != null && root.getObject() != null && root.getDeclaredType() != root.getObject().getClass() && (type = (QName)XMLConversionManager.getDefaultJavaTypes().get(object.getClass())) != null) {
                xsiPrefix = nr.resolveNamespaceURI("http://www.w3.org/2001/XMLSchema-instance");
                if (xsiPrefix == null) {
                    xsiPrefix = "xsi";
                    marshalRecord.namespaceDeclaration(xsiPrefix, "http://www.w3.org/2001/XMLSchema-instance");
                }
                marshalRecord.namespaceDeclaration("xsd", "http://www.w3.org/2001/XMLSchema");
                String typeValue = type.getLocalPart();
                if (marshalRecord.isNamespaceAware()) {
                    typeValue = "xsd" + marshalRecord.getNamespaceSeparator() + typeValue;
                }
                marshalRecord.attribute("http://www.w3.org/2001/XMLSchema-instance", "type", String.valueOf(xsiPrefix) + ':' + "type", typeValue);
            }
            marshalRecord.characters(root.getSchemaType(), object, null, false);
        }
        if (rootFragment != null && !rootFragment.getLocalName().equals("") && this.isIncludeRoot()) {
            marshalRecord.endElement(rootFragment, nr);
            marshalRecord.endPrefixMappings(nr);
        }
        if (!this.isFragment()) {
            marshalRecord.endDocument();
        }
        marshalRecord.afterContainmentMarshal(null, object);
    }

    private XPathFragment buildRootFragment(Object object, XMLDescriptor descriptor, boolean isXMLRoot, MarshalRecord marshalRecord) {
        XPathFragment rootFragment = null;
        if (isXMLRoot) {
            String xmlRootUri = ((XMLRoot)object).getNamespaceURI();
            String xmlRootLocalName = ((XMLRoot)object).getLocalName();
            rootFragment = new XPathFragment();
            rootFragment.setLocalName(xmlRootLocalName);
            rootFragment.setNamespaceURI(xmlRootUri);
            rootFragment.setNamespaceAware(marshalRecord.isNamespaceAware());
            rootFragment.setNamespaceSeparator(marshalRecord.getNamespaceSeparator());
            if (xmlRootUri != null) {
                if (descriptor != null) {
                    String xmlRootPrefix = marshalRecord.getNamespaceResolver().resolveNamespaceURI(xmlRootUri);
                    if (xmlRootPrefix == null && !xmlRootUri.equals(marshalRecord.getNamespaceResolver().getDefaultNamespaceURI())) {
                        xmlRootPrefix = marshalRecord.getNamespaceResolver().generatePrefix();
                        marshalRecord.getNamespaceResolver().put(xmlRootPrefix, xmlRootUri);
                    }
                    if (xmlRootPrefix == null) {
                        rootFragment.setXPath(xmlRootLocalName);
                    } else {
                        rootFragment.setPrefix(xmlRootPrefix);
                    }
                } else if (marshalRecord.isNamespaceAware()) {
                    String xmlRootPrefix = "ns0";
                    marshalRecord.getNamespaceResolver().put(xmlRootPrefix, xmlRootUri);
                    rootFragment.setXPath(String.valueOf(xmlRootPrefix) + marshalRecord.getNamespaceSeparator() + xmlRootLocalName);
                } else {
                    rootFragment.setXPath(xmlRootLocalName);
                }
            }
        } else {
            XMLField defaultRootField = descriptor.getDefaultRootElementField();
            if (defaultRootField != null) {
                rootFragment = defaultRootField.getXPathFragment();
            }
        }
        return rootFragment;
    }

    private boolean isSimpleXMLRoot(XMLRoot xmlRoot) {
        Class<?> xmlRootObjectClass = xmlRoot.getObject().getClass();
        if (XMLConversionManager.getDefaultJavaTypes().get(xmlRootObjectClass) != null || ClassConstants.List_Class.isAssignableFrom(xmlRootObjectClass) || ClassConstants.XML_GREGORIAN_CALENDAR.isAssignableFrom(xmlRootObjectClass) || ClassConstants.DURATION.isAssignableFrom(xmlRootObjectClass)) {
            return true;
        }
        return xmlRoot.getObject() instanceof Node;
    }

    public Document objectToXML(Object object) throws XMLMarshalException {
        boolean isXMLRoot = object instanceof XMLRoot;
        XMLDescriptor xmlDescriptor = this.getDescriptor(object, isXMLRoot);
        return this.objectToXML(object, xmlDescriptor, isXMLRoot);
    }

    protected Document objectToXML(Object object, XMLDescriptor descriptor, boolean isXMLRoot) throws XMLMarshalException {
        AbstractSession session = this.xmlContext.getSession(descriptor);
        DocumentPreservationPolicy docPresPolicy = this.xmlContext.getDocumentPreservationPolicy(session);
        if (docPresPolicy != null && docPresPolicy.shouldPreserveDocument()) {
            XMLRecord xmlRow = null;
            if (!isXMLRoot) {
                xmlRow = (XMLRecord)((XMLObjectBuilder)descriptor.getObjectBuilder()).createRecordFor(object, this.xmlContext.getDocumentPreservationPolicy(session));
                xmlRow.setMarshaller(this);
                if (this.attachmentMarshaller != null) {
                    xmlRow.setXOPPackage(this.attachmentMarshaller.isXOPPackage());
                }
                this.addDescriptorNamespacesToXMLRecord(descriptor, xmlRow);
            }
            return this.objectToXML(object, descriptor, xmlRow, isXMLRoot, docPresPolicy);
        }
        NodeRecord marshalRecord = new NodeRecord();
        marshalRecord.setMarshaller(this);
        this.marshal(object, marshalRecord, session, descriptor, isXMLRoot);
        return ((MarshalRecord)marshalRecord).getDocument();
    }

    protected Node objectToXMLNode(Object object, AbstractSession session, XMLDescriptor descriptor, boolean isXMLRoot) throws XMLMarshalException {
        return this.objectToXMLNode(object, null, session, descriptor, isXMLRoot);
    }

    protected Node objectToXMLNode(Object object, Node rootNode, AbstractSession session, XMLDescriptor descriptor, boolean isXMLRoot) throws XMLMarshalException {
        DocumentPreservationPolicy docPresPolicy = this.xmlContext.getDocumentPreservationPolicy(session);
        if (docPresPolicy != null && docPresPolicy.shouldPreserveDocument()) {
            XMLRecord xmlRow = null;
            if (!isXMLRoot) {
                xmlRow = (XMLRecord)((XMLObjectBuilder)descriptor.getObjectBuilder()).createRecordFor(object, this.xmlContext.getDocumentPreservationPolicy(session));
                xmlRow.setMarshaller(this);
                if (this.attachmentMarshaller != null) {
                    xmlRow.setXOPPackage(this.attachmentMarshaller.isXOPPackage());
                }
                if (xmlRow.getDOM().getNodeType() == 1) {
                    this.addDescriptorNamespacesToXMLRecord(descriptor, xmlRow);
                }
            }
            Document doc = this.objectToXML(object, rootNode, descriptor, xmlRow, isXMLRoot, docPresPolicy);
            if (xmlRow != null && xmlRow.getDOM().getNodeType() == 11) {
                return xmlRow.getDOM();
            }
            return doc;
        }
        NodeRecord marshalRecord = new NodeRecord();
        marshalRecord.setMarshaller(this);
        marshalRecord.getNamespaceResolver().setDOM(rootNode);
        this.marshal(object, marshalRecord, session, descriptor, isXMLRoot);
        return ((MarshalRecord)marshalRecord).getDocument();
    }

    private void addDescriptorNamespacesToXMLRecord(XMLDescriptor xmlDescriptor, XMLRecord record) {
        if (xmlDescriptor == null) {
            return;
        }
        this.copyNamespaces(xmlDescriptor.getNamespaceResolver(), record.getNamespaceResolver());
    }

    private void copyNamespaces(NamespaceResolver source, NamespaceResolver target) {
        if (source != null && target != null) {
            if (source.hasPrefixesToNamespaces()) {
                target.getPrefixesToNamespaces().putAll(source.getPrefixesToNamespaces());
            }
            target.setDefaultNamespaceURI(source.getDefaultNamespaceURI());
        }
    }

    public Document objectToXML(Object object, Node parent) throws XMLMarshalException {
        return this.objectToXML(object, parent, null);
    }

    /*
     * Unable to fully structure code
     */
    public Document objectToXML(Object object, Node parent, DocumentPreservationPolicy docPresPolicy) {
        isXMLRoot = object instanceof XMLRoot;
        session = null;
        descriptor = null;
        if (isXMLRoot) {
            try {
                session = this.xmlContext.getSession(((XMLRoot)object).getObject());
                if (session == null) ** GOTO lbl16
                descriptor = this.getDescriptor(((XMLRoot)object).getObject(), session);
            }
            catch (XMLMarshalException marshalException) {
                if (this.isSimpleXMLRoot((XMLRoot)object)) ** GOTO lbl16
                throw marshalException;
            }
        } else {
            objectClass = object.getClass();
            session = this.xmlContext.getSession(objectClass);
            descriptor = this.getDescriptor(objectClass, session);
        }
lbl16:
        // 4 sources

        if ((localRootName = descriptor.getDefaultRootElement()) == null) {
            throw XMLMarshalException.defaultRootElementNotSpecified(descriptor);
        }
        if (docPresPolicy == null) {
            docPresPolicy = this.xmlContext.getDocumentPreservationPolicy(session);
        }
        if (docPresPolicy != null && docPresPolicy.shouldPreserveDocument()) {
            xmlRow = (XMLRecord)((XMLObjectBuilder)descriptor.getObjectBuilder()).createRecord(localRootName, parent, session);
            xmlRow.setMarshaller(this);
            if (this.attachmentMarshaller != null) {
                xmlRow.setXOPPackage(this.attachmentMarshaller.isXOPPackage());
            }
            return this.objectToXML(object, descriptor, xmlRow, isXMLRoot, docPresPolicy);
        }
        marshalRecord = new NodeRecord(localRootName, parent);
        marshalRecord.setMarshaller(this);
        this.marshal(object, marshalRecord, session, descriptor, isXMLRoot);
        return marshalRecord.getDocument();
    }

    public Document objectToXML(Object object, XMLDescriptor descriptor, XMLRecord xmlRow, boolean isXMLRoot, DocumentPreservationPolicy docPresPolicy) {
        return this.objectToXML(object, null, descriptor, xmlRow, isXMLRoot, docPresPolicy);
    }

    public Document objectToXML(Object object, Node rootNode, XMLDescriptor descriptor, XMLRecord xmlRow, boolean isXMLRoot, DocumentPreservationPolicy docPresPolicy) {
        short rootNodeType;
        if (rootNode != null && (rootNodeType = rootNode.getNodeType()) != 9 && rootNodeType != 1 && rootNodeType != 11) {
            throw XMLMarshalException.marshalException(null);
        }
        Document document = null;
        NamespaceResolver resolver = new NamespaceResolver();
        resolver.setDOM(rootNode);
        this.copyNamespaces(descriptor.getNamespaceResolver(), resolver);
        boolean shouldCallSetAttributeNS = false;
        boolean isRootDocumentFragment = false;
        AbstractSession session = this.xmlContext.getSession(descriptor);
        if (xmlRow != null) {
            isRootDocumentFragment = xmlRow.getDOM().getNodeType() == 11;
        }
        Object originalObject = object;
        if (isXMLRoot) {
            String xmlRootUri = ((XMLRoot)object).getNamespaceURI();
            String xmlRootPrefix = null;
            if (xmlRow == null) {
                String recordName = ((XMLRoot)object).getLocalName();
                if (xmlRootUri != null) {
                    xmlRootPrefix = resolver.resolveNamespaceURI(xmlRootUri);
                    if (xmlRootPrefix == null && !xmlRootUri.equals(resolver.getDefaultNamespaceURI())) {
                        xmlRootPrefix = resolver.generatePrefix();
                        resolver.put(xmlRootPrefix, xmlRootUri);
                        shouldCallSetAttributeNS = true;
                    }
                    if (xmlRootPrefix != null) {
                        recordName = String.valueOf(xmlRootPrefix) + ':' + recordName;
                    }
                }
                xmlRow = (XMLRecord)((XMLObjectBuilder)descriptor.getObjectBuilder()).createRecordFor(((XMLRoot)object).getObject(), docPresPolicy, recordName, xmlRootUri);
                xmlRow.setMarshaller(this);
                if (this.attachmentMarshaller != null) {
                    xmlRow.setXOPPackage(this.attachmentMarshaller.isXOPPackage());
                }
                if (!isRootDocumentFragment && shouldCallSetAttributeNS) {
                    if (xmlRootPrefix != null) {
                        ((Element)xmlRow.getDOM()).setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + xmlRootPrefix, xmlRootUri);
                    }
                    shouldCallSetAttributeNS = false;
                }
            }
            this.copyNamespaces(resolver, xmlRow.getNamespaceResolver());
            document = xmlRow.getDocument();
            document.getDocumentElement();
            object = ((XMLRoot)object).getObject();
        }
        XMLObjectBuilder bldr = (XMLObjectBuilder)descriptor.getObjectBuilder();
        AbstractSession objectSession = this.xmlContext.getSession(object);
        xmlRow.setSession(objectSession);
        bldr.addXsiTypeAndClassIndicatorIfRequired(xmlRow, descriptor, null, null, originalObject, object, isXMLRoot, true);
        xmlRow.setMarshaller(this);
        if (shouldCallSetAttributeNS && !isRootDocumentFragment) {
            ((Element)xmlRow.getDOM()).setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        }
        xmlRow = (XMLRecord)bldr.buildRow((AbstractRecord)xmlRow, object, objectSession, isXMLRoot);
        document = xmlRow.getDocument();
        this.addSchemaLocations(document, session);
        return document;
    }

    private void addSchemaLocations(Document document, AbstractSession session) {
        XMLField field;
        Element docElement = document.getDocumentElement();
        NamespaceResolver resolver = new NamespaceResolver();
        resolver.put("xmlns", "http://www.w3.org/2000/xmlns/");
        resolver.put("xsi", "http://www.w3.org/2001/XMLSchema-instance");
        if (this.getSchemaLocation() != null || this.getNoNamespaceSchemaLocation() != null) {
            field = new XMLField("@xmlns:xsi");
            field.setNamespaceResolver(resolver);
            XPathEngine.getInstance().create(field, docElement, "http://www.w3.org/2001/XMLSchema-instance", session);
        }
        if (this.getSchemaLocation() != null) {
            field = new XMLField("@xsi:schemaLocation");
            field.setNamespaceResolver(resolver);
            XPathEngine.getInstance().create(field, docElement, this.getSchemaLocation(), session);
        }
        if (this.getNoNamespaceSchemaLocation() != null) {
            field = new XMLField("@xsi:noNamespaceSchemaLocation");
            field.setNamespaceResolver(resolver);
            XPathEngine.getInstance().create(field, docElement, this.getNoNamespaceSchemaLocation(), session);
        }
    }

    protected XMLDescriptor getDescriptor(Object object) throws XMLMarshalException {
        XMLDescriptor descriptor = (XMLDescriptor)this.xmlContext.getSession(object).getDescriptor(object);
        if (descriptor == null) {
            throw XMLMarshalException.descriptorNotFoundInProject(object.getClass().getName());
        }
        return descriptor;
    }

    protected XMLDescriptor getDescriptor(Object object, AbstractSession session) throws XMLMarshalException {
        XMLDescriptor descriptor = (XMLDescriptor)session.getDescriptor(object);
        if (descriptor == null) {
            throw XMLMarshalException.descriptorNotFoundInProject(object.getClass().getName());
        }
        return descriptor;
    }

    private XMLDescriptor getDescriptor(Class clazz, AbstractSession session) throws XMLMarshalException {
        XMLDescriptor descriptor = (XMLDescriptor)session.getDescriptor(clazz);
        if (descriptor == null) {
            throw XMLMarshalException.descriptorNotFoundInProject(clazz.getName());
        }
        return descriptor;
    }

    protected XMLDescriptor getDescriptor(Object object, boolean isXMLRoot) {
        if (isXMLRoot) {
            return this.getDescriptor((XMLRoot)object);
        }
        return this.getDescriptor(object);
    }

    protected XMLDescriptor getDescriptor(Object object, AbstractSession session, boolean isXMLRoot) {
        if (isXMLRoot) {
            return this.getDescriptor((XMLRoot)object, session);
        }
        return this.getDescriptor(object, session);
    }

    protected XMLDescriptor getDescriptor(XMLRoot object) throws XMLMarshalException {
        AbstractSession session;
        XMLDescriptor descriptor;
        block5: {
            descriptor = null;
            try {
                session = this.xmlContext.getSession(object.getObject());
                if (session != null) break block5;
                return null;
            }
            catch (XMLMarshalException marshalException) {
                if (descriptor == null && this.isSimpleXMLRoot(object)) {
                    return null;
                }
                throw marshalException;
            }
        }
        descriptor = (XMLDescriptor)session.getDescriptor(object.getObject());
        if (descriptor == null) {
            throw XMLMarshalException.descriptorNotFoundInProject(object.getClass().getName());
        }
        return descriptor;
    }

    protected XMLDescriptor getDescriptor(XMLRoot object, AbstractSession session) throws XMLMarshalException {
        XMLDescriptor descriptor;
        block5: {
            descriptor = null;
            try {
                if (session != null) break block5;
                return null;
            }
            catch (XMLMarshalException marshalException) {
                if (descriptor == null && this.isSimpleXMLRoot(object)) {
                    return null;
                }
                throw marshalException;
            }
        }
        descriptor = (XMLDescriptor)session.getDescriptor(object.getObject());
        if (descriptor == null) {
            throw XMLMarshalException.descriptorNotFoundInProject(object.getClass().getName());
        }
        return descriptor;
    }

    public void setFragment(boolean fragment) {
        this.transformer.setFragment(fragment);
    }

    public boolean isFragment() {
        return this.mediaType == MediaType.APPLICATION_XML && this.transformer.isFragment();
    }

    public void setAttachmentMarshaller(XMLAttachmentMarshaller atm) {
        this.attachmentMarshaller = atm;
    }

    public XMLAttachmentMarshaller getAttachmentMarshaller() {
        return this.attachmentMarshaller;
    }

    public XMLTransformer getTransformer() {
        return this.transformer;
    }

    public Schema getSchema() {
        return this.schema;
    }

    public void setSchema(Schema schema) {
        this.schema = schema;
    }

    public XMLMarshaller clone() {
        XMLMarshaller clone = new XMLMarshaller(this.xmlContext);
        clone.setAttachmentMarshaller(this.attachmentMarshaller);
        clone.setEncoding(this.getEncoding());
        clone.setFormattedOutput(this.isFormattedOutput());
        clone.setFragment(this.transformer.isFragment());
        clone.setMediaType(this.getMediaType());
        clone.setMarshalListener(this.marshalListener);
        clone.setNoNamespaceSchemaLocation(this.noNamespaceSchemaLocation);
        clone.setAttributePrefix(this.getAttributePrefix());
        clone.setCharacterEscapeHandler(this.getCharacterEscapeHandler());
        clone.setIncludeRoot(this.isIncludeRoot());
        clone.setIndentString(this.getIndentString());
        clone.setMarshalEmptyCollections(this.isMarshalEmptyCollections());
        clone.setNamespacePrefixMapper(this.getNamespacePrefixMapper());
        clone.setNamespaceSeparator(this.getNamespaceSeparator());
        clone.setValueWrapper(this.getValueWrapper());
        for (Map.Entry<Object, Object> entry : this.marshalProperties.entrySet()) {
            clone.getProperties().put(entry.getKey(), entry.getValue());
        }
        if (this.schema != null) {
            clone.setSchema(this.schema);
        }
        clone.setSchemaLocation(this.schemaLocation);
        return clone;
    }

    public String getAttributePrefix() {
        return this.attributePrefix;
    }

    public void setAttributePrefix(String attributePrefix) {
        this.attributePrefix = attributePrefix;
    }

    public String getValueWrapper() {
        return this.valueWrapper;
    }

    public void setValueWrapper(String valueWrapper) {
        this.valueWrapper = valueWrapper;
    }

    public boolean isMarshalEmptyCollections() {
        return this.marshalEmptyCollections;
    }

    public void setMarshalEmptyCollections(Boolean marshalEmptyCollections) {
        this.marshalEmptyCollections = marshalEmptyCollections;
    }

    public boolean isIncludeRoot() {
        if (this.mediaType == MediaType.APPLICATION_JSON) {
            return this.includeRoot;
        }
        return true;
    }

    public void setIncludeRoot(boolean includeRoot) {
        this.includeRoot = includeRoot;
    }

    public char getNamespaceSeparator() {
        return this.namespaceSeparator;
    }

    public void setNamespaceSeparator(char namespaceSeparator) {
        this.namespaceSeparator = namespaceSeparator;
    }

    public void setNamespacePrefixMapper(NamespacePrefixMapper mapper) {
        this.mapper = mapper;
    }

    public NamespacePrefixMapper getNamespacePrefixMapper() {
        return this.mapper;
    }

    public String getIndentString() {
        return this.indentString;
    }

    public void setIndentString(String s) {
        this.indentString = s;
    }

    public CharacterEscapeHandler getCharacterEscapeHandler() {
        return this.charEscapeHandler;
    }

    public void setCharacterEscapeHandler(CharacterEscapeHandler c) {
        this.charEscapeHandler = c;
    }

    public String getXmlHeader() {
        return this.xmlHeader;
    }

    public void setXmlHeader(String xmlHeader) {
        this.xmlHeader = xmlHeader;
    }

    public boolean isEqualUsingIdenity() {
        return this.equalUsingIdenity;
    }

    public void setEqualUsingIdenity(boolean equalUsingIdenity) {
        this.equalUsingIdenity = equalUsingIdenity;
    }
}

