/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.format;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.php.internal.core.ast.util.Util;
import org.eclipse.php.internal.core.documentModel.parser.regions.IPhpScriptRegion;
import org.eclipse.php.internal.core.documentModel.partitioner.PHPPartitionTypes;
import org.eclipse.php.internal.core.format.FormatterUtils;
import org.eclipse.php.internal.core.format.IIndentationStrategy;
import org.eclipse.php.internal.core.format.PHPHeuristicScanner;
import org.eclipse.php.internal.core.util.text.PHPTextSequenceUtilities;
import org.eclipse.php.internal.core.util.text.TextSequence;
import org.eclipse.wst.sse.core.internal.parser.ContextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionContainer;

public class DefaultIndentationStrategy
implements IIndentationStrategy {
    private static final List<String> multilinePartitionTypes = Arrays.asList("org.eclipse.php.PHP_QUOTED_STRING", "org.eclipse.php.PHP_MULTI_LINE_COMMENT", "org.eclipse.php.PHP_DOC");
    private static final String BLANK = "";
    private static boolean pairArrayParen;
    private static int pairArrayOffset;

    protected static boolean isBlanks(IStructuredDocument document, int startOffset, int endOffset, int currentOffset) throws BadLocationException {
        return document.get(startOffset, endOffset - startOffset).trim().length() == 0 || document.get(startOffset, currentOffset - startOffset).trim().length() == 0;
    }

    public static int getIndentationBaseLine(IStructuredDocument document, int currLineIndex, int offset, boolean checkMultiLine) throws BadLocationException {
        if (checkMultiLine) {
            currLineIndex = DefaultIndentationStrategy.adjustLine(document, currLineIndex, offset);
        }
        while (currLineIndex > 0) {
            if (DefaultIndentationStrategy.isIndentationBase(document, offset, currLineIndex, checkMultiLine)) {
                return currLineIndex;
            }
            currLineIndex = DefaultIndentationStrategy.getNextLineIndex(document, checkMultiLine, currLineIndex);
        }
        return 0;
    }

    private static int adjustLine(IStructuredDocument document, int currLineIndex, int offset) throws BadLocationException {
        int peer;
        PHPHeuristicScanner scanner;
        int token;
        IRegion lineInfo = document.getLineInformation(currLineIndex);
        int lineEnd = lineInfo.getOffset() + lineInfo.getLength();
        if ((lineEnd = Math.min(lineEnd, offset)) == lineInfo.getOffset()) {
            lineEnd = DefaultIndentationStrategy.moveLineStartToNonBlankChar(document, lineEnd, currLineIndex) - 1;
        }
        if (lineEnd == document.getLength() && lineEnd > 0) {
            --lineEnd;
        }
        if ((token = (scanner = PHPHeuristicScanner.createHeuristicScanner((IDocument)document, lineEnd, true)).previousToken(lineEnd, -2)) == 7) {
            token = scanner.previousToken(scanner.getPosition(), -2);
        }
        if (token == 6 ? (peer = scanner.findOpeningPeer(scanner.getPosition(), -2, '(', ')')) != -1 : token == 3 && (peer = scanner.findOpeningPeer(scanner.getPosition(), -2, '[', ']')) != -1) {
            return document.getLineOfOffset(scanner.getPosition());
        }
        return currLineIndex;
    }

    private static int getNextLineIndex(IStructuredDocument document, boolean checkMultiLine, int currLineIndex) throws BadLocationException {
        int index;
        IRegion lineInfo = document.getLineInformation(currLineIndex);
        int currLineEndOffset = lineInfo.getOffset() + lineInfo.getLength();
        String checkedLineBeginState = FormatterUtils.getPartitionType(document, lineInfo.getOffset(), true);
        String forLineEndState = FormatterUtils.getPartitionType(document, currLineEndOffset);
        if (DefaultIndentationStrategy.isMultilineType(checkedLineBeginState) && (checkMultiLine || DefaultIndentationStrategy.shouldNotConsiderAsIndentationBase(checkedLineBeginState, forLineEndState)) && (index = DefaultIndentationStrategy.getMultiLineStatementStartOffset(document, lineInfo.getOffset(), currLineIndex)) > -1) {
            return index;
        }
        if (checkMultiLine) {
            int result = DefaultIndentationStrategy.adjustLine(document, currLineIndex, currLineEndOffset);
            if (result == currLineIndex && result != 0) {
                --result;
            }
            return result;
        }
        return currLineIndex - 1;
    }

    private static boolean isMultilineType(String checkedLineBeginState) {
        return multilinePartitionTypes.contains(checkedLineBeginState);
    }

    private static int moveLineStartToNonBlankChar(IStructuredDocument document, int lineStart, int currLineIndex) {
        try {
            char[] line = document.get(lineStart, document.getLineLength(currLineIndex)).toCharArray();
            int i = 0;
            while (i < line.length) {
                char c = line[i];
                if (!Character.isWhitespace(c)) {
                    lineStart += i + 1;
                    break;
                }
                ++i;
            }
        }
        catch (BadLocationException badLocationException) {}
        return lineStart;
    }

    private static ITextRegion getLastTokenRegion(IStructuredDocument document, IRegion line, int forOffset) throws BadLocationException {
        int offset = forOffset;
        int lineStartOffset = line.getOffset();
        IStructuredDocumentRegion sdRegion = document.getRegionAtCharacterOffset(offset);
        if (sdRegion == null) {
            return null;
        }
        Object tRegion = sdRegion.getRegionAtCharacterOffset(offset);
        if (tRegion == null && offset == document.getLength()) {
            tRegion = sdRegion.getRegionAtCharacterOffset(--offset);
        }
        int regionStart = sdRegion.getStartOffset(tRegion);
        if (tRegion instanceof ITextRegionContainer) {
            ITextRegionContainer container = (ITextRegionContainer)tRegion;
            tRegion = container.getRegionAtCharacterOffset(offset);
            regionStart += tRegion.getStart();
        }
        if (tRegion instanceof IPhpScriptRegion) {
            IPhpScriptRegion scriptRegion = (IPhpScriptRegion)tRegion;
            if ((tRegion = scriptRegion.getPhpToken(offset - regionStart)) == null) {
                return null;
            }
            do {
                String token = tRegion.getType();
                if (regionStart + tRegion.getStart() >= forOffset || PHPPartitionTypes.isPHPCommentState(token) || token == "WHITESPACE") continue;
                return tRegion;
            } while ((tRegion = tRegion.getStart() >= 1 ? scriptRegion.getPhpToken(tRegion.getStart() - 1) : null) != null && tRegion.getStart() + regionStart > lineStartOffset);
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    private static boolean isIndentationBase(IStructuredDocument document, int forOffset, int currLineIndex, boolean checkMultiLine) throws BadLocationException {
        lineInfo = document.getLineInformation(currLineIndex);
        if (lineInfo.getLength() == 0) {
            return false;
        }
        checkedOffset = Math.min(lineInfo.getOffset() + lineInfo.getLength(), forOffset);
        lineStart = lineInfo.getOffset();
        if (DefaultIndentationStrategy.isBlanks(document, lineStart, checkedOffset, forOffset)) {
            return false;
        }
        scanner = PHPHeuristicScanner.createHeuristicScanner((IDocument)document, lineStart, true);
        if (!DefaultIndentationStrategy.inBracelessBlock(scanner, document, lineStart)) ** GOTO lbl12
        return scanner.previousToken(forOffset - 1, -2) == 5;
lbl-1000:
        // 1 sources

        {
            ++lineStart;
lbl12:
            // 2 sources

            ** while (Character.isWhitespace((char)document.getChar((int)lineStart)))
        }
lbl13:
        // 1 sources

        checkedLineBeginState = FormatterUtils.getPartitionType(document, lineStart, true);
        checkedLineEndState = FormatterUtils.getPartitionType(document, checkedOffset, true);
        forLineEndState = FormatterUtils.getPartitionType(document, forOffset);
        if (!DefaultIndentationStrategy.lineContainIncompleteBlock(document, checkedOffset, lineStart, currLineIndex) && (DefaultIndentationStrategy.shouldNotConsiderAsIndentationBase(checkedLineBeginState, forLineEndState) || checkMultiLine && DefaultIndentationStrategy.isInMultiLineStatement(document, checkedLineBeginState, checkedLineEndState, checkedOffset, lineStart, currLineIndex))) {
            return false;
        }
        if ((checkedLineBeginState == "org.eclipse.php.PHP_MULTI_LINE_COMMENT" || checkedLineBeginState == "org.eclipse.php.PHP_DOC") && checkedLineBeginState == forLineEndState) {
            sdRegion = document.getRegionAtCharacterOffset(lineStart);
            phpScriptRegion = sdRegion.getRegionAtCharacterOffset(lineStart);
            phpContentStartOffset = sdRegion.getStartOffset(phpScriptRegion);
            if (phpScriptRegion instanceof ITextRegionContainer) {
                container = (ITextRegionContainer)phpScriptRegion;
                phpScriptRegion = container.getRegionAtCharacterOffset(lineStart);
                phpContentStartOffset += phpScriptRegion.getStart();
            }
            if (phpScriptRegion instanceof IPhpScriptRegion) {
                scriptRegion = (IPhpScriptRegion)phpScriptRegion;
                checkedRegion = (ContextRegion)scriptRegion.getPhpToken(lineStart - phpContentStartOffset);
                currentRegion = (ContextRegion)scriptRegion.getPhpToken(forOffset - phpContentStartOffset);
                checkedType = checkedRegion.getType();
                currentType = currentRegion.getType();
                if (currentType.equals("PHPDOC_COMMENT_START") || currentType.equals("PHP_COMMENT_START")) {
                    return checkedType.equals("PHPDOC_COMMENT_START") != false || checkedType.equals("PHP_COMMENT_START") != false;
                }
            }
        }
        return DefaultIndentationStrategy.lineShouldInedent(checkedLineBeginState, checkedLineEndState) != false || forLineEndState == checkedLineBeginState;
    }

    private static boolean isInMultiLineStatement(IStructuredDocument document, String checkedLineBeginState, String checkedLineEndState, int checkedOffset, int lineStart, int currLineIndex) throws BadLocationException {
        return DefaultIndentationStrategy.getMultiLineStatementStartOffset(document, lineStart, currLineIndex, checkedOffset) > -1;
    }

    private static int getMultiLineStatementStartOffset(IStructuredDocument document, int lineStart, int currLineIndex, int checkedOffset) throws BadLocationException {
        TextSequence textSequence = PHPTextSequenceUtilities.getStatement(lineStart = DefaultIndentationStrategy.moveLineStartToNonBlankChar(document, lineStart, currLineIndex), document.getRegionAtCharacterOffset(lineStart), true);
        if (textSequence != null && DefaultIndentationStrategy.isRegionTypeAllowedMultiline(FormatterUtils.getRegionType(document, textSequence.getOriginalOffset(0))) && document.getLineOfOffset(textSequence.getOriginalOffset(0)) < currLineIndex) {
            return document.getLineOfOffset(textSequence.getOriginalOffset(0));
        }
        return -1;
    }

    private static boolean lineContainIncompleteBlock(IStructuredDocument document, int checkedOffset, int lineStart, int currLineIndex) throws BadLocationException {
        TextSequence textSequence;
        PHPHeuristicScanner scanner = PHPHeuristicScanner.createHeuristicScanner((IDocument)document, lineStart, true);
        if (checkedOffset == document.getLength() && checkedOffset > 0) {
            --checkedOffset;
        }
        if ((textSequence = PHPTextSequenceUtilities.getStatement(lineStart, document.getRegionAtCharacterOffset(lineStart), true)) != null && DefaultIndentationStrategy.isRegionTypeAllowedMultiline(FormatterUtils.getRegionType(document, textSequence.getOriginalOffset(0)))) {
            int statementStart = textSequence.getOriginalOffset(0);
            int openParenPeer = scanner.findOpeningPeer(checkedOffset, statementStart, '(', ')');
            int openBracePeer = scanner.findOpeningPeer(checkedOffset, statementStart, '{', '}');
            int openBracketPeer = scanner.findOpeningPeer(checkedOffset, statementStart, '[', ']');
            int biggest = Math.max(openParenPeer, openBracePeer);
            if ((biggest = Math.max(biggest, openBracketPeer)) != -1 && biggest > lineStart) {
                IPhpScriptRegion scriptRegion;
                ITextRegion[] tokens;
                IStructuredDocumentRegion sdRegion = document.getRegionAtCharacterOffset(lineStart);
                ITextRegion phpScriptRegion = sdRegion.getRegionAtCharacterOffset(lineStart);
                sdRegion.getStartOffset(phpScriptRegion);
                if (phpScriptRegion instanceof ITextRegionContainer) {
                    ITextRegionContainer container = (ITextRegionContainer)phpScriptRegion;
                    phpScriptRegion = container.getRegionAtCharacterOffset(lineStart);
                    phpScriptRegion.getStart();
                }
                if (phpScriptRegion instanceof IPhpScriptRegion && (tokens = (scriptRegion = (IPhpScriptRegion)phpScriptRegion).getPhpTokens(lineStart, biggest - lineStart)) != null && tokens.length > 0) {
                    HashSet<String> tokenTypeSet = new HashSet<String>();
                    int i = 0;
                    while (i < tokens.length) {
                        tokenTypeSet.add(tokens[i].getType());
                        ++i;
                    }
                    if (biggest == openParenPeer ? tokenTypeSet.contains("PHP_NEW") || tokenTypeSet.contains("PHP_FUNCTION") || tokenTypeSet.contains("PHP_ARRAY") : (biggest == openBracePeer ? tokenTypeSet.contains("PHP_NEW") || tokenTypeSet.contains("PHP_FUNCTION") : tokenTypeSet.contains("PHP_ARRAY"))) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private static int getMultiLineStatementStartOffset(IStructuredDocument document, int lineStart, int currLineIndex) {
        TextSequence textSequence = PHPTextSequenceUtilities.getStatement(lineStart = DefaultIndentationStrategy.moveLineStartToNonBlankChar(document, lineStart, currLineIndex), document.getRegionAtCharacterOffset(lineStart), true);
        if (textSequence != null && DefaultIndentationStrategy.isRegionTypeAllowedMultiline(FormatterUtils.getRegionType(document, textSequence.getOriginalOffset(0))) && document.getLineOfOffset(textSequence.getOriginalOffset(0)) < currLineIndex) {
            return document.getLineOfOffset(textSequence.getOriginalOffset(0));
        }
        return -1;
    }

    private static boolean isRegionTypeAllowedMultiline(String regionType) {
        return regionType != null && !"PHPDOC_COMMENT_START".equals(regionType) && !"PHP_LINE_COMMENT".equals(regionType) && !"PHP_STRING".equals(regionType) && !"PHP_CASE".equals(regionType) && !"PHP_DEFAULT".equals(regionType);
    }

    public static boolean lineShouldInedent(String beginState, String endState) {
        return beginState == "org.eclipse.php.PHP_DEFAULT" || endState == "org.eclipse.php.PHP_DEFAULT";
    }

    public void placeMatchingBlanks(IStructuredDocument document, StringBuffer result, int lineNumber, int forOffset) throws BadLocationException {
        DefaultIndentationStrategy.placeMatchingBlanksForStructuredDocument(document, result, lineNumber, forOffset, this.getCommandText());
    }

    protected String getCommandText() {
        return BLANK;
    }

    public static void placeMatchingBlanksForStructuredDocument(IStructuredDocument document, StringBuffer result, int lineNumber, int forOffset) throws BadLocationException {
        DefaultIndentationStrategy.placeMatchingBlanksForStructuredDocument(document, result, lineNumber, forOffset, BLANK);
    }

    public static void placeMatchingBlanksForStructuredDocument(IStructuredDocument document, StringBuffer result, int lineNumber, int forOffset, String commandText) throws BadLocationException {
        int line;
        int offset;
        int newForOffset;
        int indentationBaseLineIndex;
        int lastNonEmptyLineIndex;
        FormatterUtils.getFormatterCommonPrferences();
        int indentationWrappedLineSize = FormatterUtils.getFormatterCommonPrferences().getIndentationWrappedLineSize((IDocument)document);
        int indentationArrayInitSize = FormatterUtils.getFormatterCommonPrferences().getIndentationArrayInitSize((IDocument)document);
        int indentationSize = FormatterUtils.getFormatterCommonPrferences().getIndentationSize((IDocument)document);
        char indentationChar = FormatterUtils.getFormatterCommonPrferences().getIndentationChar((IDocument)document);
        IndentationObject indentationObject = new IndentationObject();
        indentationObject.indentationWrappedLineSize = indentationWrappedLineSize;
        indentationObject.indentationArrayInitSize = indentationArrayInitSize;
        indentationObject.indentationSize = indentationSize;
        indentationObject.indentationChar = indentationChar;
        boolean enterKeyPressed = document.getLineDelimiter().equals(result.toString());
        if (forOffset == 0) {
            return;
        }
        int lineOfOffset = document.getLineOfOffset(forOffset);
        IRegion lineInformationOfOffset = document.getLineInformation(lineOfOffset);
        String lineText = document.get(lineInformationOfOffset.getOffset(), lineInformationOfOffset.getLength());
        if (lineText.trim().startsWith("//") && enterKeyPressed) {
            lastNonEmptyLineIndex = lineOfOffset;
            indentationBaseLineIndex = lineOfOffset;
            int i = lineInformationOfOffset.getOffset();
            while (i < lineInformationOfOffset.getOffset() + lineInformationOfOffset.getLength() && document.getChar(i) != '/') {
                ++i;
            }
            newForOffset = forOffset < i ? i : forOffset;
        } else {
            newForOffset = forOffset;
            lastNonEmptyLineIndex = DefaultIndentationStrategy.getIndentationBaseLine(document, lineNumber, newForOffset, false);
            indentationBaseLineIndex = DefaultIndentationStrategy.getIndentationBaseLine(document, lineNumber, newForOffset, true);
        }
        IRegion lastNonEmptyLine = document.getLineInformation(lastNonEmptyLineIndex);
        IRegion indentationBaseLine = document.getLineInformation(indentationBaseLineIndex);
        String blanks = FormatterUtils.getLineBlanks((IDocument)document, indentationBaseLine);
        result.append(blanks);
        int lastLineEndOffset = lastNonEmptyLine.getOffset() + lastNonEmptyLine.getLength();
        if (newForOffset < lastLineEndOffset) {
            offset = newForOffset;
            line = lineNumber;
        } else {
            offset = lastLineEndOffset;
            line = lastNonEmptyLineIndex;
        }
        if (DefaultIndentationStrategy.shouldIndent(document, offset, line)) {
            DefaultIndentationStrategy.indent(document, result, indentationChar, indentationSize);
        } else {
            boolean intended = DefaultIndentationStrategy.indentMultiLineCase(document, lineNumber, newForOffset, enterKeyPressed, result, blanks, commandText, indentationObject);
            if (!intended) {
                int baseLineEndOffset;
                lastNonEmptyLineIndex = lineNumber;
                if (!enterKeyPressed && lastNonEmptyLineIndex > 0) {
                    --lastNonEmptyLineIndex;
                }
                while (lastNonEmptyLineIndex >= 0) {
                    IRegion lineInfo = document.getLineInformation(lastNonEmptyLineIndex);
                    String content = document.get(lineInfo.getOffset(), lineInfo.getLength());
                    if (content.trim().length() > 0) break;
                    --lastNonEmptyLineIndex;
                }
                if (!DefaultIndentationStrategy.isEndOfStatement(document, offset, lastNonEmptyLineIndex)) {
                    IRegion lineInfo;
                    if (indentationBaseLineIndex == lastNonEmptyLineIndex) {
                        DefaultIndentationStrategy.placeStringIndentation(document, lastNonEmptyLineIndex, result, indentationObject);
                    }
                    boolean shouldNotChangeIndent = false;
                    if (newForOffset != document.getLength()) {
                        char lineStartChar;
                        lineInfo = document.getLineInformation(lineNumber);
                        int nonEmptyOffset = newForOffset;
                        if (!enterKeyPressed && nonEmptyOffset == lineInfo.getOffset()) {
                            nonEmptyOffset = DefaultIndentationStrategy.moveLineStartToNonBlankChar(document, nonEmptyOffset, lineNumber) - 1;
                        }
                        if ((lineStartChar = document.getChar(nonEmptyOffset)) == '}' || lineStartChar == ')') {
                            PHPHeuristicScanner scanner = PHPHeuristicScanner.createHeuristicScanner((IDocument)document, nonEmptyOffset, true);
                            if (lineStartChar == '}') {
                                int peer = scanner.findOpeningPeer(nonEmptyOffset - 1, -2, '{', '}');
                                if (peer != -1) {
                                    shouldNotChangeIndent = true;
                                }
                            } else if (lineStartChar == ']') {
                                int peer = scanner.findOpeningPeer(nonEmptyOffset - 1, -2, '[', ']');
                                if (peer != -1) {
                                    shouldNotChangeIndent = true;
                                }
                            } else {
                                int peer = scanner.findOpeningPeer(nonEmptyOffset - 1, -2, '(', ')');
                                if (peer != -1) {
                                    shouldNotChangeIndent = true;
                                }
                            }
                        }
                    }
                    if (!shouldNotChangeIndent) {
                        result.setLength(result.length() - blanks.length());
                        lineInfo = document.getLineInformation(lastNonEmptyLineIndex);
                        result.append(FormatterUtils.getLineBlanks((IDocument)document, lineInfo));
                    }
                } else if (result.length() == blanks.length() && DefaultIndentationStrategy.shouldIndent(document, offset = (baseLineEndOffset = indentationBaseLine.getOffset() + indentationBaseLine.getLength()), line = indentationBaseLineIndex)) {
                    DefaultIndentationStrategy.indent(document, result, indentationChar, indentationSize);
                }
            }
        }
    }

    private static void indent(IStructuredDocument document, StringBuffer result, int indentationChar, int indentationSize) {
        int i = 0;
        while (i < indentationSize) {
            result.append((char)indentationChar);
            ++i;
        }
    }

    private static boolean indentMultiLineCase(IStructuredDocument document, int lineNumber, int offset, boolean enterKeyPressed, StringBuffer result, String blanks, String commandText, IndentationObject indentationObject) {
        block20: {
            block21: {
                PHPHeuristicScanner scanner;
                IRegion region;
                block19: {
                    int peer;
                    String content;
                    block18: {
                        region = document.getLineInformationOfOffset(offset);
                        content = document.get(offset, region.getOffset() + region.getLength() - offset);
                        scanner = PHPHeuristicScanner.createHeuristicScanner((IDocument)document, offset, true);
                        if (!DefaultIndentationStrategy.inBracelessBlock(scanner, document, offset)) break block18;
                        if (!"{".equals(commandText)) {
                            DefaultIndentationStrategy.indent(document, result, indentationObject.indentationChar, indentationObject.indentationSize);
                        }
                        return true;
                    }
                    if (!content.trim().startsWith("{")) break block19;
                    int token = scanner.previousToken(offset - 1, -2);
                    if (token == 6 && (peer = scanner.findOpeningPeer(scanner.getPosition(), -2, '(', ')')) != -1) {
                        String newblanks = FormatterUtils.getLineBlanks((IDocument)document, document.getLineInformationOfOffset(peer));
                        StringBuffer newBuffer = new StringBuffer(newblanks);
                        result.setLength(result.length() - blanks.length());
                        result.append(newBuffer.toString());
                        return true;
                    }
                    break block20;
                }
                try {
                    if (!DefaultIndentationStrategy.inMultiLine(scanner, document, lineNumber, offset)) break block21;
                    int peer = scanner.findOpeningPeer(offset - 1, -2, '(', ')');
                    if (peer != -1) {
                        int position = peer - 1;
                        int token = scanner.previousToken(position, -2);
                        while (token > 100 || token == 8) {
                            token = scanner.previousToken(--position, -2);
                        }
                        boolean isAssignment = scanner.previousToken(--position, -2) == 14 && scanner.previousToken(position - 1, -2) == 12;
                        token = scanner.previousToken(peer - 1, -2);
                        boolean isArray = token == 1029;
                        String newblanks = FormatterUtils.getLineBlanks((IDocument)document, document.getLineInformationOfOffset(peer));
                        StringBuffer newBuffer = new StringBuffer(newblanks);
                        pairArrayParen = false;
                        if (enterKeyPressed || !document.get(offset, region.getOffset() + region.getLength() - offset).trim().startsWith(")")) {
                            if (isArray) {
                                region = document.getLineInformationOfOffset(offset);
                                if (scanner.nextToken(offset, region.getOffset() + region.getLength()) == 6) {
                                    if (isAssignment) {
                                        DefaultIndentationStrategy.indent(document, newBuffer, 0, indentationObject.indentationChar, indentationObject.indentationSize);
                                    } else {
                                        DefaultIndentationStrategy.indent(document, newBuffer, indentationObject.indentationArrayInitSize, indentationObject.indentationChar, indentationObject.indentationSize);
                                        pairArrayParen = true;
                                    }
                                } else {
                                    DefaultIndentationStrategy.indent(document, newBuffer, indentationObject.indentationArrayInitSize, indentationObject.indentationChar, indentationObject.indentationSize);
                                }
                            } else {
                                DefaultIndentationStrategy.indent(document, newBuffer, indentationObject.indentationWrappedLineSize, indentationObject.indentationChar, indentationObject.indentationSize);
                            }
                        }
                        result.setLength(result.length() - blanks.length());
                        result.append(newBuffer.toString());
                        if (pairArrayParen) {
                            pairArrayOffset = offset + result.length();
                            result.append(Util.getLineSeparator(null, null));
                            result.append(blanks);
                        }
                        return true;
                    }
                    break block20;
                }
                catch (BadLocationException badLocationException) {}
            }
            int baseLine = DefaultIndentationStrategy.inMultiLineString(document, offset, lineNumber, enterKeyPressed);
            if (baseLine >= 0) {
                String newblanks = FormatterUtils.getLineBlanks((IDocument)document, document.getLineInformation(baseLine));
                StringBuffer newBuffer = new StringBuffer(newblanks);
                DefaultIndentationStrategy.indent(document, newBuffer, indentationObject.indentationWrappedLineSize, indentationObject.indentationChar, indentationObject.indentationSize);
                result.setLength(result.length() - blanks.length());
                result.append(newBuffer.toString());
                return true;
            }
        }
        return false;
    }

    private static void indent(IStructuredDocument document, StringBuffer indent, int times, int indentationChar, int indentationSize) {
        int i = 0;
        while (i < times) {
            DefaultIndentationStrategy.indent(document, indent, indentationChar, indentationSize);
            ++i;
        }
    }

    private static boolean inMultiLine(PHPHeuristicScanner scanner, IStructuredDocument document, int lineNumber, int offset) {
        int lineStart = offset;
        try {
            IRegion region = document.getLineInformation(lineNumber);
            char[] line = document.get(lineStart, region.getOffset() + region.getLength() - lineStart).toCharArray();
            int i = 0;
            while (i < line.length) {
                char c = line[i];
                if (!Character.isWhitespace(c)) {
                    lineStart += i + 1;
                    break;
                }
                ++i;
            }
        }
        catch (BadLocationException badLocationException) {}
        TextSequence textSequence = PHPTextSequenceUtilities.getStatement(lineStart, document.getRegionAtCharacterOffset(lineStart), true);
        if (textSequence == null) {
            return false;
        }
        String regionType = FormatterUtils.getRegionType(document, textSequence.getOriginalOffset(0));
        if (textSequence != null && DefaultIndentationStrategy.isRegionTypeAllowedMultiline(regionType)) {
            int statementStart = textSequence.getOriginalOffset(0);
            int peer = scanner.findOpeningPeer(offset - 1, textSequence.getOriginalOffset(0), '(', ')');
            if (peer == -1) {
                return false;
            }
            if (statementStart < peer) {
                return true;
            }
        }
        return false;
    }

    private static int inMultiLineString(IStructuredDocument document, int offset, int lineNumber, boolean enterKeyPressed) {
        ITextRegion token;
        block5: {
            try {
                IRegion lineInfo = document.getLineInformation(lineNumber);
                document.getRegionAtCharacterOffset(offset);
                token = DefaultIndentationStrategy.getLastTokenRegion(document, lineInfo, offset);
                if (token != null) break block5;
                return -1;
            }
            catch (BadLocationException badLocationException) {}
        }
        String tokenType = token.getType();
        if (tokenType == "PHP_CONSTANT_ENCAPSED_STRING") {
            int startLine = document.getLineOfOffset(token.getStart());
            if (enterKeyPressed && startLine <= lineNumber || !enterKeyPressed && startLine < lineNumber) {
                return startLine;
            }
        }
        return -1;
    }

    private static boolean inBracelessBlock(PHPHeuristicScanner scanner, IStructuredDocument document, int offset) {
        boolean isBracelessBlock = scanner.isBracelessBlockStart(offset - 1, -2);
        if (isBracelessBlock) {
            try {
                IRegion region = document.getLineInformationOfOffset(offset);
                String trimedLine = document.get(offset, region.getOffset() + region.getLength() - offset).trim();
                if (!trimedLine.startsWith("{")) {
                    return true;
                }
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    private static boolean isEndOfStatement(IStructuredDocument document, int offset, int lineNumber) {
        ITextRegion token;
        IRegion lineInfo;
        block6: {
            block5: {
                try {
                    lineInfo = document.getLineInformation(lineNumber);
                    document.getRegionAtCharacterOffset(offset);
                    token = DefaultIndentationStrategy.getLastTokenRegion(document, lineInfo, lineInfo.getOffset() + lineInfo.getLength());
                    if (token != null) break block5;
                    return true;
                }
                catch (BadLocationException badLocationException) {}
            }
            if (token.getType() != "PHP_SEMICOLON" && token.getType() != "PHP_CURLY_CLOSE") break block6;
            return true;
        }
        if (token.getType() == "PHP_HEREDOC_TAG" && document.get(lineInfo.getOffset(), lineInfo.getLength()).trim().endsWith(";")) {
            return true;
        }
        return false;
    }

    private static void placeStringIndentation(IStructuredDocument document, int lineNumber, StringBuffer result, IndentationObject indentationObject) {
        try {
            IRegion lineInfo = document.getLineInformation(lineNumber);
            int offset = lineInfo.getOffset() + lineInfo.getLength();
            IStructuredDocumentRegion sdRegion = document.getRegionAtCharacterOffset(offset);
            ITextRegion token = DefaultIndentationStrategy.getLastTokenRegion(document, lineInfo, offset);
            if (token == null) {
                return;
            }
            String tokenType = token.getType();
            if (tokenType == "PHP_CURLY_OPEN") {
                return;
            }
            ITextRegion scriptRegion = sdRegion.getRegionAtCharacterOffset(offset);
            if (scriptRegion == null && offset == document.getLength()) {
                scriptRegion = sdRegion.getRegionAtCharacterOffset(--offset);
            }
            int regionStart = sdRegion.getStartOffset(scriptRegion);
            if (scriptRegion instanceof ITextRegionContainer) {
                ITextRegionContainer container = (ITextRegionContainer)scriptRegion;
                scriptRegion = container.getRegionAtCharacterOffset(offset);
                regionStart += scriptRegion.getStart();
            }
            if (scriptRegion instanceof IPhpScriptRegion && tokenType == "PHP_TOKEN" && document.getChar(regionStart + token.getStart()) == '.' && (token = ((IPhpScriptRegion)scriptRegion).getPhpToken(token.getStart() - 1)) != null && token.getType() == "PHP_CONSTANT_ENCAPSED_STRING") {
                boolean isToken = true;
                int currentOffset = regionStart + token.getStart() - 1;
                while (currentOffset >= lineInfo.getOffset()) {
                    token = ((IPhpScriptRegion)scriptRegion).getPhpToken(token.getStart() - 1);
                    tokenType = token.getType();
                    if ((!isToken || tokenType != "PHP_TOKEN" || document.getChar(regionStart + token.getStart()) != '.') && (isToken || tokenType != "PHP_CONSTANT_ENCAPSED_STRING")) break;
                    currentOffset = regionStart + token.getStart() - 1;
                }
                DefaultIndentationStrategy.indent(document, result, indentationObject.indentationWrappedLineSize, indentationObject.indentationChar, indentationObject.indentationSize);
            }
        }
        catch (BadLocationException badLocationException) {}
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static boolean shouldIndent(IStructuredDocument document, int offset, int lineNumber) {
        try {
            IRegion lineInfo = document.getLineInformation(lineNumber);
            IStructuredDocumentRegion sdRegion = document.getRegionAtCharacterOffset(offset);
            ITextRegion token = DefaultIndentationStrategy.getLastTokenRegion(document, lineInfo, offset);
            if (token == null) {
                return false;
            }
            String tokenType = token.getType();
            if (tokenType == "PHP_CURLY_OPEN") {
                return true;
            }
            ITextRegion scriptRegion = sdRegion.getRegionAtCharacterOffset(offset);
            if (scriptRegion == null && offset == document.getLength()) {
                scriptRegion = sdRegion.getRegionAtCharacterOffset(--offset);
            }
            int regionStart = sdRegion.getStartOffset(scriptRegion);
            if (scriptRegion instanceof ITextRegionContainer) {
                ITextRegionContainer container = (ITextRegionContainer)scriptRegion;
                scriptRegion = container.getRegionAtCharacterOffset(offset);
                regionStart += scriptRegion.getStart();
            }
            if (!(scriptRegion instanceof IPhpScriptRegion)) return false;
            if (tokenType != "PHP_TOKEN") return false;
            if (document.getChar(regionStart + token.getStart()) != ':') return false;
            int currentOffset = regionStart + token.getStart() - 1;
            while (true) {
                if (currentOffset < lineInfo.getOffset()) {
                    return false;
                }
                tokenType = (token = ((IPhpScriptRegion)scriptRegion).getPhpToken(token.getStart() - 1)).getType();
                if (tokenType == "PHP_CASE") return true;
                if (tokenType == "PHP_DEFAULT") {
                    return true;
                }
                currentOffset = regionStart + token.getStart() - 1;
            }
        }
        catch (BadLocationException badLocationException) {}
        return false;
    }

    public static boolean shouldNotConsiderAsIndentationBase(String currentState, String forState) {
        return currentState != forState && (currentState == "org.eclipse.php.PHP_MULTI_LINE_COMMENT" || currentState == "org.eclipse.php.PHP_DOC" || currentState == "org.eclipse.php.PHP_QUOTED_STRING");
    }

    public static int getPairArrayOffset() {
        if (pairArrayParen) {
            return pairArrayOffset;
        }
        return -1;
    }

    public static boolean getPairArrayParen() {
        return pairArrayParen;
    }

    public static void unsetPairArrayParen() {
        pairArrayParen = false;
    }

    private static class IndentationObject {
        public int indentationWrappedLineSize;
        public int indentationArrayInitSize;
        public int indentationSize;
        public char indentationChar;

        private IndentationObject() {
        }
    }

    static class LineState {
        boolean inBracelessBlock;
        boolean inMultiLine;
        StringBuffer indent = new StringBuffer();

        LineState() {
        }
    }
}

