/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.ui.views;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.php.internal.debug.core.model.DebugOutput;
import org.eclipse.php.internal.debug.core.model.IPHPDebugTarget;
import org.eclipse.php.internal.debug.ui.PHPDebugUIMessages;
import org.eclipse.php.internal.debug.ui.views.DebugViewHelper;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.progress.UIJob;

public class DebugBrowserView
extends ViewPart
implements ISelectionListener {
    public static final String ID_PHPBrowserOutput = "org.eclipse.debug.ui.PHPBrowserOutput";
    private Browser swtBrowser;
    private IPHPDebugTarget fTarget;
    private int fUpdateCount;
    private IDebugEventSetListener terminateListener;
    private DebugViewHelper debugViewHelper;
    private DebugViewPartListener fPartListener;

    public void createPartControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.makeColumnsEqualWidth = true;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        container.setLayout((Layout)layout);
        RowLayout rowLayout = new RowLayout();
        rowLayout.spacing = 1;
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        try {
            this.swtBrowser = new Browser(container, 0);
            this.swtBrowser.setLayoutData((Object)gridData);
        }
        catch (SWTError sWTError) {
            this.swtBrowser = null;
            Label label = new Label(container, 64);
            label.setText(PHPDebugUIMessages.DebugBrowserView_swtBrowserNotAvailable0);
            label.setLayoutData((Object)gridData);
        }
        this.debugViewHelper = new DebugViewHelper();
        this.terminateListener = new IDebugEventSetListener(){
            IPHPDebugTarget target;

            public void handleDebugEvents(DebugEvent[] events) {
                if (events != null) {
                    int size = events.length;
                    int i = 0;
                    while (i < size) {
                        Object obj = events[i].getSource();
                        if (obj instanceof IPHPDebugTarget && events[i].getKind() == 8) {
                            this.target = (IPHPDebugTarget)obj;
                            UIJob job = new UIJob("debug output"){

                                public IStatus runInUIThread(IProgressMonitor monitor) {
                                    DebugBrowserView.this.update(target);
                                    return Status.OK_STATUS;
                                }
                            };
                            job.schedule();
                        }
                        ++i;
                    }
                }
            }
        };
        DebugPlugin.getDefault().addDebugEventListener(this.terminateListener);
        this.getSite().getWorkbenchWindow().getSelectionService().addSelectionListener("org.eclipse.debug.ui.DebugView", (ISelectionListener)this);
        if (this.fPartListener == null) {
            this.fPartListener = new DebugViewPartListener();
            this.getSite().getPage().addPartListener((IPartListener2)this.fPartListener);
        }
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.php.help.browser_output_view");
    }

    public void setFocus() {
    }

    public void dispose() {
        this.getSite().getWorkbenchWindow().getSelectionService().removeSelectionListener("org.eclipse.debug.ui.DebugView", (ISelectionListener)this);
        DebugPlugin.getDefault().removeDebugEventListener(this.terminateListener);
        if (this.swtBrowser != null && !this.swtBrowser.isDisposed()) {
            this.swtBrowser.dispose();
        }
        super.dispose();
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        IPHPDebugTarget target = this.debugViewHelper.getSelectionElement(selection);
        this.update(target);
    }

    public void update(IPHPDebugTarget target) {
        if (this.swtBrowser != null && !this.swtBrowser.isDisposed()) {
            IPHPDebugTarget oldTarget = this.fTarget;
            int oldcount = this.fUpdateCount;
            this.fTarget = target;
            DebugOutput debugOutput = null;
            if (this.fTarget != null) {
                if (this.fTarget.isSuspended() || this.fTarget.isTerminated() || this.fTarget.isWaiting()) {
                    debugOutput = this.fTarget.getOutputBuffer();
                    this.fUpdateCount = debugOutput.getUpdateCount();
                    if (this.fTarget == oldTarget && this.fUpdateCount == oldcount) {
                        return;
                    }
                } else {
                    this.fTarget = oldTarget;
                    return;
                }
            }
            if (debugOutput != null) {
                String contentType = debugOutput.getContentType();
                if (contentType != null && !contentType.startsWith("text")) {
                    return;
                }
                String output = debugOutput.toString();
                int startIdx = output.indexOf("\r\n\r\n");
                if (startIdx == -1) {
                    startIdx = output.indexOf("\r\n");
                }
                if (startIdx != -1) {
                    output = output.substring(startIdx + 2);
                }
                this.swtBrowser.setText(output);
            }
        }
    }

    private class DebugViewPartListener
    implements IPartListener2 {
        private DebugViewPartListener() {
        }

        public void partVisible(IWorkbenchPartReference ref) {
            IWorkbenchPart part = ref.getPart(false);
            if (part == DebugBrowserView.this) {
                IPHPDebugTarget target = DebugBrowserView.this.debugViewHelper.getSelectionElement(null);
                DebugBrowserView.this.update(target);
            }
        }

        public void partHidden(IWorkbenchPartReference ref) {
        }

        public void partActivated(IWorkbenchPartReference ref) {
        }

        public void partBroughtToTop(IWorkbenchPartReference ref) {
        }

        public void partClosed(IWorkbenchPartReference ref) {
        }

        public void partDeactivated(IWorkbenchPartReference ref) {
        }

        public void partOpened(IWorkbenchPartReference ref) {
        }

        public void partInputChanged(IWorkbenchPartReference ref) {
        }
    }
}

