/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.lml.core;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class JobStatusData {
    private static final String JOB_OUTERR_READY = "JOB_OUTERR_READY";
    public static final String SUBMITTED = "SUBMITTED";
    public static final String RUNNING = "RUNNING";
    public static final String COMPLETED = "COMPLETED";
    public static final String FAILED = "FAILED";
    public static final String CANCELED = "CANCELED";
    public static final String JOB_ID_ATTR = "jobId";
    public static final String CONTROL_TYPE_ATTR = "controlType";
    public static final String MONITOR_TYPE_ATTR = "monitorType";
    public static final String STDOUT_REMOTE_FILE_ATTR = "stdoutRemotePath";
    public static final String STDERR_REMOTE_FILE_ATTR = "stderrRemotePath";
    public static final String INTERACTIVE_ATTR = "interactive";
    public static final String STATE_ATTR = "state";
    public static final String STATE_DETAIL_ATTR = "stateDetail";
    public static final String OID_ATTR = "oid";
    public static final String QUEUE_NAME_ATTR = "queueName";
    public static final String OWNER_ATTR = "owner";
    public static final String REMOTE_SERVICES_ID_ATTR = "remoteServicesId";
    public static final String CONNECTION_NAME_ATTR = "connectionName";
    private boolean fOutReady = false;
    private boolean fErrReady = false;
    private boolean fRemoved = false;
    private final Map<String, String> fAttrs = new HashMap<String, String>();
    private final Map<String, String> jobData = new HashMap<String, String>();

    private static boolean detailIsFinal(String detail) {
        return CANCELED.equals(detail) || FAILED.equals(detail) || JOB_OUTERR_READY.equals(detail);
    }

    public JobStatusData(String[][] attrs) {
        this.setState(SUBMITTED);
        this.setStateDetail(SUBMITTED);
        String[][] stringArray = attrs;
        int n = attrs.length;
        int n2 = 0;
        while (n2 < n) {
            String[] attr = stringArray[n2];
            this.fAttrs.put(attr[0], attr[1]);
            ++n2;
        }
        this.fOutReady = this.getOutputPath() != null && JOB_OUTERR_READY.equals(this.getStateDetail());
        this.fErrReady = this.getErrorPath() != null && JOB_OUTERR_READY.equals(this.getStateDetail());
    }

    public void addInfo(String key, String value) {
        this.jobData.put(key, value);
    }

    public Set<String> getAdditionalKeys() {
        return this.jobData.keySet();
    }

    public String getConnectionName() {
        return this.fAttrs.get(CONNECTION_NAME_ATTR);
    }

    public String getControlType() {
        return this.fAttrs.get(CONTROL_TYPE_ATTR);
    }

    public String getErrorPath() {
        return this.fAttrs.get(STDERR_REMOTE_FILE_ATTR);
    }

    public boolean getErrReady() {
        return this.fErrReady;
    }

    public String getInfo(String key) {
        return this.jobData.get(key);
    }

    public String getJobId() {
        return this.fAttrs.get(JOB_ID_ATTR);
    }

    public String getMonitorType() {
        return this.fAttrs.get(MONITOR_TYPE_ATTR);
    }

    public String getOid() {
        return this.fAttrs.get(OID_ATTR);
    }

    public String getOutputPath() {
        return this.fAttrs.get(STDOUT_REMOTE_FILE_ATTR);
    }

    public boolean getOutReady() {
        return this.fOutReady;
    }

    public String getOwner() {
        return this.fAttrs.get(OWNER_ATTR);
    }

    public String getQueueName() {
        return this.fAttrs.get(QUEUE_NAME_ATTR);
    }

    public String getRemoteId() {
        return this.fAttrs.get(REMOTE_SERVICES_ID_ATTR);
    }

    public String getState() {
        return this.fAttrs.get(STATE_ATTR);
    }

    public String getStateDetail() {
        return this.fAttrs.get(STATE_DETAIL_ATTR);
    }

    public boolean isCompleted() {
        return this.getState().equals(COMPLETED);
    }

    public boolean isInteractive() {
        String interactive = this.fAttrs.get(INTERACTIVE_ATTR);
        if (interactive != null) {
            try {
                return Boolean.parseBoolean(interactive);
            }
            catch (Exception exception) {}
        }
        return false;
    }

    public boolean isRemoved() {
        return this.fRemoved;
    }

    public void setErrReady(boolean errReady) {
        this.fErrReady = errReady;
    }

    public void setOid(String oid) {
        this.fAttrs.put(OID_ATTR, oid);
    }

    public void setOutReady(boolean outReady) {
        this.fOutReady = outReady;
    }

    public void setRemoved() {
        this.fRemoved = true;
    }

    public void setState(String state) {
        this.fAttrs.put(STATE_ATTR, state);
    }

    public void setStateDetail(String stateDetail) {
        this.fAttrs.put(STATE_DETAIL_ATTR, stateDetail);
        this.fOutReady = this.getOutputPath() != null && JOB_OUTERR_READY.equals(stateDetail);
        this.fErrReady = this.getErrorPath() != null && JOB_OUTERR_READY.equals(stateDetail);
    }

    public void updateState(String state, String stateDetail) {
        if (!JobStatusData.detailIsFinal(this.getStateDetail())) {
            this.setState(state);
            this.setStateDetail(stateDetail);
        }
    }
}

