/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.lml.monitor.ui.handlers;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.HandlerEvent;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.ptp.rm.lml.monitor.core.IMonitorControl;
import org.eclipse.ptp.rm.lml.monitor.core.MonitorControlManager;
import org.eclipse.ptp.rm.lml.monitor.ui.LMLMonitorUIPlugin;
import org.eclipse.ptp.rm.lml.monitor.ui.messages.Messages;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;

public class StartMonitorHandler
extends AbstractHandler
implements IHandler,
ISelectionChangedListener {
    private IMonitorControl fMonitor;

    public StartMonitorHandler() {
        MonitorControlManager.getInstance().addSelectionChangedListener((ISelectionChangedListener)this);
    }

    public void selectionChanged(SelectionChangedEvent event) {
        ISelection sel = event.getSelection();
        if (!sel.isEmpty() && sel instanceof IStructuredSelection) {
            IStructuredSelection ss = (IStructuredSelection)sel;
            if (ss.size() == 1) {
                this.fMonitor = (IMonitorControl)ss.getFirstElement();
            }
        } else {
            this.fMonitor = null;
        }
        this.fireHandlerChanged(new HandlerEvent((IHandler)this, true, false));
    }

    public void dispose() {
        MonitorControlManager.getInstance().removeSelectionChangedListener((ISelectionChangedListener)this);
        super.dispose();
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (!selection.isEmpty() && selection instanceof IStructuredSelection) {
            final ArrayList<IMonitorControl> monitors = new ArrayList<IMonitorControl>();
            for (Object sel : (IStructuredSelection)selection) {
                if (!(sel instanceof IMonitorControl)) continue;
                monitors.add((IMonitorControl)sel);
            }
            try {
                HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event).run(true, true, new IRunnableWithProgress(){

                    public void run(IProgressMonitor progress) throws InvocationTargetException, InterruptedException {
                        SubMonitor subMon = SubMonitor.convert((IProgressMonitor)progress, (int)monitors.size());
                        try {
                            for (IMonitorControl monitor : monitors) {
                                try {
                                    if (monitor.isActive()) continue;
                                    monitor.start((IProgressMonitor)subMon.newChild(1));
                                }
                                catch (CoreException e) {
                                    throw new InvocationTargetException(e.getCause());
                                }
                            }
                        }
                        finally {
                            if (progress != null) {
                                progress.done();
                            }
                        }
                    }
                });
            }
            catch (InvocationTargetException e) {
                ErrorDialog.openError((Shell)HandlerUtil.getActiveShell((ExecutionEvent)event), (String)Messages.StartMonitorHandler_Start_Monitor, (String)Messages.StartMonitorHandler_Unable_to_start_monitor, (IStatus)new Status(2, LMLMonitorUIPlugin.getUniqueIdentifier(), e.getLocalizedMessage()));
            }
            catch (InterruptedException interruptedException) {}
        }
        return null;
    }

    public boolean isEnabled() {
        return this.fMonitor != null ? !this.fMonitor.isActive() : false;
    }
}

