/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rwt.internal.service;

import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import org.eclipse.rwt.internal.lifecycle.FakeContextUtil;
import org.eclipse.rwt.internal.lifecycle.ISessionShutdownAdapter;
import org.eclipse.rwt.internal.service.ContextProvider;
import org.eclipse.rwt.internal.service.ServiceContext;
import org.eclipse.rwt.internal.util.ParamCheck;
import org.eclipse.rwt.internal.util.SerializableLock;
import org.eclipse.rwt.service.ISessionStore;
import org.eclipse.rwt.service.SessionStoreEvent;
import org.eclipse.rwt.service.SessionStoreListener;
import org.eclipse.swt.internal.SerializableCompatibility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SessionStoreImpl
implements ISessionStore,
HttpSessionBindingListener,
SerializableCompatibility {
    public static final String ATTR_SESSION_STORE = SessionStoreImpl.class.getName();
    private final SerializableLock requestLock;
    private final SerializableLock lock;
    private final Map<String, Object> attributes;
    private final Set<SessionStoreListener> sessionStoreListeners;
    private final String id;
    private transient HttpSession httpSession;
    private boolean bound;
    private boolean aboutUnbound;
    private transient ISessionShutdownAdapter shutdownAdapter;

    public static SessionStoreImpl getInstanceFromSession(HttpSession httpSession) {
        return (SessionStoreImpl)httpSession.getAttribute(ATTR_SESSION_STORE);
    }

    public static void attachInstanceToSession(HttpSession httpSession, ISessionStore sessionStore) {
        httpSession.setAttribute(ATTR_SESSION_STORE, (Object)sessionStore);
    }

    public SessionStoreImpl(HttpSession httpSession) {
        ParamCheck.notNull(httpSession, "httpSession");
        this.requestLock = new SerializableLock();
        this.lock = new SerializableLock();
        this.attributes = new HashMap<String, Object>();
        this.sessionStoreListeners = new HashSet<SessionStoreListener>();
        this.id = httpSession.getId();
        this.bound = true;
        this.httpSession = httpSession;
    }

    public void setShutdownAdapter(ISessionShutdownAdapter adapter) {
        this.shutdownAdapter = adapter;
        if (this.shutdownAdapter != null) {
            this.shutdownAdapter.setSessionStore(this);
            this.shutdownAdapter.setShutdownCallback(new Runnable(){

                public void run() {
                    SessionStoreImpl.this.doValueUnbound();
                }
            });
        }
    }

    public ISessionShutdownAdapter getShutdownAdapter() {
        return this.shutdownAdapter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getAttribute(String name) {
        ParamCheck.notNull(name, "name");
        Object result = null;
        SerializableLock serializableLock = this.lock;
        synchronized (serializableLock) {
            result = this.attributes.get(name);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setAttribute(String name, Object value) {
        ParamCheck.notNull(name, "name");
        boolean result = false;
        SerializableLock serializableLock = this.lock;
        synchronized (serializableLock) {
            if (this.bound) {
                result = true;
                this.removeAttributeInternal(name);
                this.attributes.put(name, value);
                this.fireValueBound(name, value);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeAttribute(String name) {
        ParamCheck.notNull(name, "name");
        boolean result = false;
        SerializableLock serializableLock = this.lock;
        synchronized (serializableLock) {
            if (this.bound) {
                result = true;
                this.removeAttributeInternal(name);
            }
        }
        return result;
    }

    @Override
    public Enumeration<String> getAttributeNames() {
        return this.createAttributeNameEnumeration();
    }

    @Override
    public String getId() {
        return this.id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpSession getHttpSession() {
        SerializableLock serializableLock = this.lock;
        synchronized (serializableLock) {
            return this.httpSession;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void attachHttpSession(HttpSession httpSession) {
        ParamCheck.notNull(httpSession, "httpSession");
        SerializableLock serializableLock = this.lock;
        synchronized (serializableLock) {
            this.httpSession = httpSession;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isBound() {
        SerializableLock serializableLock = this.lock;
        synchronized (serializableLock) {
            return this.bound;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addSessionStoreListener(SessionStoreListener listener) {
        ParamCheck.notNull(listener, "listener");
        boolean result = false;
        SerializableLock serializableLock = this.lock;
        synchronized (serializableLock) {
            if (this.bound && !this.aboutUnbound) {
                result = true;
                this.sessionStoreListeners.add(listener);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeSessionStoreListener(SessionStoreListener listener) {
        ParamCheck.notNull(listener, "listener");
        boolean result = false;
        SerializableLock serializableLock = this.lock;
        synchronized (serializableLock) {
            if (this.bound && !this.aboutUnbound) {
                result = true;
                this.sessionStoreListeners.remove(listener);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void valueBound(HttpSessionBindingEvent event) {
        SerializableLock serializableLock = this.lock;
        synchronized (serializableLock) {
            this.bound = true;
            this.aboutUnbound = false;
        }
    }

    public void valueUnbound(HttpSessionBindingEvent event) {
        if (this.shutdownAdapter != null) {
            this.shutdownAdapter.interceptShutdown();
        } else {
            boolean fakeContext = false;
            if (!ContextProvider.hasContext()) {
                fakeContext = true;
                ServiceContext context = FakeContextUtil.createFakeContext(this);
                ContextProvider.setContext(context);
            }
            try {
                this.doValueUnbound();
            }
            finally {
                if (fakeContext) {
                    ContextProvider.releaseContextHolder();
                }
            }
        }
    }

    Object getRequestLock() {
        return this.requestLock;
    }

    private void removeAttributeInternal(String name) {
        Object removed = this.attributes.remove(name);
        this.fireValueUnbound(name, removed);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doValueUnbound() {
        HashMap<String, Object> attributesCopy;
        SerializableLock serializableLock = this.lock;
        synchronized (serializableLock) {
            this.aboutUnbound = true;
            attributesCopy = new HashMap<String, Object>(this.attributes);
        }
        this.fireBeforeDestroy();
        for (Map.Entry entry : attributesCopy.entrySet()) {
            this.fireValueUnbound((String)entry.getKey(), entry.getValue());
        }
        SerializableLock serializableLock2 = this.lock;
        synchronized (serializableLock2) {
            this.attributes.clear();
            this.sessionStoreListeners.clear();
            this.bound = false;
            this.aboutUnbound = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireBeforeDestroy() {
        SessionStoreListener[] listeners;
        SerializableLock serializableLock = this.lock;
        synchronized (serializableLock) {
            int size = this.sessionStoreListeners.size();
            listeners = this.sessionStoreListeners.toArray(new SessionStoreListener[size]);
        }
        SessionStoreEvent event = new SessionStoreEvent(this);
        int i = 0;
        while (i < listeners.length) {
            try {
                listeners[i].beforeDestroy(event);
            }
            catch (RuntimeException re) {
                this.handleExceptionInDestroy(listeners[i], re);
            }
            ++i;
        }
    }

    private void fireValueBound(String name, Object value) {
        if (value instanceof HttpSessionBindingListener) {
            HttpSessionBindingListener listener = (HttpSessionBindingListener)value;
            HttpSessionBindingEvent event = new HttpSessionBindingEvent(this.httpSession, name, value);
            try {
                listener.valueBound(event);
            }
            catch (RuntimeException re) {
                this.handleExceptionInValueBound(listener, re);
            }
        }
    }

    private void fireValueUnbound(String name, Object value) {
        if (value instanceof HttpSessionBindingListener) {
            HttpSessionBindingListener listener = (HttpSessionBindingListener)value;
            HttpSessionBindingEvent event = new HttpSessionBindingEvent(this.httpSession, name, value);
            try {
                listener.valueUnbound(event);
            }
            catch (RuntimeException re) {
                this.handleExceptionInValueUnbound(listener, re);
            }
        }
    }

    private void handleExceptionInDestroy(SessionStoreListener listener, RuntimeException exception) {
        String txt = "Could not execute {0}.beforeDestroy(SessionStoreEvent).";
        Object[] param = new Object[]{listener.getClass().getName()};
        String msg = MessageFormat.format(txt, param);
        this.httpSession.getServletContext().log(msg, (Throwable)exception);
    }

    private void handleExceptionInValueUnbound(HttpSessionBindingListener listener, RuntimeException exception) {
        String txt = "Could not execute {0}.valueUnbound(HttpSessionBindingEvent).";
        Object[] param = new Object[]{listener.getClass().getName()};
        String msg = MessageFormat.format(txt, param);
        this.httpSession.getServletContext().log(msg, (Throwable)exception);
    }

    private void handleExceptionInValueBound(HttpSessionBindingListener listener, RuntimeException exception) {
        String txt = "Could not execute {0}.valueBound(HttpSessionBindingEvent).";
        Object[] param = new Object[]{listener.getClass().getName()};
        String msg = MessageFormat.format(txt, param);
        this.httpSession.getServletContext().log(msg, (Throwable)exception);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Enumeration<String> createAttributeNameEnumeration() {
        HashSet<String> names;
        SerializableLock serializableLock = this.lock;
        synchronized (serializableLock) {
            names = new HashSet<String>(this.attributes.keySet());
        }
        final Iterator iterator = names.iterator();
        return new Enumeration<String>(){

            @Override
            public boolean hasMoreElements() {
                return iterator.hasNext();
            }

            @Override
            public String nextElement() {
                return (String)iterator.next();
            }
        };
    }
}

